/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.SmartGeocoderHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.WindowTools;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import jakarta.inject.Named;

public class MapUiTools
extends AbstractAiTool {
    private WindowTools windowTools = null;

    public MapUiTools(WindowTools windowTools) {
        this.windowTools = windowTools;
    }

    @Tool(value={"Show the map."})
    @ToolDoc(semantics={"show the map", "display the map", "open the map", "show the plan"}, rules={"If the utterance contains show/display/open + map/plan \u2192 showMap()."})
    public GJaxbCommandResponse showMap(@Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("La carte est maintenant affich\u00e9e.");
        } else {
            e.setCommandOutputMessage("The map is now shown.");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }

    @Tool(value={"Hide the map."})
    @ToolDoc(semantics={"hide the map", "close the map", "mask the map"}, rules={"If the utterance contains hide/close/mask + map/plan \u2192 hideMap()."})
    public GJaxbCommandResponse hideMap(@Named(value="userLanguage") UserTools.Language userLanguage) {
        return this.windowTools.closeWindow("map", userLanguage);
    }

    @Tool(value={"Zoom to a place (already normalized, e.g., 'paris')."})
    @ToolDoc(semantics={"zoom to [place]", "center on [place]", "go to [city]", "show [place] on the map"}, rules={"If the place is explicitly mentioned \u2192 zoomToPlace(<place>)."})
    public GJaxbCommandResponse zoomToPlace(@Named(value="place") String place, @Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        e.setForZoomToPlaceMapResponse(new GJaxbCommandResponse.ForZoomToPlaceMapResponse());
        e.getForZoomToPlaceMapResponse().setPlace(place);
        GJaxbPointType point = SmartGeocoderHelper.getInstance().geocodeCity(place);
        e.getForZoomToPlaceMapResponse().setPoint(point);
        e.getForZoomToPlaceMapResponse().setZoom(Integer.valueOf(14));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("La carte est maintenant centr\u00e9e sur " + place + ".");
        } else {
            e.setCommandOutputMessage("The map is now centered on " + place + ".");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }
}

