/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNews;
import fr.emac.gind.gov.ai_chatbot.GJaxbInventProblemsFromNewsResponse;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.FaultMessage;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.governance.ai.command.assistant.service.AICommandAssistantImpl;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemsTools
extends AbstractAiTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)AICommandAssistantImpl.class.getName());
    private CoreGov coreGovClient = null;
    private AiChatbot aiChatbotClient = null;

    public ProblemsTools(CoreGov coreGovClient, AiChatbot aiChatbotClient) {
        this.coreGovClient = coreGovClient;
        this.aiChatbotClient = aiChatbotClient;
    }

    @Tool(value={"Let me know if there is an alert."})
    @ToolDoc(semantics={"Tell me if there is an alert", "Do you see any alerts?"}, rules={"If the utterance contains alert/actuality \u2192 showAlerts().", "The userLanguage is either EN (for English) or FR (for French)", "Returns actualities or potentialities in database"})
    public GJaxbCommandResponse showAlerts(@Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            String query = "MATCH (n:ACTIVE&(`" + String.valueOf(GenericModelHelper.collab((String)"Actuality")) + "`|`" + String.valueOf(GenericModelHelper.collab((String)"Potentiality")) + "`)) RETURN n";
            GJaxbQuery reqQuery = new GJaxbQuery();
            reqQuery.setQuery(query);
            reqQuery.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            if (this.getContext().getSelectedKnowledgeSpace() != null) {
                reqQuery.getSelectedKnowledgeSpace().setCollaborationName(this.getContext().getSelectedKnowledgeSpace().getCollaborationName());
                reqQuery.getSelectedKnowledgeSpace().setKnowledgeName(this.getContext().getSelectedKnowledgeSpace().getKnowledgeName());
            }
            GJaxbQueryResponse respQuery = this.coreGovClient.query(reqQuery);
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
            if (respQuery != null && respQuery.getSingle() != null && respQuery.getSingle().getGenericModel() != null && respQuery.getSingle().getGenericModel().getNode().isEmpty() || respQuery == null || respQuery.getSingle() == null) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Aucune alerte n'a \u00e9t\u00e9 d\u00e9tect\u00e9e, mais ne vous inqui\u00e9tez pas, je vous tiendrai inform\u00e9 si des alertes surviennent.");
                } else {
                    e.setCommandOutputMessage("No alerts were detected, but don't worry, I'll let you know if any alerts occur.");
                }
            } else {
                Object outputMsg = "";
                outputMsg = userLanguage == UserTools.Language.FR ? "Alertes trouv\u00e9es dans la base de donn\u00e9es : \n" : "Alerts found in the database: \n";
                for (GJaxbNode n : respQuery.getSingle().getGenericModel().getNode()) {
                    outputMsg = (String)outputMsg + "\t- " + GenericModelHelper.getName((GJaxbNode)n) + " (" + String.join((CharSequence)", ", n.getType().getLocalPart()) + ")\n";
                }
                e.setCommandOutputMessage((String)outputMsg);
            }
        }
        catch (FaultMessage ex) {
            ex.printStackTrace();
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Erreur lors de la requ\u00eate des alertes : " + ex.getMessage());
            } else {
                e.setCommandOutputMessage("Error while querying alerts: " + ex.getMessage());
            }
            LOG.error("Error while querying alerts", (Throwable)ex);
        }
        return e;
    }

    @Tool(value={"Try to detect place and problems (alerts or risks) from the user message."})
    @ToolDoc(semantics={"finds alerts from the {user message} and the {place}", "finds risks from this {user message} and {place} given", "detect alerts from this {user message} and {place} given", "detect risks from this {user message} and {place} given"}, rules={"If the utterance contains alert/actuality/risk/potentiality + {user message} + {place} \u2192 detectProblemsFromThisInformation(<user message>, <place>).", "The {user message} can contain news, weather forecast, or any other information about the situation on the {place}.", "The userLanguage is either EN (for English) or FR (for French).", "Pass the {user message} and {place} given mentioned.", "Returns the problems found (zero, one, or multiple)"})
    public GJaxbCommandResponse detectProblemsFromThisInformation(@Named(value="user_message") String user_message, @Named(value="place") String place, @Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            e.setForDetectProblemsFromNewsAndWeatherForecast(new GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast());
            GJaxbInventProblemsFromNews request = new GJaxbInventProblemsFromNews();
            request.setContext(new GJaxbContext());
            request.getContext().setSelectedAiChatBot(GJaxbAiChatBotType.CHAT_GPT);
            if (this.getContext().getSelectedKnowledgeSpace() != null) {
                request.getContext().setCurrentCollaborationName(this.getContext().getSelectedKnowledgeSpace().getCollaborationName());
                request.getContext().setCurrentKnowledgeSpaceName(this.getContext().getSelectedKnowledgeSpace().getKnowledgeName());
            }
            GJaxbInventProblemsFromNews.News n = new GJaxbInventProblemsFromNews.News();
            n.setNewsId("news_" + UUID.randomUUID().toString());
            n.setText(user_message);
            request.getNews().add(n);
            GJaxbInventProblemsFromNewsResponse response = this.aiChatbotClient.inventProblemsFromNews(request);
            Object outputMsg = "";
            for (GJaxbInventProblemsFromNewsResponse.NewsOutput no : response.getNewsOutput()) {
                GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast.NewsOutput no2 = new GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast.NewsOutput();
                no2.setNewsTitle(user_message);
                List alerts = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Actuality"), (List)no.getGenericModel().getNode());
                List risks = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Potentiality"), (List)no.getGenericModel().getNode());
                for (GJaxbNode a : alerts) {
                    no2.getAlertDetected().add(GenericModelHelper.getName((GJaxbNode)a));
                    outputMsg = (String)outputMsg + "\t- " + GenericModelHelper.getName((GJaxbNode)a) + "(alert); \n";
                }
                for (GJaxbNode r : risks) {
                    no2.getRiskDetected().add(GenericModelHelper.getName((GJaxbNode)r));
                    outputMsg = (String)outputMsg + "\t- " + GenericModelHelper.getName((GJaxbNode)r) + "(risk); \n";
                }
                e.getForDetectProblemsFromNewsAndWeatherForecast().getNewsOutput().add(no2);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Probl\u00e8mes d\u00e9tect\u00e9s \u00e0 partir des informations fournies : " + (String)outputMsg);
            } else {
                e.setCommandOutputMessage("Problems detected from news and weather forecast: " + (String)outputMsg);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Erreur lors de la d\u00e9tection des probl\u00e8mes \u00e0 partir des informations fournies : " + ex.getMessage());
            } else {
                e.setCommandOutputMessage("Error while detecting problems from detectProblemsFromThisInformation: " + ex.getMessage());
            }
            LOG.error("Error while detecting problems from detectProblemsFromThisInformation", (Throwable)ex);
        }
        return e;
    }

    @Tool(value={"Try to detect problems (alerts or risks) from the situation (news and weather) on a given place."})
    @ToolDoc(semantics={"finds alerts on {place}", "finds risks on {place}", "detect alerts on {place}", "detect risks on {place}"}, rules={"If the utterance contains alert/actuality/risk/potentiality + {place} \u2192 detectProblemsFromNewsAndWeatherForecast(<news>, <weatherForecast>, <place>).", "The {place} is where the news and weather forecast are related to.", "The userLanguage is either EN (for English) or FR (for French).", "Pass the {news} (obtained via the 'GiveNews' tool - can be null) and {weather} forecast (obtained via the 'GiveWeather' tool - can be null) for the place mentioned.", "Returns the problems found (zero, one, or multiple)"})
    public GJaxbCommandResponse detectProblemsFromNewsAndWeatherForecast(@Named(value="news") GJaxbCommandResponse news, @Named(value="weatherForecast") GJaxbCommandResponse weatherForecasts, @Named(value="place") String place, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            e.setForDetectProblemsFromNewsAndWeatherForecast(new GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast());
            GJaxbInventProblemsFromNews request = new GJaxbInventProblemsFromNews();
            request.setContext(new GJaxbContext());
            request.getContext().setSelectedAiChatBot(GJaxbAiChatBotType.CHAT_GPT);
            if (this.getContext().getSelectedKnowledgeSpace() != null) {
                request.getContext().setCurrentCollaborationName(this.getContext().getSelectedKnowledgeSpace().getCollaborationName());
                request.getContext().setCurrentKnowledgeSpaceName(this.getContext().getSelectedKnowledgeSpace().getKnowledgeName());
            }
            HashMap newsIdMap = new HashMap();
            if (news != null && news.getForGiveNewsResponse() != null) {
                request.getNews().addAll(news.getForGiveNewsResponse().getArticle().stream().map(a -> {
                    GJaxbInventProblemsFromNews.News n = new GJaxbInventProblemsFromNews.News();
                    n.setNewsId("news_" + UUID.randomUUID().toString());
                    n.setText(a.getTitle());
                    newsIdMap.put(n.getNewsId(), a.getTitle());
                    return n;
                }).toList());
            }
            if (weatherForecasts != null && weatherForecasts.getForGiveWheatherForecastResponse() != null) {
                GJaxbInventProblemsFromNews.News n = new GJaxbInventProblemsFromNews.News();
                n.setNewsId("weather_" + UUID.randomUUID().toString());
                if (userLanguage == UserTools.Language.FR) {
                    n.setText("Le temps aujourd'hui est " + ((GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast)weatherForecasts.getForGiveWheatherForecastResponse().getForecast().get(0)).getWeatherLabel());
                } else {
                    n.setText("The weather today is " + ((GJaxbCommandResponse.ForGiveWheatherForecastResponse.Forecast)weatherForecasts.getForGiveWheatherForecastResponse().getForecast().get(0)).getWeatherLabel());
                }
                request.getNews().add(n);
            }
            GJaxbInventProblemsFromNewsResponse response = this.aiChatbotClient.inventProblemsFromNews(request);
            Object outputMsg = "";
            for (GJaxbInventProblemsFromNewsResponse.NewsOutput no : response.getNewsOutput()) {
                GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast.NewsOutput no2 = new GJaxbCommandResponse.ForDetectProblemsFromNewsAndWeatherForecast.NewsOutput();
                no2.setNewsTitle((String)newsIdMap.get(no.getNewsId()));
                List alerts = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Actuality"), (List)no.getGenericModel().getNode());
                List risks = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Potentiality"), (List)no.getGenericModel().getNode());
                for (GJaxbNode a2 : alerts) {
                    no2.getAlertDetected().add(GenericModelHelper.getName((GJaxbNode)a2));
                    outputMsg = (String)outputMsg + "\t- " + GenericModelHelper.getName((GJaxbNode)a2) + "(alert); \n";
                }
                for (GJaxbNode r : risks) {
                    no2.getRiskDetected().add(GenericModelHelper.getName((GJaxbNode)r));
                    outputMsg = (String)outputMsg + "\t- " + GenericModelHelper.getName((GJaxbNode)r) + "(risk); \n";
                }
                e.getForDetectProblemsFromNewsAndWeatherForecast().getNewsOutput().add(no2);
            }
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Probl\u00e8mes d\u00e9tect\u00e9s \u00e0 partir des informations fournies : " + (String)outputMsg);
            } else {
                e.setCommandOutputMessage("Problems detected from news and weather forecast: " + (String)outputMsg);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Erreur lors de la d\u00e9tection des probl\u00e8mes \u00e0 partir des news et pr\u00e9visions m\u00e9t\u00e9o : " + ex.getMessage());
            } else {
                e.setCommandOutputMessage("Error while detecting problems from news and weather forecast: " + ex.getMessage());
            }
            LOG.error("Error while detecting problems from news and weather forecast", (Throwable)ex);
        }
        return e;
    }
}

