/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.deduction.Deduction;
import fr.emac.gind.gov.deduction.client.DeductionClient;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import jakarta.inject.Named;
import java.util.Map;

public class SolutionTools
extends AbstractAiTool {
    private Map<String, Object> context = null;
    private Deduction deductionClient = null;

    public SolutionTools(Map<String, Object> context) throws Exception {
        this.context = context;
        this.deductionClient = DeductionClient.createClient((String)this.context.get("governance").toString().replace("/gov", "/GovDeduction"));
    }

    @Tool(value={"Run the first solution found"})
    @ToolDoc(semantics={"find me a solution", "propose a solution", "solve this", "fix this problem", "fix these problems"}, rules={"If the utterance contains deduce/generate/run/find + one/a/the first + solution \u2192 runFirstSolution(<userLanguage>).", "The first solution is the first valid solution found by the system.", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse runFirstSolution(@Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("Ex\u00e9cution de la premi\u00e8re solution en cours");
        } else {
            e.setCommandOutputMessage("Run First Solution in progress");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }

    @Tool(value={"Run campaign to generate all possible solutions"})
    @ToolDoc(semantics={"deduce all solutions", "generate all solutions", "run campaign", "execute campaign"}, rules={"If the utterance contains deduce/generate/run + all + solutions \u2192 runCampaign(<userLanguage>).", "The campaign generates all possible valid solutions for the current problems.", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse runCampaign(@Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("Ex\u00e9cution de la campagne en cours");
        } else {
            e.setCommandOutputMessage("Run Campaign in progress");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }
}

