/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent;

import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.governance.ai.command.assistant.GJaxbDetectedCommands;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolDef;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolParam;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.PojoToSchemaAndExample;
import jakarta.inject.Named;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public final class ToolIntrospector {
    private ToolIntrospector() {
    }

    public static GJaxbToolsInfo buildInfo(Mode mode, String promptTemplate, Object ... toolInstances) throws Exception {
        GJaxbToolsInfo info = new GJaxbToolsInfo();
        ArrayList<GJaxbToolDef> defs = new ArrayList<GJaxbToolDef>();
        StringBuilder definition = new StringBuilder();
        StringBuilder semantic = new StringBuilder();
        StringBuilder rules = new StringBuilder();
        for (Object tool : toolInstances) {
            Class<?> c = tool.getClass();
            for (Method m : c.getMethods()) {
                if (!m.isAnnotationPresent(Tool.class)) continue;
                Tool toolAnn = m.getAnnotation(Tool.class);
                ToolDoc docAnn = m.getAnnotation(ToolDoc.class);
                String desc = toolAnn.value() == null ? "" : toolAnn.value()[0];
                GJaxbToolDef def = new GJaxbToolDef();
                def.setClassName(c.getSimpleName());
                def.setMethodName(m.getName());
                def.setDescription(desc);
                def.setReturnType(m.getReturnType().getSimpleName());
                definition.append("- ").append(c.getSimpleName()).append(".").append(m.getName()).append(ToolIntrospector.formatParamsReadable(m)).append(" \u2014 ").append(desc.isBlank() ? "No description" : desc).append("\n");
                int idx = 0;
                for (Parameter p : m.getParameters()) {
                    GJaxbToolParam tp = new GJaxbToolParam();
                    tp.setType(p.getType().getSimpleName());
                    Object name = p.isNamePresent() ? p.getName() : "arg" + idx++;
                    Named named = p.getAnnotation(Named.class);
                    if (named != null) {
                        name = named.value();
                    }
                    tp.setName((String)name);
                    def.getParams().add(tp);
                }
                List<String> semList = docAnn != null ? Arrays.stream(docAnn.semantics()).map(String::strip).filter(s -> !s.isBlank()).toList() : List.of();
                List<String> rulList = docAnn != null ? Arrays.stream(docAnn.rules()).map(String::strip).filter(s -> !s.isBlank()).toList() : List.of();
                def.getSemantics().addAll(semList);
                def.getRules().addAll(rulList);
                for (String s2 : semList) {
                    semantic.append("- ").append("\"" + s2 + "\"").append('\n');
                }
                for (String r : rulList) {
                    rules.append("- ").append(r).append('\n');
                }
                defs.add(def);
            }
        }
        rules.append("- Call relevant tools per request; otherwise return UNKNOWN.\n").append("- Pass minimal yet sufficient arguments (use the raw user utterance when helpful).\n").append("- If no clear match with any tool \u2192 UNKNOWN.\n");
        if (mode == Mode.AUDIO) {
            rules.append("- If not addressed directly, do not speak, make any noise, or generate any text or audio.\n").append("- If the user speaks French, respond in French.\n");
        } else if (mode == Mode.TEXT_CHAT) {
            rules.append("- If the beginning of the user's text is in French, respond in French.\n");
        }
        info.setToolsDefinition(definition.toString());
        info.setToolsSemantic(semantic.toString());
        info.setToolsRules(rules.toString());
        ObjectNode schema = PojoToSchemaAndExample.generateSchema(GJaxbDetectedCommands.class);
        info.setToolsJsonSchema(schema.toPrettyString());
        String prompt = promptTemplate.replace("{{tools_definition}}", info.getToolsDefinition()).replace("{{tools_semantic}}", info.getToolsSemantic()).replace("{{tools_rules}}", info.getToolsRules()).replace("{{tools_json_schema}}", info.getToolsJsonSchema());
        info.setPrompt(prompt);
        info.getTools().addAll(defs);
        return info;
    }

    private static String formatParamsReadable(Method m) {
        Parameter[] ps = m.getParameters();
        if (ps.length == 0) {
            return "()";
        }
        StringJoiner j = new StringJoiner(", ", "(", ")");
        int i = 0;
        for (Parameter p : ps) {
            Object name = p.isNamePresent() ? p.getName() : "arg" + i++;
            Named named = p.getAnnotation(Named.class);
            if (named != null) {
                name = named.value();
            }
            j.add(p.getType().getSimpleName() + " " + (String)name);
        }
        return j.toString();
    }

    public static enum Mode {
        AUDIO,
        TEXT_CHAT;

    }
}

