/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.GeocoderHelper;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class NominatimGeocoderHelper
implements GeocoderHelper {
    private final OkHttpClient client = new OkHttpClient();
    private final ObjectMapper mapper = new ObjectMapper();
    private String acceptLanguage = "fr-FR,fr;q=0.9";
    private String userAgent = "MapAgent/1.0";

    public NominatimGeocoderHelper() {
    }

    public NominatimGeocoderHelper(String userAgent, String acceptLanguage) {
        if (userAgent != null && !userAgent.isBlank()) {
            this.userAgent = userAgent;
        }
        if (acceptLanguage != null && !acceptLanguage.isBlank()) {
            this.acceptLanguage = acceptLanguage;
        }
    }

    @Override
    public String getLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public void setLanguage(String language) {
        if (language == null || language.isBlank()) {
            return;
        }
        this.acceptLanguage = language.contains(",") || language.contains(";") ? language : (language.length() == 2 ? language + "-" + language.toUpperCase() + "," + language + ";q=0.9" : language);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GJaxbPointType geocodeCity(String place) {
        GJaxbPointType point = new GJaxbPointType();
        if (place == null) return point;
        if (place.isBlank()) {
            return point;
        }
        try {
            String q = URLEncoder.encode(place, StandardCharsets.UTF_8);
            Request req = new Request.Builder().url("https://nominatim.openstreetmap.org/search?q=" + q + "&format=json&limit=1").header("User-Agent", this.userAgent).header("Accept", "application/json").header("Accept-Language", this.acceptLanguage).build();
            try (Response res = this.client.newCall(req).execute();){
                JsonNode obj;
                if (!res.isSuccessful() || res.body() == null) {
                    GJaxbPointType gJaxbPointType2 = point;
                    return gJaxbPointType2;
                }
                JsonNode arr = this.mapper.readTree(res.body().byteStream());
                if (arr.isArray() && arr.size() > 0 && (obj = arr.get(0)).hasNonNull("lat") && obj.hasNonNull("lon")) {
                    point.setLatitude(Double.valueOf(NominatimGeocoderHelper.safeAsDouble(obj.get("lat"))));
                    point.setLongitude(Double.valueOf(NominatimGeocoderHelper.safeAsDouble(obj.get("lon"))));
                }
                GJaxbPointType gJaxbPointType = point;
                return gJaxbPointType;
            }
        }
        catch (IOException e) {
            return point;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GeocoderHelper.Address reverseGeocode(double lat, double lon) {
        NominatimGeocoderHelper.validateLatLon(lat, lon);
        String url = "https://nominatim.openstreetmap.org/reverse?format=jsonv2&lat=" + URLEncoder.encode(String.valueOf(lat), StandardCharsets.UTF_8) + "&lon=" + URLEncoder.encode(String.valueOf(lon), StandardCharsets.UTF_8) + "&addressdetails=1";
        Request req = new Request.Builder().url(url).header("User-Agent", this.userAgent).header("Accept", "application/json").header("Accept-Language", this.acceptLanguage).build();
        int attempts = 0;
        while (attempts < 3) {
            ++attempts;
            try {
                Response res = this.client.newCall(req).execute();
                try {
                    if (res.isSuccessful() && res.body() != null) {
                        JsonNode root = this.mapper.readTree(res.body().byteStream());
                        if (root != null && !root.isEmpty()) {
                            GeocoderHelper.Address a = new GeocoderHelper.Address();
                            a.displayName = NominatimGeocoderHelper.textOrNull(root, "display_name");
                            a.lat = NominatimGeocoderHelper.textOrNull(root, "lat");
                            a.lon = NominatimGeocoderHelper.textOrNull(root, "lon");
                            JsonNode addr = root.path("address");
                            a.houseNumber = NominatimGeocoderHelper.textOrNull(addr, "house_number");
                            a.road = NominatimGeocoderHelper.textOrNull(addr, "road");
                            a.neighbourhood = NominatimGeocoderHelper.textOrNull(addr, "neighbourhood");
                            a.suburb = NominatimGeocoderHelper.textOrNull(addr, "suburb");
                            a.postcode = NominatimGeocoderHelper.textOrNull(addr, "postcode");
                            a.city = NominatimGeocoderHelper.coalesce(NominatimGeocoderHelper.textOrNull(addr, "city"), NominatimGeocoderHelper.textOrNull(addr, "town"), NominatimGeocoderHelper.textOrNull(addr, "village"), NominatimGeocoderHelper.textOrNull(addr, "hamlet"));
                            a.county = NominatimGeocoderHelper.textOrNull(addr, "county");
                            a.state = NominatimGeocoderHelper.textOrNull(addr, "state");
                            a.country = NominatimGeocoderHelper.textOrNull(addr, "country");
                            a.countryCode = NominatimGeocoderHelper.textOrNull(addr, "country_code");
                            GeocoderHelper.Address address = a;
                            return address;
                        }
                        GeocoderHelper.Address address = null;
                        return address;
                    }
                    if (res.code() == 429) {
                        try {
                            Thread.sleep(500L * (long)attempts);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    GeocoderHelper.Address address = null;
                    return address;
                }
                finally {
                    if (res == null) continue;
                    res.close();
                }
            }
            catch (IOException e) {
                try {
                    Thread.sleep(200L * (long)attempts);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }

    private static void validateLatLon(double lat, double lon) {
        if (Double.isNaN(lat) || lat < -90.0 || lat > 90.0) {
            throw new IllegalArgumentException("Latitude invalide: " + lat);
        }
        if (Double.isNaN(lon) || lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Longitude invalide: " + lon);
        }
    }

    private static double safeAsDouble(JsonNode n) {
        if (n == null || n.isNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(n.asText());
        }
        catch (NumberFormatException e) {
            return n.asDouble(0.0);
        }
    }

    private static String textOrNull(JsonNode node, String field) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        JsonNode n = node.get(field);
        return n == null || n.isNull() ? null : n.asText();
    }

    private static String coalesce(String ... vals) {
        if (vals == null) {
            return null;
        }
        for (String v : vals) {
            if (v == null || v.isBlank()) continue;
            return v;
        }
        return null;
    }
}

