/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbFunction;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.GeocoderHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.geocode.SmartGeocoderHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import jakarta.inject.Named;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.List;
import javax.xml.namespace.QName;

public class PeopleTools
extends AbstractAiTool {
    private final CoreGov coreGovClient;

    public PeopleTools(CoreGov coreGovClient) {
        this.coreGovClient = coreGovClient;
    }

    @Tool(value={"Lookup a person's geolocation in Neo4j."})
    @ToolDoc(semantics={"where is {firstName} {lastName}?", "locate {firstName} {lastName}", "find {firstName} {lastName}'s location"}, rules={"If the person is found \u2192 findPersonLocation(<firstName>, <lastName>, <userLanguage>). (userLanguage is either EN (for English) or FR (for French))", "Pass the firstName and/or the lastName perceived; the tool handles normalization and ambiguity.", "Returns the candidates found (zero, one, or multiple)"})
    public GJaxbCommandResponse findPersonLocation(@Named(value="firstName") String firstName, @Named(value="lastName") String lastName, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            if ((firstName == null || firstName.isBlank()) && (lastName == null || lastName.isBlank())) {
                GJaxbCommandResponse resp = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
                if (userLanguage == UserTools.Language.FR) {
                    resp.setCommandOutputMessage("Aucun nom fourni");
                } else {
                    resp.setCommandOutputMessage("No name given");
                }
                return resp;
            }
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(this.getContext().getSelectedKnowledgeSpace());
            String queryReq = "// Param\u00e8tres : $firstName (nullable), $lastName (nullable)\nWITH $firstName AS fn, $lastName AS ln,\n     0.40 AS wF,        // poids pr\u00e9nom\n     0.60 AS wL,        // poids nom\n     0.10 AS bonusStarts,\n     0.05 AS bonusInitial,\n     0.50 AS minW\n\n// Construire la requ\u00eate Lucene fuzzy (~) pour \u00e9largir le rappel\nWITH fn, ln, wF, wL, bonusStarts, bonusInitial, minW,\n     CASE WHEN fn IS NOT NULL AND size(trim(fn)) >= 3 THEN trim(fn) + '~' ELSE coalesce(fn,'') END AS fnTerm,\n     CASE WHEN ln IS NOT NULL AND size(trim(ln)) >= 3 THEN trim(ln) + '~' ELSE coalesce(ln,'') END AS lnTerm\nCALL db.index.fulltext.queryNodes(\n  'person_name_ft',\n  coalesce(fnTerm,'') +\n  (CASE WHEN fnTerm IS NOT NULL AND lnTerm IS NOT NULL THEN ' AND ' ELSE '' END) +\n  coalesce(lnTerm,'')\n) YIELD node, score\n\n// Normalisation\nWITH node, score, wF, wL, bonusStarts, bonusInitial, minW,\n     toLower(trim(coalesce(fn,''))) AS qFn,\n     toLower(trim(coalesce(ln,''))) AS qLn,\n     toLower(trim(coalesce(node.property_firstName,''))) AS nFn,\n     toLower(trim(coalesce(node.property_lastName,'')))  AS nLn\n\n// BIGRAMMES pr\u00e9nom\nWITH node AS p, score, wF, wL, bonusStarts, bonusInitial, minW, qFn, qLn, nFn, nLn,\n     CASE WHEN qFn = '' OR nFn = '' THEN [] ELSE [i IN range(0, size(qFn)-2) | substring(qFn,i,2)] END AS qFnBi,\n     CASE WHEN qFn = '' OR nFn = '' THEN [] ELSE [i IN range(0, size(nFn)-2) | substring(nFn,i,2)] END AS nFnBi,\n     CASE WHEN qFn <> '' AND nFn STARTS WITH qFn THEN bonusStarts ELSE 0.0 END AS bonusFirstPref,\n     CASE WHEN qFn <> '' AND substring(nFn,0,1) = substring(qFn,0,1) THEN bonusInitial ELSE 0.0 END AS bonusFirstInit\nWITH p, score, wF, wL, bonusStarts, bonusInitial, minW, qLn, nLn, bonusFirstPref, bonusFirstInit,\n     size([x IN qFnBi WHERE x IN nFnBi]) AS interF,\n     size(qFnBi) AS aF, size(nFnBi) AS bF\nWITH p, score, wF, wL, bonusStarts, bonusInitial, minW, qLn, nLn, bonusFirstPref, bonusFirstInit,\n     (CASE WHEN (aF + bF - interF) = 0 THEN 1.0 ELSE toFloat(interF) / toFloat(aF + bF - interF) END) AS simFirst\n\n// BIGRAMMES nom\nWITH p, score, wF, wL, bonusStarts, bonusInitial, minW, qLn, nLn, simFirst, bonusFirstPref, bonusFirstInit,\n     CASE WHEN qLn = '' OR nLn = '' THEN [] ELSE [i IN range(0, size(qLn)-2) | substring(qLn,i,2)] END AS qLnBi,\n     CASE WHEN qLn = '' OR nLn = '' THEN [] ELSE [i IN range(0, size(nLn)-2) | substring(nLn,i,2)] END AS nLnBi,\n     CASE WHEN qLn <> '' AND nLn STARTS WITH qLn THEN bonusStarts ELSE 0.0 END AS bonusLastPref,\n     CASE WHEN qLn <> '' AND substring(nLn,0,1) = substring(qLn,0,1) THEN bonusInitial ELSE 0.0 END AS bonusLastInit\nWITH p, score, wF, wL, minW, simFirst, bonusFirstPref, bonusFirstInit, qLnBi, nLnBi, bonusLastPref, bonusLastInit\nWITH p, score, wF, wL, minW, simFirst,\n     size([x IN qLnBi WHERE x IN nLnBi]) AS interL,\n     size(qLnBi) AS aL, size(nLnBi) AS bL,\n     (bonusFirstPref + bonusFirstInit + bonusLastPref + bonusLastInit) AS bonusTotal\nWITH p, score, wF, wL, minW, simFirst, bonusTotal,\n     (CASE WHEN (aL + bL - interL) = 0 THEN 1.0 ELSE toFloat(interL) / toFloat(aL + bL - interL) END) AS simLast\n\n// Score final\nWITH p, score, (wF*simFirst + wL*simLast + bonusTotal) AS confidence, minW\nWHERE confidence >= minW\nRETURN p, confidence, score\nORDER BY confidence DESC, score DESC\nLIMIT 25;\n";
            queryReq = queryReq.replace("$firstName", (CharSequence)(firstName != null ? "'" + firstName.toLowerCase() + "'" : "null")).replace("$lastName", (CharSequence)(lastName != null ? "'" + lastName.toLowerCase() + "'" : "null"));
            queryReq = queryReq.replace("$person", GenericModelHelper.collab((String)"Person").toString());
            query.setQuery(queryReq);
            GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            String name = (firstName != null ? firstName : "") + (String)(lastName != null ? " " + lastName : "");
            e.setForFindPersonLocationResponse(new GJaxbCommandResponse.ForFindPersonLocationResponse());
            e.getForFindPersonLocationResponse().setPersonFirstNameIdentified(firstName);
            e.getForFindPersonLocationResponse().setPersonLastNameIdentified(lastName);
            if (queryResp.getSingle() == null || queryResp.getSingle().getGenericModel() == null || queryResp.getSingle().getGenericModel().getNode() == null) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Je n'ai pas pu localiser " + name);
                } else {
                    e.setCommandOutputMessage("I could not locate " + name);
                }
                e.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                return e;
            }
            for (GJaxbNode node : queryResp.getSingle().getGenericModel().getNode()) {
                GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate candidate = new GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate();
                candidate.setId(node.getId());
                candidate.setName(GenericModelHelper.getName((GJaxbNode)node));
                candidate.setPoint(((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint());
                e.getForFindPersonLocationResponse().getCandidate().add(candidate);
            }
            if (e.getForFindPersonLocationResponse().getCandidate().isEmpty()) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Je n'ai pas pu localiser " + name);
                } else {
                    e.setCommandOutputMessage("I could not locate " + name);
                }
                e.setCommandOutputMessageType(GJaxbMessageType.WARNING);
            } else if (e.getForFindPersonLocationResponse().getCandidate().size() > 1) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Il y a plusieurs candidats pour " + name + ", veuillez \u00eatre plus pr\u00e9cis.");
                } else {
                    e.setCommandOutputMessage("There are multiple candidates for " + name + ", please be more specific.");
                }
                e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
            } else {
                GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate candidate = (GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate)e.getForFindPersonLocationResponse().getCandidate().get(0);
                GJaxbPointType point = candidate.getPoint();
                GeocoderHelper.Address address = SmartGeocoderHelper.getInstance().reverseGeocode(point.getLatitude(), point.getLongitude());
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("J'ai localis\u00e9 " + candidate.getName() + " \u00e0 " + address.toSingleLine());
                } else {
                    e.setCommandOutputMessage("I located " + candidate.getName() + " at " + address.toSingleLine());
                }
                e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Je n'ai pas pu trouver " + firstName + " " + lastName);
            } else {
                e.setCommandOutputMessage("I could not find " + firstName + " " + lastName);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
        }
        return e;
    }

    @Tool(value={"Find information on a person (age, job ...)."})
    @ToolDoc(semantics={"who is {firstName} {lastName}?", "what is the job of {firstName} {lastName}", "find the job of {firstName} {lastName}"}, rules={"Pass the firstName and/or the lastName perceived; the tool handles normalization and ambiguity.", "Returns information on candidates found (zero, one, or multiple)"})
    public GJaxbCommandResponse whoIsThisPerson(@Named(value="firstName") String firstName, @Named(value="lastName") String lastName, @Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            String subjectPronoun;
            GJaxbCommandResponse personFound = this.findPersonLocation(firstName, lastName, userLanguage);
            if (personFound.getForFindPersonLocationResponse() == null || personFound.getForFindPersonLocationResponse().getCandidate().isEmpty()) {
                return personFound;
            }
            if (personFound.getForFindPersonLocationResponse().getCandidate().size() > 1) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Il y a plusieurs candidats pour " + firstName + " " + lastName + ", veuillez \u00eatre plus pr\u00e9cis.");
                } else {
                    e.setCommandOutputMessage("There are multiple candidates for " + firstName + " " + lastName + ", please be more specific.");
                }
                e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
                return e;
            }
            GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate candidate = (GJaxbCommandResponse.ForFindPersonLocationResponse.Candidate)personFound.getForFindPersonLocationResponse().getCandidate().get(0);
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(this.getContext().getSelectedKnowledgeSpace());
            String queryReq = "\t\tMATCH (pers:`$personConcept` { modelNodeId: \"$id\" })\n\n\t\tOPTIONAL MATCH (pers)-[has:`$hasConcept`]->(role:`$roleConcept`)\n\t\tOPTIONAL MATCH (role)-[prov1:`$providesConcept`]->(f1:`$function`)\n\t\tOPTIONAL MATCH (pers)<-[prov2:`$providesConcept`]-(f2:`$function`)\n\n\t\tRETURN DISTINCT pers, role, has, prov1, f1, prov2, f2;\n";
            queryReq = queryReq.replace("$id", Neo4JId.createIdUsingCollaboration((String)candidate.getId(), (String)this.getContext().getSelectedKnowledgeSpace().getCollaborationName(), (String)this.getContext().getSelectedKnowledgeSpace().getKnowledgeName()).toString());
            queryReq = queryReq.replace("$personConcept", GenericModelHelper.collab((String)"Person").toString());
            queryReq = queryReq.replace("$roleConcept", GenericModelHelper.collab((String)"Role").toString());
            queryReq = queryReq.replace("$hasConcept", GenericModelHelper.collab((String)"Has").toString());
            queryReq = queryReq.replace("$providesConcept", GenericModelHelper.collab((String)"Provides").toString());
            queryReq = queryReq.replace("$function", GenericModelHelper.collab((String)"Function").toString());
            query.setQuery(queryReq);
            GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            if (queryResp.getSingle() == null || queryResp.getSingle().getGenericModel() == null || queryResp.getSingle().getGenericModel().getNode() == null) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Je n'ai pas pu trouver " + firstName + " " + lastName);
                } else {
                    e.setCommandOutputMessage("I could not find " + firstName + " " + lastName);
                }
                e.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                return e;
            }
            GJaxbCommandResponse.ForWhoIsThisPersonResponse.Candidate candidateInfo = new GJaxbCommandResponse.ForWhoIsThisPersonResponse.Candidate();
            e.setForWhoIsThisPersonResponse(new GJaxbCommandResponse.ForWhoIsThisPersonResponse());
            e.getForWhoIsThisPersonResponse().getCandidate().add(candidateInfo);
            GJaxbGenericModel model = queryResp.getSingle().getGenericModel();
            GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{model});
            GJaxbNode person = (GJaxbNode)GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Person"), (List)model.getNode()).get(0);
            candidateInfo.setId(person.getId());
            candidateInfo.setName(GenericModelHelper.getName((GJaxbNode)person));
            candidateInfo.setGender(GenericModelHelper.findProperty((String)"gender", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"gender", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setMobilePhoneNumber(GenericModelHelper.findProperty((String)"mobile phone number", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"mobile phone number", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setEmail(GenericModelHelper.findProperty((String)"email", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"email", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setBirthDate(GenericModelHelper.findProperty((String)"birthdate", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"birthdate", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setAge(PeopleTools.calculateAge(candidateInfo.getBirthDate() != null && !candidateInfo.getBirthDate().isBlank() ? LocalDateTime.parse(candidateInfo.getBirthDate()) : null));
            candidateInfo.setHeight((GenericModelHelper.findProperty((String)"height", (List)person.getProperty(), (boolean)false) != null ? Integer.valueOf(Integer.parseInt(GenericModelHelper.findProperty((String)"height", (List)person.getProperty(), (boolean)false).getValue())) : null).intValue());
            candidateInfo.setNationality(GenericModelHelper.findProperty((String)"nationality", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"nationality", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setStatus(GenericModelHelper.findProperty((String)"Presence", (List)person.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"Presence", (List)person.getProperty(), (boolean)false).getValue() : null);
            candidateInfo.setIsolatedFunctions(new GJaxbCommandResponse.ForWhoIsThisPersonResponse.Candidate.IsolatedFunctions());
            List roles = GenericModelHelper.findNodesByType((QName)GenericModelHelper.collab((String)"Role"), (List)model.getNode());
            for (Object role : roles) {
                GJaxbCommandResponse.ForWhoIsThisPersonResponse.Candidate.Job job = new GJaxbCommandResponse.ForWhoIsThisPersonResponse.Candidate.Job();
                job.setJobName(GenericModelHelper.getName((GJaxbNode)role));
                job.setRoleId(role.getId());
                job.setJobDescription(GenericModelHelper.findProperty((String)"description", (List)role.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)role.getProperty(), (boolean)false).getValue() : null);
                candidateInfo.getJob().add(job);
                List edgesProvides = man.findOutputEdgesOfNode((GJaxbNode)role);
                for (GJaxbEdge edgeProvide : edgesProvides) {
                    if (!edgeProvide.getType().equals(GenericModelHelper.collab((String)"Provides"))) continue;
                    GJaxbNode functionNode = edgeProvide.getTarget();
                    GJaxbFunction function = new GJaxbFunction();
                    function.setFunctionId(functionNode.getId());
                    function.setFunctionName(GenericModelHelper.getName((GJaxbNode)functionNode));
                    function.setFunctionDescription(GenericModelHelper.findProperty((String)"description", (List)functionNode.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)functionNode.getProperty(), (boolean)false).getValue() : null);
                    job.getFunction().add(function);
                }
            }
            List edgesProvides = man.findOutputEdgesOfNode(person);
            for (GJaxbEdge edgeProvide : edgesProvides) {
                if (!edgeProvide.getType().equals(GenericModelHelper.collab((String)"Provides"))) continue;
                GJaxbNode functionNode = edgeProvide.getTarget();
                GJaxbFunction function = new GJaxbFunction();
                function.setFunctionId(functionNode.getId());
                function.setFunctionName(GenericModelHelper.getName((GJaxbNode)functionNode));
                function.setFunctionDescription(GenericModelHelper.findProperty((String)"description", (List)functionNode.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)functionNode.getProperty(), (boolean)false).getValue() : null);
                candidateInfo.getIsolatedFunctions().getFunction().add(function);
            }
            String msg = "";
            msg = userLanguage == UserTools.Language.FR ? "$name est un(e) $gender de $age ans. $subjectPronoun a $nJobs emploi(s) : $jobList. " : "$name is a $age year old $gender. $subjectPronoun has $nJobs job(s): $jobList. ";
            String gender = candidateInfo.getGender() != null && candidateInfo.getGender().toLowerCase().equals("male") ? "man" : "woman";
            String string = subjectPronoun = candidateInfo.getGender() != null && candidateInfo.getGender().toLowerCase().equals("male") ? "he" : "she";
            if (userLanguage == UserTools.Language.FR) {
                if (gender.equals("woman")) {
                    gender = "femme";
                    subjectPronoun = "elle";
                } else {
                    gender = "homme";
                    subjectPronoun = "il";
                }
            }
            msg = msg.replace("$name", GenericModelHelper.getName((GJaxbNode)person).toString());
            msg = msg.replace("$gender", gender);
            msg = msg.replace("$subjectPronoun", subjectPronoun);
            msg = msg.replace("$age", "" + candidateInfo.getAge());
            msg = msg.replace("$nJobs", "" + candidateInfo.getJob().size());
            msg = candidateInfo.getJob().isEmpty() ? msg.replace("$jobList", userLanguage == UserTools.Language.FR ? "aucun emploi" : "no job") : msg.replace("$jobList", String.join((CharSequence)", ", candidateInfo.getJob().stream().map(j -> j.getJobName()).toList()));
            e.setCommandOutputMessage(msg);
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Je n'ai pas pu trouver " + firstName + " " + lastName);
            } else {
                e.setCommandOutputMessage("I could not find " + firstName + " " + lastName);
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
        }
        return e;
    }

    public static int calculateAge(LocalDateTime birthDateTime) {
        if (birthDateTime == null) {
            return -1;
        }
        try {
            LocalDate referenceDate = LocalDate.now();
            LocalDate birthDate = birthDateTime.toLocalDate();
            Period period = Period.between(birthDate, referenceDate);
            return period.getYears();
        }
        catch (Exception e) {
            System.err.println("Invalid date format: " + e.getMessage());
            return -1;
        }
    }
}

