/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMonitoredAsset;
import fr.emac.gind.governance.ai.command.assistant.GJaxbSensor;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class SensorTools
extends AbstractAiTool {
    private final CoreGov coreGovClient;

    public SensorTools(CoreGov coreGovClient) {
        this.coreGovClient = coreGovClient;
    }

    @Tool(value={"Lookup a monitored sites in Neo4j."})
    @ToolDoc(semantics={"What do I monitor?", "What do I pilot?", "What components are you monitoring?", "Which monitored assets are my responsibility?"}, rules={"If the utterance contains what/which + monitor/pilot/responsibility \u2192 findMonitoredAssets(<userLanguage>).", "The userLanguage is either EN (for English) or FR (for French).", "Give the names of the buildings and people you are monitoring, if any.", "Returns a detailed list of what you are monitoring (zero, one, or multiple). "})
    public String findMonitoredAssets(@Named(value="userLanguage") UserTools.Language userLanguage) throws Exception {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        try {
            List goods;
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(this.getContext().getSelectedKnowledgeSpace());
            String queryReq = "\t\tMATCH (s:ACTIVE&`{http://fr.emac.gind/core-model}Sensor`)-[f1:`{http://fr.emac.gind/collaborative-model}Fixed_Onto`]->(g:`{http://fr.emac.gind/collaborative-model}Asset`)\n\t\tMATCH p= (g)-[f2:`{http://fr.emac.gind/collaborative-model}Fixed_Onto`*0..]->(root:`{http://fr.emac.gind/collaborative-model}Asset`)\n\t\tWHERE NOT (root)-[:FIXED_ONTO]->() AND ALL(x IN nodes(p) WHERE single(y IN nodes(p) WHERE y = x))\n\t\tRETURN DISTINCT s, f1, g, p\n";
            query.setQuery(queryReq);
            GJaxbQueryResponse queryResp = this.coreGovClient.query(query);
            if (queryResp.getMultiple() == null || queryResp.getMultiple().getGenericModel() == null || queryResp.getMultiple().getGenericModel().isEmpty()) {
                if (userLanguage == UserTools.Language.FR) {
                    e.setCommandOutputMessage("Je ne trouve aucun site que je surveille.");
                } else {
                    e.setCommandOutputMessage("I could not find any sites I monitor.");
                }
                e.setCommandOutputMessageType(GJaxbMessageType.WARNING);
                return JSONJAXBContext.getInstance().marshallAnyElement((Object)e);
            }
            e.setForFindMonitoredAssetsResponse(new GJaxbCommandResponse.ForFindMonitoredAssetsResponse());
            GJaxbGenericModel modelMerged = GenericModelHelper.mergeModels((GJaxbGenericModel[])queryResp.getMultiple().getGenericModel().toArray(new GJaxbGenericModel[queryResp.getMultiple().getGenericModel().size()]));
            List<GJaxbMonitoredAsset> assets = SensorTools.findMonitorerdAssetsFromModel(modelMerged);
            e.getForFindMonitoredAssetsResponse().getMonitoredAsset().addAll(assets);
            HashMap sitesByType = new HashMap();
            for (GJaxbMonitoredAsset s : e.getForFindMonitoredAssetsResponse().getMonitoredAsset()) {
                if (!sitesByType.containsKey(QName.valueOf(s.getType()))) {
                    sitesByType.put(QName.valueOf(s.getType()), new ArrayList());
                }
                ((List)sitesByType.get(QName.valueOf(s.getType()))).add(s);
            }
            Object msg = "";
            List territories = (List)sitesByType.remove(GenericModelHelper.collab((String)"Territory"));
            if (territories != null && !territories.isEmpty()) {
                msg = userLanguage == UserTools.Language.FR ? "Je surveille $nbMonitoredAssets territoires:\n$siteList. " : "I monitor $nbMonitoredAssets territories:\n$siteList. ";
                msg = ((String)msg).replace("$nbMonitoredAssets", "" + territories.size());
                Object siteList = "";
                for (Object s : territories) {
                    String subType;
                    GJaxbNode nBuilding = GenericModelHelper.findNodeById((String)s.getId(), (List)modelMerged.getNode());
                    String string = subType = GenericModelHelper.findProperty((String)"type", (List)nBuilding.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"type", (List)nBuilding.getProperty(), (boolean)false).getValue() : null;
                    if (userLanguage == UserTools.Language.FR) {
                        siteList = (String)siteList + "- " + s.getName() + " (c'est un " + subType + ") avec " + SensorTools.getSensorsRecursively((GJaxbMonitoredAsset)s).size() + " capteurs\n";
                        continue;
                    }
                    siteList = (String)siteList + "- " + s.getName() + " (it is a " + subType + ") with " + SensorTools.getSensorsRecursively((GJaxbMonitoredAsset)s).size() + " sensors\n";
                }
                msg = ((String)msg).replace("$siteList", (CharSequence)siteList);
            }
            if ((goods = (List)sitesByType.remove(GenericModelHelper.collab((String)"Good"))) != null && !goods.isEmpty()) {
                msg = userLanguage == UserTools.Language.FR ? (String)msg + "\nJe surveille $nbGoods biens:\n$goodList. " : "\nI monitor $nbGoods goods:\n$goodList. ";
                msg = ((String)msg).replace("$nbGoods", "" + goods.size());
                Object siteList = "";
                for (GJaxbMonitoredAsset s : goods) {
                    if (userLanguage == UserTools.Language.FR) {
                        siteList = (String)siteList + "- " + s.getName() + " avec " + SensorTools.getSensorsRecursively(s).size() + " capteurs\n";
                        continue;
                    }
                    siteList = (String)siteList + "- " + s.getName() + " with " + SensorTools.getSensorsRecursively(s).size() + " sensors\n";
                }
                msg = ((String)msg).replace("$goodList", (CharSequence)siteList);
            }
            for (Map.Entry entry : sitesByType.entrySet()) {
                QName type = (QName)entry.getKey();
                List sitesOfType = (List)entry.getValue();
                msg = userLanguage == UserTools.Language.FR ? (String)msg + "\nJe surveille $nbAssets " + type.getLocalPart() + ":\n$assetList. " : (String)msg + "\nI also monitor $nbAssets " + type.getLocalPart() + ":\n$assetList. ";
                msg = ((String)msg).replace("$nbAssets", "" + sitesOfType.size());
                Object siteList = "";
                for (GJaxbMonitoredAsset s : sitesOfType) {
                    if (userLanguage == UserTools.Language.FR) {
                        siteList = (String)siteList + "- " + s.getName() + " avec " + SensorTools.getSensorsRecursively(s).size() + " capteurs\n";
                        continue;
                    }
                    siteList = (String)siteList + "- " + s.getName() + " with " + SensorTools.getSensorsRecursively(s).size() + " sensors\n";
                }
                msg = ((String)msg).replace("$assetList", (CharSequence)siteList);
            }
            e.setCommandOutputMessage((String)msg);
            e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (userLanguage == UserTools.Language.FR) {
                e.setCommandOutputMessage("Je n'ai pas pu trouver de site");
            } else {
                e.setCommandOutputMessage("I could not find any sites");
            }
            e.setCommandOutputMessageType(GJaxbMessageType.ERROR);
        }
        return JSONJAXBContext.getInstance().marshallAnyElement((Object)e);
    }

    public static List<GJaxbMonitoredAsset> findMonitorerdAssetsFromModel(GJaxbGenericModel modelMerged) throws Exception {
        ArrayList<GJaxbMonitoredAsset> assets = new ArrayList<GJaxbMonitoredAsset>();
        GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{modelMerged});
        List sites = man.getNodesByType(GenericModelHelper.collab((String)"Asset"));
        for (GJaxbNode site : sites) {
            List edgesFixedOntosOut = man.findOutputEdgesOfNode(site);
            if (edgesFixedOntosOut.stream().filter(eFixedOnto -> eFixedOnto.getType().equals(GenericModelHelper.collab((String)"Fixed_Onto"))).count() != 0L) continue;
            GJaxbMonitoredAsset s = new GJaxbMonitoredAsset();
            s.setId(site.getId());
            s.setName(GenericModelHelper.getName((GJaxbNode)site));
            s.setType(site.getType().toString());
            s.setDescription(GenericModelHelper.findProperty((String)"description", (List)site.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)site.getProperty(), (boolean)false).getValue() : "");
            s.setShape(new GJaxbMonitoredAsset.Shape());
            if (site.getGeolocation() != null && !site.getGeolocation().getItemView().isEmpty()) {
                GJaxbNode.Geolocation.ItemView iv = (GJaxbNode.Geolocation.ItemView)site.getGeolocation().getItemView().get(0);
                if (iv.isSetPoint()) {
                    s.getShape().setPoint(iv.getPoint());
                } else if (iv.isSetPredefinedShape()) {
                    s.getShape().setPredefinedShape(iv.getPredefinedShape());
                } else if (iv.isSetPolyline()) {
                    s.getShape().setPolyline(iv.getPolyline());
                } else if (iv.isSetArea()) {
                    s.getShape().setArea(iv.getArea());
                }
            }
            s.setInternalMonitoredAssets(new GJaxbMonitoredAsset.InternalMonitoredAssets());
            SensorTools.findInternalMonitoredAssets(man, site, s);
            assets.add(s);
        }
        return assets;
    }

    public static List<GJaxbSensor> getSensorsRecursively(GJaxbMonitoredAsset s) {
        ArrayList<GJaxbSensor> sensors = new ArrayList<GJaxbSensor>();
        sensors.addAll(s.getSensor());
        if (s.isSetInternalMonitoredAssets()) {
            for (GJaxbMonitoredAsset is : s.getInternalMonitoredAssets().getMonitoredAsset()) {
                sensors.addAll(SensorTools.getSensorsRecursively(is));
            }
        }
        return sensors;
    }

    private static void findInternalMonitoredAssets(GenericModelManager man, GJaxbNode site, GJaxbMonitoredAsset s) {
        List edgesFixedOntosIn = man.findInputEdgesOfNode(site);
        for (GJaxbEdge edgeFixedOnto : edgesFixedOntosIn) {
            if (!edgeFixedOnto.getType().equals(GenericModelHelper.collab((String)"Fixed_Onto"))) continue;
            GJaxbNode sourceNode = edgeFixedOnto.getSource();
            if (sourceNode.getType().equals(GenericModelHelper.core((String)"Sensor"))) {
                GJaxbNode sensorNode = sourceNode;
                GJaxbSensor sensor = new GJaxbSensor();
                sensor.setId(sensorNode.getId());
                sensor.setName(GenericModelHelper.getName((GJaxbNode)sensorNode));
                sensor.setType(GenericModelHelper.findProperty((String)"nature", (List)sensorNode.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"nature", (List)sensorNode.getProperty(), (boolean)false).getValue() : "");
                sensor.setDescription(GenericModelHelper.findProperty((String)"description", (List)sensorNode.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)sensorNode.getProperty(), (boolean)false).getValue() : "");
                s.getSensor().add(sensor);
                continue;
            }
            if (!sourceNode.getType().equals(GenericModelHelper.collab((String)"Good"))) continue;
            GJaxbNode internalMonitoredAsset = sourceNode;
            GJaxbMonitoredAsset is = new GJaxbMonitoredAsset();
            is.setId(internalMonitoredAsset.getId());
            is.setName(GenericModelHelper.getName((GJaxbNode)internalMonitoredAsset));
            is.setType(internalMonitoredAsset.getType().toString());
            is.setDescription(GenericModelHelper.findProperty((String)"description", (List)internalMonitoredAsset.getProperty(), (boolean)false) != null ? GenericModelHelper.findProperty((String)"description", (List)internalMonitoredAsset.getProperty(), (boolean)false).getValue() : "");
            s.getInternalMonitoredAssets().getMonitoredAsset().add(is);
            SensorTools.findInternalMonitoredAssets(man, internalMonitoredAsset, is);
        }
    }
}

