/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.governance.ai.command.assistant.GJaxbToolsInfo;
import fr.emac.gind.governance.ai.command.assistant.agent.ToolIntrospector;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AiContext;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.GoodTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.MapUiTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.NewsTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.PeopleTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.ProblemsTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.SensorTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.SolutionTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.WeatherTools;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.WindowTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ToolsManager {
    private static ToolsManager INSTANCE = null;
    private NewsTools newsTools = null;
    private WeatherTools weatherTools = null;
    private UserTools userTools = null;
    private MapUiTools mapUiTools = null;
    private PeopleTools peopleTools = null;
    private PeopleTools goodTools = null;
    private SensorTools sensorTools = null;
    private ProblemsTools problemTools = null;
    private SolutionTools businessTools = null;
    private Map<String, AbstractAiTool> toolsMap = new HashMap<String, AbstractAiTool>();

    ToolsManager() {
    }

    public static ToolsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ToolsManager();
        }
        return INSTANCE;
    }

    public void initialize(CoreGov coreGovClient, AiChatbot aiChatbotClient, Map<String, Object> context) throws Exception {
        NewsTools newsTools = new NewsTools();
        WeatherTools weatherTools = new WeatherTools();
        UserTools userTools = new UserTools();
        WindowTools windowTools = new WindowTools();
        MapUiTools mapUiTools = new MapUiTools(windowTools);
        PeopleTools peopleTools = new PeopleTools(coreGovClient);
        GoodTools goodTools = new GoodTools(coreGovClient);
        SensorTools sensorTools = new SensorTools(coreGovClient);
        ProblemsTools problemTools = new ProblemsTools(coreGovClient, aiChatbotClient);
        SolutionTools solutionTools = new SolutionTools(context);
        this.toolsMap.put("newsTools", newsTools);
        this.toolsMap.put("weatherTools", weatherTools);
        this.toolsMap.put("userTools", userTools);
        this.toolsMap.put("windowTools", windowTools);
        this.toolsMap.put("mapUiTools", mapUiTools);
        this.toolsMap.put("peopleTools", peopleTools);
        this.toolsMap.put("goodTools", goodTools);
        this.toolsMap.put("sensorTools", sensorTools);
        this.toolsMap.put("problemTools", problemTools);
        this.toolsMap.put("solutionTools", solutionTools);
    }

    public Map<String, AbstractAiTool> getToolsMap() {
        return this.toolsMap;
    }

    public List<AbstractAiTool> getToolsList() {
        return new ArrayList<AbstractAiTool>(this.toolsMap.values());
    }

    public GJaxbToolsInfo getToolsInfoForChatSystem() {
        ArrayList<AbstractAiTool> tools = new ArrayList<AbstractAiTool>(this.toolsMap.values());
        try {
            GJaxbToolsInfo toolsInfo = ToolIntrospector.buildInfo(ToolIntrospector.Mode.TEXT_CHAT, "You are an assistant able to accurately detect specific user commands recognized by the system.\nYour task is to identify these commands and activate the corresponding and appropriate tools.\nIf no command is detected, this means the question is open-ended, and you must provide an appropriate answer.\nThe text of this open-ended answer should be in the answerIfNoneToolsAreDetected variable.\nIf you know the username (via the 'detectUser' tool), don't hesitate to use it in your answers.\nIf the beginning of the user's text is in French, respond in French\nIf one or more commands are detected, call each tool and provide the list of responses following the JSON schema provided below.\nThen, create a general confirmation message (globalAcknowledgmentMessage) by synthesizing the contents of the variable 'commandOutputMessage' of each command\n\nAVAILABLE TOOLS (name, signature, description):\n{{tools_definition}}\n\nSemantic hints (typical user phrasings):\n{{tools_semantic}}\n\nRules:\n{{tools_rules}}\n\nOUTPUT FORMAT IN JSON (JSON SCHEMA):\n{{tools_json_schema}}\n", tools.toArray(new Object[tools.size()]));
            return toolsInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while building tools info: " + e.getMessage(), e);
        }
    }

    public GJaxbToolsInfo getToolsInfoForRealtimeSystem() throws Exception {
        ArrayList<AbstractAiTool> tools = new ArrayList<AbstractAiTool>(this.toolsMap.values());
        GJaxbToolsInfo toolsInfo = ToolIntrospector.buildInfo(ToolIntrospector.Mode.AUDIO, "You are a voice assistant named \"Rio\" or \"Ryo\". You are in a meeting room with several people. You must listen to the conversations, but **only respond if someone explicitly calls you by your name** (for example: \"Rio,\" \"Hey Rio,\" \"Tell me Rio,\" \"OK Rio,\" \"Yo Rio,\" etc.).\nIf the sentence does not contain your name, you completely ignore what was said and produce **no response**.\nIf you are addressed directly, then respond naturally, concisely, and relevantly to the question asked, like an assistant present in the room.\nIf you see that the request made to you will take some time to process (more than 3 seconds), try to fill the silence by saying that the request is being processed.\nDo not give automatic introductions or greetings: simply respond to the content of the request.\nIf you have not been called, **do not speak, do not make any noise, and do not generate any text or audio**.\nYou are an assistant able to accurately detect specific user commands recognized by the system.\nYour task is to identify these commands and activate the corresponding and appropriate tools.\nIf no command is detected, this means the question is open-ended, and you must provide an appropriate answer.\nThe text of this open-ended answer should be in the answerIfNoneToolsAreDetected variable.\nIf you know the username (via the 'detectUser' tool), don't hesitate to use it in your answers.\nIf the beginning of the user's text is in French, respond in French\nIf one or more commands are detected, call each tool and provide responses in the TEXT channel,\nfollowing the JSON schema provided below. Then, create a general confirmation message (globalAcknowledgmentMessage)\nto indicate that you have understood the user's request(s) (if available, you can summarize the confirmation messages of the individual commands, which are usually found in the 'commandOutputMessage' variable of each command).\nIf no command is detected, this means the question is open-ended, and you must provide an appropriate answer. The text of this open-ended answer should be in the answerIfNoneToolsAreDetected variable.\nIf the user speaks French, respond in French.\nIf you know the username (via the 'detectUser' tool), don't hesitate to use it in your answers.\n\"Important:\n\" +\n                 \"1) You may call tools when helpful.\n\" +\n                 \"2) AUDIO modality is a brief summary for the user; TEXT modality is for tool calls or structured content.\n\";\nAVAILABLE TOOLS (name, signature, description):\n{{tools_definition}}\n\nSemantic hints (typical user phrasings):\n{{tools_semantic}}\n\nRules:\n{{tools_rules}}\n\nOUTPUT FORMAT IN JSON (JSON SCHEMA):\n{{tools_json_schema}}\n", tools.toArray(new Object[tools.size()]));
        return toolsInfo;
    }

    public void setContext(AiContext context) {
        for (AbstractAiTool tool : this.toolsMap.values()) {
            tool.setContext(context);
        }
    }

    public <T> T getToolByClass(Class<T> clazz) {
        for (AbstractAiTool tool : this.toolsMap.values()) {
            if (!clazz.isInstance(tool)) continue;
            return clazz.cast(tool);
        }
        return null;
    }
}

