/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import jakarta.inject.Named;

public class UserTools
extends AbstractAiTool {
    @Tool(value={"Detect the user name"})
    @ToolDoc(semantics={"my name is [userName]", "I'am [userName]", "it is [userName]"}, rules={"The \"username\" can be a nickname or a first name (it cannot contain punctuation (no space, no comma, etc ...) and cannot be more than 3 words long).", "If the user name is explicitly mentioned \u2192 detectUser(<userName>, <userLanguage>). (userLanguage is either EN (for English) or FR (for French))"})
    public GJaxbCommandResponse detectUser(@Named(value="userName") String userName, @Named(value="userLanguage") Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        e.setForDetectUserResponse(new GJaxbCommandResponse.ForDetectUserResponse());
        e.getForDetectUserResponse().setUserName(userName);
        if (userLanguage == Language.FR) {
            e.setCommandOutputMessage("Bonjour " + userName + ", j'attends tes instructions");
        } else {
            e.setCommandOutputMessage("Hello " + userName + ", I await your instructions");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }

    public static enum Language {
        FR,
        EN;

    }
}

