/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.ai.command.assistant.agent.tools;

import dev.langchain4j.agent.tool.Tool;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.governance.ai.command.assistant.GJaxbCommandResponse;
import fr.emac.gind.governance.ai.command.assistant.GJaxbExceptedWindows;
import fr.emac.gind.governance.ai.command.assistant.GJaxbMessageType;
import fr.emac.gind.governance.ai.command.assistant.agent.annotation.ToolDoc;
import fr.emac.gind.governance.ai.command.assistant.agent.helpers.CommandHelper;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.AbstractAiTool;
import fr.emac.gind.governance.ai.command.assistant.agent.tools.UserTools;
import jakarta.inject.Named;

public class WindowTools
extends AbstractAiTool {
    @Tool(value={"Close a window"})
    @ToolDoc(semantics={"hide the {windowName} window", "close the {windowName} window", "mask the {windowName} window"}, rules={"If the utterance contains hide/close/mask + {windowName} \u2192 closeWindow(<windowName>).", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse closeWindow(@Named(value="windowName") String windowName, @Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("La fen\u00eatre " + windowName + " est maintenant ferm\u00e9e.");
        } else {
            e.setCommandOutputMessage("The " + windowName + " is now hidden.");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        e.setForCloseWindowResponse(new GJaxbCommandResponse.ForCloseWindowResponse());
        e.getForCloseWindowResponse().setWindowName(windowName);
        return e;
    }

    @Tool(value={"Close all windows"})
    @ToolDoc(semantics={"Close all windows", "Hide all windows", "Mask all windows"}, rules={"If the utterance contains hide/close/mask + all \u2192 closeAllWindows().", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse closeAllWindows(@Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("Toutes les fen\u00eatres sont ferm\u00e9es.");
        } else {
            e.setCommandOutputMessage("All windows are closed.");
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }

    @Tool(value={"Close all windows except {windowsNamesList} "})
    @ToolDoc(semantics={"Close all windows except {windowsNamesList}", "Close all except {windowsNamesList}", "Hide all windows except {windowsNamesList}", "Mask all windows except {windowsNamesList}"}, rules={"If the utterance contains hide/close/mask + all + except + {windowsNamesList} \u2192 closeAllWindowsExcept(<windowsNamesList>).", "The userLanguage is either EN (for English) or FR (for French)"})
    public GJaxbCommandResponse closeAllWindowsExcept(@Named(value="exceptedWindowsNamesList") GJaxbExceptedWindows exceptedWindowsNamesList, @Named(value="userLanguage") UserTools.Language userLanguage) {
        GJaxbCommandResponse e = CommandHelper.create(ReflectionHelper.getCurrentMethod((Object)this));
        e.setForCloseAllWindowsExceptResponse(new GJaxbCommandResponse.ForCloseAllWindowsExceptResponse());
        e.getForCloseAllWindowsExceptResponse().getExceptedWindowNames().addAll(exceptedWindowsNamesList.getWindowName());
        if (userLanguage == UserTools.Language.FR) {
            e.setCommandOutputMessage("Toutes les fen\u00eatres sont ferm\u00e9es sauf : " + String.valueOf(exceptedWindowsNamesList));
        } else {
            e.setCommandOutputMessage("All windows are closed except: " + String.valueOf(exceptedWindowsNamesList));
        }
        e.setCommandOutputMessageType(GJaxbMessageType.SUCCESS);
        return e;
    }
}

