/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance;

import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.client.CampaignManagerClient;
import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.event_broker.EventBroker;
import fr.emac.gind.event.event_broker.data.GJaxbRegister;
import fr.emac.gind.event.event_broker.data.GJaxbTopic;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.event.producer.simulator.EventBrokerClient;
import fr.emac.gind.gov.ai.chatbot.service.AIChatbotImpl;
import fr.emac.gind.gov.ai.command.assistant.AiCommandAssistant;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.edge.Code2LEdgeModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.ActualityAndPotentialityModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.FunctionModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.SensorModelsPopulateInterceptor;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.service.Neo4JBasicConnectorImpl;
import fr.emac.gind.gov.core.service.SystemGovImpl;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.deduction.DeductionCallBack;
import fr.emac.gind.gov.deduction.DeductionImpl;
import fr.emac.gind.gov.meta_core.service.MetaCoreGovImpl;
import fr.emac.gind.gov.models.service.ModelsGovImpl;
import fr.emac.gind.gov.models.util.ModelsPopulateModelInterceptor;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.system_gov.SystemGov;
import fr.emac.gind.governance.ai.command.assistant.service.AICommandAssistantImpl;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.humantask.client.HumanTaskClient;
import fr.emac.gind.ll.LLManager;
import fr.emac.gind.ll.LLManagerNotifier;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.meta.models.core.service.MetaModelsGovImpl;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceWebService
extends SPIWebServicePrimitives {
    private static final Logger LOG = LoggerFactory.getLogger((String)GovernanceWebService.class.getName());
    private NotificationManagerImpl producer = null;
    protected CoreGov coreGov = null;
    protected SystemGov systemGov = null;
    private Neo4JBasicConnectorImpl neo4jGov = null;
    private ModelsGovImpl modelsGov = null;
    private CampaignManagerItf campaignClient = null;
    private Humantask humanTaskApi = null;
    private DeductionCallBack deduceCallbackClient = null;
    private MetaCoreGovImpl metaCoreGov = null;
    private MetaModelsGovImpl metaModelsGov = null;
    private DeductionImpl deductionGov = null;
    private AIChatbotImpl chatbotGov = null;
    private AiCommandAssistant commandAssistantGov = null;

    public void onInit(final Map<String, Object> context) {
        try {
            URL topicSetUrl = Thread.currentThread().getContextClassLoader().getResource("CoreGovTopicSet.xml");
            GJaxbTopicSetType topicSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(topicSetUrl, GJaxbTopicSetType.class);
            String storageAddress = (String)context.get("storage");
            if (storageAddress != null) {
                this.producer = new NotificationManagerImpl(GovernanceWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"GovCoreSubscriber"), storageAddress, "GovCoreSubscriber_" + RegExpHelper.toRegexFriendlyName((String)this.getHost().replace(".", "_")) + "_" + this.port, new HashMap(), topicSet, null, new ResourcesManager[0]);
                this.registerWSImplementation("GovCoreSubscriber", this.producer);
                LOG.warn("GovCoreSubscriber is started !!!");
            }
            this.coreGov = new CoreGovImpl(context, this.producer, Arrays.asList(new ActualityAndPotentialityModelsPopulateInterceptor(), new FunctionModelsPopulateInterceptor(), new SensorModelsPopulateInterceptor()), Arrays.asList(new Code2LEdgeModelsPopulateInterceptor()));
            this.modelsGov = new ModelsGovImpl(this.coreGov, new ModelsPopulateModelInterceptor[0]);
            ((CoreGovImpl)this.coreGov).setModelsGov((ModelsGov)this.modelsGov);
            this.systemGov = new SystemGovImpl(context, this.coreGov);
            this.metaCoreGov = new MetaCoreGovImpl(context, (CoreGovImpl)this.coreGov);
            this.metaModelsGov = new MetaModelsGovImpl((ModelsGov)this.modelsGov);
            ((CoreGovImpl)this.coreGov).setModelsGov((ModelsGov)this.modelsGov);
            this.neo4jGov = new Neo4JBasicConnectorImpl(this.coreGov);
            if (context.get("campaign-manager") != null) {
                String campaignManagerAddress = (String)context.get("campaign-manager");
                this.campaignClient = CampaignManagerClient.createClient((String)campaignManagerAddress);
            }
            if (context.get("humantask") != null) {
                String huamnTaskServerAddress = (String)context.get("humantask");
                this.humanTaskApi = HumanTaskClient.createClient((String)huamnTaskServerAddress);
            }
            this.deductionGov = new DeductionImpl(context, this.coreGov, (ModelsGov)this.modelsGov, this.humanTaskApi, this.campaignClient);
            this.chatbotGov = new AIChatbotImpl(context);
            this.commandAssistantGov = new AICommandAssistantImpl(context);
            this.registerWSImplementation("GovCore", this.coreGov);
            this.registerWSImplementation("GovSystem", this.systemGov);
            this.registerWSImplementation("GovNeo4J", this.neo4jGov);
            this.registerWSImplementation("GovMetaCore", this.metaCoreGov);
            this.registerWSImplementation("GovMetaModels", this.metaModelsGov);
            this.registerWSImplementation("GovModels", this.modelsGov);
            this.registerWSImplementation("GovDeduction", this.deductionGov);
            this.registerWSImplementation("GovAIChatbot", this.chatbotGov);
            this.registerWSImplementation("GovAICommandAssistant", this.commandAssistantGov);
            if ((String)context.get("event-broker") != null) {
                final GovernanceWebService container = this;
                ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
                service.execute(new Runnable(){
                    final /* synthetic */ GovernanceWebService this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        while (!container.isStarted()) {
                            LOG.trace("Wait core gov container start");
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        GJaxbRegister request = new GJaxbRegister();
                        String coreGovSubscriberAddress = this.this$0.producer.getAddress();
                        try {
                            GJaxbTopicSetType topicSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("CoreGovTopicSet.xml"), GJaxbTopicSetType.class);
                            for (QName topic : WSNHelper.getInstance().getTopic(topicSet)) {
                                GJaxbTopic t = new GJaxbTopic();
                                t.setName(topic);
                                request.getTopic().add(t);
                            }
                            request.setAddress(coreGovSubscriberAddress);
                            String brokerAddressRegister = ((String)context.get("event-broker")).replace("/BrokerSubscriber", "/BrokerRegister");
                            EventBroker clientBroker = EventBrokerClient.createClient((String)brokerAddressRegister);
                            boolean ok = false;
                            while (!ok) {
                                try {
                                    clientBroker.register(request);
                                    ok = true;
                                }
                                catch (Throwable e) {
                                    LOG.error("[CORE GOV] Impossible to connect to event broker. Try again....");
                                    try {
                                        Thread.sleep(300L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            LLManagerNotifier llManagerNotifier = LLManager.getInstance().subscribeOnUpdateNodeEvent(context, (ModelsGov)this.this$0.modelsGov);
                            this.this$0.registerWSImplementation("LLNotifier", llManagerNotifier);
                        }
                        catch (Exception e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UncheckedException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        ((CoreGovImpl)this.coreGov).shutdown();
        super.stop();
    }

    public static GovernanceWebService create(final int port, final String storageAddress) throws Exception {
        GovernanceWebService collabGovServer = new GovernanceWebService();
        collabGovServer.start(new HashMap<String, Object>(){
            {
                this.put("host", "localhost");
                this.put("port", port);
                this.put("neo4j-database-embedded", true);
                this.put("storage", storageAddress);
            }
        });
        return collabGovServer;
    }
}

