/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.governance.launcher;

import fr.emac.gind.governance.GovernanceWebService;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import java.util.HashMap;
import java.util.Map;

public class GovernanceLauncher
extends AbstractLauncher {
    private GovernanceWebService gov = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("Gov Service.\n");
        res.append("Number of services exposed: " + this.gov.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.gov.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "Gov Service";
    }

    public String getPromptName() {
        return "gov";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.gov = new GovernanceWebService();
        this.map.clear();
        this.map.putAll(conf.getProperties());
        this.gov.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.gov.stop();
    }
}

