/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.deduction.client;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.gov.deduction.DeduceFault;
import fr.emac.gind.gov.deduction.Deduction;
import fr.emac.gind.gov.deduction.GJaxbDeduceASync;
import fr.emac.gind.gov.deduction.GJaxbDeduceASyncResponse;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import jakarta.jws.WebMethod;
import jakarta.jws.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DeductionClient
implements Deduction {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private DeductionClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static Deduction createClient(String remoteAddress) throws Exception {
        Deduction client = (Deduction)LocalRegistry.getInstance().findWSImplementation(Deduction.class);
        if (client == null) {
            client = new DeductionClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gov/deduction/deduceASync")
    @WebResult(name="deduceASyncResponse", targetNamespace="http://www.gind.emac.fr/gov/deduction/", partName="parameters")
    public GJaxbDeduceASyncResponse deduceASync(GJaxbDeduceASync parameters) throws DeduceFault {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/gov/deduction/deduceASync");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDeduceASyncResponse response = (GJaxbDeduceASyncResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDeduceASyncResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new DeduceFault(e.getMessage(), null, e);
        }
    }
}

