/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.deduction;

import fr.emac.gind.campaign.manager.CampaignManagerItf;
import fr.emac.gind.campaign.manager.data.model.GJaxbCampaign;
import fr.emac.gind.campaign.manager.data.model.GJaxbStatusType;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.deduction.DeduceFault;
import fr.emac.gind.gov.deduction.Deduction;
import fr.emac.gind.gov.deduction.DeductionCallBack;
import fr.emac.gind.gov.deduction.GJaxbDeduceASync;
import fr.emac.gind.gov.deduction.GJaxbDeduceASyncResponse;
import fr.emac.gind.gov.deduction.GJaxbDeductionASyncCallBackResponse;
import fr.emac.gind.gov.deduction.GJaxbFault;
import fr.emac.gind.gov.deduction.client.DeductionCallBackClient;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.processgeneratorinstance.GJaxbProcessGeneratorInstance;
import fr.emac.gind.processgeneratorinstance.GJaxbProcessGeneratorInstances;
import fr.emac.gind.workflow.AbstractProcessGenerator;
import fr.emac.gind.workflow.deduction.AbstractDeductionStrategy;
import fr.emac.gind.workflow.deduction.ProcessDeductionHelper;
import fr.emac.gind.workflow.deduction.campaign.CampaignResult;
import fr.emac.gind.workflow.deduction.campaign.ErrorResult;
import fr.emac.gind.workflow.deduction.campaign.ProgressResult;
import fr.emac.gind.workflow.deduction.campaign.ScenarioResult;
import fr.emac.gind.workflow.report.GJaxbDeductionCampaignStatusType;
import fr.emac.gind.workflow.report.GJaxbDeductionProgress;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="deductionSOAPEndpoint", serviceName="deductionService", targetNamespace="http://www.gind.emac.fr/gov/deduction/", wsdlLocation="wsdl/deduction.wsdl", endpointInterface="fr.emac.gind.gov.deduction.Deduction")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class DeductionImpl
implements Deduction {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeductionImpl.class.getName());
    private Map<String, Object> context = null;
    private ServiceLoader<AbstractProcessGenerator> processGeneratorLoader = ServiceLoader.load(AbstractProcessGenerator.class);
    private Map<String, AbstractProcessGenerator> processGenerators = new HashMap<String, AbstractProcessGenerator>();
    private CoreGov core = null;
    private ModelsGov modelsGov = null;
    private Humantask humanTaskApi = null;
    private CampaignManagerItf campaignClient = null;

    public DeductionImpl(Map<String, Object> context, CoreGov coreGov, ModelsGov modelsGov, Humantask humanTaskApi, CampaignManagerItf campaignClient) throws Exception {
        this.context = context;
        this.core = coreGov;
        this.modelsGov = modelsGov;
        this.humanTaskApi = humanTaskApi;
        this.campaignClient = campaignClient;
        this.initProcessGenerators();
    }

    private GJaxbProcessGeneratorInstances initProcessGenerators() throws Exception {
        GJaxbProcessGeneratorInstances res = new GJaxbProcessGeneratorInstances();
        this.processGenerators.clear();
        this.processGeneratorLoader.reload();
        for (AbstractProcessGenerator processGenerator : this.processGeneratorLoader) {
            if (processGenerator.getDeductionStrategy() != null) {
                processGenerator.getDeductionStrategy().setCoreClient(this.core);
                processGenerator.getDeductionStrategy().setModelClient(this.modelsGov);
                processGenerator.getDeductionStrategy().setCampaignClient(this.campaignClient);
                processGenerator.getDeductionStrategy().setContext(this.context);
            }
            this.processGenerators.put(processGenerator.getDeductionStrategy().getClass().getName(), processGenerator);
            GJaxbProcessGeneratorInstance gen = new GJaxbProcessGeneratorInstance();
            if (processGenerator.getDeductionStrategy() != null) {
                gen.setName(processGenerator.getDeductionStrategy().getName());
                gen.setClazz(processGenerator.getDeductionStrategy().getClass().getName());
                gen.setDescription(processGenerator.getDeductionStrategy().getDescription());
                gen.setNgFunction(processGenerator.getDeductionStrategy().getJavascriptFunction());
                gen.setNgFunctionParams(processGenerator.getDeductionStrategy().getJavascriptFunctionParameters().toString());
                gen.setFavoriteDomains(processGenerator.getDeductionStrategy().getFavoriteDomains());
            }
            res.getProcessGeneratorInstance().add(gen);
        }
        return res;
    }

    public GJaxbDeduceASyncResponse deduceASync(GJaxbDeduceASync parameters) throws DeduceFault {
        GJaxbDeduceASyncResponse campaignResponse = new GJaxbDeduceASyncResponse();
        try {
            AbstractProcessGenerator processGenerator = this.processGenerators.get(parameters.processGeneratorInstance.getClazz());
            if (processGenerator.getDeductionStrategy() != null) {
                processGenerator.getDeductionStrategy().setCoreClient(this.core);
            }
            GJaxbNode project = ProcessDeductionHelper.getInstance().findProject(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), this.core);
            processGenerator.getDeductionStrategy().initialize(this.core, this.modelsGov, this.humanTaskApi, this.campaignClient, parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), project);
            String defaultCampaignName = "campaign_" + parameters.getCurrentKnowledgeSpaceName() + "_" + String.valueOf(UUID.randomUUID());
            GJaxbCampaign campaign = AbstractDeductionStrategy.createCampaignIfNotExist((CampaignManagerItf)this.campaignClient, (String)defaultCampaignName, (GJaxbNode)project, (long)0L, (String)parameters.getCurrentCollaborationName(), (String)parameters.getCurrentKnowledgeSpaceName());
            campaignResponse.setCampaignId(campaign.getCampaignId());
            campaignResponse.setDeductionMode(parameters.getDeductionMode());
            CoreGovImpl.ACTIVATE_QUERIES_CACHE = true;
            EffectiveMetaModelPluginManager.getInstance().clearCaches();
            DeductionCallBack deductionCallBackClient = DeductionCallBackClient.createClient((String)parameters.callBackAddress);
            LinkedBlockingQueue campaignResultsQueue = new LinkedBlockingQueue();
            processGenerator.getDeductionStrategy().deduceSolution(campaign, parameters.deductionMode, parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), parameters.inputDeductionData.getProperty(), project, campaignResultsQueue);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(() -> {
                GJaxbDeductionCampaignStatusType campaignStatus = GJaxbDeductionCampaignStatusType.RUNNING;
                CampaignResult result = null;
                while (campaignStatus.equals((Object)GJaxbDeductionCampaignStatusType.RUNNING)) {
                    try {
                        CampaignResult selector0$temp;
                        System.out.println("Wait campaign result...");
                        result = (CampaignResult)campaignResultsQueue.take();
                        GJaxbDeductionASyncCallBackResponse response = new GJaxbDeductionASyncCallBackResponse();
                        response.setDeductionProgress(new GJaxbDeductionProgress());
                        response.getDeductionProgress().setCampaignId(campaign.getCampaignId());
                        response.getDeductionProgress().setCampaignName(campaign.getCampaignName());
                        response.getDeductionProgress().setDeductionMode(parameters.deductionMode);
                        response.getDeductionProgress().setCollaborationName(parameters.getCurrentCollaborationName());
                        response.getDeductionProgress().setKnowledgeSpaceName(parameters.getCurrentKnowledgeSpaceName());
                        Objects.requireNonNull(result);
                        int index$1 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgressResult.class, ScenarioResult.class, ErrorResult.class}, (CampaignResult)selector0$temp, index$1)) {
                            case 0: {
                                ProgressResult pr = (ProgressResult)selector0$temp;
                                campaign.setNumberOfSolution(Integer.valueOf(pr.getReport().getNumberOfSolutionsToProcess()));
                                campaign.setNumberOfSolutionAchieved(Integer.valueOf(pr.getReport().getSolutionProcessed()));
                                campaign.setNumberOfFailureSolution(Integer.valueOf(0));
                                if (pr.getReport().getError() != null) {
                                    GJaxbCampaign.Error error = new GJaxbCampaign.Error();
                                    error.setErrorMessage(pr.getReport().getError().getErrorMessage());
                                    error.setErrorStacktrace(pr.getReport().getError().getErrorStacktrace());
                                    campaign.setError(error);
                                }
                                processGenerator.getDeductionStrategy().publishReportInCampaign(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), null, null, campaign);
                                if (pr.getReport().getDeductionCampaignStatus().equals((Object)GJaxbDeductionCampaignStatusType.ENDED)) {
                                    campaignStatus = GJaxbDeductionCampaignStatusType.ENDED;
                                }
                                response.getDeductionProgress().setProgressionReport(pr.getReport());
                                break;
                            }
                            case 1: {
                                ScenarioResult sr = (ScenarioResult)selector0$temp;
                                processGenerator.getDeductionStrategy().publishReportInCampaign(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), sr.getReport(), sr.getSolution(), campaign);
                                response.getDeductionProgress().setDeductionReport(sr.getReport());
                                break;
                            }
                            case 2: {
                                ErrorResult er = (ErrorResult)selector0$temp;
                                campaign.setError(new GJaxbCampaign.Error());
                                campaign.getError().setErrorMessage(er.getReport().getError().getErrorMessage());
                                campaign.getError().setErrorStacktrace(er.getReport().getError().getErrorStacktrace());
                                processGenerator.getDeductionStrategy().publishReportInCampaign(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), null, null, campaign);
                                response.getDeductionProgress().setErrorReport(er.getReport());
                                campaignStatus = GJaxbDeductionCampaignStatusType.CRASHED;
                                break;
                            }
                        }
                        deductionCallBackClient.deductionASyncCallBackResponse(response);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (campaign != null) {
                    try {
                        campaign.setEndedAt(XMLGregorianCalendarHelper.getInstance().getNewCalendar());
                        campaign.setStatus(GJaxbStatusType.valueOf((String)campaignStatus.toString()));
                        campaign.setNumberOfSolution(campaign.getNumberOfSolution());
                        processGenerator.getDeductionStrategy().publishReportInCampaign(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), null, null, campaign);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            GJaxbFault fault = new GJaxbFault();
            fault.setMessage(e.getMessage());
            fault.setStacktrace("test");
            throw new DeduceFault(e.getMessage(), fault);
        }
        finally {
            CoreGovImpl.ACTIVATE_QUERIES_CACHE = false;
            CoreGovImpl.QUERIES_CACHE.clear();
        }
        return campaignResponse;
    }
}

