/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.models.util;

import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.service.Neo4JRecord;
import fr.emac.gind.gov.core.service.Neo4JResult;
import fr.emac.gind.gov.core.util.CoreGovDriverConnectorUtil;
import fr.emac.gind.gov.core.util.query.QueryStructure;
import fr.emac.gind.gov.core.util.query.With;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.models.service.ModelsGovImpl;
import fr.emac.gind.gov.models.util.ExtractHelper;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractionASyncOptions;
import fr.emac.gind.gov.models_gov.GJaxbExtractionASyncStatus;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.models_gov.ModelsGovCallback;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONObject;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASyncExtractDriverConnector
extends CoreGovDriverConnectorUtil {
    private static Logger LOG = LoggerFactory.getLogger((String)ASyncExtractDriverConnector.class.getName());
    private static ASyncExtractDriverConnector INSTANCE = null;
    private CompletionService<GJaxbExtractASyncModelCallBack> completionService = null;
    private List<Future<GJaxbExtractASyncModelCallBack>> runningFutures = new ArrayList<Future<GJaxbExtractASyncModelCallBack>>();

    private ASyncExtractDriverConnector() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.completionService = new ExecutorCompletionService<GJaxbExtractASyncModelCallBack>(executor);
    }

    public static ASyncExtractDriverConnector getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ASyncExtractDriverConnector();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void extractBashTransaction(Driver driver, final CoreGov coreGov, ModelsGov modelsGov, final ModelsGovCallback callbackClient, final String requestId, final String collaborationName, final String knowledgeSpaceName, final GJaxbExtractSyncModel.ExtractionQuery extractionQueryMode, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels, GJaxbExtractionASyncOptions extractAsynOptions) throws Exception {
        GJaxbGenericModel resultFuture;
        GJaxbExtractSyncModelResponse res = new GJaxbExtractSyncModelResponse();
        this.runningFutures = new ArrayList<Future<GJaxbExtractASyncModelCallBack>>();
        int limit = extractAsynOptions.getBashOptions().getLotSize();
        int index = 0;
        List<QueryStructure> extractionQueries = null;
        GJaxbEffectiveDomain effDomain = null;
        if (extractionQueryMode.isSetPackage()) {
            effDomain = ((ModelsGovImpl)modelsGov).getEffectiveDomain(collaborationName, knowledgeSpaceName, extractionQueryMode.getDomain());
            extractionQueries = ExtractHelper.getInstance().createModelExtractionQueryFromPackage(effDomain, extractionQueryMode.getPackage(), collaborationName, knowledgeSpaceName, status, exclusionStatus, labels);
        } else if (extractionQueryMode.isSetDomain()) {
            effDomain = ((ModelsGovImpl)modelsGov).getEffectiveDomain(collaborationName, knowledgeSpaceName, extractionQueryMode.getDomain());
            extractionQueries = ExtractHelper.getInstance().createModelExtractionQueryFromDomain(effDomain, extractionQueryMode.getDomain(), collaborationName, knowledgeSpaceName, status, exclusionStatus, labels);
        } else if (extractionQueryMode.isSetQuery()) {
            throw new Exception("Not supported for now in async mode. (Pease, use sync mode)");
        }
        final GJaxbEffectiveDomain effDomainFinal = effDomain;
        JSONObject countResult = this.countRequest(driver, coreGov, collaborationName, knowledgeSpaceName, extractionQueries);
        final int expectedCountNodes = countResult.getInt("count_n");
        final int expectedCountEdges = countResult.getInt("count_r");
        for (QueryStructure query : extractionQueries) {
            query.get_return().setLimit(String.valueOf(limit));
            query.get_return().setSkip(String.valueOf(index));
        }
        final GJaxbGenericModel[] mergeModels = new GJaxbGenericModel[]{new GJaxbGenericModel()};
        int currentCountNodes = 0;
        int currentCountEdges = 0;
        while (index < expectedCountNodes + expectedCountEdges) {
            final String extractQuery = QueryStructure.union(extractionQueries);
            Future<GJaxbExtractASyncModelCallBack> future = this.completionService.submit(new Callable<GJaxbExtractASyncModelCallBack>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GJaxbExtractASyncModelCallBack call() throws Exception {
                    GJaxbExtractASyncModelCallBack requestCallback;
                    block6: {
                        requestCallback = new GJaxbExtractASyncModelCallBack();
                        try {
                            requestCallback.setRequestTopicId(requestId);
                            requestCallback.setStatus(GJaxbExtractionASyncStatus.ENDED);
                            requestCallback.setTotalExpectedNodes(expectedCountNodes);
                            requestCallback.setTotalExpectedNodes(expectedCountEdges);
                            GJaxbGenericModel currentModel = null;
                            GJaxbQuery query = new GJaxbQuery();
                            query.setQuery(extractQuery);
                            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                            GJaxbQueryResponse qresponse = coreGov.query(query);
                            if (qresponse.getSingle() != null) {
                                currentModel = qresponse.getSingle().getGenericModel();
                            }
                            if (currentModel == null) break block6;
                            ModelsGovImpl.validModel(currentModel, effDomainFinal, extractionQueryMode.getPackage(), (CoreGovImpl)coreGov);
                            requestCallback.setStatus(GJaxbExtractionASyncStatus.RUNNING);
                            requestCallback.setExtractSyncModelResponse(new GJaxbExtractSyncModelResponse());
                            requestCallback.getExtractSyncModelResponse().setGenericModel(currentModel);
                            callbackClient.extractASyncModelCallBack(requestCallback);
                            GJaxbGenericModel gJaxbGenericModel = mergeModels[0];
                            synchronized (gJaxbGenericModel) {
                                mergeModels[0] = GenericModelHelper.mergeModels((GJaxbGenericModel[])new GJaxbGenericModel[]{mergeModels[0], currentModel});
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return requestCallback;
                }
            });
            this.runningFutures.add(future);
            index += limit;
            for (QueryStructure query : extractionQueries) {
                query.get_return().setSkip(String.valueOf(index));
            }
        }
        for (int receivedFutures = 0; receivedFutures < this.runningFutures.size(); ++receivedFutures) {
            resultFuture = this.completionService.take();
        }
        resultFuture = mergeModels[0];
        synchronized (resultFuture) {
            currentCountNodes = mergeModels[0].getNode().size();
            currentCountEdges = mergeModels[0].getEdge().size();
        }
        GJaxbExtractASyncModelCallBack requestCallback = new GJaxbExtractASyncModelCallBack();
        requestCallback.setRequestTopicId(requestId);
        requestCallback.setStatus(GJaxbExtractionASyncStatus.ENDED);
        requestCallback.setTotalExpectedNodes(expectedCountNodes);
        requestCallback.setTotalExpectedNodes(expectedCountEdges);
        requestCallback.setExtractSyncModelResponse(new GJaxbExtractSyncModelResponse());
        requestCallback.getExtractSyncModelResponse().setGenericModel(null);
        callbackClient.extractASyncModelCallBack(requestCallback);
    }

    private JSONObject countRequest(Driver driver, CoreGov coreGov, String collaborationName, String knowledgeSpaceName, List<QueryStructure> extractionQueries) throws Exception {
        JSONObject res = new JSONObject();
        int count_n = 0;
        int count_r = 0;
        for (QueryStructure query : extractionQueries) {
            QueryStructure countQueryNode = query.cloneQuery();
            countQueryNode.getWiths().add(new With());
            if (countQueryNode.get_return().get_return().contains("node1")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct node1");
                countQueryNode.get_return().set_return("count(node1) as count_n");
            } else if (countQueryNode.get_return().get_return().contains("relation1")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct relation1");
                countQueryNode.get_return().set_return("count(relation1) as count_r");
            } else if (countQueryNode.get_return().get_return().contains("parent")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct parent");
                countQueryNode.get_return().set_return("count(parent) as count_n");
            } else if (countQueryNode.get_return().get_return().contains("rp")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct rp");
                countQueryNode.get_return().set_return("count(rp) as count_r");
            } else if (countQueryNode.get_return().get_return().contains("child")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct child");
                countQueryNode.get_return().set_return("count(child) as count_n");
            } else if (countQueryNode.get_return().get_return().contains("rc")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct rc");
                countQueryNode.get_return().set_return("count(rc) as count_r");
            } else if (countQueryNode.get_return().get_return().contains("ec")) {
                ((With)countQueryNode.getWiths().get(0)).setWith("distinct ec");
                countQueryNode.get_return().set_return("count(ec) as count_r");
            }
            countQueryNode.get_return().setOrder_by(null);
            GJaxbQuery queryNode = new GJaxbQuery();
            queryNode.setQuery(countQueryNode.toString());
            queryNode.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            queryNode.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            queryNode.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            Neo4JResult result = CoreGovDriverConnectorUtil.executeQuery((Driver)driver, null, (String)countQueryNode.toString(), (String)collaborationName, (String)knowledgeSpaceName);
            Neo4JRecord record = result.getSingleRecord();
            if (record.findOtherValuesByName("count_n") != null) {
                count_n += Integer.parseInt(record.findOtherValuesByName("count_n").toString());
            }
            if (record.findOtherValuesByName("count_r") == null) continue;
            count_r += Integer.parseInt(record.findOtherValuesByName("count_r").toString());
        }
        res.put("count_n", count_n);
        res.put("count_r", count_r);
        return res;
    }
}

