/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.models.service;

import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.util.query.QueryStructure;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.core_gov.ObjectFactory;
import fr.emac.gind.gov.models.client.ModelsGovCallbackClient;
import fr.emac.gind.gov.models.util.ASyncExtractDriverConnector;
import fr.emac.gind.gov.models.util.ExtractHelper;
import fr.emac.gind.gov.models.util.ModelsPopulateModelInterceptor;
import fr.emac.gind.gov.models.util.PublishDriverConnector;
import fr.emac.gind.gov.models_gov.FaultMessage;
import fr.emac.gind.gov.models_gov.GJaxbCloneASyncModelFromStatus;
import fr.emac.gind.gov.models_gov.GJaxbCloneASyncModelFromStatusCallBack;
import fr.emac.gind.gov.models_gov.GJaxbCloneASyncModelFromStatusResponse;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatus;
import fr.emac.gind.gov.models_gov.GJaxbCloneSyncModelFromStatusResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbExtractASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbExtractSyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbExtractionASyncMode;
import fr.emac.gind.gov.models_gov.GJaxbExtractionASyncOptions;
import fr.emac.gind.gov.models_gov.GJaxbExtractionASyncStatus;
import fr.emac.gind.gov.models_gov.GJaxbFault;
import fr.emac.gind.gov.models_gov.GJaxbFreezeASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbFreezeASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbFreezeASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbFreezeSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbFreezeSyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModelCallBack;
import fr.emac.gind.gov.models_gov.GJaxbPublishASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbPublishMode;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.gov.models_gov.GJaxbPublishSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbPublishUnpublishResultType;
import fr.emac.gind.gov.models_gov.GJaxbSendCallbackError;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishASyncModel;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishASyncModelResponse;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishSyncModel;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.models_gov.ModelsGovCallback;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.M2MMConverter;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.neo4j.driver.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="models_govSOAP", serviceName="models_gov", targetNamespace="http://www.gind.emac.fr/gov/models_gov/", wsdlLocation="wsdl/models-gov.wsdl", endpointInterface="fr.emac.gind.gov.models_gov.ModelsGov")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class ModelsGovImpl
implements ModelsGov,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)ModelsGovImpl.class.getName());
    private ObjectFactory factory = new ObjectFactory();
    private CoreGov coreGov = null;
    private Driver driver = null;
    private List<ModelsPopulateModelInterceptor> interceptors = null;

    public ModelsGovImpl(CoreGov coreGov, ModelsPopulateModelInterceptor ... interceptors) {
        this.coreGov = coreGov;
        this.driver = ((CoreGovImpl)this.coreGov).getDriver();
        this.interceptors = Arrays.asList(interceptors);
    }

    public GJaxbPublishUnpublishResultType publishSyncModel(GJaxbPublishSyncModel parameters) throws FaultMessage {
        String collaborationName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getCollaborationName()) : null;
        String knowledgeName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getKnowledgeName()) : null;
        return this.publishUnpublishSync(PublishDriverConnector.ModeType.PUBLISH, parameters.getGenericModel(), collaborationName, knowledgeName, parameters.getPublishOptions());
    }

    public GJaxbPublishUnpublishResultType unpublishSyncModel(GJaxbUnpublishSyncModel parameters) throws FaultMessage {
        String collaborationName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getCollaborationName()) : null;
        String knowledgeName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getKnowledgeName()) : null;
        return this.publishUnpublishSync(PublishDriverConnector.ModeType.UNPUBLISH, parameters.getGenericModel(), collaborationName, knowledgeName, parameters.getPublishOptions());
    }

    private GJaxbPublishUnpublishResultType publishUnpublishSync(PublishDriverConnector.ModeType mode, GJaxbGenericModel model, String collaborationName, String knowledgeName, GJaxbPublishOptions options) throws FaultMessage {
        GJaxbPublishUnpublishResultType res = new GJaxbPublishUnpublishResultType();
        try {
            if (options == null) {
                options = new GJaxbPublishOptions();
            }
            if (options.getPublishMode() == null) {
                options.setPublishMode(GJaxbPublishMode.COMPLETE_TRANSACTION);
            }
            if (options.isSetPreAndPostTreatment() && options.getPreAndPostTreatment().isSetActivatePreAndPostTreatment() && options.getPreAndPostTreatment().isActivatePreAndPostTreatment()) {
                this.postTreatmentBeforePushModel(model, collaborationName, knowledgeName, options);
            }
            if (GJaxbPublishMode.COMPLETE_TRANSACTION.equals((Object)options.getPublishMode())) {
                res = new PublishDriverConnector(this.driver, this.coreGov, mode).publishCompleteTransaction(model, collaborationName, knowledgeName, options);
            } else if (GJaxbPublishMode.BASH_TRANSACTION.equals((Object)options.getPublishMode())) {
                res = new PublishDriverConnector(this.driver, this.coreGov, mode).publishBashTransaction(model, options.getBashOptions(), collaborationName, knowledgeName, options);
            } else if (GJaxbPublishMode.UNITARY_TRANSACTION.equals((Object)options.getPublishMode())) {
                res = new PublishDriverConnector(this.driver, this.coreGov, mode).publishUnitaryTransaction(model, collaborationName, knowledgeName, options);
            }
            if (options.isSetPreAndPostTreatment() && options.getPreAndPostTreatment().isSetActivatePreAndPostTreatment() && options.getPreAndPostTreatment().isActivatePreAndPostTreatment()) {
                this.postTreatmentAfterPushModel(model, collaborationName, knowledgeName, options);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return res;
    }

    private void postTreatmentBeforePushModel(GJaxbGenericModel model, String collaborationName, String knowledgeName, GJaxbPublishOptions options) throws Exception {
        for (ModelsPopulateModelInterceptor interceptor : this.interceptors) {
            if (!interceptor.isConcernedBy(model)) continue;
            interceptor.setCoreGov(this.coreGov);
            interceptor.actionBeforePushModel(model, collaborationName, knowledgeName, options);
        }
    }

    private void postTreatmentAfterPushModel(GJaxbGenericModel model, String collaborationName, String knowledgeName, GJaxbPublishOptions options) throws Exception {
        for (ModelsPopulateModelInterceptor interceptor : this.interceptors) {
            if (!interceptor.isConcernedBy(model)) continue;
            interceptor.setCoreGov(this.coreGov);
            interceptor.actionAfterPushModel(model, collaborationName, knowledgeName, options);
        }
    }

    public GJaxbExtractSyncModelResponse extractSyncModel(GJaxbExtractSyncModel parameters) throws FaultMessage {
        String collaborationName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getCollaborationName()) : null;
        String knowledgeSpaceName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getKnowledgeName()) : null;
        GJaxbExtractSyncModelResponse res = new GJaxbExtractSyncModelResponse();
        String extractionQuery = null;
        try {
            GJaxbEffectiveDomain effDomain = null;
            if (parameters.getExtractionQuery().isSetQuery()) {
                extractionQuery = parameters.getExtractionQuery().getQuery();
            } else if (parameters.getExtractionQuery().isSetPackage()) {
                effDomain = this.getEffectiveDomain(collaborationName, knowledgeSpaceName, parameters.getExtractionQuery().getDomain());
                newLabels = new ArrayList<String>(parameters.getLabel());
                ListUtil.deleteDuplicate(newLabels);
                extractionQuery = QueryStructure.union(ExtractHelper.getInstance().createModelExtractionQueryFromPackage(effDomain, parameters.getExtractionQuery().getPackage(), collaborationName, knowledgeSpaceName, parameters.getStatus(), parameters.getExclusionStatus(), newLabels));
            } else if (parameters.getExtractionQuery().isSetDomain()) {
                effDomain = this.getEffectiveDomain(collaborationName, knowledgeSpaceName, parameters.getExtractionQuery().getDomain());
                newLabels = new ArrayList(parameters.getLabel());
                ListUtil.deleteDuplicate(newLabels);
                extractionQuery = QueryStructure.union(ExtractHelper.getInstance().createModelExtractionQueryFromDomain(effDomain, parameters.getExtractionQuery().getDomain(), collaborationName, knowledgeSpaceName, parameters.getStatus(), parameters.getExclusionStatus(), newLabels));
            }
            GJaxbQuery query = new GJaxbQuery();
            query.setQuery(extractionQuery);
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            GJaxbQueryResponse qresponse = this.coreGov.query(query);
            GJaxbGenericModel model = null;
            if (qresponse.getSingle() != null) {
                model = qresponse.getSingle().getGenericModel();
            } else {
                model = new GJaxbGenericModel();
                for (GJaxbGenericModel pathExtraction : qresponse.getMultiple().getGenericModel()) {
                    for (GJaxbNode node : pathExtraction.getNode()) {
                        if (GenericModelHelper.contains((GJaxbNode)node, (List)model.getNode())) continue;
                        model.getNode().add(node);
                    }
                    for (GJaxbEdge edge : pathExtraction.getEdge()) {
                        if (GenericModelHelper.contains((GJaxbEdge)edge, (List)model.getEdge())) continue;
                        model.getEdge().add(edge);
                    }
                }
            }
            ModelsGovImpl.validModel(model, effDomain, parameters.getExtractionQuery().getPackage(), (CoreGovImpl)this.coreGov);
            res.setGenericModel(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Impossible to realize this extraction query: " + extractionQuery);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbEffectiveDomain getEffectiveDomain(String collaborationName, String knowledgeSpaceName, String specifiedDomainName) throws Exception {
        if ("uml".equals(RegExpHelper.toRegexFriendlyName((String)specifiedDomainName))) {
            return EffectiveMetaModelPluginManager.getInstance().getUmlEffectiveDomain();
        }
        GJaxbEffectiveDomain effDomain = null;
        if (EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName) != null) {
            effDomain = EffectiveMetaModelPluginManager.getInstance().getCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName);
        }
        if (effDomain == null) {
            List<QueryStructure> queries = ExtractHelper.getInstance().createMetaModelExtractionQueryFromDomainAndOrPackage(specifiedDomainName, null, collaborationName, knowledgeSpaceName, null);
            GJaxbQuery query = new GJaxbQuery();
            query.setQuery(queries.get(0).toString());
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            GJaxbQueryResponse qresponse = this.coreGov.query(query);
            if (qresponse.getSingle() == null) {
                throw new Exception("Impossible to find effective model with: " + queries.get(0).toString());
            }
            GJaxbGenericModel model = qresponse.getSingle().getGenericModel();
            effDomain = M2MMConverter.getInstance().convertGenericModelToEffectiveDomain(model);
            EffectiveMetaModelPluginManager.getInstance().setCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName, effDomain);
        }
        return effDomain;
    }

    public static void validModel(GJaxbGenericModel model, GJaxbEffectiveDomain effDomain, QName packageQName, CoreGovImpl coreGov) throws Exception {
        if (model != null) {
            for (GJaxbEdge edge : model.getEdge()) {
                if (edge.getSource() == null && edge.getTarget() == null) {
                    throw new Exception("Source and Target of " + edge.getId() + " are both null !");
                }
                GJaxbNode source = GenericModelHelper.findNodeById((String)edge.getSource().getId(), (List)model.getNode());
                if (source == null) continue;
                CoreGovImpl.addOrUpdateBrokenEdgesFromEdge((GJaxbEdge)edge, (GJaxbNode)source);
            }
            if (packageQName != null) {
                GJaxbEffectiveMetaModel effModel = effDomain.getEffectivePackage().stream().filter(effp -> {
                    String packageName = effp.getName();
                    return packageName.equals(packageQName.getLocalPart());
                }).findFirst().get().getEffectiveMetaModelOfPackage().getEffectiveMetaModel();
                List validTypes = effModel.getEffectiveConcept().stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
                ArrayList<GJaxbNode> nodesToRemove = new ArrayList<GJaxbNode>();
                for (GJaxbNode node : model.getNode()) {
                    if (validTypes.contains(node.getType())) continue;
                    nodesToRemove.add(node);
                }
                ArrayList<GJaxbEdge> edgesToRemove = new ArrayList<GJaxbEdge>();
                for (GJaxbEdge edge : model.getEdge()) {
                    for (GJaxbNode nodeToRemove : nodesToRemove) {
                        if (!edge.getSource().getId().equals(nodeToRemove.getId()) && !edge.getTarget().getId().equals(nodeToRemove.getId())) continue;
                        edgesToRemove.add(edge);
                    }
                }
                for (GJaxbNode nodeToRemove : nodesToRemove) {
                    model.getNode().remove(nodeToRemove);
                }
                for (GJaxbEdge edgeToRemove : edgesToRemove) {
                    model.getEdge().remove(edgeToRemove);
                }
            }
        }
    }

    public GJaxbFreezeSyncModelResponse freezeSyncModel(GJaxbFreezeSyncModel parameters) throws FaultMessage {
        String collaborationName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getCollaborationName()) : null;
        String knowledgeSpaceName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getKnowledgeName()) : null;
        GJaxbFreezeSyncModelResponse res = new GJaxbFreezeSyncModelResponse();
        GJaxbQuery query = new GJaxbQuery();
        try {
            GJaxbGenericModel model = parameters.getGenericModel();
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            res.setCount(0);
            if (model != null) {
                for (GJaxbNode node : model.getNode()) {
                    query.setQuery("match (n { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)node.getId(), (String)collaborationName, (String)knowledgeSpaceName) + "'} ) set n:" + String.valueOf(GJaxbStatusType.FREEZE) + " remove n:" + String.valueOf(GJaxbStatusType.ACTIVE) + " return n");
                    this.coreGov.query(query);
                }
                res.setCount(model.getNode().size());
            }
        }
        catch (Exception e) {
            LOG.error("Impossible to realize this query: " + query.getQuery());
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbCloneSyncModelFromStatusResponse cloneSyncModelFromStatus(GJaxbCloneSyncModelFromStatus parameters) throws FaultMessage {
        String collaborationName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getCollaborationName()) : null;
        String knowledgeSpaceName = parameters.getSelectedKnowledgeSpace() != null ? RegExpHelper.toRegexFriendlyName((String)parameters.getSelectedKnowledgeSpace().getKnowledgeName()) : null;
        GJaxbCloneSyncModelFromStatusResponse res = new GJaxbCloneSyncModelFromStatusResponse();
        GJaxbQuery query = new GJaxbQuery();
        try {
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            String inLabel = "`" + parameters.getStatusIn().name() + "`";
            if (collaborationName != null && knowledgeSpaceName != null) {
                inLabel = inLabel + ":`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`:`" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "`";
            }
            if (!parameters.getAdditionalInLabel().isEmpty()) {
                inLabel = inLabel + ":`" + parameters.getAdditionalInLabel().stream().collect(Collectors.joining(":`")) + "`";
            }
            query.setQuery("match (n:" + inLabel + ") return distinct n as item union match (n1:" + inLabel + ")-[r]-(n2:" + inLabel + ") return distinct r as item");
            GJaxbQueryResponse qresponse = this.coreGov.query(query);
            StringBuffer prefix = new StringBuffer(parameters.getStatusOut().name().toLowerCase() + "##");
            if (!parameters.getAdditionalOutLabel().isEmpty()) {
                for (Object label : parameters.getAdditionalOutLabel()) {
                    prefix.append((String)label + "##");
                }
            }
            if (qresponse.getSingle() != null) {
                GJaxbGenericModel model = qresponse.getSingle().getGenericModel();
                for (GJaxbNode n : model.getNode()) {
                    String nodeId = n.getId().lastIndexOf("##") > 0 ? n.getId().substring(n.getId().lastIndexOf("##") + "##".length()) : n.getId();
                    n.setId(prefix.toString() + nodeId);
                    n.getStatus().clear();
                    n.getStatus().add(parameters.getStatusOut());
                    GJaxbNode parent = GenericModelHelper.findFirstParent((GJaxbNode)n, (GJaxbGenericModel)model);
                    if (parent != null) {
                        String parentNodeId = parent.getId().lastIndexOf("##") > 0 ? parent.getId().substring(parent.getId().lastIndexOf("##") + "##".length()) : parent.getId();
                        parent.setId(prefix.toString() + parentNodeId);
                    }
                    if (!n.isSetBrokenEdges()) continue;
                    for (GJaxbNode.BrokenEdges.BrokenEdge be : n.getBrokenEdges().getBrokenEdge()) {
                        GJaxbProperty provides;
                        GJaxbProperty satisfies;
                        String edgeId = be.getEdge().getId().lastIndexOf("##") > 0 ? be.getEdge().getId().substring(be.getEdge().getId().lastIndexOf("##") + "##".length()) : be.getEdge().getId();
                        be.getEdge().setId(prefix.toString() + edgeId);
                        if (be.isSetSourceId()) {
                            String edgeSourceId = be.getSourceId().lastIndexOf("##") > 0 ? be.getSourceId().substring(be.getSourceId().lastIndexOf("##") + "##".length()) : be.getSourceId();
                            be.setSourceId(prefix.toString() + edgeSourceId);
                        }
                        if (be.isSetTargetId()) {
                            String edgeTargetId = be.getTargetId().lastIndexOf("##") > 0 ? be.getTargetId().substring(be.getTargetId().lastIndexOf("##") + "##".length()) : be.getTargetId();
                            be.setTargetId(prefix.toString() + edgeTargetId);
                        }
                        if ((satisfies = GenericModelHelper.findProperty((String)"satisfies", (List)n.getProperty())) != null) {
                            JSONObject satisfiesJson = new JSONObject(satisfies.getValue());
                            String satisifiesId = satisfiesJson.getString("id").lastIndexOf("##") > 0 ? satisfiesJson.getString("id").substring(satisfiesJson.getString("id").lastIndexOf("##") + "##".length()) : satisfiesJson.getString("id");
                            satisfiesJson.put("id", (Object)satisifiesId);
                        }
                        if ((provides = GenericModelHelper.findProperty((String)"provides", (List)n.getProperty())) == null) continue;
                        JSONObject providesJson = new JSONObject(provides.getValue());
                        String providesId = providesJson.getString("id").lastIndexOf("##") > 0 ? providesJson.getString("id").substring(providesJson.getString("id").lastIndexOf("##") + "##".length()) : providesJson.getString("id");
                        providesJson.put("id", (Object)providesId);
                    }
                }
                model.getEdge().forEach(e -> {
                    String edgeId = e.getId().lastIndexOf("##") > 0 ? e.getId().substring(e.getId().lastIndexOf("##") + "##".length()) : e.getId();
                    e.setId(prefix.toString() + edgeId);
                    if (e.isSetSource()) {
                        String edgeSourceId = e.getSource().getId().lastIndexOf("##") > 0 ? e.getSource().getId().substring(e.getSource().getId().lastIndexOf("##") + "##".length()) : e.getSource().getId();
                        e.getSource().setId(prefix.toString() + edgeSourceId);
                    }
                    if (e.isSetTarget()) {
                        String edgeTargetId = e.getTarget().getId().lastIndexOf("##") > 0 ? e.getTarget().getId().substring(e.getTarget().getId().lastIndexOf("##") + "##".length()) : e.getTarget().getId();
                        e.getTarget().setId(prefix.toString() + edgeTargetId);
                    }
                });
                GJaxbPublishSyncModel publishRequest = new GJaxbPublishSyncModel();
                publishRequest.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                publishRequest.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                publishRequest.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                publishRequest.setGenericModel(model);
                publishRequest.setPublishOptions(new GJaxbPublishOptions());
                publishRequest.getPublishOptions().getLabel().addAll(parameters.getAdditionalOutLabel());
                publishRequest.getPublishOptions().getLabel().add(CoreGovImpl.DEFAULT_INSTANCE_NODE_LABEL);
                publishRequest.getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
                publishRequest.getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
                publishRequest.getPublishOptions().setNotification(new GJaxbNotification());
                publishRequest.getPublishOptions().getNotification().setActivateNotification(false);
                this.publishSyncModel(publishRequest);
                res.setClonedAt(XMLGregorianCalendarHelper.getInstance().getNewCalendar());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new FaultMessage(e2.getMessage(), null, (Throwable)e2);
        }
        return res;
    }

    public GJaxbPublishASyncModelResponse publishASyncModel(final GJaxbPublishASyncModel parameters) throws FaultMessage {
        GJaxbPublishASyncModelResponse asyncResp = new GJaxbPublishASyncModelResponse();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){
            final /* synthetic */ ModelsGovImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ModelsGovCallback callbackClient = null;
                try {
                    callbackClient = ModelsGovCallbackClient.createClient((String)parameters.getCallbackAddress());
                    GJaxbPublishUnpublishResultType syncResp = this.this$0.publishSyncModel(parameters.getPublishSyncModel());
                    GJaxbPublishASyncModelCallBack asyncReq = new GJaxbPublishASyncModelCallBack();
                    asyncReq.setRequestTopicId(parameters.getRequestTopicId());
                    asyncReq.setPublishSyncModelResponse(syncResp);
                    callbackClient.publishASyncModelCallBack(asyncReq);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    GJaxbSendCallbackError errorReq = new GJaxbSendCallbackError();
                    errorReq.setRequestTopicId(parameters.getRequestTopicId());
                    errorReq.setFault(new GJaxbFault());
                    errorReq.getFault().setMessage(e.getMessage());
                    errorReq.getFault().setStacktrace(ExceptionUtils.getStackTrace((Throwable)e));
                    callbackClient.sendCallbackError(errorReq);
                    e.printStackTrace();
                }
            }
        });
        return asyncResp;
    }

    public GJaxbUnpublishASyncModelResponse unpublishASyncModel(final GJaxbUnpublishASyncModel parameters) throws FaultMessage {
        GJaxbUnpublishASyncModelResponse asyncResp = new GJaxbUnpublishASyncModelResponse();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){
            final /* synthetic */ ModelsGovImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ModelsGovCallbackClient callbackClient = null;
                try {
                    callbackClient = (ModelsGovCallbackClient)ModelsGovCallbackClient.createClient((String)parameters.getCallbackAddress());
                    GJaxbPublishUnpublishResultType syncResp = this.this$0.unpublishSyncModel(parameters.getUnpublishSyncModel());
                    GJaxbPublishASyncModelCallBack asyncReq = new GJaxbPublishASyncModelCallBack();
                    asyncReq.setRequestTopicId(parameters.getRequestTopicId());
                    asyncReq.setPublishSyncModelResponse(syncResp);
                    callbackClient.publishASyncModelCallBack(asyncReq);
                }
                catch (Exception e) {
                    GJaxbSendCallbackError errorReq = new GJaxbSendCallbackError();
                    errorReq.setRequestTopicId(parameters.getRequestTopicId());
                    errorReq.setFault(new GJaxbFault());
                    errorReq.getFault().setMessage(e.getMessage());
                    errorReq.getFault().setStacktrace(ExceptionUtils.getStackTrace((Throwable)e));
                    callbackClient.sendCallbackError(errorReq);
                    e.printStackTrace();
                }
            }
        });
        return asyncResp;
    }

    public GJaxbExtractASyncModelResponse extractASyncModel(final GJaxbExtractASyncModel parameters) throws FaultMessage {
        final String collaborationName = parameters.getExtractSyncModel().getSelectedKnowledgeSpace() != null ? parameters.getExtractSyncModel().getSelectedKnowledgeSpace().getCollaborationName() : null;
        final String knowledgeSpaceName = parameters.getExtractSyncModel().getSelectedKnowledgeSpace() != null ? parameters.getExtractSyncModel().getSelectedKnowledgeSpace().getKnowledgeName() : null;
        GJaxbExtractASyncModelResponse asyncResp = new GJaxbExtractASyncModelResponse();
        final ModelsGovImpl modelsGov = this;
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){
            final /* synthetic */ ModelsGovImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                block8: {
                    ModelsGovCallback callbackClient = null;
                    try {
                        callbackClient = ModelsGovCallbackClient.createClient((String)parameters.getCallbackAddress());
                        if (parameters.getExtractionASyncOptions() == null) {
                            parameters.setExtractionASyncOptions(new GJaxbExtractionASyncOptions());
                        }
                        if (parameters.getExtractionASyncOptions().getExtractionASyncMode() == null) {
                            parameters.getExtractionASyncOptions().setExtractionASyncMode(GJaxbExtractionASyncMode.COMPLETE_TRANSACTION);
                        }
                        if (GJaxbExtractionASyncMode.COMPLETE_TRANSACTION.equals((Object)parameters.getExtractionASyncOptions().getExtractionASyncMode())) {
                            GJaxbExtractSyncModelResponse syncResp = this.this$0.extractSyncModel(parameters.getExtractSyncModel());
                            GJaxbExtractASyncModelCallBack asyncReq = new GJaxbExtractASyncModelCallBack();
                            asyncReq.setRequestTopicId(parameters.getRequestTopicId());
                            asyncReq.setTotalExpectedNodes(syncResp.getGenericModel() != null ? syncResp.getGenericModel().getNode().size() : 0);
                            asyncReq.setTotalExpectedNodes(syncResp.getGenericModel() != null ? syncResp.getGenericModel().getEdge().size() : 0);
                            asyncReq.setExtractSyncModelResponse(syncResp);
                            asyncReq.setStatus(GJaxbExtractionASyncStatus.ENDED);
                            callbackClient.extractASyncModelCallBack(asyncReq);
                            break block8;
                        }
                        if (GJaxbExtractionASyncMode.BASH_TRANSACTION.equals((Object)parameters.getExtractionASyncOptions().getExtractionASyncMode())) {
                            ASyncExtractDriverConnector.getInstance().extractBashTransaction(this.this$0.driver, this.this$0.coreGov, modelsGov, callbackClient, parameters.getRequestTopicId(), collaborationName, knowledgeSpaceName, parameters.getExtractSyncModel().getExtractionQuery(), parameters.getExtractSyncModel().getStatus(), parameters.getExtractSyncModel().getExclusionStatus(), parameters.getExtractSyncModel().getLabel(), parameters.getExtractionASyncOptions());
                            break block8;
                        }
                        if (GJaxbExtractionASyncMode.UNITARY_TRANSACTION.equals((Object)parameters.getExtractionASyncOptions().getExtractionASyncMode())) {
                            if (parameters.getExtractionASyncOptions().getBashOptions() == null) {
                                parameters.getExtractionASyncOptions().setBashOptions(new GJaxbExtractionASyncOptions.BashOptions());
                            }
                            parameters.getExtractionASyncOptions().getBashOptions().setLotSize(1);
                            ASyncExtractDriverConnector.getInstance().extractBashTransaction(this.this$0.driver, this.this$0.coreGov, modelsGov, callbackClient, parameters.getRequestTopicId(), collaborationName, knowledgeSpaceName, parameters.getExtractSyncModel().getExtractionQuery(), parameters.getExtractSyncModel().getStatus(), parameters.getExtractSyncModel().getExclusionStatus(), parameters.getExtractSyncModel().getLabel(), parameters.getExtractionASyncOptions());
                            break block8;
                        }
                        throw new Exception("Not implemented");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        GJaxbSendCallbackError errorReq = new GJaxbSendCallbackError();
                        errorReq.setRequestTopicId(parameters.getRequestTopicId());
                        errorReq.setFault(new GJaxbFault());
                        errorReq.getFault().setMessage(e.getMessage());
                        errorReq.getFault().setStacktrace(ExceptionUtils.getStackTrace((Throwable)e));
                        callbackClient.sendCallbackError(errorReq);
                        e.printStackTrace();
                    }
                }
            }
        });
        return asyncResp;
    }

    public GJaxbFreezeASyncModelResponse freezeASyncModel(final GJaxbFreezeASyncModel parameters) throws FaultMessage {
        GJaxbFreezeASyncModelResponse asyncResp = new GJaxbFreezeASyncModelResponse();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){
            final /* synthetic */ ModelsGovImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ModelsGovCallbackClient callbackClient = null;
                try {
                    callbackClient = (ModelsGovCallbackClient)ModelsGovCallbackClient.createClient((String)parameters.getCallbackAddress());
                    GJaxbFreezeSyncModelResponse syncResp = this.this$0.freezeSyncModel(parameters.getFreezeSyncModel());
                    GJaxbFreezeASyncModelCallBack asyncReq = new GJaxbFreezeASyncModelCallBack();
                    asyncReq.setRequestTopicId(parameters.getRequestTopicId());
                    asyncReq.setFreezeSyncModelResponse(syncResp);
                    callbackClient.freezeASyncModelCallBack(asyncReq);
                }
                catch (Exception e) {
                    GJaxbSendCallbackError errorReq = new GJaxbSendCallbackError();
                    errorReq.setRequestTopicId(parameters.getRequestTopicId());
                    errorReq.setFault(new GJaxbFault());
                    errorReq.getFault().setMessage(e.getMessage());
                    errorReq.getFault().setStacktrace(ExceptionUtils.getStackTrace((Throwable)e));
                    callbackClient.sendCallbackError(errorReq);
                    e.printStackTrace();
                }
            }
        });
        return asyncResp;
    }

    public GJaxbCloneASyncModelFromStatusResponse cloneASyncModelFromStatus(final GJaxbCloneASyncModelFromStatus parameters) throws FaultMessage {
        GJaxbCloneASyncModelFromStatusResponse asyncResp = new GJaxbCloneASyncModelFromStatusResponse();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){
            final /* synthetic */ ModelsGovImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ModelsGovCallbackClient callbackClient = null;
                try {
                    callbackClient = (ModelsGovCallbackClient)ModelsGovCallbackClient.createClient((String)parameters.getCallbackAddress());
                    GJaxbCloneSyncModelFromStatusResponse syncResp = this.this$0.cloneSyncModelFromStatus(parameters.getCloneSyncModelFromStatus());
                    GJaxbCloneASyncModelFromStatusCallBack asyncReq = new GJaxbCloneASyncModelFromStatusCallBack();
                    asyncReq.setRequestTopicId(parameters.getRequestTopicId());
                    asyncReq.setCloneSyncModelFromStatusResponse(syncResp);
                    callbackClient.cloneASyncModelFromStatusCallBack(asyncReq);
                }
                catch (Exception e) {
                    GJaxbSendCallbackError errorReq = new GJaxbSendCallbackError();
                    errorReq.setRequestTopicId(parameters.getRequestTopicId());
                    errorReq.setFault(new GJaxbFault());
                    errorReq.getFault().setMessage(e.getMessage());
                    errorReq.getFault().setStacktrace(ExceptionUtils.getStackTrace((Throwable)e));
                    callbackClient.sendCallbackError(errorReq);
                    e.printStackTrace();
                }
            }
        });
        return asyncResp;
    }
}

