/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.models;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.edge.Code2LEdgeModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.ActualityAndPotentialityModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.FunctionModelsPopulateInterceptor;
import fr.emac.gind.gov.core.domains.collabortive.interceptors.node.SensorModelsPopulateInterceptor;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.service.Neo4JBasicConnectorImpl;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models.service.ModelsGovImpl;
import fr.emac.gind.gov.models.util.ModelsPopulateModelInterceptor;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsGovWebService
extends SPIWebServicePrimitives {
    private static final Logger LOG = LoggerFactory.getLogger((String)ModelsGovWebService.class.getName());
    private CoreGovImpl coreGov = null;
    private ModelsGovImpl modelsGov = null;
    private NotificationManagerImpl producer = null;

    public void onInit(Map<String, Object> context) {
        try {
            URL topicSetUrl = Thread.currentThread().getContextClassLoader().getResource("CoreGovTopicSet.xml");
            GJaxbTopicSetType topicSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(topicSetUrl, GJaxbTopicSetType.class);
            String storageAddress = (String)context.get("storage");
            this.producer = new NotificationManagerImpl(ModelsGovWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"GovCoreSubscriber"), storageAddress, "GovCoreSubscriber_" + this.getHost() + "_" + this.port, new HashMap(), topicSet, null, new ResourcesManager[0]);
            this.registerWSImplementation("GovCoreSubscriber", this.producer);
            this.coreGov = new CoreGovImpl(context, this.producer, Arrays.asList(new ActualityAndPotentialityModelsPopulateInterceptor(), new FunctionModelsPopulateInterceptor(), new SensorModelsPopulateInterceptor()), Arrays.asList(new Code2LEdgeModelsPopulateInterceptor()));
            this.modelsGov = new ModelsGovImpl((CoreGov)this.coreGov, new ModelsPopulateModelInterceptor[0]);
            this.coreGov.setModelsGov((ModelsGov)this.modelsGov);
            this.registerWSImplementation("GovCore", this.coreGov);
            this.registerWSImplementation("GovModels", this.modelsGov);
            this.registerWSImplementation("GovNeo4J", new Neo4JBasicConnectorImpl((CoreGov)this.coreGov));
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        this.coreGov.shutdown();
        super.stop();
    }
}

