/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.models.util;

import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.util.CoreGovDriverConnectorUtil;
import fr.emac.gind.gov.core.util.query.MatchWhere;
import fr.emac.gind.gov.core.util.query.OptionalMatchWhere;
import fr.emac.gind.gov.core.util.query.QueryStructure;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbEffectivePackage;
import fr.emac.gind.modeler.metamodel.GJaxbImportedNode;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractHelper
extends CoreGovDriverConnectorUtil {
    private static Logger LOG = LoggerFactory.getLogger((String)ExtractHelper.class.getName());
    private static ExtractHelper INSTANCE = null;

    private ExtractHelper() {
    }

    public static ExtractHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtractHelper();
        }
        return INSTANCE;
    }

    public static List<QueryStructure> createModelExtractionQueryFromPackage(GJaxbEffectivePackage _package, GJaxbEffectiveMetaModel effMetaModel, String collaborationName, String knowledgeSpaceName, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels) {
        ArrayList<QueryStructure> queries = new ArrayList<QueryStructure>();
        Object labelTags = "";
        if (collaborationName != null && collaborationName.trim().length() > 0) {
            labelTags = (String)labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`";
        }
        if (knowledgeSpaceName != null && knowledgeSpaceName.trim().length() > 0) {
            labelTags = (String)labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "`";
        }
        if (labels != null && !labels.isEmpty()) {
            for (String label : labels) {
                labelTags = (String)labelTags + ":`" + label + "`";
            }
        }
        ArrayList parentTypes = new ArrayList();
        if (_package != null && _package.getRules() != null && _package.getRules().getContainmentRule() != null) {
            _package.getRules().getContainmentRule().getContain().forEach(c -> {
                if (c.getType() != null) {
                    parentTypes.add(c.getType());
                }
            });
        }
        ArrayList<QName> childTypes = new ArrayList<QName>();
        if (_package != null) {
            for (GJaxbImportedNode in : _package.getImportedNode()) {
                childTypes.add(in.getRef());
            }
        }
        ListUtil.deleteDuplicate(parentTypes);
        ListUtil.deleteDuplicate(childTypes);
        ArrayList<QName> validParentEdgesTypes = new ArrayList<QName>();
        ArrayList<QName> validChildEdgeTypes = new ArrayList<QName>();
        if (effMetaModel.getRules() != null && effMetaModel.getRules().getConnectionRules() != null && effMetaModel.getRules().getConnectionRules().getConnectionRule() != null && effMetaModel.getRules().getConnectionRules().getConnectionRule().size() > 0) {
            for (GJaxbConnectionRule connectRule : effMetaModel.getRules().getConnectionRules().getConnectionRule()) {
                if (parentTypes.contains(connectRule.getFrom()) && parentTypes.contains(connectRule.getTo())) {
                    validParentEdgesTypes.add(connectRule.getRelationType());
                }
                if (!childTypes.contains(connectRule.getFrom()) || !childTypes.contains(connectRule.getTo())) continue;
                validChildEdgeTypes.add(connectRule.getRelationType());
            }
        } else {
            LOG.debug("none connexion rules");
        }
        ListUtil.deleteDuplicate(validChildEdgeTypes);
        ListUtil.deleteDuplicate(validParentEdgesTypes);
        validChildEdgeTypes.removeIf(type -> type.getNamespaceURI().equals("http://fr.emac.gind/uml-model"));
        validParentEdgesTypes.removeIf(type -> type.getNamespaceURI().equals("http://fr.emac.gind/uml-model"));
        QueryStructure queryMatch1 = new QueryStructure();
        OptionalMatchWhere match1 = new OptionalMatchWhere();
        queryMatch1.getOptionalMatchWheres().add(match1);
        match1.setOptionalMatch("(parent" + (String)labelTags + ")");
        StringBuffer whereMatch1 = new StringBuffer();
        if (parentTypes != null && !parentTypes.isEmpty()) {
            whereMatch1.append("(");
            for (QName pType : parentTypes) {
                whereMatch1.append("parent.type = '" + pType.toString().trim() + "' OR ");
            }
            whereMatch1.delete(whereMatch1.length() - " OR ".length(), whereMatch1.length());
            whereMatch1.append(")");
        }
        whereMatch1.append(ExtractHelper.addSelectedStatus(status, Arrays.asList("parent")));
        whereMatch1.append(ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("parent")));
        match1.setWhere(whereMatch1.toString());
        queryMatch1.get_return().set_return("distinct parent");
        queries.add(queryMatch1);
        QueryStructure queryMatch2 = new QueryStructure();
        OptionalMatchWhere match2 = new OptionalMatchWhere();
        queryMatch2.getOptionalMatchWheres().add(match2);
        match2.setOptionalMatch("(parent" + (String)labelTags + ")-[rp]->(parent1" + (String)labelTags + ")");
        StringBuffer whereMatch2 = new StringBuffer();
        whereMatch2.append("(");
        if (parentTypes != null && !parentTypes.isEmpty()) {
            whereMatch2.append("(");
            for (QName pType : parentTypes) {
                whereMatch2.append("parent.type = '" + pType.toString().trim() + "' OR ");
            }
            whereMatch2.delete(whereMatch2.length() - " OR ".length(), whereMatch2.length());
            whereMatch2.append(")");
        }
        if (parentTypes != null && !parentTypes.isEmpty()) {
            whereMatch2.append(" OR ");
            whereMatch2.append("(");
            for (QName pType : parentTypes) {
                whereMatch2.append("parent1.type = '" + pType.toString().trim() + "' OR ");
            }
            whereMatch2.delete(whereMatch2.length() - " OR ".length(), whereMatch2.length());
            whereMatch2.append(")");
        }
        whereMatch2.append(")");
        whereMatch2.append(ExtractHelper.addSelectedStatus(status, Arrays.asList("parent", "parent1")));
        whereMatch2.append(ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("parent", "parent1")));
        match2.setWhere(whereMatch2.toString());
        queryMatch2.get_return().set_return("distinct rp");
        queries.add(queryMatch2);
        QueryStructure queryMatch3 = new QueryStructure();
        OptionalMatchWhere match3 = new OptionalMatchWhere();
        queryMatch3.getOptionalMatchWheres().add(match3);
        match3.setOptionalMatch("(parent" + (String)labelTags + ")<-[ec:`{http://fr.emac.gind/uml-model}Compose`*]-(child" + (String)labelTags + ")");
        StringBuffer whereMatch3 = new StringBuffer();
        whereMatch3.append("(");
        if (parentTypes != null && !parentTypes.isEmpty()) {
            whereMatch3.append("(");
            for (QName pType : parentTypes) {
                whereMatch3.append("parent.type = '" + pType.toString().trim() + "' OR ");
            }
            whereMatch3.delete(whereMatch3.length() - " OR ".length(), whereMatch3.length());
            whereMatch3.append(")");
        }
        if (childTypes != null && !childTypes.isEmpty()) {
            whereMatch3.append(" AND ");
            whereMatch3.append("(");
            for (QName cType : childTypes) {
                whereMatch3.append("child.type = '" + cType.toString().trim() + "' OR ");
            }
            whereMatch3.delete(whereMatch3.length() - " OR ".length(), whereMatch3.length());
            whereMatch3.append(")");
        }
        whereMatch3.append(")");
        whereMatch3.append(ExtractHelper.addSelectedStatus(status, Arrays.asList("parent", "child")));
        whereMatch3.append(ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("parent", "child")));
        match3.setWhere(whereMatch3.toString());
        queryMatch3.get_return().set_return("distinct child");
        queries.add(queryMatch3);
        QueryStructure queryMatch4 = new QueryStructure();
        OptionalMatchWhere match4 = new OptionalMatchWhere();
        queryMatch4.getOptionalMatchWheres().add(match4);
        match4.setOptionalMatch("(parent" + (String)labelTags + ")<-[ec:`{http://fr.emac.gind/uml-model}Compose`*]-(child" + (String)labelTags + ")-[rc]->(child1" + (String)labelTags + ")");
        StringBuffer whereMatch4 = new StringBuffer();
        whereMatch4.append("(");
        if (parentTypes != null && !parentTypes.isEmpty()) {
            whereMatch4.append("(");
            for (QName pType : parentTypes) {
                whereMatch4.append("parent.type = '" + pType.toString().trim() + "' OR ");
            }
            whereMatch4.delete(whereMatch4.length() - " OR ".length(), whereMatch4.length());
            whereMatch4.append(")");
        }
        if (childTypes != null && !childTypes.isEmpty()) {
            whereMatch4.append(" AND ");
            whereMatch4.append("(");
            for (QName cType : childTypes) {
                whereMatch4.append("child.type = '" + cType.toString().trim() + "' OR ");
            }
            whereMatch4.delete(whereMatch4.length() - " OR ".length(), whereMatch4.length());
            whereMatch4.append(")");
        }
        if (validChildEdgeTypes != null && !validChildEdgeTypes.isEmpty()) {
            whereMatch4.append(" AND ");
            whereMatch4.append("(");
            for (QName eType : validChildEdgeTypes) {
                whereMatch4.append("type(rc)='" + eType.toString().trim() + "' OR ");
            }
            whereMatch4.delete(whereMatch4.length() - " OR ".length(), whereMatch4.length());
            whereMatch4.append(")");
        }
        if (childTypes != null && !childTypes.isEmpty()) {
            whereMatch4.append(" AND ");
            whereMatch4.append("(");
            for (QName cType : childTypes) {
                whereMatch4.append("child1.type = '" + cType.toString().trim() + "' OR ");
            }
            whereMatch4.delete(whereMatch4.length() - " OR ".length(), whereMatch4.length());
            whereMatch4.append(")");
        }
        whereMatch4.append(")");
        whereMatch4.append(ExtractHelper.addSelectedStatus(status, Arrays.asList("parent", "child", "child1")));
        whereMatch4.append(ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("parent", "child", "child1")));
        match4.setWhere(whereMatch4.toString());
        queryMatch4.get_return().set_return("distinct rc");
        queries.add(queryMatch4);
        QueryStructure queryMatch5 = new QueryStructure();
        OptionalMatchWhere match5 = new OptionalMatchWhere();
        queryMatch5.getOptionalMatchWheres().add(match5);
        match5.setOptionalMatch("(child" + (String)labelTags + ")<-[ec:`{http://fr.emac.gind/uml-model}Compose`]-(child1" + (String)labelTags + ")");
        StringBuffer whereMatch5 = new StringBuffer();
        whereMatch5.append("(");
        if (childTypes != null && !childTypes.isEmpty()) {
            whereMatch5.append("(");
            for (QName cType : childTypes) {
                whereMatch5.append("child.type = '" + cType.toString().trim() + "' OR ");
            }
            whereMatch5.delete(whereMatch5.length() - " OR ".length(), whereMatch5.length());
            whereMatch5.append(")");
        }
        if (childTypes != null && !childTypes.isEmpty()) {
            whereMatch5.append(" AND ");
            whereMatch5.append("(");
            for (QName cType : childTypes) {
                whereMatch5.append("child1.type = '" + cType.toString().trim() + "' OR ");
            }
            whereMatch5.delete(whereMatch5.length() - " OR ".length(), whereMatch5.length());
            whereMatch5.append(")");
        }
        whereMatch5.append(")");
        whereMatch5.append(ExtractHelper.addSelectedStatus(status, Arrays.asList("child", "child1")));
        whereMatch5.append(ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("child", "child1")));
        if (!whereMatch5.toString().isBlank()) {
            match5.setWhere(whereMatch5.toString());
        }
        queryMatch5.get_return().set_return("distinct ec");
        queries.add(queryMatch5);
        return queries;
    }

    private static String addSelectedStatus(List<GJaxbStatusType> selectedStatus, List<String> instances) {
        Object res = "";
        if (selectedStatus != null && !selectedStatus.isEmpty()) {
            for (String instance : instances) {
                res = (String)res + " and (";
                for (GJaxbStatusType status : selectedStatus) {
                    res = (String)res + instance + ":" + String.valueOf(status) + " or ";
                }
                res = ((String)res).substring(0, ((String)res).length() - " or ".length());
                res = (String)res + ") ";
            }
        }
        return res;
    }

    private static String addExclusionsStatus(List<GJaxbStatusType> exclusionStatus, List<String> instances) {
        Object res = "";
        if (exclusionStatus != null && !exclusionStatus.isEmpty()) {
            for (String instance : instances) {
                res = (String)res + " and (";
                for (GJaxbStatusType status : exclusionStatus) {
                    res = (String)res + " not " + instance + ":" + String.valueOf(status) + " and ";
                }
                res = ((String)res).substring(0, ((String)res).length() - " and ".length());
                res = (String)res + ") ";
            }
        }
        return res;
    }

    public List<QueryStructure> createModelExtractionQueryFromMetaModelByType(GJaxbEffectiveMetaModel effMetaModel, String collaborationName, String knowledgeSpaceName, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels) {
        ArrayList<QueryStructure> queries = new ArrayList<QueryStructure>();
        Object labelTags = "";
        if (collaborationName != null && collaborationName.trim().length() > 0) {
            labelTags = (String)labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`";
        }
        if (knowledgeSpaceName != null && knowledgeSpaceName.trim().length() > 0) {
            labelTags = (String)labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "`";
        }
        if (labels != null && !labels.isEmpty()) {
            for (String label : labels) {
                labelTags = (String)labelTags + ":`" + label + "`";
            }
        }
        QueryStructure queryNodes = new QueryStructure();
        MatchWhere matchNode = new MatchWhere();
        queryNodes.getMatchWheres().add(matchNode);
        matchNode.setMatch("(node1" + (String)labelTags + ")");
        matchNode.setWhere("");
        for (GJaxbEffectiveConceptType node : effMetaModel.getEffectiveConcept()) {
            if (node.isSetAbstract() && (!node.isSetAbstract() || node.isAbstract().booleanValue())) continue;
            matchNode.setWhere(matchNode.getWhere() + "node1.type = '" + node.getType().toString().trim() + "' OR ");
        }
        matchNode.setWhere("(" + matchNode.getWhere().substring(0, matchNode.getWhere().length() - " OR ".length()) + ")" + ExtractHelper.addSelectedStatus(status, Arrays.asList("node1")) + ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("node1")));
        queryNodes.get_return().set_return("distinct node1");
        queryNodes.get_return().setOrder_by("id(node1)");
        queries.add(queryNodes);
        QueryStructure queryEdges = new QueryStructure();
        MatchWhere matchEdge = new MatchWhere();
        queryEdges.getMatchWheres().add(matchEdge);
        if (effMetaModel.getRelation().size() > 0) {
            matchEdge.setMatch("(node1" + (String)labelTags + ")-[relation1]-(node2" + (String)labelTags + ")");
            matchEdge.setWhere("");
            for (GJaxbRelation edge : effMetaModel.getRelation()) {
                matchEdge.setWhere(matchEdge.getWhere() + "type(relation1)='" + edge.getType().toString().trim() + "' OR ");
            }
            matchEdge.setWhere("(" + matchEdge.getWhere().substring(0, matchEdge.getWhere().length() - " OR ".length()) + ")" + ExtractHelper.addSelectedStatus(status, Arrays.asList("node1")) + ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("node1")) + ExtractHelper.addSelectedStatus(status, Arrays.asList("node2")) + ExtractHelper.addExclusionsStatus(exclusionStatus, Arrays.asList("node2")));
            queryEdges.get_return().set_return("distinct relation1");
            queryEdges.get_return().setOrder_by("id(relation1)");
            queries.add(queryEdges);
        }
        LOG.debug("extract nodes: \n" + String.valueOf(queryNodes));
        LOG.debug("extract edges: \n" + String.valueOf(queryEdges));
        return queries;
    }

    public List<QueryStructure> createModelExtractionQueryFromPackage(GJaxbEffectiveDomain effDomain, QName packageQName, String collaborationName, String knowledgeName, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels) throws Exception {
        GJaxbEffectivePackage _package = effDomain.getEffectivePackage().stream().filter(effPack -> effPack.getName().equals(packageQName.getLocalPart())).findFirst().get();
        GJaxbEffectiveMetaModel effModel = _package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel();
        List<QueryStructure> extractionQuery = ExtractHelper.createModelExtractionQueryFromPackage(_package, effModel, collaborationName, knowledgeName, status, exclusionStatus, labels);
        return extractionQuery;
    }

    public List<QueryStructure> createModelExtractionQueryFromDomain(GJaxbEffectiveDomain effDomain, String domain, String collaborationName, String knowledgeName, List<GJaxbStatusType> status, List<GJaxbStatusType> exclusionStatus, List<String> labels) throws Exception {
        GJaxbEffectiveMetaModel effModel = effDomain.getGlobalEffectiveMetaModel().getEffectiveMetaModel();
        List<QueryStructure> extractionQuery = this.createModelExtractionQueryFromMetaModelByType(effModel, collaborationName, knowledgeName, status, exclusionStatus, labels);
        return extractionQuery;
    }

    public List<QueryStructure> createMetaModelExtractionQueryFromDomainAndOrPackage(String domain, String _package, String collaborationName, String knowledgeSpaceName, List<String> labels) throws Exception {
        ArrayList<QueryStructure> queries = new ArrayList<QueryStructure>();
        String labelTags = ":" + CoreGovImpl.DEFAULT_CONCEPT_NODE_LABEL;
        if (collaborationName != null && collaborationName.trim().length() > 0) {
            labelTags = labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)collaborationName) + "`";
        }
        if (knowledgeSpaceName != null && knowledgeSpaceName.trim().length() > 0) {
            labelTags = labelTags + ":`" + RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName) + "`";
        }
        if (labels != null && !labels.isEmpty()) {
            for (String label : labels) {
                labelTags = labelTags + ":`" + label + "`";
            }
        }
        QueryStructure queryNodes = new QueryStructure();
        MatchWhere matchNode = new MatchWhere();
        queryNodes.getMatchWheres().add(matchNode);
        matchNode.setMatch("(n1" + labelTags + ") optional match (n1" + labelTags + ")-[r]-(n2" + labelTags + ")");
        if (domain != null) {
            matchNode.setWhere(matchNode.getWhere() + " AND n1.property_Domains CONTAINS \"" + RegExpHelper.toRegexFriendlyName((String)domain) + "\"");
            matchNode.setWhere(matchNode.getWhere() + " AND n2.property_Domains CONTAINS \"" + RegExpHelper.toRegexFriendlyName((String)domain) + "\"");
        }
        if (_package != null) {
            matchNode.setWhere(matchNode.getWhere() + " AND n1.property_Packages CONTAINS \"" + RegExpHelper.toRegexFriendlyName((String)_package) + "\"");
            matchNode.setWhere(matchNode.getWhere() + " AND n2.property_Packages CONTAINS \"" + RegExpHelper.toRegexFriendlyName((String)_package) + "\"");
        }
        queryNodes.get_return().set_return("distinct n1, n2, r");
        queries.add(queryNodes);
        LOG.debug("extract nodes: \n" + String.valueOf(queryNodes));
        return queries;
    }
}

