/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.models.util;

import fr.emac.gind.gov.core.service.CoreGovImpl;
import fr.emac.gind.gov.core.util.CoreGovDriverConnectorUtil;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbRemoveEdge;
import fr.emac.gind.gov.core_gov.GJaxbRemoveNode;
import fr.emac.gind.gov.core_gov.GJaxbUpdateEdge;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNode;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.gov.models_gov.GJaxbPublishUnpublishResultType;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishDriverConnector
extends CoreGovDriverConnectorUtil {
    private static Logger LOG = LoggerFactory.getLogger((String)PublishDriverConnector.class.getName());
    private Driver driver = null;
    private CoreGov coreGov = null;
    private ModeType mode = null;
    private CompletionService<GJaxbPublishUnpublishResultType> completionServiceWithNodes = null;
    private CompletionService<GJaxbPublishUnpublishResultType> completionServiceWithOnlyEdgesAndParentRelation = null;
    private List<Future<GJaxbPublishUnpublishResultType>> runningFuturesWithNodes = new ArrayList<Future<GJaxbPublishUnpublishResultType>>();
    private List<Future<GJaxbPublishUnpublishResultType>> runningFuturesWithOnlyEdgesAndParentRelation = new ArrayList<Future<GJaxbPublishUnpublishResultType>>();

    public PublishDriverConnector(Driver driver, CoreGov coreGov, ModeType mode) {
        this.driver = driver;
        this.coreGov = coreGov;
        this.mode = mode;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        this.completionServiceWithNodes = new ExecutorCompletionService<GJaxbPublishUnpublishResultType>(executor);
        this.completionServiceWithOnlyEdgesAndParentRelation = new ExecutorCompletionService<GJaxbPublishUnpublishResultType>(executor);
    }

    public GJaxbPublishUnpublishResultType publishCompleteTransaction(GJaxbGenericModel model, String collaborationName, String knowledgeSpaceName, GJaxbPublishOptions publishOptions) throws Exception {
        GJaxbPublishUnpublishResultType res = new GJaxbPublishUnpublishResultType();
        res.setNodesId(new GJaxbPublishUnpublishResultType.NodesId());
        res.setEdgesId(new GJaxbPublishUnpublishResultType.EdgesId());
        try (Session session = this.driver.session();){
            if (ModeType.PUBLISH.equals((Object)this.mode)) {
                this.updateOrRemoveNodes(model, collaborationName, knowledgeSpaceName, publishOptions, res, session);
                this.updateOrRemoveEdges(model, collaborationName, knowledgeSpaceName, publishOptions, res, session);
            } else {
                this.updateOrRemoveEdges(model, collaborationName, knowledgeSpaceName, publishOptions, res, session);
                this.updateOrRemoveNodes(model, collaborationName, knowledgeSpaceName, publishOptions, res, session);
            }
        }
        return res;
    }

    private void updateOrRemoveEdges(GJaxbGenericModel model, String collaborationName, String knowledgeSpaceName, GJaxbPublishOptions publishOptions, GJaxbPublishUnpublishResultType res, Session session) throws Exception {
        GJaxbUpdateEdge updateEdge = PublishDriverConnector.createUpdateEdgeRequest(publishOptions, collaborationName, knowledgeSpaceName);
        GJaxbRemoveEdge removeEdge = this.createRemoveEdgeRequest(publishOptions, collaborationName, knowledgeSpaceName);
        for (GJaxbEdge edge : model.getEdge()) {
            if (publishOptions.getExcludeItems().contains(edge.getId())) continue;
            try {
                if (ModeType.PUBLISH.equals((Object)this.mode)) {
                    updateEdge.setEdge(edge);
                    if (edge.getSource() != null) {
                        updateEdge.setSourceNodeId(edge.getSource().getId());
                    }
                    if (edge.getTarget() != null) {
                        updateEdge.setTargetNodeId(edge.getTarget().getId());
                    }
                    ((CoreGovImpl)this.coreGov).updateEdgeWithSession(updateEdge, session);
                } else {
                    removeEdge.setId(edge.getId());
                    ((CoreGovImpl)this.coreGov).removeEdgeWithSession(removeEdge, session);
                }
                res.getEdgesId().getId().add(edge.getId());
            }
            catch (Exception e) {
                LOG.error("Impossible to update edge: " + edge.getId() + " => " + e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
        }
    }

    private void updateOrRemoveNodes(GJaxbGenericModel model, String collaborationName, String knowledgeSpaceName, GJaxbPublishOptions publishOptions, GJaxbPublishUnpublishResultType res, Session session) throws Exception {
        GJaxbUpdateNode updateNode = PublishDriverConnector.createUpdateNodeRequest(publishOptions, collaborationName, knowledgeSpaceName, model, true);
        GJaxbRemoveNode removeNode = this.createRemoveNodeRequest(publishOptions, collaborationName, knowledgeSpaceName);
        for (GJaxbNode node : model.getNode()) {
            try {
                if (publishOptions.getExcludeItems().contains(node.getId())) continue;
                if (ModeType.PUBLISH.equals((Object)this.mode)) {
                    updateNode.setNode(node);
                    ((CoreGovImpl)this.coreGov).updateNodeWithSession(updateNode, session);
                } else {
                    removeNode.setId(node.getId());
                    ((CoreGovImpl)this.coreGov).removeNodeWithSession(removeNode, session);
                }
                res.getNodesId().getId().add(node.getId());
            }
            catch (Exception e) {
                LOG.error((String)("Impossible to update node: " + String.valueOf(node) != null ? node.getId() : "null => " + e.getMessage()), (Throwable)e);
                throw new Exception(e);
            }
        }
    }

    public GJaxbPublishUnpublishResultType publishBashTransaction(GJaxbGenericModel model, GJaxbPublishOptions.BashOptions bashOptions, String collaborationName, String knowledgeName, GJaxbPublishOptions parameters) throws Exception {
        GJaxbPublishUnpublishResultType res = new GJaxbPublishUnpublishResultType();
        res.setNodesId(new GJaxbPublishUnpublishResultType.NodesId());
        res.setEdgesId(new GJaxbPublishUnpublishResultType.EdgesId());
        if (bashOptions == null) {
            throw new Exception("Bash options cannot be null!!");
        }
        if (!bashOptions.isSetLotSize()) {
            throw new Exception("lot size cannot be null!!");
        }
        int lotSize = bashOptions.getLotSize();
        GJaxbGenericModel batchModel = new GJaxbGenericModel();
        for (GJaxbNode node : model.getNode()) {
            batchModel.getNode().add(node);
            batchModel = this.verifAndRunBatchIfComplete(batchModel, lotSize, false, collaborationName, knowledgeName, parameters);
        }
        for (GJaxbEdge edge : model.getEdge()) {
            batchModel.getEdge().add(edge);
            batchModel = this.verifAndRunBatchIfComplete(batchModel, lotSize, false, collaborationName, knowledgeName, parameters);
        }
        batchModel = this.verifAndRunBatchIfComplete(batchModel, lotSize, true, collaborationName, knowledgeName, parameters);
        for (int receivedNodes = 0; receivedNodes < this.runningFuturesWithNodes.size(); ++receivedNodes) {
            Future<GJaxbPublishUnpublishResultType> resultFuture = this.completionServiceWithNodes.take();
            GJaxbPublishUnpublishResultType result = (GJaxbPublishUnpublishResultType)resultFuture.get();
            res.getNodesId().getId().addAll(result.getNodesId().getId());
            res.getEdgesId().getId().addAll(result.getEdgesId().getId());
        }
        for (GJaxbNode node : model.getNode()) {
            GJaxbNode parent = GenericModelHelper.findFirstParent((GJaxbNode)node, (GJaxbGenericModel)model);
            if (parent == null) continue;
            batchModel.getNode().add(node);
            batchModel = this.verifAndRunBatchIfComplete(batchModel, lotSize, false, collaborationName, knowledgeName, parameters);
        }
        if (batchModel.getNode().size() > 0 || batchModel.getEdge().size() > 0) {
            batchModel = this.verifAndRunBatchIfComplete(batchModel, lotSize, true, collaborationName, knowledgeName, parameters);
        }
        for (int receivedEdgesAndParentRelation = 0; receivedEdgesAndParentRelation < this.runningFuturesWithOnlyEdgesAndParentRelation.size(); ++receivedEdgesAndParentRelation) {
            Future<GJaxbPublishUnpublishResultType> resultFuture = this.completionServiceWithOnlyEdgesAndParentRelation.take();
            GJaxbPublishUnpublishResultType result = resultFuture.get();
            res.getEdgesId().getId().addAll(result.getEdgesId().getId());
        }
        return res;
    }

    public GJaxbPublishUnpublishResultType publishUnitaryTransaction(GJaxbGenericModel model, String collaborationName, String knowledgeName, GJaxbPublishOptions parameters) throws Exception {
        if (parameters.getBashOptions() == null) {
            parameters.setBashOptions(new GJaxbPublishOptions.BashOptions());
        }
        parameters.getBashOptions().setLotSize(1);
        return this.publishBashTransaction(model, parameters.getBashOptions(), collaborationName, knowledgeName, parameters);
    }

    private GJaxbGenericModel verifAndRunBatchIfComplete(GJaxbGenericModel batchModel, int lotSize, boolean forceToSend, final String collaborationName, final String knowledgeSpaceName, final GJaxbPublishOptions publishOptions) throws Exception {
        if (batchModel.getNode().size() + batchModel.getEdge().size() == lotSize || forceToSend) {
            final GJaxbGenericModel batchModelToSend = batchModel;
            batchModel = new GJaxbGenericModel();
            CompletionService<GJaxbPublishUnpublishResultType> validCompletionService = null;
            List<Future<GJaxbPublishUnpublishResultType>> validRunningFutures = null;
            if (batchModelToSend.getNode().size() == 0) {
                validCompletionService = this.completionServiceWithOnlyEdgesAndParentRelation;
                validRunningFutures = this.runningFuturesWithOnlyEdgesAndParentRelation;
            } else {
                validCompletionService = this.completionServiceWithNodes;
                validRunningFutures = this.runningFuturesWithNodes;
            }
            Future<GJaxbPublishUnpublishResultType> batchFuture = validCompletionService.submit(new Callable<GJaxbPublishUnpublishResultType>(){
                final /* synthetic */ PublishDriverConnector this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public GJaxbPublishUnpublishResultType call() throws Exception {
                    return this.this$0.publishCompleteTransaction(batchModelToSend, collaborationName, knowledgeSpaceName, publishOptions);
                }
            });
            validRunningFutures.add(batchFuture);
        }
        return batchModel;
    }

    private static GJaxbUpdateEdge createUpdateEdgeRequest(GJaxbPublishOptions parameters, String collaborationName, String knowledgeSpaceName) {
        GJaxbUpdateEdge updateEdge = new GJaxbUpdateEdge();
        if (parameters.isSetNotification()) {
            updateEdge.setNotification(parameters.getNotification());
        }
        if (parameters.isSetPreAndPostTreatment()) {
            updateEdge.setPreAndPostTreatment(parameters.getPreAndPostTreatment());
        }
        if (collaborationName != null && knowledgeSpaceName != null) {
            updateEdge.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            updateEdge.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            updateEdge.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        }
        updateEdge.setCreateIfNotExist(true);
        return updateEdge;
    }

    private GJaxbRemoveEdge createRemoveEdgeRequest(GJaxbPublishOptions publishOptions, String collaborationName, String knowledgeSpaceName) {
        GJaxbRemoveEdge removeEdge = new GJaxbRemoveEdge();
        if (publishOptions.isSetNotification()) {
            removeEdge.setNotification(publishOptions.getNotification());
        }
        if (publishOptions.isSetPreAndPostTreatment()) {
            removeEdge.setPreAndPostTreatment(publishOptions.getPreAndPostTreatment());
        }
        removeEdge.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        removeEdge.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        removeEdge.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        return removeEdge;
    }

    private static GJaxbUpdateNode createUpdateNodeRequest(GJaxbPublishOptions parameters, String collaborationName, String knowledgeSpaceName, GJaxbGenericModel model, boolean createNodesIfNotExist) {
        GJaxbUpdateNode updateNode = new GJaxbUpdateNode();
        if (parameters.isSetNotification()) {
            updateNode.setNotification(parameters.getNotification());
        }
        if (parameters.isSetPreAndPostTreatment()) {
            updateNode.setPreAndPostTreatment(parameters.getPreAndPostTreatment());
        }
        if (parameters.isSetLabel()) {
            updateNode.getLabel().addAll(parameters.getLabel());
        }
        if (collaborationName != null && knowledgeSpaceName != null) {
            updateNode.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            updateNode.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            updateNode.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        }
        updateNode.setCreateIfNotExist(createNodesIfNotExist);
        return updateNode;
    }

    private GJaxbRemoveNode createRemoveNodeRequest(GJaxbPublishOptions publishOptions, String collaborationName, String knowledgeSpaceName) {
        GJaxbRemoveNode removeNode = new GJaxbRemoveNode();
        if (publishOptions.isSetNotification()) {
            removeNode.setNotification(publishOptions.getNotification());
        }
        if (publishOptions.isSetPreAndPostTreatment()) {
            removeNode.setPreAndPostTreatment(publishOptions.getPreAndPostTreatment());
        }
        if (publishOptions.isSetLabel()) {
            removeNode.getLabel().addAll(publishOptions.getLabel());
        }
        if (collaborationName != null && knowledgeSpaceName != null) {
            removeNode.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            removeNode.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            removeNode.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        }
        return removeNode;
    }

    public static enum ModeType {
        PUBLISH,
        UNPUBLISH;

    }
}

