/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.process.mining.improver.gallery;

import fr.emac.gind.dsl.kpil.IndicatorManager;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.workflow.deduction.ProcessGraphHelper;
import fr.emac.gind.workflow.deduction.domain.UsecaseModelManager;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Process;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessMiningImprover {
    protected boolean isSelected = false;
    protected Map<String, Object> context = null;
    private CoreGov core = null;
    private ModelsGov models = null;
    protected ProcessGraphHelper processGraphHelper = null;
    protected IndicatorManager indicatorsManager;
    protected static EffectiveMetaModelManager processEffectiveMetaModelManager = null;
    private static Logger LOG = LoggerFactory.getLogger(AbstractProcessMiningImprover.class);

    public abstract String getName();

    public abstract String getDescription();

    public abstract List<String> domains();

    public boolean isSelected() {
        return this.isSelected;
    }

    public abstract boolean couldBeImproved(Process var1, GJaxbNode var2, String var3, String var4, UsecaseModelManager var5) throws Exception;

    public boolean couldBeImprovedUsingDomains(Process originalProcess, GJaxbNode project, String collaborationName, String knowledgeSpaceName, UsecaseModelManager usecaseManager, String ... domains) throws Exception {
        if (domains != null && domains.length > 0 && List.of(domains).parallelStream().anyMatch(s -> {
            if (this.domains() != null) {
                return !this.domains().contains(s);
            }
            return false;
        })) {
            return false;
        }
        return this.couldBeImproved(originalProcess, project, collaborationName, knowledgeSpaceName, usecaseManager);
    }

    public Process improve(Process originalProcess, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager) throws Exception {
        Process clonedProcess = originalProcess.copy();
        this.indicatorsManager = new IndicatorManager(project);
        this.doImprove(clonedProcess, project, collab, knowledge, usecaseManager);
        return clonedProcess;
    }

    public abstract void doImprove(Process var1, GJaxbNode var2, String var3, String var4, UsecaseModelManager var5) throws Exception;

    protected static List<String> cleanList(List<String> roles) {
        ArrayList<String> list = new ArrayList<String>();
        for (String role : roles) {
            list.add(role.trim().replace("//n", "").replace("//t", ""));
        }
        return list;
    }

    public void initialize(Map<String, Object> context) throws Exception {
        this.context = context;
    }

    protected void printRequirePaths(Map<JSONObject, List<List<GJaxbNode>>> res) {
        for (Map.Entry<JSONObject, List<List<GJaxbNode>>> entry : res.entrySet()) {
            LOG.debug("============================\nRequire : " + entry.getKey().getString("name"));
            entry.getValue().forEach(lls -> {
                System.out.print("[");
                lls.forEach(ls -> System.out.print(GenericModelHelper.findProperty((String)"name", (List)ls.getProperty()).getValue() + " -> "));
                LOG.debug("End ]");
            });
        }
    }

    public void setCore(CoreGov coreClient) {
        this.core = coreClient;
    }

    public CoreGov getCore() {
        return this.core;
    }

    public ModelsGov getModels() {
        return this.models;
    }

    public void setModels(ModelsGov models) {
        this.models = models;
    }

    public ProcessGraphHelper getProcessGraphHelper() {
        return this.processGraphHelper;
    }

    public void setProcessGraphHelper(ProcessGraphHelper processGraphHelper) {
        this.processGraphHelper = processGraphHelper;
    }

    public void setProcessEffectiveMetaModelManager(EffectiveMetaModelManager pef) {
        processEffectiveMetaModelManager = pef;
    }

    public EffectiveMetaModelManager getProcessEffectiveMetaModelManager() {
        return processEffectiveMetaModelManager;
    }

    protected void buildPath(GenericModelManager mm, JSONArray require, List<List<GJaxbNode>> paths, List<List<GJaxbNode>> res, List<QName> validTypes) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        List<GJaxbNode> currentPath = paths.get(0);
        GJaxbNode currentNode = currentPath.get(currentPath.size() - 1);
        List<GJaxbNode> followingNodes = mm.findOutputEdgesOfNode(currentNode).parallelStream().map(e -> e.getTarget()).filter(n -> !validTypes.contains(n.getType()) && GenericModelHelper.findProperty((String)"requires", (List)n.getProperty()) != null && this.findIndexInJsonArray(GenericModelHelper.parsePropertyValueAsJSONArray((GJaxbNode)n, (String)"requires"), require) != -1).collect(Collectors.toList());
        if (followingNodes == null || followingNodes.isEmpty()) {
            res.add(currentPath);
            paths.remove(0);
            return;
        }
        currentPath.add((GJaxbNode)followingNodes.get(0));
        followingNodes.remove(0);
        this.buildPath(mm, require, paths, res, validTypes);
        followingNodes.forEach(newSeed -> {
            ArrayList<GJaxbNode> otherPath = new ArrayList<GJaxbNode>();
            otherPath.add(currentNode);
            otherPath.add((GJaxbNode)newSeed);
            paths.add(otherPath);
            this.buildPath(mm, require, paths, res, validTypes);
        });
    }

    protected int findIndexInJsonArray(JSONArray array, JSONArray o) {
        if (array == null) {
            return -1;
        }
        List props1 = GenericModelHelper.convertJSONArrayToPropertyList((JSONArray)o);
        for (int i = 0; i < array.length(); ++i) {
            List props2 = GenericModelHelper.convertJSONArrayToPropertyList((JSONArray)array.getJSONArray(i));
            if (!GenericModelHelper.findProperty((String)"id", (List)props1).getValue().equals(GenericModelHelper.findProperty((String)"id", (List)props2).getValue())) continue;
            return i;
        }
        return -1;
    }
}

