/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.process.mining.improver;

import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.gov.process.mining.improver.gallery.AbstractProcessMiningImprover;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.workflow.deduction.ProcessGraphHelper;
import fr.emac.gind.workflow.deduction.domain.UsecaseModelManager;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Process;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessImproversManager {
    private Map<String, AbstractProcessMiningImprover> improvers = new HashMap<String, AbstractProcessMiningImprover>();
    private CoreGov core = null;
    private ModelsGov models = null;
    private EffectiveMetaModelManager processEffectiveMetaModelManager = null;
    private static Logger LOG = LoggerFactory.getLogger(ProcessImproversManager.class);

    public ProcessImproversManager(Map<String, Object> context, CoreGov core, ModelsGov models, EffectiveMetaModelManager processEffectiveMetaModelManager) throws Exception {
        if (context != null && core == null) {
            this.core = CoreGovClient.createClient((String)((String)context.get("governance")).replace("/gov", "/GovCore"));
            this.models = ModelsGovClient.createClient((String)((String)context.get("governance")).replace("/gov", "/GovModels"));
        } else {
            this.core = core;
            this.models = models;
        }
        this.processEffectiveMetaModelManager = processEffectiveMetaModelManager;
        this.initImprovers(context);
    }

    private void initImprovers(Map<String, Object> context) throws Exception {
        ServiceLoader<AbstractProcessMiningImprover> improversLoader = ServiceLoader.load(AbstractProcessMiningImprover.class);
        this.improvers.clear();
        improversLoader.reload();
        for (AbstractProcessMiningImprover improver : improversLoader) {
            improver.initialize(context);
            improver.setCore(this.core);
            improver.setModels(this.models);
            improver.setProcessEffectiveMetaModelManager(this.processEffectiveMetaModelManager);
            this.improvers.put(improver.getName(), improver);
        }
    }

    public Map<String, AbstractProcessMiningImprover> getImprovers() {
        return this.improvers;
    }

    public List<AbstractProcessMiningImprover> couldBeImprovedUsingDomains(Process originalProcess, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager, String ... domains) throws Exception {
        ArrayList<AbstractProcessMiningImprover> validImprovers = new ArrayList<AbstractProcessMiningImprover>();
        for (AbstractProcessMiningImprover improver : this.improvers.values()) {
            improver.setProcessGraphHelper(new ProcessGraphHelper(usecaseManager));
            if (!improver.couldBeImprovedUsingDomains(originalProcess, project, collab, knowledge, usecaseManager, domains)) continue;
            validImprovers.add(improver);
        }
        return validImprovers;
    }

    public List<AbstractProcessMiningImprover> couldBeImprovedUsingSelectedImprovers(Process originalProcess, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager, String ... improvers) throws Exception {
        ArrayList<AbstractProcessMiningImprover> validImprovers = new ArrayList<AbstractProcessMiningImprover>();
        List<String> listImprovers = List.of(improvers);
        for (AbstractProcessMiningImprover improver : this.improvers.values()) {
            improver.setProcessGraphHelper(new ProcessGraphHelper(usecaseManager));
            if (listImprovers == null || !listImprovers.contains(improver.getName()) || !improver.couldBeImproved(originalProcess, project, collab, knowledge, usecaseManager)) continue;
            validImprovers.add(improver);
        }
        return validImprovers;
    }

    public Process improve(Process process, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager, String ... domains) throws Exception {
        Process clonedProcess = process.copy();
        List<AbstractProcessMiningImprover> validImprovers = this.couldBeImprovedUsingDomains(clonedProcess, project, collab, knowledge, usecaseManager, domains);
        do {
            for (AbstractProcessMiningImprover improver : validImprovers) {
                improver.setProcessGraphHelper(new ProcessGraphHelper(usecaseManager));
                LOG.debug("Improving " + improver.getName() + " on " + clonedProcess.getName());
                int nbNodes = clonedProcess.getTasks().length;
                clonedProcess = improver.improve(clonedProcess, project, collab, knowledge, usecaseManager);
                assert (nbNodes != clonedProcess.getTasks().length);
            }
            if (validImprovers.size() > 1) {
                validImprovers = this.couldBeImprovedUsingDomains(clonedProcess, project, collab, knowledge, usecaseManager, domains);
                continue;
            }
            validImprovers.clear();
        } while (validImprovers.size() > 0);
        return clonedProcess;
    }

    public Process improveOnlyWithSelectImprovers(Process process, List<String> improverNames, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager) throws Exception {
        Process clonedProcess = process.copy();
        List<AbstractProcessMiningImprover> validImprovers = this.couldBeImprovedUsingSelectedImprovers(clonedProcess, project, collab, knowledge, usecaseManager, improverNames.toArray(new String[improverNames.size()]));
        do {
            for (AbstractProcessMiningImprover improver : validImprovers) {
                improver.setProcessGraphHelper(new ProcessGraphHelper(usecaseManager));
                LOG.debug("Improving " + improver.getName() + " on " + process.getName());
                clonedProcess = improver.improve(clonedProcess, project, collab, knowledge, usecaseManager);
            }
            if (validImprovers.size() > 1) {
                validImprovers = this.couldBeImprovedUsingSelectedImprovers(clonedProcess, project, collab, knowledge, usecaseManager, improverNames.toArray(new String[improverNames.size()]));
                continue;
            }
            validImprovers.clear();
        } while (validImprovers.size() > 0);
        return clonedProcess;
    }

    public GJaxbGenericModel cloneProcess(GJaxbGenericModel originalProcess) throws Exception {
        HashMap<String, Map> mapUserData = new HashMap<String, Map>();
        for (GJaxbNode node : originalProcess.getNode()) {
            mapUserData.put(node.getId(), node.getMapUserData());
            node.clearMapUserData();
        }
        GJaxbGenericModel clonedProcess = GenericModelHelper.cloneGenericModel((GJaxbGenericModel)originalProcess);
        for (GJaxbNode node : originalProcess.getNode()) {
            node.setMapUserData((Map)mapUserData.get(node.getId()));
        }
        for (GJaxbNode node : clonedProcess.getNode()) {
            node.setMapUserData((Map)mapUserData.get(node.getId()));
        }
        return clonedProcess;
    }

    public EffectiveMetaModelManager getProcessEffectiveMetaModelManager() {
        return this.processEffectiveMetaModelManager;
    }
}

