/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gov.process.mining.improver.gallery;

import fr.emac.gind.commons.gis.DistanceTimeMatrixManager;
import fr.emac.gind.commons.gis.GlobalDistanceTimeMatrices;
import fr.emac.gind.distance.RouteHelper;
import fr.emac.gind.distance.data.GJaxbLocalization;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;
import fr.emac.gind.dsl.kpil.IndicatorManager;
import fr.emac.gind.gov.process.mining.improver.gallery.AbstractProcessMiningImprover;
import fr.emac.gind.indicators.Indicator;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbIndicatorValueType;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPolyline;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.genericmodel.GJaxbTheoricValue;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.utils.GeoLocHelper;
import fr.emac.gind.models.generic.modeler.utils.PointHelper;
import fr.emac.gind.workflow.deduction.domain.AbstractNodeModel;
import fr.emac.gind.workflow.deduction.domain.UsecaseModelManager;
import fr.emac.gind.workflow.deduction.domain.collaborative.AbstractCollaborativeNodeModel;
import fr.emac.gind.workflow.deduction.domain.collaborative.context.nodes.Actor;
import fr.emac.gind.workflow.deduction.domain.collaborative.context.nodes.Function;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.edges.Sequence_Flow;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.AbstractProcessGraphModel;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.End_Event;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Process;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Start_Event;
import fr.emac.gind.workflow.deduction.domain.collaborative.process.nodes.Task;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveNodeProcessImprover
extends AbstractProcessMiningImprover {
    private static Logger LOG = LoggerFactory.getLogger(MoveNodeProcessImprover.class);
    protected DistanceTimeMatrixManager distanceMatrix = null;
    protected static GJaxbEffectiveConceptType functionMetaModel = null;
    protected static Function moveFunction = null;

    @Override
    public String getName() {
        return "move nodes improver";
    }

    @Override
    public String getDescription() {
        return "Try to insert move activity nodes when 2 activities in sequence have requires properties in common";
    }

    public static Function getMoveFunction(UsecaseModelManager usecaseManager) throws Exception {
        if (moveFunction == null) {
            moveFunction = new Function("Move", GJaxbStatusType.ACTIVE, usecaseManager);
        }
        return moveFunction;
    }

    @Override
    public synchronized boolean couldBeImproved(Process originalProcess, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager) throws Exception {
        Map orderedTasksByActors = this.processGraphHelper.extractOrderedTasksByActors(originalProcess);
        if (orderedTasksByActors != null && !orderedTasksByActors.isEmpty()) {
            for (Map.Entry entry : orderedTasksByActors.entrySet()) {
                GJaxbPointType p2;
                Actor currentActor = (Actor)entry.getKey();
                if (currentActor == null) continue;
                List orderedTasksOfCurrentActor = (List)entry.getValue();
                GJaxbPointType p1 = currentActor.getPoint();
                if (p1 != null & (p2 = GeoLocHelper.findFirstPointOfPolyline((GJaxbPolyline)GeoLocHelper.getPolyline((GJaxbNode)((Task)orderedTasksOfCurrentActor.get(0)).getModel()))) != null && !PointHelper.areEquals((GJaxbPointType)p1, (GJaxbPointType)p2)) {
                    return true;
                }
                for (int i = 0; i < orderedTasksOfCurrentActor.size() - 1; ++i) {
                    p1 = GeoLocHelper.findFirstPointOfPolyline((GJaxbPolyline)GeoLocHelper.getPolyline((GJaxbNode)((Task)orderedTasksOfCurrentActor.get(i)).getModel()));
                    if (!(p1 != null & (p2 = GeoLocHelper.findFirstPointOfPolyline((GJaxbPolyline)GeoLocHelper.getPolyline((GJaxbNode)((Task)orderedTasksOfCurrentActor.get(i + 1)).getModel()))) != null) || PointHelper.areEquals((GJaxbPointType)p1, (GJaxbPointType)p2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void doImprove(Process clonedProcess, GJaxbNode project, String collab, String knowledge, UsecaseModelManager usecaseManager) throws Exception {
        LOG.debug("Perform Improve Move");
        this.distanceMatrix = GlobalDistanceTimeMatrices.get((String)collab, (String)knowledge);
        Map orderedTasksByActors = this.processGraphHelper.extractOrderedTasksByActors(clonedProcess);
        if (orderedTasksByActors != null && !orderedTasksByActors.isEmpty()) {
            for (Map.Entry entry : orderedTasksByActors.entrySet()) {
                Actor currentActor = (Actor)entry.getKey();
                List orderedTasksOfCurrentActor = (List)entry.getValue();
                if (currentActor == null) continue;
                this.insertMoveTask(currentActor, null, (AbstractCollaborativeNodeModel)orderedTasksOfCurrentActor.get(0), clonedProcess, project, usecaseManager);
                for (int i = 0; i < orderedTasksOfCurrentActor.size() - 1; ++i) {
                    this.insertMoveTask(currentActor, (AbstractCollaborativeNodeModel)orderedTasksOfCurrentActor.get(i), (AbstractCollaborativeNodeModel)orderedTasksOfCurrentActor.get(i + 1), clonedProcess, project, usecaseManager);
                }
            }
        }
    }

    private void insertMoveTask(Actor<?> currentActor, AbstractCollaborativeNodeModel<?> nodeBefore, AbstractCollaborativeNodeModel<?> nodeAfter, Process process, GJaxbNode project, UsecaseModelManager usecaseManager) throws Exception {
        GJaxbPointType p2;
        LOG.debug("inserting move");
        GJaxbPointType p1 = null;
        if (nodeBefore != null) {
            p1 = GeoLocHelper.findLastPointOfPolyline((GJaxbPolyline)GeoLocHelper.getPolyline((GJaxbNode)nodeBefore.getModel()));
        }
        if ((p2 = GeoLocHelper.findFirstPointOfPolyline((GJaxbPolyline)GeoLocHelper.getPolyline((GJaxbNode)nodeAfter.getModel()))) != null && !PointHelper.areEquals((GJaxbPointType)p1, (GJaxbPointType)p2)) {
            IndicatorManager indMan = new IndicatorManager(project);
            String timeUnit = ((Indicator)indMan.getIndicators().get("Function:duration")).getDefinition().getUnit();
            String distanceUnit = "m";
            Object nodeStart = null;
            nodeStart = nodeBefore != null ? nodeBefore : currentActor;
            if (this.distanceMatrix.getDistanceTimeCalculatorSelected() != DistanceTimeMatrixManager.GisAPI.GOOGLE_MAPS_API) {
                throw new Exception("You need to set Google API Keys to insert move task !!!");
            }
            GJaxbRoute route = this.invokeShortestPath(nodeStart.getModel(), nodeAfter.getModel());
            if (route != null) {
                Task t;
                GJaxbTheoricValue durationVal;
                LOG.debug("create new move activity");
                Task moveTask = new Task("Move", null, MoveNodeProcessImprover.getMoveFunction(usecaseManager), null, false);
                moveTask.setAssignedActor(currentActor);
                moveTask.getModel().setModeling(new GJaxbNode.Modeling());
                GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
                iv.setViewId("view_" + String.valueOf(UUID.randomUUID()));
                iv.setPackageName("process");
                iv.setPosition(new GJaxbPosition());
                iv.getPosition().setX(0.0f);
                iv.getPosition().setY(0.0f);
                moveTask.getModel().getModeling().getItemView().add(iv);
                GenericModelHelper.findProperty((String)"Function:distance", (List)moveTask.getModel().getProperty(), (boolean)true);
                this.setGeolocalisationToNode(moveTask, route, indMan, p1, p2);
                if ("m".equalsIgnoreCase(distanceUnit)) {
                    GJaxbIndicatorValueType indVal;
                    if (indMan.getIndicators().get("Function:distance") != null) {
                        GJaxbTheoricValue thDistance = new GJaxbTheoricValue();
                        thDistance.setPrecise(Float.valueOf(RouteHelper.getDistance((GJaxbRoute)route).floatValue()));
                        indVal = new GJaxbIndicatorValueType();
                        indVal.setTheoricValue(thDistance);
                        GenericModelHelper.findProperty((String)"Function:distance", (List)moveTask.getModel().getProperty(), (boolean)true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)indVal));
                    }
                    if (timeUnit.toLowerCase().contains("seconds")) {
                        GJaxbTheoricValue thDuration = new GJaxbTheoricValue();
                        thDuration.setPrecise(Float.valueOf(RouteHelper.getDuration((GJaxbRoute)route).floatValue()));
                        indVal = new GJaxbIndicatorValueType();
                        indVal.setTheoricValue(thDuration);
                        GenericModelHelper.findProperty((String)"Function:duration", (List)moveTask.getModel().getProperty(), (boolean)true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)indVal));
                    } else {
                        throw new RuntimeException("Not supported: " + timeUnit);
                    }
                }
                if (nodeBefore == null) {
                    nodeBefore = process.getStartEvent();
                }
                LOG.debug("inserting move task " + moveTask.getName() + " between " + nodeBefore.getName() + " and " + nodeAfter.getName());
                Sequence_Flow sfb = new Sequence_Flow("SequenceFlow_M1", usecaseManager, (AbstractProcessGraphModel)nodeBefore, (AbstractProcessGraphModel)moveTask);
                moveTask.addDirectPredecessors(sfb);
                if (nodeBefore instanceof Start_Event) {
                    Start_Event se = nodeBefore;
                    se.addDirectSuccessors(sfb);
                    moveTask.setExpectedStart(se.getStart());
                } else if (nodeBefore instanceof Task) {
                    Task t2 = (Task)nodeBefore;
                    t2.addDirectSuccessors(sfb);
                    moveTask.setObjectivePlans(t2.getObjectivePlans());
                    moveTask.setPriority(t2.getPriority());
                    moveTask.setExpectedStart(t2.getExpectedEnd());
                }
                process.getSequenceFlows().add(sfb);
                Sequence_Flow sfa = new Sequence_Flow("SequenceFlow_M2", usecaseManager, (AbstractProcessGraphModel)moveTask, (AbstractProcessGraphModel)nodeAfter);
                moveTask.addDirectSuccessors(sfa);
                if (nodeAfter instanceof End_Event) {
                    End_Event ee = (End_Event)nodeAfter;
                    ee.addDirectPredecessors(sfa);
                    moveTask.setExpectedEnd(ee.getEnd());
                } else if (nodeAfter instanceof Task) {
                    Task t3 = (Task)nodeAfter;
                    t3.addDirectPredecessors(sfa);
                    moveTask.setObjectivePlans(t3.getObjectivePlans());
                    moveTask.setPriority(t3.getPriority());
                    moveTask.setExpectedEnd(t3.getExpectedStart());
                }
                process.getSequenceFlows().add(sfa);
                List seqFlows = process.findSequenceFlowsBetween((AbstractCollaborativeNodeModel)nodeBefore, nodeAfter);
                if (!seqFlows.isEmpty()) {
                    for (Sequence_Flow sf : seqFlows) {
                        Task t4;
                        if (nodeBefore instanceof Start_Event) {
                            Start_Event se = nodeBefore;
                            se.removeDirectSuccessors(sf);
                        } else if (nodeBefore instanceof Task) {
                            t4 = (Task)nodeBefore;
                            t4.removeDirectSuccessors(sf);
                        }
                        if (nodeAfter instanceof End_Event) {
                            End_Event ee = (End_Event)nodeAfter;
                            ee.removeDirectPredecessors(sf);
                        } else if (nodeAfter instanceof Task) {
                            t4 = (Task)nodeAfter;
                            t4.removeDirectPredecessors(sf);
                        }
                        process.getSequenceFlows().remove(sf);
                    }
                }
                if ((durationVal = moveTask.getDuration()).isSetPrecise() && nodeAfter instanceof Task) {
                    t = (Task)nodeAfter;
                    if (moveTask.getExpectedStart() == null && moveTask.getExpectedEnd() != null) {
                        moveTask.setExpectedStart(moveTask.getExpectedEnd().minusSeconds(durationVal.getPrecise().longValue()));
                    }
                    if (moveTask.getExpectedStart() != null && moveTask.getExpectedEnd() == null) {
                        moveTask.setExpectedEnd(moveTask.getExpectedStart().plusSeconds(durationVal.getPrecise().longValue()));
                    }
                } else {
                    throw new Exception("Not implemented !!!");
                }
                this.shiftProcessDurationFrom(t, durationVal.getPrecise());
                process.addTask(moveTask);
                System.out.println("new process: \n" + String.valueOf(process));
            } else {
                LOG.warn("geolocalization problem for " + nodeStart.getId() + " and " + nodeAfter.getId());
            }
        }
    }

    private void shiftProcessDurationFrom(Task t, Float precise) throws Exception {
        t.setExpectedStart(t.getExpectedStart().plusSeconds(precise.longValue()));
        t.setExpectedEnd(t.getExpectedEnd().plusSeconds(precise.longValue()));
        for (Sequence_Flow sf : t.getDirectSuccessors()) {
            AbstractNodeModel abstractNodeModel = sf.getTarget();
            if (!(abstractNodeModel instanceof Task)) continue;
            Task tn = (Task)abstractNodeModel;
            this.shiftProcessDurationFrom(tn, precise);
        }
    }

    protected void setGeolocalisationToNode(Task task, GJaxbRoute route, IndicatorManager indMan, GJaxbPointType p1, GJaxbPointType p2) throws Exception {
        GJaxbProperty actorColor;
        GJaxbNode.Geolocation geoRes = new GJaxbNode.Geolocation();
        geoRes.getItemView().add(new GJaxbNode.Geolocation.ItemView());
        GJaxbPolyline resPolyline = new GJaxbPolyline();
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().setPolyline(new GJaxbNodeMetaGeolocation.Polyline());
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).setPolyline(resPolyline);
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillOpacity(1.0);
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor("#FFFFFF");
        ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor("#FFFFFF");
        if (task.getAssignedActor() != null && (actorColor = GenericModelHelper.findProperty((String)"color", (List)task.getAssignedActor().getModel().getProperty())) != null) {
            ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor(actorColor.getValue());
            ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor(actorColor.getValue());
        }
        if (route != null) {
            LOG.debug("route " + route.getSummary() + "\n" + RouteHelper.getDistance((GJaxbRoute)route) + "\n" + RouteHelper.getDuration((GJaxbRoute)route));
            ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getPolyline().getPoint().add(p1);
            if (route.getOverviewPolyline() != null) {
                ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getPolyline().getPoint().addAll(route.getOverviewPolyline().getPoint());
            }
            ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getPolyline().getPoint().add(p2);
            ((GJaxbNode.Geolocation.ItemView)geoRes.getItemView().get(0)).getPolyline().getPoint().removeIf(p -> p == null);
            GJaxbTheoricValue thDuration = new GJaxbTheoricValue();
            thDuration.setPrecise(Float.valueOf(RouteHelper.getDuration((GJaxbRoute)route).floatValue()));
            indMan.setTheoricValue("Function:duration", task.getModel(), null, thDuration);
            GenericModelHelper.findProperty((String)"route", (List)task.getModel().getProperty(), (boolean)true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)route));
            task.getModel().setGeolocation(geoRes);
        } else {
            LOG.error(GenericModelHelper.getName((GJaxbNode)task.getModel()) + "  has no journey");
        }
    }

    private boolean hasGeolocalisation(GJaxbNode node) {
        return node.isSetGeolocation() && (((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetPoint() || ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetArea() || ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetPredefinedShape() || ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).isSetPolyline());
    }

    protected GJaxbRoute invokeShortestPath(GJaxbNode nodeBefore, GJaxbNode nodeAfter) throws Exception {
        if (!this.hasGeolocalisation(nodeBefore) || !this.hasGeolocalisation(nodeAfter)) {
            return new GJaxbRoute();
        }
        GJaxbLocalization a = new GJaxbLocalization();
        a.setId(nodeBefore.getId());
        a.setName(GenericModelHelper.findProperty((String)"name", (List)nodeBefore.getProperty()).getValue());
        GJaxbPointType jaxbStartPoint = new GJaxbPointType();
        a.setPoint(jaxbStartPoint);
        GJaxbLocalization b = new GJaxbLocalization();
        b.setId(nodeAfter.getId());
        b.setName(GenericModelHelper.findProperty((String)"name", (List)nodeAfter.getProperty()).getValue());
        GJaxbPointType jaxbEndPoint = new GJaxbPointType();
        b.setPoint(jaxbEndPoint);
        if (((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).isSetPolyline()) {
            GJaxbPointType pointModel = (GJaxbPointType)((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPolyline().getPoint().get(((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPolyline().getPoint().size() - 1);
            jaxbStartPoint.setLatitude(pointModel.getLatitude());
            jaxbStartPoint.setLongitude(pointModel.getLongitude());
        } else if (((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).isSetPoint()) {
            jaxbStartPoint.setLatitude(((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPoint().getLatitude());
            jaxbStartPoint.setLongitude(((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPoint().getLongitude());
        } else if (((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).isSetPredefinedShape() && ((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPredefinedShape().isSetCircle()) {
            jaxbStartPoint.setLatitude(((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLatitude());
            jaxbStartPoint.setLongitude(((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLongitude());
        } else {
            throw new Exception("Geometry not supported ");
        }
        if (((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).isSetPolyline()) {
            GJaxbPointType endPointModel = (GJaxbPointType)((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).getPolyline().getPoint().get(0);
            jaxbEndPoint.setLatitude(endPointModel.getLatitude());
            jaxbEndPoint.setLongitude(endPointModel.getLongitude());
        } else if (((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).isSetPoint()) {
            jaxbEndPoint.setLatitude(((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).getPoint().getLatitude());
            jaxbEndPoint.setLongitude(((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).getPoint().getLongitude());
        } else if (((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).isSetPredefinedShape() && ((GJaxbNode.Geolocation.ItemView)nodeBefore.getGeolocation().getItemView().get(0)).getPredefinedShape().isSetCircle()) {
            jaxbEndPoint.setLatitude(((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLatitude());
            jaxbEndPoint.setLongitude(((GJaxbNode.Geolocation.ItemView)nodeAfter.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle().getCenter().getLongitude());
        } else {
            throw new Exception("Geometry not supported");
        }
        LOG.debug("Invoke DistanceTimeMatrix " + String.valueOf(this.distanceMatrix.getDistanceTimeCalculatorSelected()));
        GJaxbPair journey = this.distanceMatrix.findJourney(a, b);
        GJaxbRoute route = RouteHelper.getRouteWithMinDuration((GJaxbPair)journey);
        LOG.trace("Journey " + String.valueOf(journey));
        LOG.trace("Time  " + RouteHelper.getDuration((GJaxbRoute)route));
        return route;
    }

    @Override
    public void initialize(Map<String, Object> context) throws Exception {
        super.initialize(context);
        if (context != null && context.get("MATRIX") != null) {
            this.distanceMatrix = (DistanceTimeMatrixManager)context.get("MATRIX");
        }
    }

    @Override
    public List<String> domains() {
        return null;
    }
}

