/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.humantask.service;

import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbPutDocumentEvent;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.service.Locker;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class HumantaskNotifier
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)HumantaskNotifier.class.getName());
    private static Map<String, Locker> lockers = new HashMap<String, Locker>();

    public HumantaskNotifier(String address) throws Exception {
        super(address);
    }

    public void addLockers(String task, Locker locker) {
        lockers.put(task, locker);
    }

    public void notify(GJaxbNotify notify) {
        block3: {
            Document msg = null;
            try {
                msg = WSNHelper.getInstance().getFirstMessageInNotification(notify);
                LOG.debug("message receive: " + XMLPrettyPrinter.print((Node)msg));
                if (!msg.getDocumentElement().getLocalName().equals("updateDocumentEvent") || !msg.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/EventType")) break block3;
                GJaxbPutDocumentEvent payload = (GJaxbPutDocumentEvent)XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbPutDocumentEvent.class);
                Object doc = payload.getDocument().getAny();
                if (doc instanceof Element) {
                    Element elmt = (Element)doc;
                    LOG.debug("receive notification: " + elmt.getTextContent());
                    GJaxbTask task = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall(elmt.getTextContent(), GJaxbTask.class);
                    this.handleMessage(task);
                    break block3;
                }
                throw new Exception("Document unrecognized !!!: " + String.valueOf(doc));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error("Impossible to handle: " + XMLCompactPrinter.print((Node)msg), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(GJaxbTask task) {
        LOG.debug("handle task " + GenericModelHelper.getName((GJaxbNode)task.getNode()));
        GJaxbProperty acceptance = GenericModelHelper.findProperty((String)"Acceptance", (List)task.getNode().getProperty(), (boolean)true);
        GJaxbProperty achieved = GenericModelHelper.findProperty((String)"Achieved", (List)task.getNode().getProperty(), (boolean)true);
        GJaxbProperty cancelled = GenericModelHelper.findProperty((String)"Cancelled", (List)task.getNode().getProperty(), (boolean)true);
        if ("ACCEPT".equals(acceptance.getValue()) || "DONE".equals(achieved.getValue()) || "ERROR".equals(achieved.getValue()) || "true".equals(cancelled.getValue())) {
            Locker locker = lockers.remove(task.getDeployedTaskId());
            if (locker != null) {
                Locker locker2 = locker;
                synchronized (locker2) {
                    locker.setTaskResponse(task);
                    locker.notify();
                }
            } else {
                LOG.warn("Locker not found");
            }
        }
    }
}

