/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.humantask.service;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.humantask.FaultMessage;
import fr.emac.gind.humantask.GJaxbAddHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbAddTaskASync;
import fr.emac.gind.humantask.GJaxbAddTaskASyncResponse;
import fr.emac.gind.humantask.GJaxbAddTaskSync;
import fr.emac.gind.humantask.GJaxbAddTaskSyncResponse;
import fr.emac.gind.humantask.GJaxbFindTask;
import fr.emac.gind.humantask.GJaxbFindTaskResponse;
import fr.emac.gind.humantask.GJaxbFindTasksByProcessInstanceId;
import fr.emac.gind.humantask.GJaxbFindTasksByProcessInstanceIdResponse;
import fr.emac.gind.humantask.GJaxbGetTask;
import fr.emac.gind.humantask.GJaxbGetTaskResponse;
import fr.emac.gind.humantask.GJaxbGetTodoList;
import fr.emac.gind.humantask.GJaxbGetTodoListResponse;
import fr.emac.gind.humantask.GJaxbRemoveHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbRemoveTask;
import fr.emac.gind.humantask.GJaxbRemoveTaskResponse;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResource;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResourceResponse;
import fr.emac.gind.humantask.GJaxbTask;
import fr.emac.gind.humantask.GJaxbTodoList;
import fr.emac.gind.humantask.GJaxbUnSubscribeTasksByAssignedToResource;
import fr.emac.gind.humantask.GJaxbUnSubscribeTasksByAssignedToResourceResponse;
import fr.emac.gind.humantask.GJaxbUpdateHumanTaskEvent;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.humantask.GJaxbUpdateTaskResponse;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.humantask.service.HumantaskNotifier;
import fr.emac.gind.humantask.service.Locker;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.storage.GJaxbGet;
import fr.emac.gind.storage.GJaxbGetResponse;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.GJaxbPutResponse;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbRemove;
import fr.emac.gind.storage.GJaxbRemoveResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.GJaxbUpdateResponse;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import fr.emac.gind.wsn.b_2_extension.GJaxbAndmessageContaining;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbSubscribeResponse;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribe;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbUnsubscribeResponse;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.Endpoint;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(portName="humantaskSOAP", serviceName="humantaskService", targetNamespace="http://www.gind.emac.fr/humantask", wsdlLocation="wsdl/humantask.wsdl", endpointInterface="fr.emac.gind.humantask.Humantask")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class HumantaskSOAPImpl
implements Humantask {
    private String humanTaskCollection = "HumanTask";
    private static final Logger LOG = LoggerFactory.getLogger((String)HumantaskSOAPImpl.class.getName());
    private String storageClientAddress = null;
    private Storage client = null;
    private String clientAddress = null;
    private HumantaskNotifier notifierClient = null;
    private Endpoint notifierClientServer = null;
    private NotificationManagerImpl producer = null;

    public HumantaskSOAPImpl(Map<String, Object> context, HumantaskNotifier notifierClient, NotificationManagerImpl producer) throws Exception {
        this.storageClientAddress = (String)context.get("storage");
        URI urlDefinedStockage = URI.create(this.storageClientAddress);
        if (context.get("host").toString().trim().equals(urlDefinedStockage.getHost().trim())) {
            this.storageClientAddress = String.valueOf(IPUtil.TRANSPORT_PROTOCOL.HTTP) + "://localhost:" + urlDefinedStockage.getPort() + urlDefinedStockage.getPath();
        }
        String suffixMongoId = RegExpHelper.toRegexFriendlyName((String)context.get("host").toString().replace(".", "_")) + "_" + Integer.parseInt(context.get("port").toString());
        this.humanTaskCollection = this.humanTaskCollection + "_" + suffixMongoId;
        this.client = StorageClient.createClient((String)this.storageClientAddress);
        this.producer = producer;
        this.notifierClient = notifierClient;
    }

    public GJaxbAddTaskASyncResponse addTaskASync(GJaxbAddTaskASync parameters) throws FaultMessage {
        LOG.info("Executing operation addTaskASync");
        try {
            GJaxbTask task = parameters.getTask();
            GJaxbPut putRequest = new GJaxbPut();
            putRequest.setCollection(this.humanTaskCollection);
            String document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)task) + "]]></gind:json>";
            putRequest.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
            GJaxbPutResponse updateResponse = this.client.put(putRequest);
            GJaxbAddTaskASyncResponse _return = new GJaxbAddTaskASyncResponse();
            _return.setDeployedTaskId(updateResponse.getId());
            task.setDeployedTaskId(updateResponse.getId());
            this.notifyOnHumanTaskEvent(task, new QName("http://www.gind.emac.fr/HumanTaskTopic", "addHumanTaskTopic"), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GJaxbAddTaskSyncResponse addTaskSync(GJaxbAddTaskSync parameters) throws FaultMessage {
        LOG.info("Executing operation addTask");
        try {
            Object updateRequest;
            GJaxbTask task = parameters.getTask();
            GJaxbAddTaskSyncResponse _return = new GJaxbAddTaskSyncResponse();
            if (task.getDeployedTaskId() == null) {
                GJaxbPut putRequest = new GJaxbPut();
                putRequest.setCollection(this.humanTaskCollection);
                document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)task) + "]]></gind:json>";
                putRequest.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
                GJaxbPutResponse putResponse = this.client.put(putRequest);
                parameters.getTask().setDeployedTaskId(putResponse.getId());
                updateRequest = new GJaxbUpdate();
                updateRequest.setCollection(this.humanTaskCollection);
                updateRequest.setId(putResponse.getId());
                document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)task) + "]]></gind:json>";
                updateRequest.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
                this.client.update(updateRequest);
                task.setDeployedTaskId(putResponse.getId());
                _return.setId(putResponse.getId());
            } else {
                GJaxbUpdate updateRequest2 = new GJaxbUpdate();
                updateRequest2.setCollection(this.humanTaskCollection);
                updateRequest2.setId(task.getDeployedTaskId());
                document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)task) + "]]></gind:json>";
                updateRequest2.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
                this.client.update(updateRequest2);
                task.setDeployedTaskId(task.getDeployedTaskId());
                _return.setId(task.getDeployedTaskId());
            }
            if (task.getNode().getId() == null || task.getNode().getId().isEmpty()) {
                throw new Exception("id of task cannot be null!!!");
            }
            GJaxbAndmessageContaining andmessageContaining = new GJaxbAndmessageContaining();
            andmessageContaining.getMessage().add("\"id\" : \"" + task.getDeployedTaskId() + "\"");
            Locker locker = new Locker();
            System.out.println("locker creater for task: " + parameters.getTask().getDeployedTaskId() + " (" + GenericModelHelper.getName((GJaxbNode)parameters.getTask().getNode()) + ")");
            this.notifierClient.addLockers(parameters.getTask().getDeployedTaskId(), locker);
            String subscriptionId = this.notifierClient.subscribeOn(this.storageClientAddress + "Subscriber", new QName("http://www.gind.emac.fr/EventType", "updateDocumentTopic"), andmessageContaining, null);
            locker.setSubscriptionId(subscriptionId);
            System.out.println("--- locker on task : " + GenericModelHelper.getName((GJaxbNode)task.getNode()) + " - mongo id: " + task.getDeployedTaskId());
            updateRequest = locker;
            synchronized (updateRequest) {
                this.notifyOnHumanTaskEvent(task, new QName("http://www.gind.emac.fr/HumanTaskTopic", "addHumanTaskTopic"), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                locker.wait();
            }
            this.notifierClient.unsubscribeOn(this.storageClientAddress + "Subscriber", locker.getSubscriptionId());
            GJaxbProperty cancelled = GenericModelHelper.findProperty((String)"Cancelled", (List)locker.getTaskResponse().getNode().getProperty());
            GJaxbProperty acceptance = GenericModelHelper.findProperty((String)"Acceptance", (List)locker.getTaskResponse().getNode().getProperty());
            GJaxbProperty achieved = GenericModelHelper.findProperty((String)"Achieved", (List)locker.getTaskResponse().getNode().getProperty());
            GJaxbProperty errorMsg = GenericModelHelper.findProperty((String)"Error Message", (List)locker.getTaskResponse().getNode().getProperty(), (boolean)true);
            if (cancelled != null && "true".equals(cancelled.getValue())) {
                errorMsg.setValue("Process cancelled");
                throw new FaultMessage(errorMsg.getValue(), null);
            }
            if (errorMsg.getValue() == null) {
                errorMsg.setValue("Error occured (without error message)");
            }
            if (acceptance.getValue().equals("REJECT") || achieved.getValue().equals("ERROR")) {
                throw new FaultMessage(errorMsg.getValue(), null);
            }
            _return.setResponse(new GJaxbAddTaskSyncResponse.Response());
            _return.getResponse().setTask(locker.getTaskResponse());
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetTaskResponse getTask(GJaxbGetTask parameters) throws FaultMessage {
        LOG.info("Executing operation getTask");
        try {
            GJaxbGetTaskResponse _return = new GJaxbGetTaskResponse();
            GJaxbGet query = new GJaxbGet();
            query.setCollection(this.humanTaskCollection);
            query.setId(parameters.getDeployedTaskId());
            GJaxbGetResponse queryResponse = this.client.get(query);
            if (queryResponse.getAny() != null) {
                Element result = (Element)queryResponse.getAny();
                String buffer = result.getTextContent();
                Document doc = Document.parse((String)buffer);
                String jsonTask = ((Document)doc.get((Object)"task")).toJson();
                GJaxbTask taskToGet = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall("{ \"task\" : " + jsonTask + " }", GJaxbTask.class);
                _return.setTask(taskToGet);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbGetTodoListResponse getTodoList(GJaxbGetTodoList parameters) throws FaultMessage {
        LOG.info("Executing operation getTodoList");
        try {
            GJaxbQueryResponse queryResponse;
            GJaxbGetTodoListResponse _return = new GJaxbGetTodoListResponse();
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.humanTaskCollection);
            if (parameters.getAssignedToId() != null && !parameters.getAssignedToId().isBlank() && !parameters.getAssignedToId().equals("null")) {
                query.setQuery("{\n   \"task.assignedToIds\" : \"" + parameters.getAssignedToId() + "\",\n}");
            }
            if ((queryResponse = this.client.query(query)).getAny() != null && !queryResponse.getAny().isEmpty()) {
                GJaxbTodoList todoList = new GJaxbTodoList();
                for (Object item : queryResponse.getAny()) {
                    Element result = (Element)item;
                    String buffer = result.getTextContent();
                    Document doc = Document.parse((String)buffer);
                    String taskId = doc.get((Object)"_id").toString();
                    String jsonTask = ((Document)doc.get((Object)"task")).toJson();
                    GJaxbTask task = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall("{ \"task\" : " + jsonTask + " }", GJaxbTask.class);
                    task.setDeployedTaskId(taskId);
                    todoList.getTask().add(task);
                }
                _return.setTodoList(todoList);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbRemoveTaskResponse removeTask(GJaxbRemoveTask parameters) throws FaultMessage {
        LOG.info("Executing operation removeTask");
        try {
            GJaxbRemoveTaskResponse _return = new GJaxbRemoveTaskResponse();
            GJaxbRemove query = new GJaxbRemove();
            query.setCollection(this.humanTaskCollection);
            query.setId(parameters.getId());
            GJaxbRemoveResponse queryResponse = this.client.remove(query);
            if (queryResponse.getAny() != null) {
                Element result = (Element)queryResponse.getAny();
                String buffer = result.getTextContent();
                Document doc = Document.parse((String)buffer);
                String jsonTask = ((Document)doc.get((Object)"task")).toJson();
                GJaxbTask taskToRemove = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall("{ \"task\" : " + jsonTask + " }", GJaxbTask.class);
                _return.setTask(taskToRemove);
            }
            this.notifyOnHumanTaskEvent(_return.getTask(), new QName("http://www.gind.emac.fr/HumanTaskTopic", "removeHumanTaskTopic"), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public synchronized GJaxbUpdateTaskResponse updateTask(GJaxbUpdateTask parameters) throws FaultMessage {
        LOG.info("Executing operation updateTask");
        try {
            GJaxbUpdateTaskResponse _return = new GJaxbUpdateTaskResponse();
            if (parameters.getDeployedTaskId() == null) {
                GJaxbFindTask findTaskReq = new GJaxbFindTask();
                findTaskReq.setTask(parameters.getTask());
                GJaxbFindTaskResponse findTaskResp = this.findTask(findTaskReq);
                if (findTaskResp.isSetId()) {
                    parameters.setDeployedTaskId(findTaskResp.getId());
                    return this.updateTask(parameters);
                }
                GJaxbAddTaskASync addTask = new GJaxbAddTaskASync();
                addTask.setTask(parameters.getTask());
                addTask.setCollaborationName(parameters.getCollaborationName());
                addTask.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                GJaxbAddTaskASyncResponse addTaskResp = this.addTaskASync(addTask);
                _return.setDeployedTaskId(addTaskResp.getDeployedTaskId());
            } else {
                GJaxbUpdate update = new GJaxbUpdate();
                update.setCollection(this.humanTaskCollection);
                assert (parameters.getDeployedTaskId() != null);
                update.setId(parameters.getDeployedTaskId());
                String document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters.getTask()) + "]]></gind:json>";
                org.w3c.dom.Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes()));
                update.setAny((Object)doc.getDocumentElement());
                GJaxbUpdateResponse queryResponse = this.client.update(update);
                this.notifyOnHumanTaskEvent(parameters.getTask(), new QName("http://www.gind.emac.fr/HumanTaskTopic", "updateHumanTaskTopic"), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                _return.setDeployedTaskId(queryResponse.getId());
            }
            return _return;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbFindTaskResponse findTask(GJaxbFindTask parameters) throws FaultMessage {
        try {
            GJaxbFindTaskResponse _return = new GJaxbFindTaskResponse();
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.humanTaskCollection);
            StringBuffer queryS = new StringBuffer();
            queryS.append("{\n");
            if (parameters.getTask().getNode().getId() != null) {
                queryS.append("   \"task.node.id\" : \"" + parameters.getTask().getNode().getId() + "\"\n");
            }
            queryS.append("}");
            query.setQuery(queryS.toString());
            GJaxbQueryResponse queryResponse = this.client.query(query);
            if (queryResponse.getAny() != null && !queryResponse.getAny().isEmpty()) {
                Element result = (Element)queryResponse.getAny().get(0);
                String buffer = result.getTextContent();
                Document doc = Document.parse((String)buffer);
                String taskId = doc.get((Object)"_id").toString();
                String jsonTask = ((Document)doc.get((Object)"task")).toJson();
                GJaxbTask task = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall("{ \"task\" : " + jsonTask + " }", GJaxbTask.class);
                _return.setId(taskId);
                _return.setTask(task);
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbSubscribeTasksByAssignedToResourceResponse subscribeTasksByAssignedToResource(GJaxbSubscribeTasksByAssignedToResource parameters) throws FaultMessage {
        GJaxbSubscribeTasksByAssignedToResourceResponse response = new GJaxbSubscribeTasksByAssignedToResourceResponse();
        try {
            GJaxbAndmessageContaining andMsg4Doc = new GJaxbAndmessageContaining();
            if (parameters.getAssignedToIds() != null && !parameters.getAssignedToIds().isEmpty()) {
                ArrayList<String> cleanedAssignedToIds = new ArrayList<String>();
                for (String assignedToId : parameters.getAssignedToIds()) {
                    if (assignedToId == null || assignedToId.isBlank() || assignedToId.equals("null")) continue;
                    cleanedAssignedToIds.add(assignedToId);
                }
                if (!cleanedAssignedToIds.isEmpty()) {
                    andMsg4Doc.getMessage().add("\"assignedToIds\" : \"" + String.valueOf(parameters.getAssignedToIds()) + "\"");
                }
            }
            GJaxbSubscribe subscribeRequest = WSNHelper.getInstance().createSubscription(parameters.getCallbackAddress(), parameters.getTopic(), andMsg4Doc, null);
            GJaxbSubscribeResponse resp = this.producer.subscribe(subscribeRequest);
            response.setSubscriptionId(resp.getSubscriptionReference().getAddress().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbUnSubscribeTasksByAssignedToResourceResponse unSubscribeTasksByAssignedToResource(GJaxbUnSubscribeTasksByAssignedToResource parameters) throws FaultMessage {
        GJaxbUnSubscribeTasksByAssignedToResourceResponse response = new GJaxbUnSubscribeTasksByAssignedToResourceResponse();
        try {
            GJaxbUnsubscribe unsubscribeRequest = WSNHelper.getInstance().createUnSubscription(parameters.getSubscriptionId());
            GJaxbUnsubscribeResponse gJaxbUnsubscribeResponse = this.producer.unsubscribe(unsubscribeRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    private void notifyOnHumanTaskEvent(final GJaxbTask task, final QName topic, final String collaborationName, final String knowledgeSpaceName) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ HumantaskSOAPImpl this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GJaxbTask gJaxbTask = task;
                    synchronized (gJaxbTask) {
                        GJaxbAddHumanTaskEvent notif = null;
                        if (topic.equals(new QName("http://www.gind.emac.fr/HumanTaskTopic", "addHumanTaskTopic"))) {
                            GJaxbAddHumanTaskEvent event = new GJaxbAddHumanTaskEvent();
                            event.setTask(task);
                            event.setCollaborationName(collaborationName);
                            event.setKnowledgeSpaceName(knowledgeSpaceName);
                            notif = event;
                        } else if (topic.equals(new QName("http://www.gind.emac.fr/HumanTaskTopic", "updateHumanTaskTopic"))) {
                            GJaxbUpdateHumanTaskEvent event = new GJaxbUpdateHumanTaskEvent();
                            event.setTask(task);
                            event.setCollaborationName(collaborationName);
                            event.setKnowledgeSpaceName(knowledgeSpaceName);
                            notif = event;
                        } else if (topic.equals(new QName("http://www.gind.emac.fr/HumanTaskTopic", "removeHumanTaskTopic"))) {
                            GJaxbRemoveHumanTaskEvent event = new GJaxbRemoveHumanTaskEvent();
                            event.setTask(task);
                            event.setCollaborationName(collaborationName);
                            event.setKnowledgeSpaceName(knowledgeSpaceName);
                            notif = event;
                        }
                        LOG.debug("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)notif)));
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)notif, topic, null, Boolean.valueOf(true));
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)notif, new QName("http://www.gind.emac.fr/HumanTaskTopic", "allHumanTaskTopic"), null, Boolean.valueOf(true));
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), null, (Object)e);
                }
            }
        });
    }

    public GJaxbFindTasksByProcessInstanceIdResponse findTasksByProcessInstanceId(GJaxbFindTasksByProcessInstanceId parameters) throws FaultMessage {
        try {
            GJaxbFindTasksByProcessInstanceIdResponse _return = new GJaxbFindTasksByProcessInstanceIdResponse();
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.humanTaskCollection);
            StringBuffer queryS = new StringBuffer();
            queryS.append("{\n");
            queryS.append("   \"task.processInstanceId\" : \"" + parameters.getProcessInstanceId() + "\"\n");
            queryS.append("}");
            query.setQuery(queryS.toString());
            GJaxbQueryResponse queryResponse = this.client.query(query);
            if (queryResponse.getAny() != null && !queryResponse.getAny().isEmpty()) {
                for (Object obj : queryResponse.getAny()) {
                    Element result = (Element)obj;
                    String buffer = result.getTextContent();
                    Document doc = Document.parse((String)buffer);
                    String taskId = doc.get((Object)"_id").toString();
                    String jsonTask = ((Document)doc.get((Object)"task")).toJson();
                    GJaxbTask task = (GJaxbTask)JSONJAXBContext.getInstance().unmarshall("{ \"task\" : " + jsonTask + " }", GJaxbTask.class);
                    _return.getTask().add(task);
                }
            }
            return _return;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), null, (Object)e);
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
    }
}

