/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.cep.manager.CepRulesManagerCommand;
import fr.emac.gind.event.cep.manager.CepRulesManagerNotifier;
import fr.emac.gind.event.event_broker.EventBroker;
import fr.emac.gind.event.event_broker.data.GJaxbRegister;
import fr.emac.gind.event.event_broker.data.GJaxbTopic;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.ml.manager.MLConfigManagerCommand;
import fr.emac.gind.event.ml.manager.MLManagerNotifier;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.event.producer.simulator.EventBrokerClient;
import fr.emac.gind.io.interpretation.engine.HighLevelInterpretationEngine;
import fr.emac.gind.io.interpretation.engine.HighLevelInterpretationNotifier;
import fr.emac.gind.io.interpretation.engine.LowLevelInterpretationDispatcherEngineCommand;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpretationEngineContainer
extends SPIWebServicePrimitives {
    private Logger LOG = LoggerFactory.getLogger((String)InterpretationEngineContainer.class.getName());
    private String storageAddress = null;
    private String governanceAddress = null;

    public void onInit(final Map<String, Object> context) throws RuntimeException {
        try {
            if (context.get("storage") == null) {
                throw new UncheckedException("Configuration Error: storage cannot be null!!!");
            }
            this.storageAddress = (String)context.get("storage");
            if (context.get("governance") == null) {
                throw new UncheckedException("Configuration Error: governance cannot be null!!!");
            }
            this.governanceAddress = (String)context.get("governance");
            GJaxbTopicSetType hightopicSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("highLevelTopicSet/TopicSet.xml"), GJaxbTopicSetType.class);
            GJaxbTopicSetType lowtopicSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("lowLevelCepTopicSet/TopicSet.xml"), GJaxbTopicSetType.class);
            HighLevelInterpretationEngine highLevelSubscriber = new HighLevelInterpretationEngine(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"HighLevelInterpretationSubscriber"), this.storageAddress, hightopicSet);
            HighLevelInterpretationNotifier highLevelNotifier = new HighLevelInterpretationNotifier(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"HighLevelInterpretationNotifier"), this.governanceAddress, highLevelSubscriber, context);
            final NotificationManagerImpl lowLevelSubscriber = new NotificationManagerImpl(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"LowLevelInterpretationSubscriber"), this.storageAddress, "LowLevelInterpretationSubscriber_" + RegExpHelper.toRegexFriendlyName((String)this.getHost().replace(".", "_")), new HashMap(), new GJaxbTopicSetType(), null, new ResourcesManager[0]);
            LowLevelInterpretationDispatcherEngineCommand lowLevelCommand = new LowLevelInterpretationDispatcherEngineCommand(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"LowLevelInterpretationManager"), lowtopicSet, highLevelNotifier.getAddress(), lowLevelSubscriber, context);
            CepRulesManagerNotifier lowLevelCepNotifier = new CepRulesManagerNotifier(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"LowLevelInterpretationCepNotifier"), (CepRulesManagerCommand)lowLevelCommand.getCepEngine());
            MLManagerNotifier lowLevelMLNotifier = new MLManagerNotifier(InterpretationEngineContainer.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)"LowLevelInterpretationMLNotifier"), (MLConfigManagerCommand)lowLevelCommand.getMlEngine(), context);
            lowLevelCommand.getCepEngine().setNotifier(lowLevelCepNotifier);
            lowLevelCommand.getMlEngine().setNotifier(lowLevelMLNotifier);
            this.registerWSImplementation("LowLevelInterpretationManager", lowLevelCommand);
            this.registerWSImplementation("LowLevelInterpretationSubscriber", lowLevelSubscriber);
            this.registerWSImplementation("LowLevelInterpretationCepNotifier", lowLevelCepNotifier);
            this.registerWSImplementation("LowLevelInterpretationMLNotifier", lowLevelMLNotifier);
            this.registerWSImplementation("HighLevelInterpretationSubscriber", highLevelSubscriber);
            this.registerWSImplementation("HighLevelInterpretationNotifier", highLevelNotifier);
            if ((String)context.get("event-broker") != null) {
                final InterpretationEngineContainer container = this;
                ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
                service.execute(new Runnable(){
                    final /* synthetic */ InterpretationEngineContainer this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        while (!container.isStarted()) {
                            this.this$0.LOG.debug("Wait interpretation engine container start");
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        GJaxbRegister request = new GJaxbRegister();
                        String lowLevelInterpretationSubscriberAddress = lowLevelSubscriber.getAddress();
                        try {
                            GJaxbTopicSetType topicLowLevelCepSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("lowLevelCepTopicSet/TopicSet.xml"), GJaxbTopicSetType.class);
                            for (Object topic : WSNHelper.getInstance().getTopic(topicLowLevelCepSet)) {
                                GJaxbTopic t = new GJaxbTopic();
                                t.setName((QName)topic);
                                request.getTopic().add(t);
                            }
                            GJaxbTopicSetType topicHighLevelSet = (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("highLevelTopicSet/TopicSet.xml"), GJaxbTopicSetType.class);
                            for (QName topic : WSNHelper.getInstance().getTopic(topicHighLevelSet)) {
                                GJaxbTopic t = new GJaxbTopic();
                                t.setName(topic);
                                request.getTopic().add(t);
                            }
                            request.setAddress(lowLevelInterpretationSubscriberAddress);
                            String brokerAddressRegister = ((String)context.get("event-broker")).replace("/BrokerSubscriber", "/BrokerRegister");
                            EventBroker clientBroker = EventBrokerClient.createClient((String)brokerAddressRegister);
                            boolean ok = false;
                            while (!ok) {
                                try {
                                    clientBroker.register(request);
                                    ok = true;
                                }
                                catch (Throwable e) {
                                    this.this$0.LOG.error("Impossible to connect to event broker. Try again....");
                                    try {
                                        Thread.sleep(300L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                        }
                        catch (Exception e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UncheckedException(e.getMessage(), (Throwable)e);
        }
    }
}

