/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine.interpretor;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.rest.HTTPClientUtil;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.event.interpretation.predict.SPIPredictModuleService;
import fr.emac.gind.eventtype.GJaxbAddEdgeEvent;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbPublishModelEvent;
import fr.emac.gind.eventtype.GJaxbReflexEvent;
import fr.emac.gind.eventtype.GJaxbRemoveEdgeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveNodeEvent;
import fr.emac.gind.eventtype.GJaxbUnpublishModelEvent;
import fr.emac.gind.eventtype.GJaxbUpdateEdgeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateNodeEvent;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core.client.util.Neo4JReqConstant;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models_gov.GJaxbPublishOptions;
import fr.emac.gind.gov.models_gov.GJaxbPublishSyncModel;
import fr.emac.gind.gov.models_gov.GJaxbUnpublishSyncModel;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.io.interpretation.engine.HighLevelInterpretationNotifier;
import fr.emac.gind.io.interpretation.engine.interpretor.AbstractConceptInterpretor;
import fr.emac.gind.io.interpretation.engine.interpretor.DefaultInterpretor;
import fr.emac.gind.io.interpretation.module.predict.ChatGPTPredictEngine;
import fr.emac.gind.json_connector.GJaxbData;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.message.GJaxbMsgMediaObject;
import fr.emac.gind.model.interpretation.config.GJaxbContext;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.io.File;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpretationManager {
    private static Logger LOG = LoggerFactory.getLogger(InterpretationManager.class);
    private Map<String, Object> context = null;
    private ModelsGov modelsClient = null;
    private CoreGov coreClient = null;
    private DefaultInterpretor defaultInterpretor = null;
    private ServiceLoader<AbstractConceptInterpretor> conceptInterpretorsLoader = ServiceLoader.load(AbstractConceptInterpretor.class);
    private Map<QName, AbstractConceptInterpretor> conceptInterpretors = new HashMap<QName, AbstractConceptInterpretor>();
    private HighLevelInterpretationNotifier highLevelInterpretationNotifier = null;

    public InterpretationManager(HighLevelInterpretationNotifier highLevelInterpretationNotifier, String governanceAddress, Map<String, Object> context) throws Exception {
        this.context = context;
        this.modelsClient = ModelsGovClient.createClient((String)governanceAddress.replace("/gov", "/GovModels"));
        this.coreClient = CoreGovClient.createClient((String)governanceAddress.replace("/gov", "/GovCore"));
        this.highLevelInterpretationNotifier = highLevelInterpretationNotifier;
        this.defaultInterpretor = new DefaultInterpretor();
        this.defaultInterpretor.setContext(context);
        this.initConceptInterpretors();
    }

    private void initConceptInterpretors() throws Exception {
        this.defaultInterpretor.setCoreClient(this.coreClient);
        this.defaultInterpretor.setModelsClient(this.modelsClient);
        this.conceptInterpretors.clear();
        this.conceptInterpretorsLoader.reload();
        for (AbstractConceptInterpretor conceptInterpretor : this.conceptInterpretorsLoader) {
            conceptInterpretor.setCoreClient(this.coreClient);
            conceptInterpretor.setModelsClient(this.modelsClient);
            conceptInterpretor.setContext(this.context);
            this.conceptInterpretors.put(conceptInterpretor.getConcept(), conceptInterpretor);
        }
    }

    public void interpret(AbstractJaxbObject payload, Map<QName, String> eventContext) throws Exception {
        GJaxbEdge edgeInModel;
        GJaxbNode nodeInModel;
        GJaxbPublishModelEvent.Model model;
        String collaborationName = null;
        String knowledgeSpaceName = null;
        GJaxbNode node = null;
        if (payload instanceof GJaxbAddNodeEvent) {
            collaborationName = ((GJaxbAddNodeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbAddNodeEvent)payload).getKnowledgeSpaceName();
            node = ((GJaxbAddNodeEvent)payload).getNode();
            InterpretationManager.cleanNode(node);
            this.addNodeEvent(node, ((GJaxbAddNodeEvent)payload).getParentNodeId(), collaborationName, knowledgeSpaceName, eventContext);
        } else if (payload instanceof GJaxbUpdateNodeEvent) {
            collaborationName = ((GJaxbUpdateNodeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbUpdateNodeEvent)payload).getKnowledgeSpaceName();
            node = ((GJaxbUpdateNodeEvent)payload).getNode();
            InterpretationManager.cleanNode(node);
            this.updateNodeEvent(node, ((GJaxbUpdateNodeEvent)payload).getParentNodeId(), collaborationName, knowledgeSpaceName, eventContext);
        } else if (payload instanceof GJaxbRemoveNodeEvent) {
            collaborationName = ((GJaxbRemoveNodeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbRemoveNodeEvent)payload).getKnowledgeSpaceName();
            node = ((GJaxbRemoveNodeEvent)payload).getNode();
            InterpretationManager.cleanNode(node);
            this.removeNodeEvent(node, collaborationName, knowledgeSpaceName, eventContext);
        }
        GJaxbEdge edge = null;
        if (payload instanceof GJaxbAddEdgeEvent) {
            collaborationName = ((GJaxbAddEdgeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbAddEdgeEvent)payload).getKnowledgeSpaceName();
            edge = ((GJaxbAddEdgeEvent)payload).getEdge();
            this.addEdgeEvent(edge, ((GJaxbAddEdgeEvent)payload).getSourceNodeId(), ((GJaxbAddEdgeEvent)payload).getTargetNodeId(), collaborationName, knowledgeSpaceName, eventContext);
        } else if (payload instanceof GJaxbUpdateEdgeEvent) {
            collaborationName = ((GJaxbUpdateEdgeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbUpdateEdgeEvent)payload).getKnowledgeSpaceName();
            edge = ((GJaxbUpdateEdgeEvent)payload).getEdge();
            this.updateEdgeEvent(edge, ((GJaxbUpdateEdgeEvent)payload).getSourceNodeId(), ((GJaxbUpdateEdgeEvent)payload).getTargetNodeId(), collaborationName, knowledgeSpaceName, eventContext);
        } else if (payload instanceof GJaxbRemoveEdgeEvent) {
            collaborationName = ((GJaxbRemoveEdgeEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbRemoveEdgeEvent)payload).getKnowledgeSpaceName();
            edge = ((GJaxbRemoveEdgeEvent)payload).getEdge();
            this.removeEdgeEvent(edge, collaborationName, knowledgeSpaceName, eventContext);
        }
        if (payload instanceof GJaxbPublishModelEvent) {
            collaborationName = ((GJaxbPublishModelEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbPublishModelEvent)payload).getKnowledgeSpaceName();
            model = null;
            model = ((GJaxbPublishModelEvent)payload).getModel();
            for (GJaxbPublishModelEvent.Model.Nodes nodesInModel : model.getNodes()) {
                nodeInModel = nodesInModel.getNode();
                if (nodeInModel.getStatus().isEmpty()) {
                    nodeInModel.getStatus().add(GJaxbStatusType.ACTIVE);
                }
                InterpretationManager.cleanNode(nodeInModel);
                this.addNodeEvent(nodeInModel, nodesInModel.getParentNodeId(), collaborationName, knowledgeSpaceName, eventContext);
            }
            for (GJaxbPublishModelEvent.Model.Edges edgesInModel : model.getEdges()) {
                edgeInModel = edgesInModel.getEdge();
                this.addEdgeEvent(edgeInModel, edgesInModel.getSourceNodeId(), edgesInModel.getTargetNodeId(), collaborationName, knowledgeSpaceName, eventContext);
            }
        }
        if (payload instanceof GJaxbUnpublishModelEvent) {
            collaborationName = ((GJaxbUnpublishModelEvent)payload).getCollaborationName();
            knowledgeSpaceName = ((GJaxbUnpublishModelEvent)payload).getKnowledgeSpaceName();
            model = null;
            model = ((GJaxbUnpublishModelEvent)payload).getModel();
            for (GJaxbPublishModelEvent.Model.Nodes nodesInModel : model.getNodes()) {
                nodeInModel = nodesInModel.getNode();
                InterpretationManager.cleanNode(nodeInModel);
                this.removeNodeEvent(nodeInModel, collaborationName, knowledgeSpaceName, eventContext);
            }
            for (GJaxbPublishModelEvent.Model.Edges edgesInModel : model.getEdges()) {
                edgeInModel = edgesInModel.getEdge();
                this.removeEdgeEvent(edgeInModel, collaborationName, knowledgeSpaceName, eventContext);
            }
        }
    }

    private void addReflexActions(final GJaxbNode nodeAdded, Map<QName, String> eventContext, final String collaborationName, final String knowledgeSpaceName) throws Exception {
        if (eventContext.containsKey(new QName("http://www.gind.emac.fr", "dataSourcesConcerned"))) {
            final ArrayList<GJaxbNode> iots = new ArrayList<GJaxbNode>();
            GJaxbContext.DataSourcesConcerned sensorsConcerned = (GJaxbContext.DataSourcesConcerned)JSONJAXBContext.getInstance().unmarshall("{ \"dataSourcesConcerned\" : " + eventContext.get(new QName("http://www.gind.emac.fr", "dataSourcesConcerned")) + " }", GJaxbContext.DataSourcesConcerned.class);
            for (String sensorId : sensorsConcerned.getDataSourceId()) {
                GJaxbNode sensor_node = null;
                GJaxbQuery querySensor = new GJaxbQuery();
                querySensor.setQuery("match (s:" + Neo4JReqConstant.core((String)"Sensor") + " { modelNodeId: \"" + Neo4JId.createIdUsingCollaboration((String)sensorId, (String)collaborationName, (String)knowledgeSpaceName) + "\"}) return distinct s");
                querySensor.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                querySensor.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                querySensor.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                GJaxbQueryResponse queryRespSensor = this.coreClient.query(querySensor);
                if (queryRespSensor.getSingle() != null && queryRespSensor.getSingle().getGenericModel() != null) {
                    GJaxbGenericModel model = queryRespSensor.getSingle().getGenericModel();
                    sensor_node = (GJaxbNode)model.getNode().getFirst();
                }
                String type = GenericModelHelper.findProperty((String)"type", (List)sensor_node.getProperty(), (boolean)true).getValue();
                if ("Media".toLowerCase().equals(type.toLowerCase())) {
                    iots.add(sensor_node);
                    continue;
                }
                GJaxbQuery query = new GJaxbQuery();
                query.setQuery("match (s:" + Neo4JReqConstant.core((String)"Sensor") + " { modelNodeId: \"" + Neo4JId.createIdUsingCollaboration((String)sensorId, (String)collaborationName, (String)knowledgeSpaceName) + "\"})-[p:" + Neo4JReqConstant.collab((String)"Pilots") + "]->(g:" + Neo4JReqConstant.collab((String)"Good") + ") return distinct g");
                query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                GJaxbQueryResponse queryResp = this.coreClient.query(query);
                if (queryResp.getSingle() == null || queryResp.getSingle().getGenericModel() == null) continue;
                GJaxbGenericModel model = queryResp.getSingle().getGenericModel();
                iots.addAll(model.getNode());
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.execute(new Runnable(){
                final /* synthetic */ InterpretationManager this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        GJaxbReflexEvent reflexEvent = new GJaxbReflexEvent();
                        reflexEvent.setEventId("reflex_event_" + UUID.randomUUID().toString());
                        reflexEvent.setCreatedAt(XMLGregorianCalendarHelper.getInstance().getNewCalendar());
                        reflexEvent.setCollaborationName(collaborationName);
                        reflexEvent.setKnowledgeSpaceName(knowledgeSpaceName);
                        Iterator iterator = iots.iterator();
                        while (true) {
                            JSONObject takeAPhotoResponse;
                            String embedded64OrUrlImg;
                            GJaxbReflexEvent.Iot iotEv;
                            GJaxbNode iot;
                            block10: {
                                if (!iterator.hasNext()) {
                                    this.this$0.highLevelInterpretationNotifier.notifyReflexEvent(reflexEvent);
                                    return;
                                }
                                iot = (GJaxbNode)iterator.next();
                                iotEv = new GJaxbReflexEvent.Iot();
                                iotEv.setIotId(iot.getId());
                                iotEv.setIotName(GenericModelHelper.findProperty((String)"name", (List)iot.getProperty()).getValue());
                                iotEv.setIotEndpointAddress(GenericModelHelper.findProperty((String)"endpoint address", (List)iot.getProperty(), (boolean)true).getValue());
                                iotEv.setNode(iot);
                                reflexEvent.getIot().add(iotEv);
                                String iotType = GenericModelHelper.findProperty((String)"type", (List)iot.getProperty(), (boolean)true).getValue();
                                String iotNature = GenericModelHelper.findProperty((String)"nature", (List)iot.getProperty(), (boolean)true).getValue();
                                if (iotType.toLowerCase().equals("camera") || iotType.toLowerCase().equals("media") && iotNature.toLowerCase().equals("video")) {
                                    iotEv.setIotType("camera");
                                    iotEv.setFunctionToPlay("play");
                                    continue;
                                }
                                if (!iotType.toLowerCase().equals("photo_camera") && (!iotType.toLowerCase().equals("media") || !iotNature.toLowerCase().equals("picture"))) continue;
                                iotEv.setIotType("photo_camera");
                                iotEv.setFunctionToPlay("takeAPhoto");
                                embedded64OrUrlImg = null;
                                takeAPhotoResponse = null;
                                if (iotType.toLowerCase().equals("photo_camera")) {
                                    String endpointAddress = GenericModelHelper.findProperty((String)"endpoint address", (List)iot.getProperty(), (boolean)true).getValue() + "/takeAPhoto";
                                    JSONObject payloadJson = new JSONObject("{\n\ttakeAPhoto: {}\n}\n");
                                    LOG.debug("send TakeAPhoto request at address => " + endpointAddress + ": \n" + payloadJson.toString());
                                    HttpResponse httpResp = HTTPClientUtil.sendHTTPRequest((HTTPClientUtil.HTTPProtocol)HTTPClientUtil.HTTPProtocol.POST, (String)endpointAddress, (JSONObject)payloadJson, (Long)30000L, (Integer)3, null);
                                    if (httpResp.statusCode() == 200 && httpResp.body() != null && !((String)httpResp.body()).isBlank()) {
                                        LOG.debug("TakeAPhoto response => status code: " + httpResp.statusCode() + " - body length: " + (httpResp.body() != null ? ((String)httpResp.body()).length() : 0));
                                        takeAPhotoResponse = new JSONObject((String)httpResp.body());
                                        JSONObject embedded = takeAPhotoResponse.getJSONObject("takeAPhotoResponse").getJSONObject("embedded");
                                        embedded64OrUrlImg = embedded.getString("dataEncodedBase64");
                                        break block10;
                                    } else {
                                        LOG.error("TakeAPhoto response => status code: " + httpResp.statusCode() + " - body: " + (httpResp.body() != null ? (String)httpResp.body() : "no error msg"));
                                        throw new RuntimeException("Impossible to POST TakeAPhoto (error code: " + httpResp.statusCode() + ") at this adress: " + endpointAddress);
                                    }
                                }
                                JSONArray mediaValueArray = new JSONArray(GenericModelHelper.findProperty((String)"mediaValue", (List)nodeAdded.getProperty(), (boolean)true).getValue());
                                GJaxbData.Media.Value mediaValue = (GJaxbData.Media.Value)JSONJAXBContext.getInstance().unmarshall("{ \"value\" : " + mediaValueArray.getJSONObject(0).toString() + " }", GJaxbData.Media.Value.class);
                                GJaxbMsgMediaObject media1 = (GJaxbMsgMediaObject)mediaValue.getMessage().getMedia().get(0);
                                if (media1.isSetUrl()) {
                                    embedded64OrUrlImg = media1.getUrl();
                                    takeAPhotoResponse = new JSONObject();
                                    takeAPhotoResponse.put("takeAPhotoResponse", (Object)new JSONObject());
                                    takeAPhotoResponse.getJSONObject("takeAPhotoResponse").put("url", (Object)embedded64OrUrlImg);
                                } else {
                                    embedded64OrUrlImg = media1.getEmbedded().getDataEncodedBase64().toString();
                                    takeAPhotoResponse = new JSONObject();
                                    takeAPhotoResponse.put("takeAPhotoResponse", (Object)new JSONObject());
                                    takeAPhotoResponse.getJSONObject("takeAPhotoResponse").put("embedded", (Object)new JSONObject());
                                    takeAPhotoResponse.getJSONObject("takeAPhotoResponse").getJSONObject("embedded").put("dataEncodedBase64", (Object)embedded64OrUrlImg);
                                }
                            }
                            if (embedded64OrUrlImg == null) continue;
                            iotEv.setOutputPayload(takeAPhotoResponse.toString());
                            LOG.debug("Run prediction");
                            iotEv.setPredict(new GJaxbReflexEvent.Iot.Predict());
                            iotEv.getPredict().setLastResult(new GJaxbReflexEvent.Iot.Predict.LastResult());
                            iotEv.getPredict().getLastResult().setNonePredictionResult("Wait picture analysis (IA)...");
                            this.this$0.highLevelInterpretationNotifier.notifyReflexEvent(reflexEvent);
                            this.this$0.runChatGPTPredict(iot, iotEv, embedded64OrUrlImg, nodeAdded, collaborationName, knowledgeSpaceName);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void runChatGPTPredict(GJaxbNode iot, GJaxbReflexEvent.Iot iotEv, String dataEncodedBase64, GJaxbNode nodeAdded, String collaborationName, String knowledgeSpaceName) throws Exception {
        GJaxbQuery query = new GJaxbQuery();
        StringBuffer contextualData = new StringBuffer();
        if (EffectiveMetaModelPluginManager.getInstance().inherit(iot, GenericModelHelper.collab((String)"Good"))) {
            query.setQuery("match path = (iot { modelNodeId : '" + Neo4JId.createIdUsingCollaboration((String)iotEv.getIotId(), (String)collaborationName, (String)knowledgeSpaceName) + "'})<-[p:`" + String.valueOf(GenericModelHelper.collab((String)"Pilots")) + "`]-(g1)-[f:`" + String.valueOf(GenericModelHelper.collab((String)"Fixed_Onto")) + "`*]->(g2) return path");
        } else {
            query.setQuery("match path = (iot { modelNodeId : '" + Neo4JId.createIdUsingCollaboration((String)iotEv.getIotId(), (String)collaborationName, (String)knowledgeSpaceName) + "'})-[f:`" + String.valueOf(GenericModelHelper.collab((String)"Fixed_Onto")) + "`*]->(g2) return path");
        }
        query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
        GJaxbQueryResponse queryResponse = this.coreClient.query(query);
        GJaxbPointType positionFound = new GJaxbPointType();
        ArrayList<GJaxbNode> impactedAssets = new ArrayList<GJaxbNode>();
        if (queryResponse.isSetSingle() && queryResponse.getSingle().isSetGenericModel() && queryResponse.getSingle().getGenericModel().isSetNode() && !queryResponse.getSingle().getGenericModel().getNode().isEmpty()) {
            contextualData.append(this.createContextualDataAndFoundPosition(iotEv.getIotId(), queryResponse.getSingle().getGenericModel(), positionFound, impactedAssets));
            iotEv.setFunctionToPlay("Photo Identication " + String.valueOf(contextualData));
        } else if (queryResponse.isSetMultiple() && queryResponse.getMultiple().isSetGenericModel() && !queryResponse.getMultiple().getGenericModel().isEmpty()) {
            GJaxbGenericModel mergeModel = new GJaxbGenericModel();
            for (GJaxbGenericModel model : queryResponse.getMultiple().getGenericModel()) {
                mergeModel.getNode().addAll(model.getNode());
                mergeModel.getEdge().addAll(model.getEdge());
            }
            GenericModelHelper.deleteDuplicateNodes((List)mergeModel.getNode());
            GenericModelHelper.deleteDuplicateEdges((List)mergeModel.getEdge());
            contextualData.append(this.createContextualDataAndFoundPosition(iotEv.getIotId(), mergeModel, positionFound, impactedAssets));
            iotEv.setFunctionToPlay(GenericModelHelper.getName((GJaxbNode)nodeAdded) + ":  Photo Identication " + String.valueOf(contextualData));
        }
        SPIPredictModuleService predictor = new SPIPredictModuleService(this.context);
        ChatGPTPredictEngine chatEngine = (ChatGPTPredictEngine)predictor.getPredictModules().get(ChatGPTPredictEngine.class.getSimpleName());
        ArrayList<GJaxbProperty> properties = new ArrayList<GJaxbProperty>();
        ArrayList textsTable = new ArrayList();
        ArrayList<GJaxbProperty> textRow = new ArrayList<GJaxbProperty>();
        textsTable.add(textRow);
        textRow.add(GenericModelHelper.createProperty((String)"text", (String)GenericModelHelper.getName((GJaxbNode)nodeAdded)));
        properties.add(GenericModelHelper.createProperty((String)"texts", (String)GenericModelHelper.convertTableToJSONArray(textsTable).toString()));
        ArrayList imagesTable = new ArrayList();
        ArrayList<GJaxbProperty> imageRow = new ArrayList<GJaxbProperty>();
        imagesTable.add(imageRow);
        imageRow.add(GenericModelHelper.createProperty((String)"imageUrl", (String)dataEncodedBase64));
        properties.add(GenericModelHelper.createProperty((String)"images", (String)GenericModelHelper.convertTableToJSONArray(imagesTable).toString()));
        properties.add(GenericModelHelper.createProperty((String)"parentActualityId", (String)nodeAdded.getId()));
        properties.add(GenericModelHelper.createProperty((String)"parentActuality", (String)JSONJAXBContext.getInstance().marshallAnyElement((Object)nodeAdded)));
        iotEv.setPredict(new GJaxbReflexEvent.Iot.Predict());
        iotEv.getPredict().getProperty().addAll(properties);
        GJaxbPointType position = null;
        if (positionFound.isSetLatitude() && positionFound.isSetLongitude()) {
            position = positionFound;
            iotEv.getPredict().setPoint(position);
        }
        GJaxbPredictResponse predictResp = chatEngine.predictUsingProperties(properties, new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString(), collaborationName, knowledgeSpaceName, UUID.randomUUID().toString(), position, contextualData.toString(), impactedAssets);
        iotEv.getPredict().setLastResult(new GJaxbReflexEvent.Iot.Predict.LastResult());
        if (predictResp != null && predictResp.getPredictOutputs() != null) {
            if (predictResp.getPredictOutputs().isSetNonePredictionResult()) {
                iotEv.getPredict().getLastResult().setNonePredictionResult(predictResp.getPredictOutputs().getNonePredictionResult());
            } else {
                iotEv.getPredict().getLastResult().setGenericModel(predictResp.getPredictOutputs().getGenericModel());
                GJaxbPublishSyncModel pushReq = new GJaxbPublishSyncModel();
                pushReq.setGenericModel(predictResp.getPredictOutputs().getGenericModel());
                pushReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                pushReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                pushReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                pushReq.setPublishOptions(new GJaxbPublishOptions());
                pushReq.getPublishOptions().setNotification(new GJaxbNotification());
                pushReq.getPublishOptions().getNotification().setActivateNotification(true);
                pushReq.getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
                pushReq.getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
                this.modelsClient.publishSyncModel(pushReq);
                GJaxbGenericModel modelToDelete = new GJaxbGenericModel();
                modelToDelete.getNode().add(nodeAdded);
                GJaxbUnpublishSyncModel unpushReq = new GJaxbUnpublishSyncModel();
                unpushReq.setGenericModel(modelToDelete);
                unpushReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                unpushReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                unpushReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                unpushReq.setPublishOptions(new GJaxbPublishOptions());
                unpushReq.getPublishOptions().setNotification(new GJaxbNotification());
                unpushReq.getPublishOptions().getNotification().setActivateNotification(true);
                unpushReq.getPublishOptions().setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
                unpushReq.getPublishOptions().getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
                this.modelsClient.unpublishSyncModel(unpushReq);
            }
        }
    }

    protected String createContextualDataAndFoundPosition(String iotId, GJaxbGenericModel genericModel, GJaxbPointType positionFound, List<GJaxbNode> impactedAssets) throws Exception {
        Object res = " knowing that the photo was taken from a ";
        GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{genericModel});
        GJaxbNode iot = man.getNodeById(iotId);
        Object iotType = null;
        if (EffectiveMetaModelPluginManager.getInstance().inherit(iot, GenericModelHelper.collab((String)"Good"))) {
            iotType = GenericModelHelper.findProperty((String)"type", (List)iot.getProperty(), (boolean)true).getValue().toLowerCase().replace("_", " ");
        } else {
            String type = GenericModelHelper.findProperty((String)"type", (List)iot.getProperty(), (boolean)true).getValue();
            String nature = GenericModelHelper.findProperty((String)"nature", (List)iot.getProperty(), (boolean)true).getValue();
            iotType = nature.toLowerCase() + " " + type.toLowerCase() + " sensor";
        }
        this.setPositionFromNode(positionFound, iot);
        res = (String)res + (String)iotType;
        List inputEdgesIot = man.findInputEdgesOfNode(iot);
        if (!inputEdgesIot.isEmpty()) {
            List pilots = GenericModelHelper.findEdgesByType((QName)GenericModelHelper.collab((String)"Pilots"), (List)inputEdgesIot);
            if (pilots != null && !pilots.isEmpty()) {
                GJaxbEdge pilot = (GJaxbEdge)pilots.get(0);
                GJaxbNode sensor = pilot.getSource();
                this.setPositionFromNode(positionFound, sensor);
                String natureSensor = GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).getValue().toLowerCase().replace("_", " ");
                res = (String)res + " piloted by " + natureSensor + " sensor";
                res = this.getFixedOntoContextOnSensor(impactedAssets, (String)res, man, sensor);
            }
        } else {
            res = this.getFixedOntoContextOnSensor(impactedAssets, (String)res, man, iot);
        }
        return res;
    }

    private String getFixedOntoContextOnSensor(List<GJaxbNode> impactedAssets, String res, GenericModelManager man, GJaxbNode sensor) {
        List outputEdgesSensor = man.findOutputEdgesOfNode(sensor);
        if (!outputEdgesSensor.isEmpty()) {
            List fixed_ontos = GenericModelHelper.findEdgesByType((QName)GenericModelHelper.collab((String)"Fixed_Onto"), (List)outputEdgesSensor);
            while (fixed_ontos != null && !fixed_ontos.isEmpty()) {
                GJaxbEdge fixed_onto = (GJaxbEdge)fixed_ontos.get(0);
                fixed_ontos = null;
                GJaxbNode goodOrTerritory = fixed_onto.getTarget();
                if (goodOrTerritory.getType().equals(GenericModelHelper.collab((String)"Territory"))) {
                    String type = GenericModelHelper.findProperty((String)"type", (List)goodOrTerritory.getProperty(), (boolean)true).getValue().toLowerCase().replace("_", " ");
                    res = (String)res + " fixed onto the " + type + " '" + GenericModelHelper.getName((GJaxbNode)goodOrTerritory) + "'";
                } else {
                    res = (String)res + " fixed onto '" + GenericModelHelper.getName((GJaxbNode)goodOrTerritory) + "'";
                }
                String description = GenericModelHelper.findProperty((String)"description", (List)goodOrTerritory.getProperty(), (boolean)true).getValue();
                if (description != null && !description.isBlank()) {
                    res = (String)res + " (" + description + ")";
                }
                impactedAssets.add(goodOrTerritory);
                List outputEdgesGood = man.findOutputEdgesOfNode(goodOrTerritory);
                if (outputEdgesGood.isEmpty()) continue;
                fixed_ontos = GenericModelHelper.findEdgesByType((QName)GenericModelHelper.collab((String)"Fixed_Onto"), (List)outputEdgesGood);
            }
        }
        return res;
    }

    private void setPositionFromNode(GJaxbPointType positionFound, GJaxbNode sensor) throws Exception {
        if (sensor.isSetGeolocation() && sensor.getGeolocation().isSetItemView() && !sensor.getGeolocation().getItemView().isEmpty()) {
            GJaxbNode.Geolocation.ItemView iv = (GJaxbNode.Geolocation.ItemView)sensor.getGeolocation().getItemView().get(0);
            if (iv.isSetPoint()) {
                positionFound.setLatitude(iv.getPoint().getLatitude());
                positionFound.setLongitude(iv.getPoint().getLongitude());
            } else if (iv.isSetArea()) {
                List polygons = GeometryHelper.getInstance().extractGeometryFromGJaxbNode(sensor);
                if (!polygons.isEmpty()) {
                    Polygon polygon = (Polygon)polygons.get(0);
                    Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                    positionFound.setLatitude(Double.valueOf(randomPoint.getY()));
                    positionFound.setLongitude(Double.valueOf(randomPoint.getX()));
                }
            } else if (iv.isSetPredefinedShape()) {
                if (iv.getPredefinedShape().isSetCircle()) {
                    positionFound.setLatitude(iv.getPredefinedShape().getCircle().getCenter().getLatitude());
                    positionFound.setLongitude(iv.getPredefinedShape().getCircle().getCenter().getLongitude());
                } else if (iv.getPredefinedShape().isSetRect()) {
                    positionFound.setLatitude(iv.getPredefinedShape().getRect().getCenter().getLatitude());
                    positionFound.setLongitude(iv.getPredefinedShape().getRect().getCenter().getLongitude());
                }
            } else if (iv.isSetPolyline()) {
                positionFound.setLatitude(((GJaxbPointType)iv.getPolyline().getPoint().get(0)).getLatitude());
                positionFound.setLongitude(((GJaxbPointType)iv.getPolyline().getPoint().get(0)).getLongitude());
            }
        }
    }

    public static void cleanNode(GJaxbNode nodeInModel) {
        if (nodeInModel.isSetGeolocation() && nodeInModel.getGeolocation().getItemView().isEmpty()) {
            nodeInModel.setGeolocation(null);
        }
    }

    private void removeEdgeEvent(GJaxbEdge edge, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        if (this.conceptInterpretors.get(edge.getType()) != null && this.conceptInterpretors.get(edge.getType()).isAbleToInterpret((AbstractJaxbObject)edge)) {
            this.conceptInterpretors.get(edge.getType()).removeEdge(edge, collaborationName, knowledgeSpaceName, eventContext);
        } else {
            this.defaultInterpretor.removeEdge(edge, collaborationName, knowledgeSpaceName, eventContext);
        }
    }

    private void updateEdgeEvent(GJaxbEdge edge, String sourceNodeId, String targetNodeId, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        if (this.conceptInterpretors.get(edge.getType()) != null && this.conceptInterpretors.get(edge.getType()).isAbleToInterpret((AbstractJaxbObject)edge)) {
            this.conceptInterpretors.get(edge.getType()).updateEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
        } else {
            this.defaultInterpretor.updateEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
        }
    }

    private void addEdgeEvent(GJaxbEdge edge, String sourceNodeId, String targetNodeId, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbEdge existingEdge = this.alreadyExist(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName);
        if (existingEdge == null) {
            if (edge.getId() == null || edge.getId().isEmpty()) {
                edge.setId("ie_edge_" + String.valueOf(UUID.randomUUID()));
            }
            if (this.conceptInterpretors.get(edge.getType()) != null && this.conceptInterpretors.get(edge.getType()).isAbleToInterpret((AbstractJaxbObject)edge)) {
                this.conceptInterpretors.get(edge.getType()).addEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
            } else {
                this.defaultInterpretor.addEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
            }
        } else {
            edge.setId(existingEdge.getId());
            if (this.conceptInterpretors.get(edge.getType()) != null && this.conceptInterpretors.get(edge.getType()).isAbleToInterpret((AbstractJaxbObject)edge)) {
                this.conceptInterpretors.get(edge.getType()).updateEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
            } else {
                this.defaultInterpretor.updateEdge(edge, sourceNodeId, targetNodeId, collaborationName, knowledgeSpaceName, eventContext);
            }
        }
    }

    private void removeNodeEvent(GJaxbNode node, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbNode existingNode = this.alreadyExist(node, collaborationName, knowledgeSpaceName);
        LOG.debug("find existing node: " + String.valueOf(existingNode));
        if (existingNode != null) {
            node.setId(existingNode.getId());
        }
        if (this.conceptInterpretors.get(node.getType()) != null && this.conceptInterpretors.get(node.getType()).isAbleToInterpret((AbstractJaxbObject)node)) {
            this.conceptInterpretors.get(node.getType()).removeNode(node, collaborationName, knowledgeSpaceName, eventContext);
        } else {
            this.defaultInterpretor.removeNode(node, collaborationName, knowledgeSpaceName, eventContext);
        }
    }

    private void updateNodeEvent(GJaxbNode node, String parentNodeId, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbNode existingNode = this.alreadyExist(node, collaborationName, knowledgeSpaceName);
        LOG.debug("find existing node: " + String.valueOf(existingNode));
        if (existingNode != null) {
            node.setId(existingNode.getId());
        }
        if (node.getStatus().isEmpty()) {
            node.getStatus().add(GJaxbStatusType.ACTIVE);
        }
        if (this.conceptInterpretors.get(node.getType()) != null && this.conceptInterpretors.get(node.getType()).isAbleToInterpret((AbstractJaxbObject)node)) {
            this.conceptInterpretors.get(node.getType()).updateNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            LOG.debug("node updated with specific interpret");
        } else {
            this.defaultInterpretor.updateNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            LOG.debug("node updated with generic interpret");
        }
    }

    private void addNodeEvent(GJaxbNode node, String parentNodeId, String collaborationName, String knowledgeSpaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbNode existingNode = this.alreadyExist(node, collaborationName, knowledgeSpaceName);
        if (existingNode == null) {
            if (node.getId() == null || node.getId().isEmpty()) {
                node.setId("ie_node_" + String.valueOf(UUID.randomUUID()));
            }
            if (node.getStatus().isEmpty()) {
                node.getStatus().add(GJaxbStatusType.ACTIVE);
            }
            if (this.conceptInterpretors.get(node.getType()) != null && this.conceptInterpretors.get(node.getType()).isAbleToInterpret((AbstractJaxbObject)node)) {
                this.conceptInterpretors.get(node.getType()).addNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            } else {
                this.defaultInterpretor.addNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            }
        } else {
            node.setId(existingNode.getId());
            if (this.conceptInterpretors.get(node.getType()) != null && this.conceptInterpretors.get(node.getType()).isAbleToInterpret((AbstractJaxbObject)node)) {
                this.conceptInterpretors.get(node.getType()).updateNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            } else {
                this.defaultInterpretor.updateNode(node, parentNodeId, collaborationName, knowledgeSpaceName, eventContext);
            }
        }
        this.addReflexActions(node, eventContext, collaborationName, knowledgeSpaceName);
    }

    private GJaxbNode alreadyExist(GJaxbNode node, String collaborationName, String knownledgeName) throws Exception {
        if (node.getId() != null && node.getId().trim().length() > 0) {
            return node;
        }
        GJaxbQuery request = new GJaxbQuery();
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knownledgeName);
        request.setQuery("match (n:ACTIVE {type: '" + String.valueOf(node.getType()) + "', property_name: '" + GenericModelHelper.getName((GJaxbNode)node) + "'}) return n");
        GJaxbQueryResponse response = this.coreClient.query(request);
        if (response.getSingle() != null && response.getSingle().getGenericModel() != null) {
            GJaxbGenericModel model = response.getSingle().getGenericModel();
            for (GJaxbNode nodeInBdd : model.getNode()) {
                if (nodeInBdd.getGeolocation() != null && node.getGeolocation() != null && !nodeInBdd.getGeolocation().getItemView().isEmpty() && !node.getGeolocation().getItemView().isEmpty()) {
                    GJaxbPointType point2;
                    boolean found;
                    int indice;
                    List points2;
                    List points1;
                    GJaxbPointType point22;
                    GJaxbPointType point1;
                    if (((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPoint() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint() != null) {
                        point1 = ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPoint();
                        point22 = ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint();
                        if (point1.getLatitude() != point22.getLatitude() || point1.getLongitude() != point22.getLongitude() || point1.getAltitude() != point22.getAltitude()) continue;
                        return nodeInBdd;
                    }
                    if (((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape() != null && ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle() != null) {
                        point1 = ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle();
                        point22 = ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getCircle();
                        if (point1.getCenter().getLatitude() != point22.getCenter().getLatitude() || point1.getCenter().getLongitude() != point22.getCenter().getLongitude() || point1.getCenter().getAltitude() != point22.getCenter().getAltitude()) continue;
                        return nodeInBdd;
                    }
                    if (((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape() != null && ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape().getRect() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getRect() != null) {
                        point1 = ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPredefinedShape().getRect();
                        point22 = ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPredefinedShape().getRect();
                        if (point1.getCenter().getLatitude() != point22.getCenter().getLatitude() || point1.getCenter().getLongitude() != point22.getCenter().getLongitude() || point1.getCenter().getAltitude() != point22.getCenter().getAltitude()) continue;
                        return nodeInBdd;
                    }
                    if (((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPolyline() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPolyline() != null) {
                        points1 = ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getPolyline().getPoint();
                        points2 = ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPolyline().getPoint();
                        indice = 0;
                        found = true;
                        for (GJaxbPointType point12 : points1) {
                            point2 = (GJaxbPointType)points2.get(indice);
                            if (point12.getLatitude() != point2.getLatitude() || point12.getLongitude() != point2.getLongitude() || point12.getAltitude() != point2.getAltitude()) {
                                found = false;
                            }
                            ++indice;
                        }
                        if (!found) continue;
                        return nodeInBdd;
                    }
                    if (((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getArea() != null && ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getArea() != null) {
                        points1 = ((GJaxbNode.Geolocation.ItemView)nodeInBdd.getGeolocation().getItemView().get(0)).getArea().getPoint();
                        points2 = ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getArea().getPoint();
                        indice = 0;
                        found = true;
                        for (GJaxbPointType point12 : points1) {
                            point2 = (GJaxbPointType)points2.get(indice);
                            if (point12.getLatitude() != point2.getLatitude() || point12.getLongitude() != point2.getLongitude() || point12.getAltitude() != point2.getAltitude()) {
                                found = false;
                            }
                            ++indice;
                        }
                        if (!found) continue;
                        return nodeInBdd;
                    }
                    return nodeInBdd;
                }
                return nodeInBdd;
            }
        }
        return null;
    }

    private GJaxbEdge alreadyExist(GJaxbEdge edge, String sourceNodeId, String targetNodeId, String collaborationName, String knownledgeName) throws Exception {
        GJaxbQuery request = new GJaxbQuery();
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knownledgeName);
        request.setQuery("match (e {type: '" + String.valueOf(edge.getType()) + "', source: '" + sourceNodeId + "', target : '" + targetNodeId + "' }) return e");
        GJaxbQueryResponse response = this.coreClient.query(request);
        if (response.getSingle() != null && response.getSingle().getGenericModel() != null) {
            GJaxbGenericModel model = response.getSingle().getGenericModel();
            if (model.getEdge().size() > 1) {
                throw new Exception("Several existing edges found!!!");
            }
            return (GJaxbEdge)model.getEdge().get(0);
        }
        return null;
    }
}

