/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine.interpretor;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core_gov.GJaxbAddEdge;
import fr.emac.gind.gov.core_gov.GJaxbAddNode;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.gov.core_gov.GJaxbRemoveEdge;
import fr.emac.gind.gov.core_gov.GJaxbRemoveNode;
import fr.emac.gind.gov.core_gov.GJaxbUpdateEdge;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNode;
import fr.emac.gind.io.interpretation.engine.interpretor.AbstractConceptInterpretor;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import fr.emac.gind.sharedOptions.GJaxbNotification;
import fr.emac.gind.sharedOptions.GJaxbPreAndPostTreatment;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.json.JSONArray;

public class DefaultInterpretor
extends AbstractConceptInterpretor {
    @Override
    public QName getConcept() {
        return null;
    }

    @Override
    public void addNode(GJaxbNode node, String parentNodeId, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbAddNode request = new GJaxbAddNode();
        request.setNode(node);
        GenericModelHelper.setName((GJaxbNode)node, (String)URLDecoder.decode(GenericModelHelper.getName((GJaxbNode)node), "UTF-8"));
        this.refreshGeoloc(node, collaborationName, knowledgespaceName);
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        if (eventContext.get(new QName("http://fr.emac.gind", "label")) != null) {
            request.getLabel().addAll(Arrays.asList(eventContext.get(new QName("http://fr.emac.gind", "label")).replace("[", "").replace("]", "").replace(" ", "").split(",")));
        }
        this.getCoreClient().addNode(request);
    }

    @Override
    public void updateNode(GJaxbNode node, String parentNodeId, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbUpdateNode request = new GJaxbUpdateNode();
        request.setNode(node);
        GenericModelHelper.setName((GJaxbNode)node, (String)URLDecoder.decode(GenericModelHelper.getName((GJaxbNode)node), "UTF-8"));
        this.refreshGeoloc(node, collaborationName, knowledgespaceName);
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setCreateIfNotExist(true);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        if (eventContext.get(new QName("http://fr.emac.gind", "label")) != null) {
            request.getLabel().addAll(Arrays.asList(eventContext.get(new QName("http://fr.emac.gind", "label")).replace("[", "").replace("]", "").replace(" ", "").split(",")));
        }
        this.getCoreClient().updateNode(request);
    }

    @Override
    public void removeNode(GJaxbNode node, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbRemoveNode request = new GJaxbRemoveNode();
        request.setId(node.getId());
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        this.getCoreClient().removeNode(request);
    }

    @Override
    public void addEdge(GJaxbEdge edge, String sourceNodeId, String targetNodeId, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbAddEdge request = new GJaxbAddEdge();
        request.setEdge(edge);
        request.setSourceNodeId(sourceNodeId);
        request.setTargetNodeId(targetNodeId);
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        this.getCoreClient().addEdge(request);
    }

    @Override
    public void updateEdge(GJaxbEdge edge, String sourceNodeId, String targetNodeId, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbUpdateEdge request = new GJaxbUpdateEdge();
        request.setEdge(edge);
        request.setSourceNodeId(sourceNodeId);
        request.setTargetNodeId(targetNodeId);
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        this.getCoreClient().updateEdge(request);
    }

    @Override
    public void removeEdge(GJaxbEdge edge, String collaborationName, String knowledgespaceName, Map<QName, String> eventContext) throws Exception {
        GJaxbRemoveEdge request = new GJaxbRemoveEdge();
        request.setId(edge.getId());
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
        request.setNotification(new GJaxbNotification());
        request.getNotification().setActivateNotification(true);
        request.setPreAndPostTreatment(new GJaxbPreAndPostTreatment());
        request.getPreAndPostTreatment().setActivatePreAndPostTreatment(true);
        this.getCoreClient().removeEdge(request);
    }

    private void refreshGeoloc(GJaxbNode node, String collaborationName, String knowledgespaceName) throws Exception {
        List refProps;
        GJaxbProperty sensorId;
        GJaxbProperty ref;
        List inferByProps;
        GJaxbProperty inferBy = GenericModelHelper.findProperty((String)"infer by", (List)node.getProperty());
        if (!(inferBy == null || inferBy.getValue() == null || inferBy.getValue().isBlank() || (inferByProps = GenericModelHelper.convertJSONArrayToTable((JSONArray)new JSONArray(inferBy.getValue()))).isEmpty() || (ref = GenericModelHelper.findProperty((String)"ref", (List)((List)inferByProps.get(0)))) == null || ref.getValue() == null || ref.getValue().isBlank() || (sensorId = GenericModelHelper.findProperty((String)"datasource_id", (List)((List)(refProps = GenericModelHelper.convertJSONArrayToTable((JSONArray)new JSONArray(ref.getValue()))).get(0)))) == null || sensorId.getValue() == null || sensorId.getValue().isBlank())) {
            GJaxbQuery query = new GJaxbQuery();
            query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgespaceName);
            query.setQuery("match (s:`{http://fr.emac.gind/core-model}Sensor` { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)sensorId.getValue(), (String)collaborationName, (String)knowledgespaceName) + "' }) optional match (s:`{http://fr.emac.gind/core-model}Sensor` { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)sensorId.getValue(), (String)collaborationName, (String)knowledgespaceName) + "' })-[`{http://fr.emac.gind/collaborative-model}Fixed_Onto`]->(g:`{http://fr.emac.gind/collaborative-model}Good`) optional match (s:`{http://fr.emac.gind/core-model}Sensor` { modelNodeId: '" + Neo4JId.createIdUsingCollaboration((String)sensorId.getValue(), (String)collaborationName, (String)knowledgespaceName) + "' })-[`{http://fr.emac.gind/collaborative-model}Fixed_Onto`]->(g:`{http://fr.emac.gind/collaborative-model}Good`)-[`{http://fr.emac.gind/collaborative-model}Fixed_Onto`]->(p:`{http://fr.emac.gind/collaborative-model}Person`) return distinct s, g, p");
            GJaxbQueryResponse queryResponse = this.getCoreClient().query(query);
            if (queryResponse.getSingle() != null && queryResponse.getSingle().getGenericModel() != null) {
                GJaxbGenericModel model = queryResponse.getSingle().getGenericModel();
                GJaxbPointType geolocPoint = null;
                block0: for (QName type : Arrays.asList(GenericModelHelper.collab((String)"Person"), GenericModelHelper.collab((String)"Good"), GenericModelHelper.core((String)"Sensor"))) {
                    List typeNodes = GenericModelHelper.findNodesByType((QName)type, (List)model.getNode());
                    if (typeNodes == null || typeNodes.isEmpty()) continue;
                    for (GJaxbNode typeNode : typeNodes) {
                        if (!typeNode.isSetGeolocation() || !typeNode.getGeolocation().isSetItemView() || typeNode.getGeolocation().getItemView().isEmpty()) continue;
                        GJaxbNode.Geolocation.ItemView iv = (GJaxbNode.Geolocation.ItemView)typeNode.getGeolocation().getItemView().get(0);
                        if (iv.isSetPoint() && iv.getPoint().isSetLatitude() && iv.getPoint().isSetLongitude()) {
                            geolocPoint = iv.getPoint();
                            break block0;
                        }
                        if (iv.isSetArea()) {
                            List polygons = GeometryHelper.getInstance().extractGeometryFromGJaxbNode(typeNode);
                            if (polygons.isEmpty()) continue;
                            Polygon polygon = (Polygon)GeometryHelper.getInstance().extractGeometryFromGJaxbNode(typeNode).get(0);
                            Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                            geolocPoint = new GJaxbPointType();
                            geolocPoint.setLatitude(Double.valueOf(randomPoint.getY()));
                            geolocPoint.setLongitude(Double.valueOf(randomPoint.getX()));
                            break block0;
                        }
                        if (iv.isSetPredefinedShape()) {
                            if (iv.getPredefinedShape().isSetCircle() && iv.getPredefinedShape().getCircle().isSetCenter() && iv.getPredefinedShape().getCircle().getCenter().isSetLatitude() && iv.getPredefinedShape().getCircle().getCenter().isSetLongitude()) {
                                geolocPoint = iv.getPredefinedShape().getCircle().getCenter();
                                break block0;
                            }
                            if (!iv.getPredefinedShape().isSetRect() || !iv.getPredefinedShape().getRect().isSetCenter() || !iv.getPredefinedShape().getRect().getCenter().isSetLatitude() || !iv.getPredefinedShape().getRect().getCenter().isSetLongitude()) continue;
                            geolocPoint = iv.getPredefinedShape().getRect().getCenter();
                            break block0;
                        }
                        if (!iv.isSetPolyline()) continue;
                        geolocPoint = (GJaxbPointType)iv.getPolyline().getPoint().get(0);
                    }
                }
                if (geolocPoint != null) {
                    GJaxbNode.Geolocation.ItemView ivNode = null;
                    if (!node.isSetGeolocation()) {
                        node.setGeolocation(new GJaxbNode.Geolocation());
                    }
                    if (node.getGeolocation().getItemView().isEmpty()) {
                        ivNode = new GJaxbNode.Geolocation.ItemView();
                        ivNode.setPoint(new GJaxbPointType());
                        node.getGeolocation().getItemView().add(ivNode);
                    } else {
                        ivNode = (GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0);
                        if (!ivNode.isSetPoint()) {
                            ivNode.setPoint(new GJaxbPointType());
                        }
                    }
                    ivNode.getPoint().setLongitude(geolocPoint.getLongitude());
                    ivNode.getPoint().setLatitude(geolocPoint.getLatitude());
                }
            }
        }
    }
}

