/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.module.predict;

import fr.emac.gind.commons.utils.io.UploadUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.event.interpretation.predict.SPIAbstractPredictModule;
import fr.emac.gind.gov.ai.chatbot.client.AIChatbotClient;
import fr.emac.gind.gov.ai.chatbot.service.builder.model.openai.OpenAiChatModelBuilder;
import fr.emac.gind.gov.ai.chatbot.service.util.PhotosHelper;
import fr.emac.gind.gov.ai_chatbot.AiChatbot;
import fr.emac.gind.gov.ai_chatbot.GJaxbAiChatBotType;
import fr.emac.gind.gov.ai_chatbot.GJaxbContext;
import fr.emac.gind.gov.ai_chatbot.GJaxbPictureInput;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPictures;
import fr.emac.gind.gov.ai_chatbot.GJaxbQueryOnPicturesResponse;
import fr.emac.gind.gov.ai_chatbot.GJaxbSemanticMethodType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarAnalysisType;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevel;
import fr.emac.gind.gov.ai_chatbot.GJaxbSimilarityLevelResponse;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.interpretationconfigs.PredictFault;
import fr.emac.gind.json_connector.GJaxbMediaType;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.json_connector.GJaxbSensorNatureSocialType;
import fr.emac.gind.json_connector.GJaxbSensorType;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.message.GJaxbMessageObject;
import fr.emac.gind.message.GJaxbMsgMediaObject;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictOutputs;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.tweet.GJaxbMediaObject;
import fr.emac.gind.tweet.GJaxbTweetObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChatGPTPredictEngine
extends SPIAbstractPredictModule {
    private static Logger LOG = LoggerFactory.getLogger(ChatGPTPredictEngine.class);
    private AiChatbot aiChatBot = null;
    private CoreGov coreClient = null;
    private Map<String, Object> context = null;
    private static List<String> EVENT_CACHE = new ArrayList<String>();

    public String getName() {
        return ChatGPTPredictEngine.class.getSimpleName();
    }

    public void init(Map<String, Object> context) throws Exception {
        this.context = context;
        this.aiChatBot = AIChatbotClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovAIChatbot"));
        this.coreClient = CoreGovClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovCore"));
    }

    public GJaxbPredictResponse predict(GJaxbPredict parameters) throws PredictFault {
        GJaxbPredictResponse resp = null;
        try {
            List impactedAssets = null;
            if (parameters.isSetImpactedAssets() && parameters.getImpactedAssets().isSetNode() && !parameters.getImpactedAssets().getNode().isEmpty()) {
                impactedAssets = parameters.getImpactedAssets().getNode();
            }
            if (parameters.getPredictInputs().isSetDocument()) {
                Document doc = DOMUtil.getInstance().createDocumentFromElement((Element)parameters.getPredictInputs().getDocument().getAny());
                resp = this.predictUsingDocument(doc, parameters.getResourcesFolderBaseDir(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName(), parameters.getContextualData(), impactedAssets);
            } else {
                resp = this.predictUsingProperties(parameters.getPredictInputs().getProperty(), parameters.getResourcesFolderBaseDir(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName(), null, parameters.getPoint(), parameters.getContextualData(), impactedAssets);
            }
        }
        catch (Exception e) {
            throw new PredictFault(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    public GJaxbPredictResponse predictUsingDocument(Document doc, String resourcesFolderBaseDir, String collaborationName, String knowledgeSpaceName, String contextualData, List<GJaxbNode> impactedAssets) throws PredictFault {
        GJaxbPredictResponse resp = null;
        try {
            QName eventQName = new QName(doc.getDocumentElement().getNamespaceURI(), doc.getDocumentElement().getLocalName());
            if (eventQName.equals(new QName("http://www.gind.emac.fr/json_connector", "sensorEvent"))) {
                GJaxbSensorEvent event = (GJaxbSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbSensorEvent.class);
                if (GJaxbSensorType.SOCIAL.equals((Object)event.getSensorType())) {
                    if (GJaxbSensorNatureSocialType.TWITTER.equals((Object)event.getSensorNature().getSocialNature())) {
                        GJaxbTweetObject tweet = event.getData().getSocial().getValue().getTweet();
                        GJaxbPointType point = null;
                        if (tweet != null) {
                            ArrayList<GJaxbProperty> properties = new ArrayList<GJaxbProperty>();
                            if (!tweet.getText().isBlank()) {
                                List<List> textsTable = Arrays.asList(Arrays.asList(GenericModelHelper.createProperty((String)"text", (String)tweet.getText())));
                                GJaxbProperty texts = GenericModelHelper.createProperty((String)"texts", (String)GenericModelHelper.convertTableToJSONArray(textsTable).toString());
                                properties.add(texts);
                            }
                            if (tweet.getExtendedEntities() != null && !tweet.getExtendedEntities().getMedia().isEmpty()) {
                                ArrayList<List<GJaxbProperty>> picturesTable = new ArrayList<List<GJaxbProperty>>();
                                for (GJaxbMediaObject media : tweet.getExtendedEntities().getMedia()) {
                                    if (!media.getType().equals("photo")) continue;
                                    picturesTable.add(Arrays.asList(GenericModelHelper.createProperty((String)"imageUrl", (String)media.getMediaUrl())));
                                }
                                GJaxbProperty pictures = GenericModelHelper.createProperty((String)"images", (String)GenericModelHelper.convertTableToJSONArray(picturesTable).toString());
                                properties.add(pictures);
                            }
                            if (event.getPosition() != null) {
                                point = new GJaxbPointType();
                                point.setLatitude(Double.valueOf(event.getPosition().getPoint().getLatitude()));
                                point.setLongitude(Double.valueOf(event.getPosition().getPoint().getLongitude()));
                            }
                            resp = this.predictUsingProperties(properties, resourcesFolderBaseDir, collaborationName, knowledgeSpaceName, event.getEventId(), point, contextualData, impactedAssets);
                        }
                    } else if (GJaxbSensorNatureSocialType.MESSAGING.equals((Object)event.getSensorNature().getSocialNature())) {
                        GJaxbMessageObject message = event.getData().getSocial().getValue().getMessage();
                        resp = this.predictMessage(resourcesFolderBaseDir, collaborationName, knowledgeSpaceName, resp, event, message, contextualData, impactedAssets);
                    } else {
                        LOG.warn("Not implemented !!!");
                    }
                } else if (GJaxbSensorType.MEDIA.equals((Object)event.getSensorType())) {
                    if (event.getData().getMedia().getValue().getType().equals((Object)GJaxbMediaType.PICTURE)) {
                        GJaxbMessageObject message = event.getData().getMedia().getValue().getMessage();
                        resp = this.predictMessage(resourcesFolderBaseDir, collaborationName, knowledgeSpaceName, resp, event, message, contextualData, impactedAssets);
                    } else {
                        LOG.warn("Not implemented !!!");
                    }
                } else {
                    LOG.warn("Not implemented !!!");
                }
            } else {
                LOG.warn("Not implemented !!!");
            }
        }
        catch (Exception e) {
            throw new PredictFault(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    private GJaxbPredictResponse predictMessage(String resourcesFolderBaseDir, String collaborationName, String knowledgeSpaceName, GJaxbPredictResponse resp, GJaxbSensorEvent event, GJaxbMessageObject message, String contextualData, List<GJaxbNode> impactedAssets) throws PredictFault {
        GJaxbPointType point = null;
        if (message != null) {
            ArrayList<GJaxbProperty> properties = new ArrayList<GJaxbProperty>();
            if (!message.getText().isBlank()) {
                List<List> textsTable = Arrays.asList(Arrays.asList(GenericModelHelper.createProperty((String)"text", (String)message.getText())));
                GJaxbProperty texts = GenericModelHelper.createProperty((String)"texts", (String)GenericModelHelper.convertTableToJSONArray(textsTable).toString());
                properties.add(texts);
            }
            if (message.getMedia() != null && !message.getMedia().isEmpty()) {
                ArrayList<List<GJaxbProperty>> picturesTable = new ArrayList<List<GJaxbProperty>>();
                for (GJaxbMsgMediaObject media : message.getMedia()) {
                    if (!media.getType().equals("photo")) continue;
                    picturesTable.add(Arrays.asList(GenericModelHelper.createProperty((String)"imageUrl", (String)media.getUrl())));
                }
                GJaxbProperty pictures = GenericModelHelper.createProperty((String)"images", (String)GenericModelHelper.convertTableToJSONArray(picturesTable).toString());
                properties.add(pictures);
            }
            if (event.getPosition() != null && event.getPosition().getPoint() != null) {
                point = new GJaxbPointType();
                point.setLatitude(Double.valueOf(event.getPosition().getPoint().getLatitude()));
                point.setLongitude(Double.valueOf(event.getPosition().getPoint().getLongitude()));
            }
            resp = this.predictUsingProperties(properties, resourcesFolderBaseDir, collaborationName, knowledgeSpaceName, event.getEventId(), point, contextualData, impactedAssets);
        }
        return resp;
    }

    public GJaxbPredictResponse predictUsingProperties(List<GJaxbProperty> properties, String resourcesFolderBaseDir, String collaborationName, String knowledgeSpaceName, String eventId, GJaxbPointType point, String contextualData, List<GJaxbNode> impactedAssets) throws PredictFault {
        GJaxbPredictResponse resp = new GJaxbPredictResponse();
        try {
            LOG.debug("PREDICT ON EVENT: " + eventId);
            System.out.println("PREDICT ON EVENT: " + eventId);
            if (eventId == null || !EVENT_CACHE.contains(eventId)) {
                EVENT_CACHE.add(eventId);
                GJaxbContext context = new GJaxbContext();
                context.setSelectedAiChatBot(GJaxbAiChatBotType.CHAT_GPT);
                context.setChatGPTContext(new GJaxbContext.ChatGPTContext());
                GJaxbGenericModel model = new GJaxbGenericModel();
                resp.setPredictOutputs(new GJaxbPredictOutputs());
                resp.getPredictOutputs().setGenericModel(model);
                resp.getPredictOutputs().setContextualData(contextualData);
                GJaxbQueryOnPictures queryTextsAndPictures = new GJaxbQueryOnPictures();
                queryTextsAndPictures.setContext(context);
                GJaxbProperty texts = GenericModelHelper.findProperty((String)"texts", properties);
                ArrayList<String> imageUrls = new ArrayList<String>();
                GJaxbProperty images = GenericModelHelper.findProperty((String)"images", properties);
                if (images != null) {
                    List imagesTable = GenericModelHelper.convertJSONArrayToTable((JSONArray)new JSONArray(images.getValue()));
                    for (List imageRow : imagesTable) {
                        for (GJaxbProperty image : imageRow) {
                            imageUrls.add(image.getValue());
                            GJaxbPictureInput pi = new GJaxbPictureInput();
                            pi.setPictureId("picture_" + UUID.randomUUID().toString());
                            if (image.getValue().contains("/r-io")) {
                                Object queryPath = image.getValue().substring(image.getValue().lastIndexOf("resourcesFolder") + "resourcesFolder".length());
                                if (!image.getValue().contains(RegExpHelper.toRegexFriendlyName((String)collaborationName))) {
                                    queryPath = RegExpHelper.toRegexFriendlyName((String)collaborationName) + (String)queryPath;
                                }
                                String internalFileName = (resourcesFolderBaseDir + "/" + (String)queryPath).replace("//", "/").replace("\\", "/");
                                pi.setPictureDataEncodedBase64(ChatGPTPredictEngine.encodeImageToBase64(new File(internalFileName).toURI().toURL()));
                            } else if (image.getValue().startsWith("data:")) {
                                pi.setPictureDataEncodedBase64(image.getValue());
                            } else {
                                pi.setPictureDataEncodedBase64(ChatGPTPredictEngine.encodeImageToBase64(URI.create(image.getValue()).toURL()));
                            }
                            queryTextsAndPictures.getPictureInput().add(pi);
                        }
                    }
                }
                String userMessageEnding = " and if yes, identify them by specifying your certainty index (it is better to find a danger or risk with low precision than no danger or risk at all) (avoid doublon) ?";
                String systemMessage = "(The output must be a valid JSON object of the following form if you find nothing: { problems: [ { type: enum(\"risk\" or \"danger\"), name: \"name of the hazard or risk\", certainty_index: number (between 0 and 1), probability_that_risk_occurs: number (between 0 and 1 if type = risk), details: \"Explanation of why you think there is this danger or risk in the image\" } ], none_problem: \"Explanation of why there are no hazards or risks in the images (can be empty or null)\" } )";
                if (texts != null) {
                    List textsTable = GenericModelHelper.convertJSONArrayToTable((JSONArray)new JSONArray(texts.getValue()));
                    for (List textRow : textsTable) {
                        for (GJaxbProperty text : textRow) {
                            StringBuffer userMessage = new StringBuffer();
                            if (text.getValue() != null && !text.getValue().isBlank()) {
                                userMessage.append("Assuming the context is under high tension, do you detect if there is a danger and risks in this sentence: \"" + text.getValue() + "\"");
                                if (imageUrls.isEmpty()) {
                                    if (contextualData != null) {
                                        userMessage.append(" " + contextualData);
                                    }
                                    userMessage.append(userMessageEnding);
                                } else if (imageUrls.size() == 1) {
                                    userMessage.append(" but above all in the image attached to the request");
                                    if (contextualData != null) {
                                        userMessage.append(" " + contextualData);
                                    }
                                    userMessage.append(userMessageEnding);
                                } else if (imageUrls.size() > 1) {
                                    userMessage.append(" but above all in the " + imageUrls.size() + " images attached to the request");
                                    if (contextualData != null) {
                                        userMessage.append(" " + contextualData);
                                    }
                                    userMessage.append(userMessageEnding);
                                }
                            } else if (!imageUrls.isEmpty()) {
                                if (imageUrls.size() == 1) {
                                    userMessage.append("Assuming the context is under high tension, do you detect if there is a danger and risks in the image attached to the request");
                                    userMessage.append(" " + contextualData);
                                    userMessage.append(userMessageEnding);
                                } else if (imageUrls.size() > 1) {
                                    userMessage.append("Assuming the context is under high tension, do you detect if there is a danger and risks in the " + imageUrls.size() + " images attached to the request");
                                    userMessage.append(" " + contextualData);
                                    userMessage.append(userMessageEnding);
                                }
                            }
                            if (userMessage.isEmpty()) continue;
                            queryTextsAndPictures.getUserMessage().add(userMessage.toString());
                            System.out.println("userMessage: " + userMessage.toString());
                            LOG.debug("userMessage: " + userMessage.toString());
                            queryTextsAndPictures.setSystemMessage(systemMessage);
                        }
                    }
                } else {
                    StringBuffer userMessage = new StringBuffer();
                    if (!imageUrls.isEmpty()) {
                        if (imageUrls.size() == 1) {
                            userMessage.append("Assuming the context is under high tension, do you detect if there is a danger and risks in the image attached to the request");
                            userMessage.append(" " + contextualData);
                            userMessage.append(userMessageEnding);
                        } else if (imageUrls.size() > 1) {
                            userMessage.append("Assuming the context is under high tension, do you detect if there is a danger and risks in the " + imageUrls.size() + " images attached to the request");
                            userMessage.append(" " + contextualData);
                            userMessage.append(userMessageEnding);
                        }
                    }
                    if (!userMessage.isEmpty()) {
                        queryTextsAndPictures.setSystemMessage(systemMessage);
                        queryTextsAndPictures.getUserMessage().add(userMessage.toString());
                        System.out.println("userMessage: " + userMessage.toString());
                        LOG.debug("userMessage: " + userMessage.toString());
                    }
                }
                JSONArray textAnalysisTable = null;
                int cpt = 0;
                while (textAnalysisTable == null & !resp.getPredictOutputs().isSetNonePredictionResult() && cpt < 8) {
                    try {
                        Object noProblemObj;
                        System.out.println("systemMessage: " + systemMessage);
                        LOG.debug("systemMessage: " + systemMessage);
                        GJaxbQueryOnPicturesResponse textQueryResp = this.aiChatBot.queryOnPictures(queryTextsAndPictures);
                        System.out.println("JSON Response: \n" + textQueryResp.getResponse());
                        JSONObject jsonResponse = new JSONObject(textQueryResp.getResponse());
                        JSONArray problems = null;
                        if (jsonResponse.has("problems")) {
                            problems = jsonResponse.getJSONArray("problems");
                        }
                        String noProblem = null;
                        if (jsonResponse.has("none_problem") && (noProblemObj = jsonResponse.get("none_problem")) != null) {
                            noProblem = noProblemObj.toString();
                        }
                        if (problems != null && problems.length() > 0) {
                            textAnalysisTable = problems;
                            continue;
                        }
                        if (noProblem == null) continue;
                        resp.getPredictOutputs().setNonePredictionResult(noProblem);
                    }
                    catch (Exception e) {
                        LOG.warn(e.getMessage());
                        ++cpt;
                    }
                }
                GJaxbNode parentActuality = null;
                GJaxbProperty parentActualityIdProp = GenericModelHelper.findProperty((String)"parentActualityId", properties);
                if (parentActualityIdProp != null && parentActualityIdProp.getValue() != null && !parentActualityIdProp.getValue().isBlank()) {
                    String parentActualityId = parentActualityIdProp.getValue();
                    GJaxbGetNode reqNode = new GJaxbGetNode();
                    reqNode.setId(parentActualityId);
                    reqNode.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                    reqNode.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                    reqNode.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                    GJaxbGetNodeResponse respNode = this.coreClient.getNode(reqNode);
                    parentActuality = respNode.getNode();
                }
                GJaxbNode actuality = null;
                if (textAnalysisTable != null) {
                    List<GJaxbEdge> impactsEdges;
                    JSONObject textAnalysis;
                    int i;
                    for (i = 0; i < textAnalysisTable.length(); ++i) {
                        textAnalysis = textAnalysisTable.getJSONObject(i);
                        System.out.println("textAnalysis: \n" + String.valueOf(textAnalysis));
                        if (!textAnalysis.getString("type").toLowerCase().equals("danger")) continue;
                        actuality = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Actuality"));
                        actuality.getStatus().add(GJaxbStatusType.NOT_VALIDATED);
                        actuality.setModeling(new GJaxbNode.Modeling());
                        actuality.setBrokenEdges(new GJaxbNode.BrokenEdges());
                        GenericModelHelper.findProperty((String)"name", (List)actuality.getProperty(), (boolean)true).setValue(textAnalysis.getString("name"));
                        GenericModelHelper.findProperty((String)"description", (List)actuality.getProperty(), (boolean)true).setValue(textAnalysis.getString("details"));
                        actuality.setId("node_actuality_" + eventId + "_" + GenericModelHelper.findProperty((String)"name", (List)actuality.getProperty()).getValue().hashCode());
                        GenericModelHelper.findProperty((String)"type", (List)actuality.getProperty(), (boolean)true).setValue("Damage");
                        String actDamageUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/damage.png";
                        impactsEdges = this.addImpactsOnNode(actuality, impactedAssets);
                        if (!impactsEdges.isEmpty()) {
                            model.getEdge().addAll(impactsEdges);
                        }
                        actuality.setModeling(new GJaxbNode.Modeling());
                        GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
                        iv.setViewId("view_" + UUID.randomUUID().toString());
                        iv.setPackageName("Objectives");
                        iv.setPosition(new GJaxbPosition());
                        iv.getPosition().setX(0.0f);
                        iv.getPosition().setY(0.0f);
                        iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                        iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
                        iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(actDamageUrl);
                        actuality.getModeling().getItemView().add(iv);
                        actuality.setGeolocation(new GJaxbNode.Geolocation());
                        GJaxbNode.Geolocation.ItemView ivAct = new GJaxbNode.Geolocation.ItemView();
                        ivAct.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                        ivAct.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                        ivAct.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                        ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(actDamageUrl);
                        ivAct.setPoint(new GJaxbPointType());
                        if (point != null) {
                            ivAct.getPoint().setLatitude(point.getLatitude());
                            ivAct.getPoint().setLongitude(point.getLongitude());
                        }
                        actuality.getGeolocation().getItemView().add(ivAct);
                        if (!imageUrls.isEmpty()) {
                            if (!((String)imageUrls.get(0)).contains("/r-io")) {
                                InputStream imgInputStream = null;
                                Object fileName = null;
                                if (((String)imageUrls.get(0)).startsWith("data:")) {
                                    String extension = "";
                                    if (((String)imageUrls.get(0)).startsWith("data:image/jpeg")) {
                                        extension = ".jpeg";
                                    } else if (((String)imageUrls.get(0)).startsWith("data:image/jpg")) {
                                        extension = ".jpg";
                                    } else if (((String)imageUrls.get(0)).startsWith("data:image/png")) {
                                        extension = ".png";
                                    }
                                    fileName = "img_" + UUID.randomUUID().toString() + extension;
                                    imgInputStream = new ByteArrayInputStream(PhotosHelper.decodeImageFromBase64ToFile((String)((String)imageUrls.get(0))));
                                } else {
                                    URL inputUrl = URI.create((String)imageUrls.get(0)).toURL();
                                    fileName = inputUrl.getFile().substring(inputUrl.getFile().lastIndexOf("/"), inputUrl.getFile().length());
                                    imgInputStream = inputUrl.openStream();
                                }
                                JSONObject data = new JSONObject();
                                data.put("category", (Object)"node");
                                data.put("nodeId", (Object)actuality.getId());
                                String outputUrl = UploadUtil.upload((String)fileName, (InputStream)imgInputStream, (JSONObject)data, (String)collaborationName, (String)knowledgeSpaceName, (String)collaborationName, null);
                                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(outputUrl);
                                actuality.getModeling().getItemView().add(iv);
                                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(outputUrl);
                            } else {
                                iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl((String)imageUrls.get(0));
                                actuality.getModeling().getItemView().add(iv);
                                ivAct.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage((String)imageUrls.get(0));
                            }
                            if (imageUrls.size() > 1) {
                                ArrayList propsArray = new ArrayList();
                                for (int j = 1; j < imageUrls.size(); ++j) {
                                    ArrayList<GJaxbProperty> propsRow = new ArrayList<GJaxbProperty>();
                                    if (!((String)imageUrls.get(j)).contains("/r-io")) {
                                        InputStream imgInputStream = null;
                                        Object fileName = null;
                                        if (((String)imageUrls.get(j)).startsWith("data:")) {
                                            String extension = "";
                                            if (((String)imageUrls.get(j)).startsWith("data:image/jpeg")) {
                                                extension = ".jpeg";
                                            } else if (((String)imageUrls.get(j)).startsWith("data:image/jpg")) {
                                                extension = ".jpg";
                                            } else if (((String)imageUrls.get(j)).startsWith("data:image/png")) {
                                                extension = ".png";
                                            }
                                            fileName = "img_" + UUID.randomUUID().toString() + extension;
                                            imgInputStream = new ByteArrayInputStream(PhotosHelper.decodeImageFromBase64ToFile((String)((String)imageUrls.get(j))));
                                        } else {
                                            URL inputUrl = URI.create((String)imageUrls.get(j)).toURL();
                                            fileName = inputUrl.getFile().substring(inputUrl.getFile().lastIndexOf("/"), inputUrl.getFile().length());
                                            imgInputStream = inputUrl.openStream();
                                        }
                                        JSONObject data = new JSONObject();
                                        data.put("category", (Object)"node");
                                        data.put("nodeId", (Object)actuality.getId());
                                        String outputUrl = UploadUtil.upload((String)fileName, (InputStream)imgInputStream, (JSONObject)data, (String)collaborationName, (String)knowledgeSpaceName, (String)collaborationName, null);
                                        propsRow.add(GenericModelHelper.createProperty((String)"resource", (String)outputUrl));
                                    } else {
                                        propsRow.add(GenericModelHelper.createProperty((String)"resource", (String)((String)imageUrls.get(j))));
                                    }
                                    propsRow.add(GenericModelHelper.createProperty((String)"description", (String)("image " + j)));
                                    propsArray.add(propsRow);
                                }
                                GenericModelHelper.findProperty((String)"other resources", (List)actuality.getProperty(), (boolean)true).setValue(GenericModelHelper.convertTableToJSONArray(propsArray).toString());
                            }
                        }
                        model.getNode().add(actuality);
                        if (parentActuality != null) {
                            GJaxbEdge generated_by = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)actuality, (GJaxbNode)parentActuality, (QName)GenericModelHelper.collab((String)"Generated_By"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                            model.getNode().add(parentActuality);
                            model.getEdge().add(generated_by);
                        }
                        GJaxbNode objective = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Objective"));
                        objective.setId("node_objective_" + eventId + "_" + GenericModelHelper.findProperty((String)"name", (List)objective.getProperty()).getValue().hashCode());
                        objective.getStatus().add(GJaxbStatusType.NOT_VALIDATED);
                        objective.setBrokenEdges(new GJaxbNode.BrokenEdges());
                        GenericModelHelper.findProperty((String)"name", (List)objective.getProperty(), (boolean)true).setValue("Treat " + GenericModelHelper.findProperty((String)"name", (List)actuality.getProperty()).getValue());
                        this.addInferByOnConcept(objective, eventId);
                        this.addInferByOnConcept(actuality, eventId);
                        GJaxbEdge treats = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)objective, (GJaxbNode)actuality, (QName)GenericModelHelper.collab((String)"Treats"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                        treats.setId("treats_" + objective.getId());
                        model.getEdge().add(treats);
                        model.getNode().add(objective);
                    }
                    for (i = 0; i < textAnalysisTable.length(); ++i) {
                        textAnalysis = textAnalysisTable.getJSONObject(i);
                        if (!textAnalysis.getString("type").toLowerCase().equals("risk")) continue;
                        GJaxbNode risk = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Potentiality"));
                        risk.getStatus().add(GJaxbStatusType.NOT_VALIDATED);
                        risk.setBrokenEdges(new GJaxbNode.BrokenEdges());
                        GenericModelHelper.findProperty((String)"name", (List)risk.getProperty(), (boolean)true).setValue(textAnalysis.getString("name"));
                        GenericModelHelper.findProperty((String)"description", (List)risk.getProperty(), (boolean)true).setValue(textAnalysis.getString("details"));
                        risk.setId("node_risk_" + eventId + "_" + GenericModelHelper.findProperty((String)"name", (List)risk.getProperty()).getValue().hashCode());
                        GenericModelHelper.findProperty((String)"type", (List)risk.getProperty(), (boolean)true).setValue("Risk");
                        GenericModelHelper.findProperty((String)"probability", (List)risk.getProperty(), (boolean)true).setValue("{\"theoricValue\":{\"precise\":" + textAnalysis.get("probability_that_risk_occurs").toString() + "}}");
                        impactsEdges = this.addImpactsOnNode(risk, impactedAssets);
                        if (!impactsEdges.isEmpty()) {
                            model.getEdge().addAll(impactsEdges);
                        }
                        String potRiskUrl = "/##application_name##/webjars/gind/rio/collaborative_model/images/model/nodes/objectives/risk.png";
                        risk.setModeling(new GJaxbNode.Modeling());
                        GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
                        iv.setViewId("view_" + UUID.randomUUID().toString());
                        iv.setPackageName("Objectives");
                        iv.setPosition(new GJaxbPosition());
                        iv.getPosition().setX(0.0f);
                        iv.getPosition().setY(0.0f);
                        iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
                        iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
                        iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(48.0f);
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(48.0f);
                        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(potRiskUrl);
                        risk.getModeling().getItemView().add(iv);
                        risk.setGeolocation(new GJaxbNode.Geolocation());
                        GJaxbNode.Geolocation.ItemView ivRisk = new GJaxbNode.Geolocation.ItemView();
                        ivRisk.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
                        ivRisk.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
                        ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                        ivRisk.getSpecificGeolocation().getNodeMetaGeolocation().getPoint().setImage(potRiskUrl);
                        ivRisk.setPoint(new GJaxbPointType());
                        risk.getGeolocation().getItemView().add(ivRisk);
                        if (point != null) {
                            ivRisk.getPoint().setLatitude(point.getLatitude());
                            ivRisk.getPoint().setLongitude(point.getLongitude());
                        }
                        model.getNode().add(risk);
                        if (actuality != null) {
                            generated_by = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)risk, (GJaxbNode)actuality, (QName)GenericModelHelper.collab((String)"Generated_By"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                            model.getEdge().add(generated_by);
                            GJaxbNode.BrokenEdges.BrokenEdge be = new GJaxbNode.BrokenEdges.BrokenEdge();
                            be.setEdge(generated_by);
                            be.setSourceId(risk.getId());
                            be.setTargetId(actuality.getId());
                            risk.getBrokenEdges().getBrokenEdge().add(be);
                            model.getEdge().add(generated_by);
                        } else if (parentActuality != null) {
                            generated_by = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)risk, (GJaxbNode)parentActuality, (QName)GenericModelHelper.collab((String)"Generated_By"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                            model.getNode().add(parentActuality);
                            model.getEdge().add(generated_by);
                        }
                        GJaxbNode objective = EffectiveMetaModelPluginManager.getInstance().createNodeConcept(GenericModelHelper.collab((String)"Objective"));
                        objective.getStatus().add(GJaxbStatusType.NOT_VALIDATED);
                        GenericModelHelper.findProperty((String)"name", (List)objective.getProperty(), (boolean)true).setValue("Prevents " + GenericModelHelper.findProperty((String)"name", (List)risk.getProperty()).getValue());
                        objective.setId("node_objective_" + eventId + "_" + GenericModelHelper.findProperty((String)"name", (List)objective.getProperty()).getValue().hashCode());
                        model.getNode().add(objective);
                        GJaxbEdge prevents = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)objective, (GJaxbNode)risk, (QName)GenericModelHelper.collab((String)"Prevents"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                        prevents.setId("prevents_" + objective.getId());
                        model.getEdge().add(prevents);
                        this.addInferByOnConcept(objective, eventId);
                        this.addInferByOnConcept(risk, eventId);
                    }
                }
                GenericModelHelper.deleteDuplicateNodes((List)model.getNode());
                GenericModelHelper.deleteDuplicateEdges((List)model.getEdge());
                GJaxbQuery queryReq = new GJaxbQuery();
                queryReq.setQuery("MATCH (n:`" + String.valueOf(GenericModelHelper.collab((String)"Potentiality")) + "`) RETURN n UNION MATCH (n:`" + String.valueOf(GenericModelHelper.collab((String)"Actuality")) + "`) RETURN n");
                queryReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                queryReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                queryReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                GJaxbQueryResponse queryResp = this.coreClient.query(queryReq);
                ArrayList<GJaxbSimilarityLevel.SimilarityLevelInput.TargetSentence> targetSentences = new ArrayList<GJaxbSimilarityLevel.SimilarityLevelInput.TargetSentence>();
                for (GJaxbNode node : queryResp.getSingle().getGenericModel().getNode()) {
                    GJaxbSimilarityLevel.SimilarityLevelInput.TargetSentence targetSentence = new GJaxbSimilarityLevel.SimilarityLevelInput.TargetSentence();
                    targetSentence.setId(node.getId());
                    targetSentence.setSentence(GenericModelHelper.getName((GJaxbNode)node));
                    targetSentences.add(targetSentence);
                }
                for (GJaxbNode node : model.getNode()) {
                    if (!node.getType().equals(GenericModelHelper.collab((String)"Potentiality")) && !node.getType().equals(GenericModelHelper.collab((String)"Actuality"))) continue;
                    GJaxbSimilarityLevel request = new GJaxbSimilarityLevel();
                    GJaxbSimilarityLevel.SimilarityLevelInput input = new GJaxbSimilarityLevel.SimilarityLevelInput();
                    input.setSimilarityId("similar_" + UUID.randomUUID().toString());
                    input.setSimilarAnalysisTypeSelected(GJaxbSimilarAnalysisType.SEMANTIC);
                    input.setSemanticMethodSelected(GJaxbSemanticMethodType.IA);
                    GJaxbSimilarityLevel.SimilarityLevelInput.SourceSentence sourceSentence = new GJaxbSimilarityLevel.SimilarityLevelInput.SourceSentence();
                    sourceSentence.setId(node.getId());
                    sourceSentence.setSentence(GenericModelHelper.getName((GJaxbNode)node));
                    input.setSourceSentence(sourceSentence);
                    input.getTargetSentence().addAll(targetSentences);
                    request.getSimilarityLevelInput().add(input);
                    request.setContext(new GJaxbContext());
                    request.getContext().setSelectedAiChatBot(GJaxbAiChatBotType.CHAT_GPT);
                    request.getContext().setChatGPTContext(new GJaxbContext.ChatGPTContext());
                    request.getContext().getChatGPTContext().setModelName(OpenAiChatModelBuilder.ChatModelName.gpt_4.toString());
                    request.getContext().setCurrentCollaborationName(collaborationName);
                    request.getContext().setCurrentKnowledgeSpaceName(knowledgeSpaceName);
                    GJaxbSimilarityLevelResponse response = this.aiChatBot.similarityLevel(request);
                    GenericModelHelper.findProperty((String)"similarityLevel", (List)node.getProperty(), (boolean)true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)response));
                }
            } else {
                LOG.debug("Event already treated !!!: " + eventId);
            }
        }
        catch (Exception e) {
            throw new PredictFault(e.getMessage(), null, (Throwable)e);
        }
        return resp;
    }

    private List<GJaxbEdge> addImpactsOnNode(GJaxbNode actuality, List<GJaxbNode> impactedAssets) {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        if (impactedAssets != null) {
            for (GJaxbNode asset : impactedAssets) {
                GJaxbEdge edge = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)actuality, (GJaxbNode)asset, (QName)GenericModelHelper.collab((String)"Impacts"), (GJaxbRelationModeType)GJaxbRelationModeType.ASSOCIATION);
                edges.add(edge);
            }
        }
        return edges;
    }

    private void addInferByOnConcept(GJaxbNode instance, String eventId) {
        ArrayList inferByTable = new ArrayList();
        ArrayList<GJaxbProperty> inferByRow = new ArrayList<GJaxbProperty>();
        inferByTable.add(inferByRow);
        ArrayList refTable = new ArrayList();
        ArrayList<GJaxbProperty> refRow = new ArrayList<GJaxbProperty>();
        refTable.add(refRow);
        refRow.add(GenericModelHelper.createProperty((String)"type", (String)"PRIMITIVE_EVENT"));
        refRow.add(GenericModelHelper.createProperty((String)"event_id", (String)eventId));
        inferByRow.add(GenericModelHelper.createProperty((String)"ref", (String)GenericModelHelper.convertTableToJSONArray(refTable).toString()));
        ArrayList realizedByTable = new ArrayList();
        ArrayList<GJaxbProperty> realizedByRow = new ArrayList<GJaxbProperty>();
        realizedByTable.add(realizedByRow);
        realizedByRow.add(GenericModelHelper.createProperty((String)"name", (String)this.getName()));
        realizedByRow.add(GenericModelHelper.createProperty((String)"type", (String)"ML_RULE"));
        inferByRow.add(GenericModelHelper.createProperty((String)"Realized by", (String)GenericModelHelper.convertTableToJSONArray(realizedByTable).toString()));
        GJaxbProperty inferByProp = GenericModelHelper.findProperty((String)"infer by", (List)instance.getProperty(), (boolean)true);
        inferByProp.setValue(GenericModelHelper.convertTableToJSONArray(inferByTable).toString());
    }

    public static String encodeImageToBase64(URL imageUrl) throws IOException {
        byte[] imageBytes = IOUtils.toByteArray((InputStream)imageUrl.openStream());
        String base64Image = Base64.getEncoder().encodeToString(imageBytes);
        return base64Image;
    }
}

