/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.ml.manager.MLConfigManagerCommand;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.interpretationconfigs.DeployFault;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.interpretationconfigs.PredictFault;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbContext;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import gind.org.w3._2005._08.addressing.GJaxbAttributedURIType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import java.io.File;
import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LowLevelInterpretationMLEngineCommand
extends MLConfigManagerCommand
implements InterpretationCommand {
    private static Logger LOG = LoggerFactory.getLogger(LowLevelInterpretationMLEngineCommand.class);
    private GJaxbTopicSetType topicset = null;
    private ObjectFactory factory = new ObjectFactory();
    private String highLevelInterpretationEngineAddress = null;
    private NotificationManagerImpl subscriber = null;
    private GJaxbEndpointReferenceType eprBroker = null;
    private Storage storageClient = null;

    public LowLevelInterpretationMLEngineCommand(String producerAddress, GJaxbTopicSetType topicset, String highLevelInterpretationEngineAddress, NotificationManagerImpl subscriber, Map<String, Object> context) throws Exception {
        super(context);
        this.topicset = topicset;
        this.subscriber = subscriber;
        this.highLevelInterpretationEngineAddress = highLevelInterpretationEngineAddress;
        if (context.get("storage") != null) {
            this.storageClient = StorageClient.createClient((String)context.get("storage").toString());
        }
        this.eprBroker = new GJaxbEndpointReferenceType();
        this.eprBroker.setAddress(new GJaxbAttributedURIType());
        String eventBrokerAddress = ((String)context.get("event-broker")).replace("/BrokerSubscriber", "/BrokerNotifier");
        URI eventBrokerURI = URI.create(eventBrokerAddress);
        LOG.debug("--- EVENT BROKER: host = " + ((String)context.get("host")).trim());
        LOG.debug("--- EVENT BROKER: eventBrokerURI.getHost() = " + eventBrokerURI.getHost().trim());
        LOG.debug("--- EVENT BROKER: test = " + eventBrokerURI.getHost().trim().equals(((String)context.get("host")).trim()));
        if (context.get("host") != null && context.get("proxy-port") != null && eventBrokerURI.getHost().trim().equals(((String)context.get("host")).trim())) {
            String localBrokerAddress;
            eventBrokerAddress = localBrokerAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)context.get("host").toString(), (int)eventBrokerURI.getPort(), (int)Integer.parseInt(context.get("proxy-port").toString()), (String)eventBrokerURI.getPath());
            LOG.debug("--- EVENT BROKER: use local adress:  " + eventBrokerAddress);
        } else {
            LOG.debug("--- EVENT BROKER: use remote adress:  " + eventBrokerAddress);
        }
        this.eprBroker.getAddress().setValue(eventBrokerAddress);
    }

    public GJaxbDeployResponse deploy(GJaxbDeploy request) throws DeployFault {
        GJaxbInterpretationConfigs configs = new GJaxbInterpretationConfigs();
        try {
            for (GJaxbInterpretationConfig mlConfig : InterpretationConfigDeployHelper.extractInterpretationConfig((GJaxbDeploy)request).getInterpretationConfig()) {
                if (mlConfig.getContext() == null) {
                    mlConfig.setContext(new GJaxbContext());
                }
                for (GJaxbEventAction action : mlConfig.getEventAction()) {
                    boolean findTopic = false;
                    QName topic = action.getTopic();
                    for (Object obj : this.topicset.getAny()) {
                        Element elmt = (Element)obj;
                        if (!topic.equals(new QName(elmt.getNamespaceURI(), elmt.getLocalName()))) continue;
                        findTopic = true;
                        break;
                    }
                    if (!findTopic) {
                        try {
                            throw new DeployFault("the event action of rule must provide an output event using a topic included in this topicSet: " + XMLCompactPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement(this.factory.createTopicSet(this.topicset))), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean findPublisher = false;
                    for (String publisher : action.getPublishDestination()) {
                        if (!publisher.equals(this.highLevelInterpretationEngineAddress)) continue;
                        findPublisher = true;
                    }
                    if (findPublisher) continue;
                    action.getPublishDestination().add(this.highLevelInterpretationEngineAddress);
                }
                configs.getInterpretationConfig().add(mlConfig);
            }
            return super.deploy(InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)request.getCollaborationName(), (String)request.getKnowledgeSpaceName(), (File[])new File[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeployFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbPredictResponse predict(GJaxbPredict predictReq) throws PredictFault {
        GJaxbPredictResponse response = super.predict(predictReq);
        return response;
    }
}

