/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.ml.manager;

import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.ml.manager.MLConfigManagerCommand;
import fr.emac.gind.eventtype.GJaxbPublishModelEvent;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbQuery;
import fr.emac.gind.gov.core_gov.GJaxbQueryResponse;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbOriginOfInputData;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictInputs;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelManager;
import fr.emac.gind.models.generic.modeler.utils.GeometryHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class MLManagerNotifier
extends AbstractNotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)MLManagerNotifier.class.getName());
    private static int cpt = 0;
    private MLConfigManagerCommand cmc = null;
    private String producerAddress = null;
    private SOAPSender sender = new SOAPSender(new SOAPInterceptor[0]);
    private static List<String> CACHE_EVENTS = new ArrayList<String>();
    private CoreGov coreClient = null;

    public MLManagerNotifier(String producerAddress, MLConfigManagerCommand cmc, Map<String, Object> context) throws Exception {
        super(producerAddress);
        this.producerAddress = producerAddress;
        this.cmc = cmc;
        this.coreClient = CoreGovClient.createClient((String)context.get("governance").toString().replace("/gov", "/GovCore"));
    }

    public synchronized void notify(GJaxbNotify notify) {
        block19: {
            LOG.debug("Executing operation notify on ml");
            try {
                List<GJaxbInterpretationConfig> executionPlanRuntimes;
                Map ctxt = WSNHelper.getInstance().getAdditionalInformationInNotification(notify);
                Element context = (Element)ctxt.get(new QName("http://www.gind.emac.fr", "context"));
                String collaborationName = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "collaborationName", false).get(0)).getTextContent();
                String knowledgeSpaceName = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "knowledgeSpaceName", false).get(0)).getTextContent();
                String dataSourceId = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "dataSourceId", false).get(0)).getTextContent();
                String dataSourceName = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "dataSourceName", false).get(0)).getTextContent();
                String eventId = ((Element)DOMUtil.getInstance().findElementsByNameWithoutNS(context, "eventId", false).get(0)).getTextContent();
                if (CACHE_EVENTS.contains(eventId)) break block19;
                CACHE_EVENTS.add(eventId);
                Document event = this.getEventInNotify(notify);
                LOG.debug("****** Notify on CEP: \n" + XMLPrettyPrinter.print((Node)event));
                QName eventQName = new QName(event.getDocumentElement().getNamespaceURI(), event.getDocumentElement().getLocalName());
                GJaxbSensorEvent sensorEvent = null;
                if (eventQName.equals(new QName("http://www.gind.emac.fr/json_connector", "sensorEvent"))) {
                    sensorEvent = (GJaxbSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(event, GJaxbSensorEvent.class);
                }
                if (!(executionPlanRuntimes = this.findExecutionsPlanRuntime(eventQName)).isEmpty()) {
                    for (GJaxbInterpretationConfig rule : executionPlanRuntimes) {
                        GJaxbQuery query = new GJaxbQuery();
                        StringBuffer contextualData = new StringBuffer();
                        query.setQuery("match path = (s { modelNodeId : '" + Neo4JId.createIdUsingCollaboration((String)dataSourceId, (String)collaborationName, (String)knowledgeSpaceName) + "'})-[f:`" + String.valueOf(GenericModelHelper.collab((String)"Fixed_Onto")) + "`*]->(g2) return path");
                        query.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                        query.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                        query.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                        GJaxbQueryResponse queryResponse = this.coreClient.query(query);
                        GJaxbPointType positionFound = new GJaxbPointType();
                        GJaxbNode sensor = null;
                        if (queryResponse.isSetSingle() && queryResponse.getSingle().isSetGenericModel() && queryResponse.getSingle().getGenericModel().isSetNode() && !queryResponse.getSingle().getGenericModel().getNode().isEmpty()) {
                            GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{queryResponse.getSingle().getGenericModel()});
                            sensor = man.getNodeById(Neo4JId.cleanId((String)dataSourceId));
                            contextualData.append(this.createContextualDataAndFoundPosition(sensor, man, queryResponse.getSingle().getGenericModel(), positionFound));
                        } else if (queryResponse.isSetMultiple() && queryResponse.getMultiple().isSetGenericModel() && !queryResponse.getMultiple().getGenericModel().isEmpty()) {
                            GJaxbGenericModel mergeModel = new GJaxbGenericModel();
                            for (GJaxbGenericModel model : queryResponse.getMultiple().getGenericModel()) {
                                mergeModel.getNode().addAll(model.getNode());
                                mergeModel.getEdge().addAll(model.getEdge());
                            }
                            GenericModelHelper.deleteDuplicateNodes((List)mergeModel.getNode());
                            GenericModelHelper.deleteDuplicateEdges((List)mergeModel.getEdge());
                            GenericModelManager man = new GenericModelManager(new GJaxbGenericModel[]{mergeModel});
                            sensor = man.getNodeById(dataSourceId);
                            contextualData.append(this.createContextualDataAndFoundPosition(sensor, man, mergeModel, positionFound));
                        }
                        GJaxbPointType position = null;
                        if (positionFound.isSetLatitude() && positionFound.isSetLongitude()) {
                            position = positionFound;
                        } else if (sensorEvent != null && sensorEvent.getPosition() != null && sensorEvent.getPosition().getPoint() != null) {
                            position = new GJaxbPointType();
                            position.setLatitude(Double.valueOf(sensorEvent.getPosition().getPoint().getLatitude()));
                            position.setLongitude(Double.valueOf(sensorEvent.getPosition().getPoint().getLongitude()));
                        }
                        GJaxbPredict predictReq = new GJaxbPredict();
                        predictReq.setCollaborationName(collaborationName);
                        predictReq.setKnowledgeSpaceName(knowledgeSpaceName);
                        predictReq.setPluginName(rule.getMlConfig().getModule().getPluggedOn());
                        predictReq.setOriginOfInputData(new GJaxbOriginOfInputData());
                        predictReq.getOriginOfInputData().setSensorId(dataSourceId);
                        predictReq.getOriginOfInputData().setSensorName(dataSourceName);
                        predictReq.getOriginOfInputData().setSensorNode(new GJaxbOriginOfInputData.SensorNode());
                        predictReq.getOriginOfInputData().getSensorNode().setNode(sensor);
                        predictReq.getOriginOfInputData().setEventId(eventId);
                        if (position != null) {
                            predictReq.setPoint(position);
                        }
                        predictReq.setContextualData(contextualData.toString());
                        predictReq.setPredictInputs(new GJaxbPredictInputs());
                        predictReq.getPredictInputs().setDocument(new GJaxbPredictInputs.Document());
                        predictReq.getPredictInputs().getDocument().setAny((Object)event.getDocumentElement());
                        predictReq.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
                        GJaxbPredictResponse predictResp = this.cmc.predict(predictReq);
                        LOG.debug("predictResp = " + String.valueOf(predictResp));
                        if (predictResp == null || predictResp.getPredictOutputs() == null || predictResp.getPredictOutputs().getGenericModel() == null) continue;
                        for (GJaxbEventAction action : rule.getEventAction()) {
                            if (action.getEventElementName().equals(new QName("http://www.gind.emac.fr/EventType", "publishModelEvent"))) {
                                GJaxbPublishModelEvent publish = new GJaxbPublishModelEvent();
                                publish.setCollaborationName(collaborationName);
                                publish.setKnowledgeSpaceName(knowledgeSpaceName);
                                publish.setModel(new GJaxbPublishModelEvent.Model());
                                for (GJaxbNode node : predictResp.getPredictOutputs().getGenericModel().getNode()) {
                                    GJaxbPublishModelEvent.Model.Nodes nodes = new GJaxbPublishModelEvent.Model.Nodes();
                                    nodes.setNode(node);
                                    publish.getModel().getNodes().add(nodes);
                                }
                                for (GJaxbEdge edge : predictResp.getPredictOutputs().getGenericModel().getEdge()) {
                                    GJaxbPublishModelEvent.Model.Edges edges = new GJaxbPublishModelEvent.Model.Edges();
                                    edges.setEdge(edge);
                                    edges.setSourceNodeId(edge.getSource().getId());
                                    edges.setTargetNodeId(edge.getTarget().getId());
                                    publish.getModel().getEdges().add(edges);
                                }
                                HashMap<QName, String> newContext = new HashMap<QName, String>();
                                newContext.put(new QName("http://www.gind.emac.fr", "collaborationName"), rule.getContext().getCollaborationName());
                                newContext.put(new QName("http://www.gind.emac.fr", "knowledgeSpaceName"), rule.getContext().getKnowledgeSpaceName());
                                Document doc = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)publish);
                                QName topicUsed = action.getTopic();
                                for (String publisher : action.getPublishDestination()) {
                                    GJaxbNotify newNotify = WSNHelper.getInstance().createNotification(publisher, this.producerAddress, topicUsed, (Object)doc, newContext);
                                    LOG.debug("notification created for " + publisher + " producer : " + this.producerAddress + " on topic " + String.valueOf(topicUsed));
                                    Document requestResultEvent = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)newNotify);
                                    LOG.debug("newEvent: " + XMLPrettyPrinter.print((Node)requestResultEvent));
                                    LOG.debug("************ SEND COMPLEX EVENT FROM ML: \n" + XMLPrettyPrinter.print((Node)requestResultEvent));
                                    System.out.println("************ SEND COMPLEX EVENT FROM ML: \n" + XMLPrettyPrinter.print((Node)requestResultEvent));
                                    this.sender.sendSoapRequest(requestResultEvent, publisher, null);
                                }
                                continue;
                            }
                            throw new Exception("Not implemented !!!");
                        }
                    }
                } else {
                    String errorMsg = "Impossible to find rules corresponding to event: " + String.valueOf(eventQName);
                    LOG.warn(errorMsg);
                    throw new RuntimeException(errorMsg);
                }
                LOG.debug("****** NUMBER OF NOTIFICATION RECEIVED ON ML: " + ++cpt);
            }
            catch (Exception e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
                e1.printStackTrace();
            }
        }
    }

    protected String createContextualDataAndFoundPosition(GJaxbNode sensor, GenericModelManager man, GJaxbGenericModel genericModel, GJaxbPointType positionFound) throws Exception {
        Object res = null;
        if (sensor != null) {
            res = " knowing that the photo was taken from a ";
            if (sensor.isSetGeolocation() && sensor.getGeolocation().isSetItemView() && !sensor.getGeolocation().getItemView().isEmpty()) {
                GJaxbNode.Geolocation.ItemView iv = (GJaxbNode.Geolocation.ItemView)sensor.getGeolocation().getItemView().get(0);
                if (iv.isSetPoint()) {
                    positionFound.setLatitude(iv.getPoint().getLatitude());
                    positionFound.setLongitude(iv.getPoint().getLongitude());
                } else if (iv.isSetArea()) {
                    List polygons = GeometryHelper.getInstance().extractGeometryFromGJaxbNode(sensor);
                    if (!polygons.isEmpty()) {
                        Polygon polygon = (Polygon)polygons.get(0);
                        Point randomPoint = GeometryHelper.getInstance().generateRandomPointInsidePolygon(polygon);
                        positionFound.setLatitude(Double.valueOf(randomPoint.getY()));
                        positionFound.setLongitude(Double.valueOf(randomPoint.getX()));
                    }
                } else if (iv.isSetPredefinedShape()) {
                    if (iv.getPredefinedShape().isSetCircle()) {
                        positionFound.setLatitude(iv.getPredefinedShape().getCircle().getCenter().getLatitude());
                        positionFound.setLongitude(iv.getPredefinedShape().getCircle().getCenter().getLongitude());
                    } else if (iv.getPredefinedShape().isSetRect()) {
                        positionFound.setLatitude(iv.getPredefinedShape().getRect().getCenter().getLatitude());
                        positionFound.setLongitude(iv.getPredefinedShape().getRect().getCenter().getLongitude());
                    }
                } else if (iv.isSetPolyline()) {
                    positionFound.setLatitude(((GJaxbPointType)iv.getPolyline().getPoint().get(0)).getLatitude());
                    positionFound.setLongitude(((GJaxbPointType)iv.getPolyline().getPoint().get(0)).getLongitude());
                }
            }
            String natureSensor = GenericModelHelper.findProperty((String)"nature", (List)sensor.getProperty(), (boolean)true).getValue().toLowerCase().replace("_", " ");
            res = (String)res + " fixed onto " + natureSensor + " sensor";
            List outputEdgesSensor = man.findOutputEdgesOfNode(sensor);
            if (!outputEdgesSensor.isEmpty()) {
                List fixed_ontos = GenericModelHelper.findEdgesByType((QName)GenericModelHelper.collab((String)"Fixed_Onto"), (List)outputEdgesSensor);
                while (fixed_ontos != null && !fixed_ontos.isEmpty()) {
                    List outputEdgesGood;
                    GJaxbEdge fixed_onto = (GJaxbEdge)fixed_ontos.get(0);
                    fixed_ontos = null;
                    GJaxbNode goodOrTerritory = fixed_onto.getTarget();
                    if (goodOrTerritory.getType().equals(GenericModelHelper.collab((String)"Territory"))) {
                        String type = GenericModelHelper.findProperty((String)"type", (List)goodOrTerritory.getProperty(), (boolean)true).getValue().toLowerCase().replace("_", " ");
                        res = (String)res + " fixed onto the " + type + " '" + GenericModelHelper.getName((GJaxbNode)goodOrTerritory) + "'";
                    } else {
                        res = (String)res + " fixed onto '" + GenericModelHelper.getName((GJaxbNode)goodOrTerritory) + "'";
                    }
                    if ((outputEdgesGood = man.findOutputEdgesOfNode(goodOrTerritory)).isEmpty()) continue;
                    fixed_ontos = GenericModelHelper.findEdgesByType((QName)GenericModelHelper.collab((String)"Fixed_Onto"), (List)outputEdgesGood);
                }
            }
        }
        return res;
    }

    private Document getEventInNotify(GJaxbNotify notify) throws Exception {
        Document doc = null;
        for (GJaxbNotificationMessageHolderType msgh : notify.getNotificationMessage()) {
            if (msgh.getMessage().getAny() instanceof Element) {
                Element elmt = (Element)msgh.getMessage().getAny();
                doc = DOMUtil.getInstance().newDocument();
                doc.appendChild(doc.adoptNode(elmt));
                continue;
            }
            doc = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)msgh.getMessage().getAny());
        }
        return doc;
    }

    private synchronized List<GJaxbInterpretationConfig> findExecutionsPlanRuntime(QName eventQName) {
        ArrayList<GJaxbInterpretationConfig> res = new ArrayList<GJaxbInterpretationConfig>();
        for (Map<QName, List<GJaxbInterpretationConfig>> mapExec : this.cmc.getMapExecRuntime().values()) {
            if (mapExec.get(eventQName) == null) continue;
            res.addAll((Collection<GJaxbInterpretationConfig>)mapExec.get(eventQName));
        }
        return res;
    }
}

