/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.mock.endpoints.manager;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.rest.StaticRestServer;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerImpl;
import fr.emac.gind.mock.endpoints.manager.protocol.AbstractMockEndpoint;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.server.ResourceConfig;

public class MockEndpointManagerWebService
extends SPIWebServicePrimitives {
    private String storageAddress = null;
    private MockEndpointManagerImpl mockEndpointsManager = null;
    private Map<String, Object> context = null;

    public void onInit(Map<String, Object> context) {
        try {
            if (context.get("storage") == null) {
                throw new UncheckedException("Configuration Error: storage cannot be null!!!");
            }
            this.storageAddress = (String)context.get("storage");
            this.context = context;
            this.mockEndpointsManager = new MockEndpointManagerImpl(MockEndpointManagerWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.getProxyPort(), (String)"mockEndpointsManager"), this);
            this.registerWSImplementation("mockEndpointsManager", this.mockEndpointsManager);
            if (this.getContext().get("json-restmock-endpoint-listener-port") != null) {
                int port = Integer.parseInt(this.getContext().get("json-restmock-endpoint-listener-port").toString());
                ResourceConfig rc = new ResourceConfig().packages(new String[]{"fr.emac.gind.mock.endpoints.manager.protocol.http_rest.iots.resources"});
                HashMap<String, MockEndpointManagerWebService> mapProps = new HashMap<String, MockEndpointManagerWebService>();
                mapProps.put("mockEndpointsWebService", this);
                rc.setProperties(mapProps);
                StaticRestServer.getInstance().start(Integer.valueOf(port), rc);
            }
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.mockEndpointsManager != null && this.mockEndpointsManager.getMockEndpointsMap() != null) {
            for (Map<String, AbstractMockEndpoint> agents : this.mockEndpointsManager.getMockEndpointsMap().values()) {
                for (AbstractMockEndpoint agent : agents.values()) {
                    agent.stop();
                }
            }
        }
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getStorageAddress() {
        return this.storageAddress;
    }

    public MockEndpointManagerImpl getMockEndpointsManager() {
        return this.mockEndpointsManager;
    }
}

