/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.mock.endpoints.manager;

import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.mock.endpoints.manager.FaultMessage;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManager;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerWebService;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbAddExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbDeleteMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbEndpointType;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbExpectedExchange;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodId;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbFindMockEndpointByGoodIdResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpoints;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpointsResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockOperation;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbPlayExchangeOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbRunActuatorOnMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStartMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopAllMockEndpoints;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopAllMockEndpointsResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbStopMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbUpdateConfigOfMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbUpdateConfigOfMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.protocol.AbstractMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.protocol.http_rest.RESTMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.protocol.http_rest.iots.RESTPhotoCameraMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.protocol.http_soap.SOAPMockEndpoint;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sensors.model.GJaxbStatusType;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import jakarta.xml.ws.Endpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="mock-endpoint-manager-serviceSOAP", serviceName="mock-endpoint-manager-service", targetNamespace="http://www.gind.emac.fr/mock/endpoints/manager/", wsdlLocation="wsdl/mock-endpoints-manager.wsdl", endpointInterface="fr.emac.gind.mock.endpoints.manager.MockEndpointManager")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class MockEndpointManagerImpl
implements MockEndpointManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)MockEndpointManagerImpl.class.getName());
    private String address = null;
    private CoreGov coreGovClient = null;
    private MockEndpointManagerWebService mockEndpointsWebService = null;
    private Map<String, Map<String, AbstractMockEndpoint>> mockEndpointsMap = new HashMap<String, Map<String, AbstractMockEndpoint>>();

    public MockEndpointManagerImpl(String address, MockEndpointManagerWebService eventMockEndpointWebService) throws Exception {
        this.address = address;
        this.mockEndpointsWebService = eventMockEndpointWebService;
        if (eventMockEndpointWebService.getContext().get("governance") != null) {
            this.coreGovClient = CoreGovClient.createClient((String)((String)eventMockEndpointWebService.getContext().get("governance")));
        }
    }

    public String getAddress() {
        return this.address;
    }

    public Map<String, Map<String, AbstractMockEndpoint>> getMockEndpointsMap() {
        return this.mockEndpointsMap;
    }

    public GJaxbUpdateConfigOfMockEndpointResponse updateConfigOfMockEndpoint(GJaxbUpdateConfigOfMockEndpoint parameters) throws FaultMessage {
        throw new UnsupportedOperationException();
    }

    public GJaxbCreateMockEndpointResponse createMockEndpoint(GJaxbCreateMockEndpoint request) throws FaultMessage {
        GJaxbCreateMockEndpointResponse response = new GJaxbCreateMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = null;
            String key = request.getCollaborationName() + ":" + request.getKnowledgeSpaceName();
            if (this.mockEndpointsMap.get(key) == null) {
                this.mockEndpointsMap.put(key, new HashMap());
            }
            GJaxbMockEndpoint defaultMockEndpointConfig = request.getMockEndpoint();
            GJaxbNode node = defaultMockEndpointConfig.getNode();
            String iot = GenericModelHelper.findProperty((String)"iot", (List)node.getProperty(), (boolean)true).getValue();
            String iotType = GenericModelHelper.findProperty((String)"type", (List)node.getProperty(), (boolean)true).getValue();
            ArrayList<GJaxbProperty> context = new ArrayList();
            if (request.isSetContext()) {
                context = request.getContext().getProperty();
            }
            if (this.mockEndpointsMap.get(key).get(defaultMockEndpointConfig.getGoodId()) != null) {
                LOG.warn("Mock Endpoint already created by riosemit");
                mockEndpoint = this.mockEndpointsMap.get(key).get(defaultMockEndpointConfig.getGoodId());
            } else if (iot.equals("yes") && iotType.equals("photo_camera")) {
                defaultMockEndpointConfig.setIot(Boolean.valueOf(true));
                defaultMockEndpointConfig.setIotType("photo_camera");
                mockEndpoint = new RESTPhotoCameraMockEndpoint(defaultMockEndpointConfig, this.mockEndpointsWebService, request.getCollaborationName(), request.getKnowledgeSpaceName(), context);
                if (this.mockEndpointsMap.get(key) == null) {
                    this.mockEndpointsMap.put(key, new HashMap());
                }
                this.mockEndpointsMap.get(key).put(defaultMockEndpointConfig.getGoodId(), mockEndpoint);
            } else if (iot.equals("yes") && iotType.equals("camera")) {
                defaultMockEndpointConfig.setIot(Boolean.valueOf(true));
                defaultMockEndpointConfig.setIotType("camera");
                mockEndpoint = new RESTMockEndpoint(defaultMockEndpointConfig, this.mockEndpointsWebService, request.getCollaborationName(), request.getKnowledgeSpaceName(), context);
                if (this.mockEndpointsMap.get(key) == null) {
                    this.mockEndpointsMap.put(key, new HashMap());
                }
                this.mockEndpointsMap.get(key).put(defaultMockEndpointConfig.getGoodId(), mockEndpoint);
            } else {
                mockEndpoint = defaultMockEndpointConfig.getType().equals((Object)GJaxbEndpointType.HTTP_SOAP) ? new SOAPMockEndpoint(defaultMockEndpointConfig, this.mockEndpointsWebService, request.getCollaborationName(), request.getKnowledgeSpaceName(), context) : new RESTMockEndpoint(defaultMockEndpointConfig, this.mockEndpointsWebService, request.getCollaborationName(), request.getKnowledgeSpaceName(), context);
                if (this.mockEndpointsMap.get(key) == null) {
                    this.mockEndpointsMap.put(key, new HashMap());
                }
                this.mockEndpointsMap.get(key).put(defaultMockEndpointConfig.getGoodId(), mockEndpoint);
            }
            if (request.isStartEndpoint()) {
                GJaxbStartMockEndpoint startRequest = new GJaxbStartMockEndpoint();
                startRequest.setId(mockEndpoint.getMockEndpointModel().getId());
                startRequest.setCollaborationName(request.getCollaborationName());
                startRequest.setKnowledgeSpaceName(request.getKnowledgeSpaceName());
                this.startMockEndpoint(startRequest);
            }
            response.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (!(e instanceof FaultMessage)) {
                throw new FaultMessage(e.getMessage(), null, (Throwable)e);
            }
            throw (FaultMessage)e;
        }
        return response;
    }

    private GJaxbMockEndpoint copyLightMockEndpoint(GJaxbMockEndpoint mockEndpointModel) {
        GJaxbMockEndpoint mock = new GJaxbMockEndpoint();
        mock.setAddress(mockEndpointModel.getAddress());
        mock.setGoodId(mockEndpointModel.getGoodId());
        mock.setId(mockEndpointModel.getId());
        mock.setName(mockEndpointModel.getName());
        mock.setPort(mockEndpointModel.getPort());
        mock.setStatus(mockEndpointModel.getStatus());
        mock.setIot(mockEndpointModel.isIot());
        mock.setIotType(mockEndpointModel.getIotType());
        mock.getActuator().addAll(mockEndpointModel.getActuator());
        mock.getMockOperation().addAll(mockEndpointModel.getMockOperation());
        return mock;
    }

    public synchronized GJaxbStartMockEndpointResponse startMockEndpoint(GJaxbStartMockEndpoint request) throws FaultMessage {
        GJaxbStartMockEndpointResponse response = new GJaxbStartMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(request.getId(), request.getCollaborationName(), request.getKnowledgeSpaceName());
            if (mockEndpoint == null) {
                throw new Exception("Impossible to find existing sensor with this url: " + request.getId());
            }
            mockEndpoint.start();
            response.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return response;
    }

    public GJaxbStopMockEndpointResponse stopMockEndpoint(GJaxbStopMockEndpoint request) throws FaultMessage {
        GJaxbStopMockEndpointResponse response = new GJaxbStopMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(request.getId(), request.getCollaborationName(), request.getKnowledgeSpaceName());
            mockEndpoint.stop();
            response.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbStopAllMockEndpointsResponse stopAllMockEndpoints(GJaxbStopAllMockEndpoints parameters) throws FaultMessage {
        GJaxbStopAllMockEndpointsResponse response = new GJaxbStopAllMockEndpointsResponse();
        try {
            String key = parameters.getCollaborationName() + ":" + parameters.getKnowledgeSpaceName();
            if (this.mockEndpointsMap.get(key) != null) {
                ArrayList<AbstractMockEndpoint> producerAgents = new ArrayList<AbstractMockEndpoint>(this.mockEndpointsMap.get(key).values());
                for (AbstractMockEndpoint producerAgent : producerAgents) {
                    if (producerAgent == null || producerAgent.getMockEndpointModel() == null || !producerAgent.getMockEndpointModel().getStatus().equals((Object)GJaxbStatusType.STARTED)) continue;
                    GJaxbStopMockEndpoint stopReq = new GJaxbStopMockEndpoint();
                    stopReq.setId(producerAgent.getMockEndpointModel().getId());
                    stopReq.setCollaborationName(parameters.getCollaborationName());
                    stopReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                    GJaxbStopMockEndpointResponse stopResp = this.stopMockEndpoint(stopReq);
                    response.getMockEndpoint().add(stopResp.getMockEndpoint());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbDeleteMockEndpointResponse deleteMockEndpoint(GJaxbDeleteMockEndpoint request) throws FaultMessage {
        GJaxbDeleteMockEndpointResponse response = new GJaxbDeleteMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(request.getId(), request.getCollaborationName(), request.getKnowledgeSpaceName());
            String queryPath = mockEndpoint.getAddress().replace("http://", "");
            queryPath = queryPath.substring(queryPath.indexOf("/") + 1);
            Endpoint endpoint = this.mockEndpointsWebService.findEndpointByQueryPath(queryPath);
            if (endpoint.isPublished()) {
                GJaxbStopMockEndpoint requestStop = new GJaxbStopMockEndpoint();
                requestStop.setId(request.getId());
                this.stopMockEndpoint(requestStop);
            }
            endpoint.stop();
            String key = request.getCollaborationName() + ":" + request.getKnowledgeSpaceName();
            this.mockEndpointsMap.get(key).remove(mockEndpoint.getMockEndpointModel().getId());
            mockEndpoint.getMockEndpointModel().setStatus(null);
            response.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    private AbstractMockEndpoint findMockEndpointById(String id, String collaborationName, String knowledgeSpaceName) throws Exception {
        AbstractMockEndpoint provider = null;
        String key = collaborationName + ":" + knowledgeSpaceName;
        if (this.mockEndpointsMap.get(key) != null) {
            for (Map.Entry<String, AbstractMockEndpoint> entry : this.mockEndpointsMap.get(key).entrySet()) {
                AbstractMockEndpoint providerUrl = entry.getValue();
                if (!providerUrl.getMockEndpointModel().getId().equals(id)) continue;
                provider = providerUrl;
                break;
            }
        }
        return provider;
    }

    public GJaxbFindMockEndpointByGoodIdResponse findMockEndpointByGoodId(GJaxbFindMockEndpointByGoodId parameters) throws FaultMessage {
        GJaxbFindMockEndpointByGoodIdResponse response = new GJaxbFindMockEndpointByGoodIdResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointByGoodId(parameters.getGoodId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (mockEndpoint != null) {
                response.setMockEndpoint(mockEndpoint.getMockEndpointModel());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public AbstractMockEndpoint findMockEndpointByGoodId(String goodId, String collaborationName, String knowledgeSpaceName) {
        String key = collaborationName + ":" + knowledgeSpaceName;
        if (this.mockEndpointsMap.get(key) != null) {
            for (Map.Entry<String, AbstractMockEndpoint> entry : this.mockEndpointsMap.get(key).entrySet()) {
                AbstractMockEndpoint mockEndpoint = entry.getValue();
                String id = mockEndpoint.getMockEndpointModel().getGoodId();
                if (!id.toLowerCase().equals(goodId.toLowerCase())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public GJaxbGetMockEndpointResponse getMockEndpoint(GJaxbGetMockEndpoint parameters) throws FaultMessage {
        GJaxbGetMockEndpointResponse res = new GJaxbGetMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(parameters.getId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (mockEndpoint != null) {
                res.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbGetMockEndpointsResponse getMockEndpoints(GJaxbGetMockEndpoints parameters) throws FaultMessage {
        GJaxbGetMockEndpointsResponse res = new GJaxbGetMockEndpointsResponse();
        String key = parameters.getCollaborationName() + ":" + parameters.getKnowledgeSpaceName();
        if (this.mockEndpointsMap.get(key) != null) {
            for (Map.Entry<String, AbstractMockEndpoint> entry : this.mockEndpointsMap.get(key).entrySet()) {
                res.getMockEndpoint().add(this.copyLightMockEndpoint(entry.getValue().getMockEndpointModel()));
            }
        }
        return res;
    }

    public GJaxbRunActuatorOnMockEndpointResponse runActuatorOnMockEndpoint(GJaxbRunActuatorOnMockEndpoint parameters) throws FaultMessage {
        GJaxbRunActuatorOnMockEndpointResponse res;
        block3: {
            res = new GJaxbRunActuatorOnMockEndpointResponse();
            try {
                AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(parameters.getId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                if (mockEndpoint == null) break block3;
                GJaxbMockOperation expectedOperationFound = this.foundMockOperation(mockEndpoint, parameters.getActuator().getOperationName());
                GJaxbExpectedExchange expectedExchangeFound = this.foundExpectedExchange(mockEndpoint, parameters.getActuator().getOperationName(), parameters.getActuator().getExpectedExchangeId().trim());
                if (expectedExchangeFound == null) break block3;
                if (mockEndpoint.getMockEndpointModel().getType().equals((Object)GJaxbEndpointType.HTTP_SOAP)) {
                    SOAPSender sender = new SOAPSender(new SOAPInterceptor[0]);
                    sender.sendSoapRequest(expectedExchangeFound.getInput().getPayload(), mockEndpoint.getAddress(), expectedOperationFound.getSoapAction());
                    break block3;
                }
                throw new Exception("type not implemented: " + String.valueOf(mockEndpoint.getMockEndpointModel().getType()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new FaultMessage(e.getMessage(), null, (Throwable)e);
            }
        }
        return res;
    }

    private GJaxbMockOperation foundMockOperation(AbstractMockEndpoint mockEndpoint, String operationName) {
        GJaxbMockOperation res = null;
        for (GJaxbMockOperation mockOp : mockEndpoint.getMockEndpointModel().getMockOperation()) {
            if (!mockOp.getOperationName().trim().equals(operationName.trim())) continue;
            res = mockOp;
            break;
        }
        return res;
    }

    private GJaxbExpectedExchange foundExpectedExchange(AbstractMockEndpoint mockEndpoint, String operationName, String expectedExchangeId) {
        GJaxbExpectedExchange res = null;
        block0: for (GJaxbMockOperation mockOp : mockEndpoint.getMockEndpointModel().getMockOperation()) {
            if (!mockOp.getOperationName().trim().equals(operationName.trim())) continue;
            for (GJaxbExpectedExchange expectedExchange : mockOp.getExpectedExchange()) {
                if (!expectedExchange.getId().trim().equals(expectedExchangeId.trim())) continue;
                res = expectedExchange;
                break block0;
            }
        }
        return res;
    }

    public CoreGov getCoreGovClient() {
        return this.coreGovClient;
    }

    public GJaxbAddExchangeOnMockEndpointResponse addExchangeOnMockEndpoint(GJaxbAddExchangeOnMockEndpoint parameters) throws FaultMessage {
        GJaxbAddExchangeOnMockEndpointResponse res = new GJaxbAddExchangeOnMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(parameters.getId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (mockEndpoint != null) {
                GJaxbMockOperation operation = this.foundMockOperation(mockEndpoint, parameters.getOperationName());
                if (operation == null) {
                    throw new Exception("Opreation not found: " + parameters.getOperationName());
                }
                operation.getExpectedExchange().add(parameters.getExpectedExchange());
                res.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbDeleteExchangeOnMockEndpointResponse deleteExchangeOnMockEndpoint(GJaxbDeleteExchangeOnMockEndpoint parameters) throws FaultMessage {
        GJaxbDeleteExchangeOnMockEndpointResponse res = new GJaxbDeleteExchangeOnMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(parameters.getId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (mockEndpoint != null) {
                GJaxbMockOperation operation = this.foundMockOperation(mockEndpoint, parameters.getOperationName());
                if (operation == null) {
                    throw new Exception("Opreation not found: " + parameters.getOperationName());
                }
                operation.getExpectedExchange().removeIf(ee -> ee.getId().equals(parameters.getExchangeId()));
                res.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbPlayExchangeOnMockEndpointResponse playExchangeOnMockEndpoint(GJaxbPlayExchangeOnMockEndpoint parameters) throws FaultMessage {
        GJaxbPlayExchangeOnMockEndpointResponse res = new GJaxbPlayExchangeOnMockEndpointResponse();
        try {
            AbstractMockEndpoint mockEndpoint = this.findMockEndpointById(parameters.getId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (mockEndpoint != null) {
                GJaxbMockOperation operation = this.foundMockOperation(mockEndpoint, parameters.getOperationName());
                if (operation == null) {
                    throw new Exception("Operation not found: " + parameters.getOperationName());
                }
                GJaxbExpectedExchange expectedExchange = operation.getExpectedExchange().stream().filter(ee -> ee.getId().equals(parameters.getExchangeId())).findFirst().get();
                operation.getExpectedExchange().remove(expectedExchange);
                res.setMockEndpoint(this.copyLightMockEndpoint(mockEndpoint.getMockEndpointModel()));
                res.setExpectedExchange(expectedExchange);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }
}

