/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.mock.endpoints.manager.protocol.http_soap;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbActionType;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbExpectedExchange;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbHttpMethodType;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockOperation;
import fr.emac.gind.servlet.soap.impl.servlet.SoapReceiver;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapMockEndpointReceiver
implements SoapReceiver {
    private static final Logger LOG = LoggerFactory.getLogger((String)SoapMockEndpointReceiver.class.getName());
    private GJaxbMockEndpoint mockEndpointModel = null;
    private Map<String, Object> context = null;

    public SoapMockEndpointReceiver(GJaxbMockEndpoint mockEndpointModel, Map<String, Object> context) {
        this.mockEndpointModel = mockEndpointModel;
        this.context = context;
    }

    public void accept(Document request, Map<String, Object> context, Document response) throws Exception {
        System.out.println("xml req: \n" + XMLPrettyPrinter.print((Node)request));
        Document payload = SOAPHandler.extractPayload((Document)request);
        System.out.println("xml payload: \n" + XMLPrettyPrinter.print((Node)payload));
        String soapAction = (String)context.get("soapAction");
        GJaxbExpectedExchange expectedExchange = this.findExpectedExchange(payload, soapAction);
        if (expectedExchange == null) {
            throw new Exception("Expected Exchange not found !!!");
        }
        if (!expectedExchange.getIntermediateAction().isEmpty()) {
            for (GJaxbActionType action : expectedExchange.getIntermediateAction()) {
                if (!action.isSetSendEvent()) continue;
                if (action.getSendEvent().isSetHttpRest()) {
                    if (action.getSendEvent().getHttpRest().getHttpMethod().equals((Object)GJaxbHttpMethodType.POST)) {
                        Client client = ClientBuilder.newClient();
                        String address = action.getSendEvent().getEndpointAddress().strip().stripIndent().toString();
                        if (this.context.get("protocol") == null || this.context.get("host") == null || this.context.get("json-connector-listener-port") == null) continue;
                        address = address.replace("${protocol}", this.context.get("protocol").toString());
                        address = address.replace("${host}", this.context.get("host").toString());
                        address = address.replace("${json-connector-listener-port}", this.context.get("json-connector-listener-port").toString());
                        WebTarget webTarget = client.target(address);
                        String jsonPayload = action.getSendEvent().getHttpRest().getJsonRequest().strip().stripIndent().toString();
                        ByteArrayInputStream jsonStream = new ByteArrayInputStream(new JSONObject(jsonPayload).toString().getBytes());
                        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
                        Response responseRest = invocationBuilder.post(Entity.entity((Object)jsonStream, (String)"application/json"));
                        if (responseRest.getStatus() != 200) {
                            String error = (String)responseRest.readEntity(String.class);
                            LOG.error("Error from Server .... \n");
                            LOG.error(error);
                            throw new Exception("Failed on Server (HTTP error code : " + responseRest.getStatus() + ") : " + error);
                        }
                        String output = (String)responseRest.readEntity(String.class);
                        System.out.println("output: \n" + output);
                        continue;
                    }
                    throw new Exception("Not implemented !!!");
                }
                throw new Exception("Not implemented !!!");
            }
        }
        if (expectedExchange.isSetOutput()) {
            context.put("pattern", "in-out");
            String output = expectedExchange.getOutput().getPayload();
            Element outputElmt = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(output.getBytes())).getDocumentElement();
            Document outputDoc = SOAPSender.createSOAPMessageRequest((Document)DOMUtil.getInstance().createDocumentFromElement(outputElmt), null);
            response.appendChild(response.adoptNode(outputDoc.getDocumentElement()));
        } else {
            context.put("pattern", "in-only");
        }
    }

    private GJaxbExpectedExchange findExpectedExchange(Document payload, String soapAction) throws Exception {
        List<GJaxbMockOperation> possibleOperations = this.findPossibleOperations(soapAction);
        List<GJaxbExpectedExchange> expectedExchanges = this.findPossibleExpectedExchanges(possibleOperations, payload);
        if (expectedExchanges.size() > 0) {
            return expectedExchanges.get(0);
        }
        return null;
    }

    private List<GJaxbExpectedExchange> findPossibleExpectedExchanges(List<GJaxbMockOperation> possibleOperations, Document payload) throws Exception {
        ArrayList<GJaxbExpectedExchange> res = new ArrayList<GJaxbExpectedExchange>();
        for (GJaxbMockOperation op : possibleOperations) {
            for (GJaxbExpectedExchange exExch : op.getExpectedExchange()) {
                String input = exExch.getInput().getPayload();
                Document inputDoc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(input.getBytes()));
                Diff diff = XMLUnit.compareXML((Document)inputDoc, (Document)payload);
                if (!diff.similar()) continue;
                res.add(exExch);
            }
        }
        return res;
    }

    private List<GJaxbMockOperation> findPossibleOperations(String soapAction) {
        ArrayList<GJaxbMockOperation> res = new ArrayList<GJaxbMockOperation>();
        for (GJaxbMockOperation mop : this.mockEndpointModel.getMockOperation()) {
            if (soapAction != null) {
                if (mop.getSoapAction() == null) continue;
                res.add(mop);
                continue;
            }
            res.add(mop);
        }
        return res;
    }
}

