/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.distance;

import fr.emac.gind.distance.data.GJaxbLeg;
import fr.emac.gind.distance.data.GJaxbPair;
import fr.emac.gind.distance.data.GJaxbRoute;

public class RouteHelper {
    public static Double getDuration(GJaxbRoute route) {
        Double duration = 0.0;
        if (route != null) {
            for (GJaxbLeg leg : route.getLeg()) {
                duration = duration + RouteHelper.getDuration(leg);
            }
        }
        return duration;
    }

    public static Double getDuration(GJaxbLeg leg) {
        if (leg.isSetDurationInTraffic()) {
            return leg.getDurationInTraffic();
        }
        if (leg.isSetDuration()) {
            return leg.getDuration();
        }
        return null;
    }

    public static Double getDistance(GJaxbRoute route) {
        Double distance = 0.0;
        if (route != null) {
            for (GJaxbLeg leg : route.getLeg()) {
                distance = distance + leg.getDistance();
            }
        }
        return distance;
    }

    public static GJaxbRoute getRouteWithMinDuration(GJaxbPair pair) {
        GJaxbRoute minRoute = null;
        Double minDuration = null;
        if (pair != null) {
            for (GJaxbRoute route : pair.getRoute()) {
                for (GJaxbLeg leg : route.getLeg()) {
                    if (minDuration == null) {
                        minDuration = RouteHelper.getDuration(leg);
                        minRoute = route;
                    }
                    if (!(leg.getDuration() < minDuration)) continue;
                    minDuration = RouteHelper.getDuration(leg);
                    minRoute = route;
                }
            }
        }
        return minRoute;
    }
}

