/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils;

import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class MetaModelURIResolver
implements URIResolver {
    private static Logger LOG = LoggerFactory.getLogger((String)MetaModelURIResolver.class.getName());

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        try {
            if (href.contains("http://fr.emac.gind/collaborative-model")) {
                QName collaborativeQName = new QName("http://fr.emac.gind/collaborative-model", "CollaborativeModel");
                GJaxbMetaModel collaborativeMM = EffectiveMetaModelPluginManager.getInstance().getMetaModels().get(collaborativeQName);
                return new SAXSource(new InputSource(collaborativeMM.getBaseURI().toURL().openStream()));
            }
            if (href.contains("../symlink-sources/core_meta_model/symlink-sources/uml_meta_model/UML_MetaModel.xml")) {
                QName umlQName = new QName("http://fr.emac.gind/uml-model", "UML");
                GJaxbMetaModel umlMM = EffectiveMetaModelPluginManager.getInstance().getMetaModels().get(umlQName);
                return new SAXSource(new InputSource(umlMM.getBaseURI().toURL().openStream()));
            }
            if (href.contains("../symlink-sources/core_meta_model/Core_MetaModel.xml")) {
                QName coreQName = new QName("http://fr.emac.gind/core-model", "CoreModel");
                GJaxbMetaModel coreMM = EffectiveMetaModelPluginManager.getInstance().getMetaModels().get(coreQName);
                return new SAXSource(new InputSource(coreMM.getBaseURI().toURL().openStream()));
            }
            if (href.contains("../symlink-sources/system/System_MetaModel.xml")) {
                QName systemQName = new QName("http://fr.emac.gind/system", "System");
                GJaxbMetaModel systemMM = EffectiveMetaModelPluginManager.getInstance().getMetaModels().get(systemQName);
                return new SAXSource(new InputSource(systemMM.getBaseURI().toURL().openStream()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
        return null;
    }
}

