/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.generic_model;

import fr.emac.gind.commons.utils.xml.resolver.URIMultipleResolvers;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.AbstractManager;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.wsdl11.WSDLDefinitionsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;

public class GenericModelManager
extends AbstractManager<GJaxbGenericModel> {
    private WSDLDefinitionsManager wsdlDefinitionManager;

    public GenericModelManager(GJaxbGenericModel ... models) throws Exception {
        this(AbstractManager.Mode.FULL, (URIResolver)new URIMultipleResolvers(), null, null, models);
    }

    public GenericModelManager(AbstractManager.Mode mode, GJaxbGenericModel ... models) throws Exception {
        this(mode, (URIResolver)new URIMultipleResolvers(), null, null, models);
    }

    public GenericModelManager(AbstractManager.Mode mode, URIResolver resolver, AbstractManager<?> parent, Map<QName, Class<? extends AbstractJaxbObject>> jaxbSpecificImportResolver, GJaxbGenericModel ... models) throws Exception {
        super(mode, resolver, parent, jaxbSpecificImportResolver, (AbstractJaxbObject[])models);
    }

    public void init() throws Exception {
    }

    public GJaxbGenericModel findModelForNode(GJaxbNode node) {
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbNode n : model.getNode()) {
                if (!n.getId().trim().equals(node.getId().trim())) continue;
                return model;
            }
        }
        return null;
    }

    public List<GJaxbEdge> findEdgesOfNode(GJaxbNode node) {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        GJaxbGenericModel model = this.findModelForNode(node);
        for (GJaxbEdge edge : model.getEdge()) {
            if (edge.getSource() != null && edge.getSource().getId() == node.getId()) {
                edges.add(edge);
            }
            if (edge.getTarget() == null || edge.getTarget().getId() != node.getId()) continue;
            edges.add(edge);
        }
        return edges;
    }

    public void findConnectedEdgesUsingNames(String nameCol, String nameRow) {
    }

    public List<GJaxbEdge> findConnectedEdges(GJaxbNode node1, GJaxbNode node2) {
        List<GJaxbEdge> edges1 = this.findEdgesOfNode(node1);
        List<GJaxbEdge> edges2 = this.findEdgesOfNode(node2);
        edges1.retainAll(edges2);
        return edges1;
    }

    public List<GJaxbEdge> findInputEdgesOfNode(GJaxbNode node) {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        GJaxbGenericModel model = this.findModelForNode(node);
        for (GJaxbEdge edge : model.getEdge()) {
            if (edge.getTarget() == null || !edge.getTarget().getId().equals(node.getId())) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List<GJaxbEdge> findOutputEdgesOfNode(GJaxbNode node) {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        GJaxbGenericModel model = this.findModelForNode(node);
        if (model != null) {
            for (GJaxbEdge edge : model.getEdge()) {
                if (edge.getSource() == null) continue;
                if (edge.getSource().getId() == null) {
                    throw new RuntimeException("edge source node has no id");
                }
                if (!edge.getSource().getId().equals(node.getId())) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public List<GJaxbNode> getNodesByType(QName type) {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        for (GJaxbGenericModel model : this.models) {
            if (model == null) continue;
            List nodesFound = model.getNode().stream().filter(n -> n.getType().equals(type) || n.getExtends() != null && n.getExtends().contains(type)).collect(Collectors.toList());
            nodes.addAll(nodesFound);
        }
        return nodes;
    }

    public List<GJaxbNode> getNodesByProperty(String name, Object value) {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        for (GJaxbGenericModel model : this.models) {
            if (model == null) continue;
            for (GJaxbNode n : model.getNode()) {
                GJaxbProperty prop = GenericModelHelper.findProperty(name, n.getProperty());
                if (prop == null || prop.getValue() == null || !prop.getValue().equals(value)) continue;
                nodes.add(n);
            }
        }
        return nodes;
    }

    public List<GJaxbNode> getNodesByType(QName type, GJaxbNode parent) throws Exception {
        return this.getChildNodes(parent).stream().filter(n -> n.getType().equals(type) || n.getExtends() != null && n.getExtends().contains(type)).collect(Collectors.toList());
    }

    public List<GJaxbEdge> getEdgesByType(QName type) {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbEdge e : model.getEdge()) {
                if (e.getType() == null || !e.getType().getLocalPart().trim().equals(type.getLocalPart().trim()) || !e.getType().getNamespaceURI().trim().equals(type.getNamespaceURI().trim())) continue;
                edges.add(e);
            }
        }
        return edges;
    }

    public List<GJaxbNode> getNodes() {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbNode n : model.getNode()) {
                nodes.add(n);
            }
        }
        return nodes;
    }

    public GJaxbNode getNodeById(String id) {
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbNode n : model.getNode()) {
                if (!n.getId().equals(id)) continue;
                return n;
            }
        }
        return null;
    }

    public List<GJaxbEdge> getEdges() {
        ArrayList<GJaxbEdge> edges = new ArrayList<GJaxbEdge>();
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbEdge e : model.getEdge()) {
                edges.add(e);
            }
        }
        return edges;
    }

    public GJaxbEdge getEdgeById(String id) {
        for (GJaxbGenericModel model : this.models) {
            for (GJaxbEdge e : model.getEdge()) {
                if (!e.getId().equals(id)) continue;
                return e;
            }
        }
        return null;
    }

    public List<GJaxbNode> getChildNodes(GJaxbNode parent) throws Exception {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        GJaxbGenericModel model = this.findModelForNode(parent);
        for (GJaxbNode node : model.getNode()) {
            List<GJaxbNode> parentsOfNode = GenericModelHelper.findParents(node, model);
            if (parentsOfNode == null || !GenericModelHelper.contains(parent, parentsOfNode)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public List<GJaxbNode> getRecursiveChildNodes(GJaxbNode parent) throws Exception {
        ArrayList<GJaxbNode> nodes = new ArrayList<GJaxbNode>();
        GJaxbGenericModel model = this.findModelForNode(parent);
        for (GJaxbNode node : model.getNode()) {
            List<GJaxbNode> parentsOfNode = GenericModelHelper.findParents(node, model);
            if (parentsOfNode == null || !GenericModelHelper.contains(parent, parentsOfNode)) continue;
            nodes.add(node);
            nodes.addAll(this.getRecursiveChildNodes(node));
        }
        return nodes;
    }

    public WSDLDefinitionsManager getWSDLDefinitionsManager() {
        return this.wsdlDefinitionManager;
    }

    public void setWsdlDefinitionsManager(WSDLDefinitionsManager wsdlManager) {
        this.wsdlDefinitionManager = wsdlManager;
    }

    public List<GJaxbNode> findEndingNodes(GJaxbNode anyNode) {
        GJaxbGenericModel model = this.findModelForNode(anyNode);
        return model.getNode().parallelStream().filter(node -> this.findOutputEdgesOfNode((GJaxbNode)((Object)node)).isEmpty()).collect(Collectors.toList());
    }

    public List<GJaxbNode> getNodesThatInherit(QName type) throws Exception {
        List validTypes = EffectiveMetaModelPluginManager.getInstance().getImplements(type).stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
        validTypes.add(type);
        List<GJaxbNode> inheritsNodes = this.getNodes().stream().filter(n -> validTypes.contains(n.getType())).collect(Collectors.toList());
        return inheritsNodes;
    }
}

