/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.effective_meta_model;

import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRules;
import fr.emac.gind.modeler.metamodel.GJaxbContainmentRule;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbImport;
import fr.emac.gind.modeler.metamodel.GJaxbImportedNode;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.modeler.metamodel.GJaxbPackage;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.modeler.metamodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.metamodel.GJaxbRules;
import fr.emac.gind.models.generic.modeler.PackageManager;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelHelper;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;

public class EffectiveMetaModelHelper {
    public static GJaxbEffectiveConceptType createEffectiveConcept(GJaxbConceptType concept, GJaxbEffectiveMetaModel effMetaModel) throws Exception {
        GJaxbEffectiveConceptType effConcept = new GJaxbEffectiveConceptType();
        effConcept.setType(concept.getType());
        if (effMetaModel != null) {
            EffectiveMetaModelHelper.addExtends(effConcept, effMetaModel);
        }
        effConcept.setAbstract(concept.isAbstract());
        effConcept.setReadonly(concept.isReadonly());
        effConcept.setDescription(concept.getDescription());
        effConcept.setBrokenRelations(new GJaxbEffectiveConceptType.BrokenRelations());
        effConcept.setNodeMetaGeolocation(concept.getNodeMetaGeolocation());
        effConcept.setNodeMetaModeling(concept.getNodeMetaModeling());
        effConcept.setEvents(concept.getEvents());
        effConcept.getMetaProperty().addAll(concept.getMetaProperty());
        return effConcept;
    }

    private static void addExtends(GJaxbEffectiveConceptType effConcept, GJaxbEffectiveMetaModel effMetaModel) throws Exception {
        EffectiveMetaModelManager effMan = new EffectiveMetaModelManager(effMetaModel);
        List<GJaxbConceptType> parents = effMan.getInherits(effConcept.getType());
        EffectiveMetaModelHelper.extendsEffectiveConcept(effConcept, parents);
        parents.forEach(parent -> {
            if (!effConcept.getExtends().contains(parent.getType())) {
                effConcept.getExtends().add(parent.getType());
            }
        });
    }

    public static GJaxbEffectiveMetaModel generateEffectiveMetaModelFromMetaModel(GJaxbMetaModel metaModel) throws Exception {
        MetaModelManager mms = new MetaModelManager(metaModel);
        GJaxbEffectiveMetaModel effModel = new GJaxbEffectiveMetaModel();
        effModel.setTargetNamespace(metaModel.getTargetNamespace());
        effModel.setName(metaModel.getName());
        effModel.setRules(new GJaxbRules());
        effModel.getRules().setConnectionRules(new GJaxbConnectionRules());
        mms.getConnectionRules().forEach(rule -> effModel.getRules().getConnectionRules().getConnectionRule().add((GJaxbConnectionRule)((Object)rule)));
        for (GJaxbConceptType node : mms.getConcepts()) {
            effModel.getEffectiveConcept().add(EffectiveMetaModelHelper.createEffectiveConcept(node, null));
        }
        mms.getRelations().forEach(edge -> effModel.getRelation().add((GJaxbRelation)((Object)edge)));
        for (GJaxbEffectiveConceptType ec : effModel.getEffectiveConcept()) {
            EffectiveMetaModelHelper.addExtends(ec, effModel);
        }
        return effModel;
    }

    public static GJaxbEffectiveMetaModel generateEffectiveMetaModelFromPackage(GJaxbPackage _package, PackageManager ... packageManagers) throws Exception {
        PackageManager packageManager = null;
        packageManager = packageManagers != null && packageManagers.length == 1 ? packageManagers[0] : new PackageManager(Map.of(new QName("http://www.gind.emac.fr/modeler/metaModel", "package"), GJaxbPackage.class), _package);
        ArrayList<GJaxbEffectiveMetaModel> effModels = new ArrayList<GJaxbEffectiveMetaModel>();
        ArrayList<GJaxbMetaModel> metaModels = new ArrayList<GJaxbMetaModel>();
        for (GJaxbImport impt : _package.getImport()) {
            for (AbstractJaxbObject mmo : packageManager.getAdoptedChildren()) {
                GJaxbPackage importedPackage;
                GJaxbEffectiveMetaModel effmm;
                if (mmo instanceof GJaxbMetaModel) {
                    GJaxbMetaModel mm = (GJaxbMetaModel)mmo;
                    if (!mm.getTargetNamespace().equals(impt.getNamespace())) continue;
                    effmm = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(mm);
                    effModels.add(effmm);
                    metaModels.add(mm);
                    continue;
                }
                if (!(mmo instanceof GJaxbPackage) || mmo == _package || !(importedPackage = (GJaxbPackage)mmo).getTargetNamespace().equals(impt.getNamespace())) continue;
                effmm = EffectiveMetaModelHelper.generateEffectiveMetaModelFromPackage(importedPackage, new PackageManager[0]);
                effModels.add(effmm);
                GJaxbMetaModel mm = new GJaxbMetaModel();
                mm.getConcept().addAll(effmm.getEffectiveConcept());
                mm.getRelation().addAll(effmm.getRelation());
                mm.setRules(effmm.getRules());
                metaModels.add(mm);
                _package.getImportedNode().addAll(importedPackage.getImportedNode());
                if (!_package.isSetRules()) {
                    _package.setRules(new GJaxbPackage.Rules());
                    _package.getRules().setContainmentRule(new GJaxbContainmentRule());
                }
                _package.getRules().getContainmentRule().getContain().addAll(importedPackage.getRules().getContainmentRule().getContain());
            }
        }
        GJaxbEffectiveMetaModel effMetaModel = EffectiveMetaModelHelper.createMergedEffectiveMetaModelFromPackage(new QName(_package.getTargetNamespace(), _package.getName()), new ArrayList<GJaxbImportedNode>(_package.getImportedNode()), metaModels);
        return effMetaModel;
    }

    public static GJaxbEffectiveMetaModel createMergedEffectiveMetaModelFromPackage(QName packageQName, List<GJaxbImportedNode> importedNodes, List<GJaxbMetaModel> metaModels) throws Exception {
        MetaModelManager mms = new MetaModelManager(metaModels.toArray(new GJaxbMetaModel[metaModels.size()]));
        GJaxbEffectiveMetaModel effModel = new GJaxbEffectiveMetaModel();
        effModel.setTargetNamespace(packageQName.getNamespaceURI());
        effModel.setName(packageQName.getLocalPart());
        effModel.setRules(new GJaxbRules());
        effModel.getRules().setConnectionRules(new GJaxbConnectionRules());
        EffectiveMetaModelHelper.addImportedConcepts(effModel.getEffectiveConcept(), importedNodes, mms);
        List<QName> validConceptTypes = new ArrayList();
        for (GJaxbEffectiveConceptType effConcept : effModel.getEffectiveConcept()) {
            validConceptTypes.add(effConcept.getType());
            validConceptTypes.addAll(effConcept.getExtends());
        }
        validConceptTypes = ListUtil.deleteDuplicate(validConceptTypes);
        for (GJaxbConnectionRule rule : mms.getConnectionRules()) {
            if (!validConceptTypes.contains(rule.getTo()) && !validConceptTypes.contains(rule.getFrom())) continue;
            effModel.getRules().getConnectionRules().getConnectionRule().add(rule);
        }
        for (GJaxbEffectiveConceptType ec : effModel.getEffectiveConcept()) {
            EffectiveMetaModelHelper.addExtends(ec, effModel);
        }
        for (GJaxbEffectiveConceptType concept : effModel.getEffectiveConcept()) {
            if (concept.getType().getLocalPart().toLowerCase().equals("kid")) {
                System.out.println("kid");
            }
            Map<GJaxbRelation, List<GJaxbConnectionRule>> brokenEdges = EffectiveMetaModelHelper.findBrokenRelations(concept, effModel, importedNodes, mms);
            EffectiveMetaModelHelper.addBrokenRelationsToConcept(concept, brokenEdges, mms);
        }
        for (GJaxbRelation edge : mms.getRelations()) {
            if (effModel.getRules().getConnectionRules().getConnectionRule().stream().filter(r -> r.getRelationType().equals(edge.getType())).count() <= 0L) continue;
            effModel.getRelation().add(edge);
        }
        return effModel;
    }

    private static void addBrokenRelationsToConcept(GJaxbEffectiveConceptType concept, Map<GJaxbRelation, List<GJaxbConnectionRule>> brokenEdges, MetaModelManager mms) {
        for (GJaxbRelation relation : brokenEdges.keySet()) {
            if (relation == null || EffectiveMetaModelHelper.containsRelation(concept.getBrokenRelations().getRelation(), relation.getType())) continue;
            concept.getBrokenRelations().getRelation().add(relation);
        }
    }

    private static void addImportedConcepts(List<GJaxbEffectiveConceptType> concepts, List<GJaxbImportedNode> importedNodes, MetaModelManager mms) throws Exception {
        for (GJaxbImportedNode importedNode : importedNodes) {
            assert (importedNode.getRef() != null) : "null reference in model: " + String.valueOf(importedNode.getNaturalParent().getBaseURI());
            GJaxbConceptType concept = mms.getConceptByType(importedNode.getRef());
            if (concept == null) {
                throw new Exception("Impossible to find imported node: " + String.valueOf(importedNode.getRef()));
            }
            if (EffectiveMetaModelHelper.containsConcept(concepts, concept.getType())) continue;
            GJaxbEffectiveConceptType effConcept = EffectiveMetaModelHelper.createEffectiveConcept(concept, null);
            concepts.add(effConcept);
            List<GJaxbConceptType> parents = mms.getInherits(concept);
            EffectiveMetaModelHelper.extendsEffectiveConcept(effConcept, parents);
            for (GJaxbConceptType parent : parents) {
                if (EffectiveMetaModelHelper.containsConcept(concepts, parent.getType())) continue;
                GJaxbEffectiveConceptType effParent = EffectiveMetaModelHelper.createEffectiveConcept(parent, null);
                concepts.add(effParent);
            }
            List<GJaxbConceptType> aggregateOrComposeChilds = mms.getAggregateOrComposeChildConcepts(concept);
            if (aggregateOrComposeChilds.size() > 0) {
                ArrayList<GJaxbImportedNode> aggregateOrComposeImportedNodes = new ArrayList<GJaxbImportedNode>();
                aggregateOrComposeChilds.forEach(c -> {
                    if (!EffectiveMetaModelHelper.containsConcept(concepts, c.getType())) {
                        GJaxbImportedNode in = new GJaxbImportedNode();
                        in.setRef(c.getType());
                        aggregateOrComposeImportedNodes.add(in);
                    }
                });
                if (aggregateOrComposeImportedNodes.size() > 0) {
                    EffectiveMetaModelHelper.addImportedConcepts(concepts, aggregateOrComposeImportedNodes, mms);
                }
            }
            if (importedNode.getRedefine() == null) continue;
            for (GJaxbMetaProperty prop : importedNode.getRedefine().getMetaProperty()) {
                GJaxbMetaProperty parentProp = MetaModelHelper.findMetaProperty(prop.getName(), effConcept.getMetaProperty());
                if (parentProp != null) {
                    int indexOf = effConcept.getMetaProperty().indexOf((Object)parentProp);
                    effConcept.getMetaProperty().remove((Object)parentProp);
                    effConcept.getMetaProperty().add(indexOf, prop);
                    continue;
                }
                effConcept.getMetaProperty().add(prop);
            }
        }
    }

    private static synchronized void extendsEffectiveConcept(GJaxbEffectiveConceptType concept, List<GJaxbConceptType> inheritParents) throws Exception {
        if (inheritParents.size() > 0) {
            for (GJaxbConceptType parent : inheritParents) {
                concept.getExtends().add(parent.getType());
                if (!concept.isSetEvents()) {
                    concept.setEvents(new GJaxbConceptType.Events());
                }
                if (parent.isSetEvents()) {
                    concept.getEvents().getBeforeSaved().addAll(parent.getEvents().getBeforeSaved());
                    concept.getEvents().getAfterSaved().addAll(parent.getEvents().getAfterSaved());
                }
                if (!concept.isSetNodeMetaModeling()) {
                    concept.setNodeMetaModeling(parent.getNodeMetaModeling());
                }
                if (!concept.isSetNodeMetaGeolocation()) {
                    concept.setNodeMetaGeolocation(parent.getNodeMetaGeolocation());
                }
                for (GJaxbMetaProperty parentProp : parent.getMetaProperty()) {
                    GJaxbMetaProperty childProp = MetaModelHelper.propertyAlreadyExist(concept.getMetaProperty(), parentProp);
                    if (childProp == null) {
                        childProp = (GJaxbMetaProperty)((Object)GenericModelHelper.clone(parentProp, ((Object)((Object)parentProp)).getClass()));
                        childProp.setInheritFromConcept(parent.getType());
                        concept.getMetaProperty().add(parentProp);
                        continue;
                    }
                    MetaModelHelper.overridePropertyParameters(childProp, parentProp);
                    childProp.setInheritFromConcept(parent.getType());
                }
            }
        }
    }

    public static Map<GJaxbRelation, List<GJaxbConnectionRule>> findBrokenRelations(GJaxbEffectiveConceptType concept, GJaxbEffectiveMetaModel effMetaModel, List<GJaxbImportedNode> importedNodes, MetaModelManager mms) throws Exception {
        HashMap<GJaxbRelation, List<GJaxbConnectionRule>> brokenRelations = new HashMap<GJaxbRelation, List<GJaxbConnectionRule>>();
        ArrayList<QName> sourceValidTypes = new ArrayList<QName>(concept.getExtends());
        sourceValidTypes.add(concept.getType());
        List rulesWhereNodeIsFrom = mms.getConnectionRules().stream().filter(rule -> rule.getMode().equals((Object)GJaxbRelationModeType.ASSOCIATION) && sourceValidTypes.contains(rule.getFrom())).collect(Collectors.toList());
        for (GJaxbConnectionRule rule2 : rulesWhereNodeIsFrom) {
            boolean broken = true;
            if (!broken) continue;
            GJaxbRelation brokenRelation = mms.getRelationByType(rule2.getRelationType());
            if (brokenRelations.get((Object)brokenRelation) == null) {
                brokenRelations.put(brokenRelation, new ArrayList());
            }
            ((List)brokenRelations.get((Object)brokenRelation)).add(rule2);
        }
        return brokenRelations;
    }

    private static boolean containsConcept(List<GJaxbEffectiveConceptType> list, QName currentNodeType) {
        for (GJaxbConceptType gJaxbConceptType : list) {
            if (gJaxbConceptType.getType() == null || !gJaxbConceptType.getType().equals(currentNodeType)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsRelation(List<GJaxbRelation> list, QName type) {
        for (GJaxbRelation relation : list) {
            if (!relation.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static GJaxbEffectiveMetaModel cloneEffectiveMetaModel(GJaxbEffectiveMetaModel effmm) throws Exception {
        String json = JSONJAXBContext.getInstance().marshallAnyElement((Object)effmm);
        GJaxbEffectiveMetaModel model = (GJaxbEffectiveMetaModel)((Object)JSONJAXBContext.getInstance().unmarshall(json, GJaxbEffectiveMetaModel.class));
        return model;
    }

    public static GJaxbEffectiveMetaModel mergeEffectiveMetaModel(List<GJaxbEffectiveMetaModel> effMMList) throws Exception {
        GJaxbEffectiveMetaModel effModel = new GJaxbEffectiveMetaModel();
        if (effMMList.size() > 0) {
            int i;
            effModel.setName(effMMList.get(0).getName());
            for (GJaxbEffectiveMetaModel mm : effMMList) {
                if (mm.getName() == null) continue;
                effModel.getMergedMetaModel().add(new QName(mm.getTargetNamespace(), mm.getName()));
            }
            effModel.getEffectiveConcept().addAll(effMMList.get(0).getEffectiveConcept());
            for (i = 1; i < effMMList.size(); ++i) {
                GJaxbEffectiveMetaModel currentEffModel2 = effMMList.get(i);
                for (GJaxbConceptType gJaxbConceptType : currentEffModel2.getEffectiveConcept()) {
                    if (EffectiveMetaModelHelper.containsConcept(effModel.getEffectiveConcept(), gJaxbConceptType.getType())) continue;
                    effModel.getEffectiveConcept().add((GJaxbEffectiveConceptType)((Object)GenericModelHelper.clone(gJaxbConceptType, ((Object)((Object)gJaxbConceptType)).getClass())));
                }
            }
            effModel.getRelation().addAll(effMMList.get(0).getRelation());
            for (i = 1; i < effMMList.size(); ++i) {
                GJaxbEffectiveMetaModel currentEffModel = effMMList.get(i);
                for (GJaxbRelation gJaxbRelation : currentEffModel.getRelation()) {
                    if (MetaModelHelper.containsRelation(effModel.getRelation(), gJaxbRelation)) continue;
                    effModel.getRelation().add((GJaxbRelation)((Object)GenericModelHelper.clone(gJaxbRelation, ((Object)((Object)gJaxbRelation)).getClass())));
                }
            }
            effModel.setRules(new GJaxbRules());
            effModel.getRules().setConnectionRules(new GJaxbConnectionRules());
            for (GJaxbEffectiveMetaModel currentEffModel : effMMList) {
                if (currentEffModel.getRules() == null || currentEffModel.getRules().getConnectionRules() == null) continue;
                for (GJaxbConnectionRule gJaxbConnectionRule : currentEffModel.getRules().getConnectionRules().getConnectionRule()) {
                    if (MetaModelHelper.containsConnectionRule(effModel.getRules().getConnectionRules().getConnectionRule(), gJaxbConnectionRule)) continue;
                    effModel.getRules().getConnectionRules().getConnectionRule().add((GJaxbConnectionRule)((Object)GenericModelHelper.clone(gJaxbConnectionRule, ((Object)((Object)gJaxbConnectionRule)).getClass())));
                }
            }
        }
        return effModel;
    }

    public static void addConcept(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbEffectiveConceptType concept) {
        effectiveMetaModel.getEffectiveConcept().add(concept);
    }

    public static void updateConcept(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbEffectiveConceptType concept) {
        GJaxbEffectiveConceptType foundConcept = EffectiveMetaModelHelper.getConceptByType(effectiveMetaModel, concept.getType());
        foundConcept.setAbstract(concept.isAbstract());
        foundConcept.setBrokenRelations(concept.getBrokenRelations());
        foundConcept.setDescription(concept.getDescription());
        foundConcept.setNodeMetaGeolocation(concept.getNodeMetaGeolocation());
        foundConcept.setNodeMetaModeling(concept.getNodeMetaModeling());
        foundConcept.setEvents(concept.getEvents());
        foundConcept.getExtends().clear();
        foundConcept.getExtends().addAll(concept.getExtends());
        foundConcept.getMetaProperty().clear();
        foundConcept.getMetaProperty().addAll(concept.getMetaProperty());
    }

    public static void removeConcept(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbEffectiveConceptType concept) {
        effectiveMetaModel.getEffectiveConcept().removeIf(ec -> ec.getType().equals(concept.getType()));
    }

    public static GJaxbEffectiveConceptType getConceptByType(GJaxbEffectiveMetaModel effectiveMetaModel, QName type) {
        GJaxbEffectiveConceptType foundConcept = null;
        if (type != null) {
            for (GJaxbEffectiveConceptType c : effectiveMetaModel.getEffectiveConcept()) {
                if (!type.equals(c.getType())) continue;
                foundConcept = c;
                break;
            }
        }
        return foundConcept;
    }

    public static GJaxbEffectiveConceptType getConceptByLocalPartType(GJaxbEffectiveMetaModel effectiveMetaModel, String type) {
        GJaxbEffectiveConceptType foundConcept = null;
        if (type != null) {
            for (GJaxbEffectiveConceptType c : effectiveMetaModel.getEffectiveConcept()) {
                if (!type.trim().equals(c.getType().getLocalPart().trim())) continue;
                foundConcept = c;
                break;
            }
        }
        return foundConcept;
    }

    public static void addRelation(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbRelation relation) {
        effectiveMetaModel.getRelation().add(relation);
    }

    public static void updateRelation(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbRelation relation) {
        GJaxbRelation foundRelation = EffectiveMetaModelHelper.getRelationByType(effectiveMetaModel, relation.getType());
        foundRelation.setDescription(relation.getDescription());
        foundRelation.setEdgeMetaModeling(relation.getEdgeMetaModeling());
        foundRelation.setType(relation.getType());
        foundRelation.getMetaProperty().clear();
        foundRelation.getMetaProperty().addAll(relation.getMetaProperty());
    }

    public static GJaxbRelation getRelationByType(GJaxbEffectiveMetaModel effectiveMetaModel, QName type) {
        GJaxbRelation foundRelation = null;
        for (GJaxbRelation r : effectiveMetaModel.getRelation()) {
            if (!type.equals(r.getType())) continue;
            foundRelation = r;
            break;
        }
        return foundRelation;
    }

    public static void removeRelation(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbRelation relation) {
        effectiveMetaModel.getRelation().removeIf(ec -> ec.getType().equals(relation.getType()));
    }

    public static void addConnexionRule(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbConnectionRule rule) {
        effectiveMetaModel.getRules().getConnectionRules().getConnectionRule().add(rule);
    }

    public static void updateConnexionRule(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbConnectionRule rule) {
        GJaxbConnectionRule foundConnectionRule = EffectiveMetaModelHelper.getConnexionRuleByRelationTypeAndFromAndTo(effectiveMetaModel, rule.getRelationType(), rule.getFrom(), rule.getTo());
        foundConnectionRule.setCardinalityRule(rule.getCardinalityRule());
        foundConnectionRule.setFrom(rule.getFrom());
        foundConnectionRule.setMode(rule.getMode());
        foundConnectionRule.setModeling(rule.getModeling());
        foundConnectionRule.setRelationType(rule.getRelationType());
        foundConnectionRule.setTo(rule.getTo());
        foundConnectionRule.getExcludeOnFrom().clear();
        foundConnectionRule.getExcludeOnFrom().addAll(rule.getExcludeOnFrom());
        foundConnectionRule.getExcludeOnTo().clear();
        foundConnectionRule.getExcludeOnTo().addAll(rule.getExcludeOnTo());
    }

    public static GJaxbConnectionRule getConnexionRuleByRelationTypeAndFromAndTo(GJaxbEffectiveMetaModel effectiveMetaModel, QName relationType, QName from, QName to) {
        GJaxbConnectionRule foundRelation = null;
        for (GJaxbConnectionRule r : effectiveMetaModel.getRules().getConnectionRules().getConnectionRule()) {
            if (!relationType.equals(r.getRelationType()) || !r.getFrom().equals(from) || !r.getTo().equals(to)) continue;
            foundRelation = r;
            break;
        }
        return foundRelation;
    }

    public static void removeConnexionRule(GJaxbEffectiveMetaModel effectiveMetaModel, GJaxbConnectionRule rule) {
        effectiveMetaModel.getRules().getConnectionRules().getConnectionRule().removeIf(ec -> ec.getRelationType().equals(rule.getRelationType()) && ec.getFrom().equals(rule.getFrom()) && ec.getTo().equals(rule.getTo()));
    }
}

