/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.plugins;

import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbContainmentRule;
import fr.emac.gind.modeler.metamodel.GJaxbDomain;
import fr.emac.gind.modeler.metamodel.GJaxbDomainDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbEffectivePackage;
import fr.emac.gind.modeler.metamodel.GJaxbImportedNode;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbPackage;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.models.generic.modeler.PackageManager;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.plugins.AbstractMetaModelPlugin;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.models.generic.modeler.plugins.MetaModelPluginsManager;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValdiationModelTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractValdiationModelTest.class.getName());
    protected AbstractMetaModelPlugin plugin = null;
    private Validator validator = null;

    public AbstractValdiationModelTest(AbstractMetaModelPlugin plugin) throws Exception {
        this.plugin = plugin;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(Thread.currentThread().getContextClassLoader().getResource("schema/metaModel.xsd"));
        this.validator = schema.newValidator();
    }

    @Test
    public void validateXMLSchema() throws Exception {
        if (this.plugin.getMetaModels() != null) {
            for (URL metaModelUrl : this.plugin.getMetaModels()) {
                LOG.debug("metaModelUrl = " + String.valueOf(metaModelUrl));
                this.validator.validate(new StreamSource(metaModelUrl.openStream()));
            }
        }
        if (this.plugin.getPackages() != null) {
            for (URL containerUrl : this.plugin.getPackages()) {
                this.validator.validate(new StreamSource(containerUrl.openStream()));
            }
        }
        if (this.plugin.getDomains() != null) {
            for (URL containerUrl : this.plugin.getDomains()) {
                this.validator.validate(new StreamSource(containerUrl.openStream()));
            }
        }
    }

    @Test
    public void validEffectiveMetaModel() throws Exception {
        if (this.plugin.getMetaModels() != null) {
            for (URL metaModelUrl : this.plugin.getMetaModels()) {
                GJaxbMetaModel metaModel = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(metaModelUrl, GJaxbMetaModel.class);
                GJaxbEffectiveMetaModel effMetaModel = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(metaModel);
                EffectiveMetaModelManager effMMS = new EffectiveMetaModelManager(effMetaModel);
                Assertions.assertNotNull((Object)((Object)effMMS));
                LOG.debug("Analyse: " + String.valueOf(metaModelUrl));
                LOG.debug("Concepts detected: ");
                effMMS.getConcepts().forEach(node -> {
                    System.out.print(node.getType());
                    if (node.isSetAbstract() && node.isAbstract().booleanValue()) {
                        System.out.print(" (abstract)");
                    }
                    LOG.debug("");
                });
                LOG.debug("");
                LOG.debug("");
                LOG.debug("Relations detected: ");
                effMMS.getRelations().forEach(edge -> LOG.debug(edge.getType().toString()));
                for (GJaxbConnectionRule rule : effMMS.getConnectionRules()) {
                    if (effMMS.getRelationByType(rule.getRelationType()) == null) {
                        throw new Exception("[CONNECITON RULE ERROR]: Impossible to find edge: " + String.valueOf(rule.getRelationType()));
                    }
                    if (effMMS.getConceptByType(rule.getFrom()) == null) {
                        throw new Exception("[CONNECITON RULE ERROR]: Impossible to find concept in from: " + String.valueOf(rule.getFrom()));
                    }
                    if (effMMS.getConceptByType(rule.getTo()) != null) continue;
                    throw new Exception("[CONNECITON RULE ERROR]: Impossible to find concept in to: " + String.valueOf(rule.getTo()));
                }
            }
        }
    }

    @Test
    public void createEffectiveMetaModelFromExistingPackage() throws Exception {
        if (this.plugin.getPackages() != null) {
            for (URL packageUrl : this.plugin.getPackages()) {
                LOG.debug("packageUrl = " + String.valueOf(packageUrl));
                GJaxbPackage packageModel = (GJaxbPackage)XMLJAXBContext.getInstance().unmarshallDocument(packageUrl, GJaxbPackage.class);
                GJaxbEffectiveMetaModel effMModel = EffectiveMetaModelHelper.generateEffectiveMetaModelFromPackage(packageModel, new PackageManager[0]);
                Assertions.assertNotNull((Object)((Object)effMModel));
            }
        }
    }

    @Test
    public void createEffectiveDomainFromDomainDefinition() throws Exception {
        if (this.plugin.getDomains() != null) {
            for (URL domainUrl : this.plugin.getDomains()) {
                LOG.debug("domainUrl = " + String.valueOf(domainUrl));
                GJaxbDomain domain = (GJaxbDomain)XMLJAXBContext.getInstance().unmarshallDocument(domainUrl, GJaxbDomain.class);
                GJaxbDomainDefinition domainDef = EffectiveMetaModelPluginManager.getInstance().findDomainDefinitionByName(domain.getName());
                GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromDefinition(domainDef);
                for (GJaxbEffectivePackage _package : effDomain.getEffectivePackage()) {
                    LOG.debug("packageQName: " + String.valueOf(new QName(_package.getTargetNamespace(), _package.getName())));
                    Assertions.assertTrue((_package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().size() > 0 ? 1 : 0) != 0);
                    for (GJaxbImportedNode imptNode : _package.getImportedNode()) {
                        if (_package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().stream().filter(c -> c.getType().equals(imptNode.getRef())).count() != 0L) continue;
                        throw new Exception("[IMPORTED NODE ERROR]: Impossible to find concept: " + String.valueOf(imptNode.getRef()));
                    }
                    for (GJaxbContainmentRule.Contain _contain : _package.getRules().getContainmentRule().getContain()) {
                        Optional<GJaxbEffectiveConceptType> concept = _package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().stream().filter(c -> c.getType().equals(_contain.getType())).findFirst();
                        if (concept.isEmpty()) {
                            throw new Exception("[CONTAINMENT RULE ERROR]: Impossible to find concept: " + String.valueOf(_contain.getType()));
                        }
                        if (!concept.get().isSetAbstract() || !concept.get().isAbstract().booleanValue()) continue;
                        throw new Exception("[CONTAINMENT RULE ERROR]: Impossible to contains an abstract concept: " + String.valueOf(_contain.getType()));
                    }
                    Map<GJaxbConceptType, Map<GJaxbRelation, List<GJaxbConnectionRule>>> brokenRelationsByConcept = EffectiveMetaModelPluginManager.getInstance().findBrokenRelations(new QName(_package.getTargetNamespace(), _package.getName()));
                    if (brokenRelationsByConcept.size() > 0) {
                        LOG.debug("\n\nbroken edges detected on package: " + String.valueOf(new QName(_package.getTargetNamespace(), _package.getName())));
                    }
                    for (Map.Entry<GJaxbConceptType, Map<GJaxbRelation, List<GJaxbConnectionRule>>> entryConcept : brokenRelationsByConcept.entrySet()) {
                        LOG.debug("concept has brokens edges: " + String.valueOf(entryConcept.getKey().getType()));
                        for (Map.Entry<GJaxbRelation, List<GJaxbConnectionRule>> entryRelation : entryConcept.getValue().entrySet()) {
                            LOG.debug("\tbroken relation: " + String.valueOf(entryRelation.getKey().getType()));
                            for (GJaxbConnectionRule rule : entryRelation.getValue()) {
                                LOG.debug("\t\t-rule: " + String.valueOf(rule.getFrom()) + "--- (" + String.valueOf(rule.getRelationType()) + ") -//--->" + String.valueOf(rule.getTo()));
                            }
                        }
                    }
                }
                Assertions.assertNotNull((Object)((Object)effDomain));
            }
        }
    }

    @Test
    public void verifyPluginDetection() throws Exception {
        AbstractMetaModelPlugin plugin = MetaModelPluginsManager.getInstance().findPluginByClass(this.plugin.getClass());
        Assertions.assertNotNull((Object)plugin);
    }

    @Test
    public void validDomain() throws Exception {
        AbstractMetaModelPlugin plugin = MetaModelPluginsManager.getInstance().findPluginByClass(this.plugin.getClass());
        Assertions.assertNotNull((Object)plugin);
        for (GJaxbDomainDefinition domainDef : EffectiveMetaModelPluginManager.getInstance().getDomainsDefinition()) {
            Assertions.assertNotNull((Object)((Object)domainDef));
            LOG.debug(EffectiveMetaModelPluginManager.getInstance().printDomainDefinition(domainDef));
            GJaxbEffectiveDomain effDomain = EffectiveMetaModelPluginManager.getInstance().createEffectiveDomainFromDefinition(domainDef);
            Assertions.assertNotNull((Object)((Object)effDomain));
            LOG.debug(EffectiveMetaModelPluginManager.getInstance().printEffectiveDomain(effDomain));
        }
    }
}

