/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.plugins;

import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRules;
import fr.emac.gind.modeler.metamodel.GJaxbContainmentRule;
import fr.emac.gind.modeler.metamodel.GJaxbDomain;
import fr.emac.gind.modeler.metamodel.GJaxbDomainDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbEffectivePackage;
import fr.emac.gind.modeler.metamodel.GJaxbImport;
import fr.emac.gind.modeler.metamodel.GJaxbImportedNode;
import fr.emac.gind.modeler.metamodel.GJaxbMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbPackage;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.modeler.metamodel.GJaxbRules;
import fr.emac.gind.models.generic.modeler.PackageManager;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelManager;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.meta_model.MetaModelManager;
import fr.emac.gind.models.generic.modeler.plugins.AbstractMetaModelPlugin;
import fr.emac.gind.models.generic.modeler.plugins.MetaModelPluginsManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveMetaModelPluginManager {
    private static Logger LOG = LoggerFactory.getLogger(EffectiveMetaModelPluginManager.class);
    private static EffectiveMetaModelPluginManager INSTANCE = null;
    private Map<QName, GJaxbEffectiveMetaModel> effectiveMetaModelFromPackageByQNameMap = new HashMap<QName, GJaxbEffectiveMetaModel>();
    private Map<QName, GJaxbEffectiveMetaModel> effectiveMetaModelFromMetaModelByQNameMap = new HashMap<QName, GJaxbEffectiveMetaModel>();
    private Map<QName, GJaxbPackage> packages = new HashMap<QName, GJaxbPackage>();
    private Map<QName, GJaxbMetaModel> metaModels = new HashMap<QName, GJaxbMetaModel>();
    private List<GJaxbDomainDefinition> domainsDefinition = new ArrayList<GJaxbDomainDefinition>();
    private EffectiveMetaModelManager effectiveMetaModelFromPackageManager = null;
    private EffectiveMetaModelManager effectiveMetaModelFromMetaModelManager = null;
    private Map<String, GJaxbEffectiveDomain> effectiveDomains = new HashMap<String, GJaxbEffectiveDomain>();
    private Map<QName, GJaxbEffectivePackage> mergedEffectivePackage = new HashMap<QName, GJaxbEffectivePackage>();
    private Map<String, Map<String, GJaxbEffectiveDomain>> cacheEffectiveDomainByKnowledgeSpaceByCollaboration = Collections.synchronizedMap(new HashMap());
    private GJaxbEffectiveDomain umlDomain = null;

    private EffectiveMetaModelPluginManager() throws Exception {
        ArrayList<GJaxbDomain> discoveredDomain = new ArrayList<GJaxbDomain>();
        for (AbstractMetaModelPlugin plugin : MetaModelPluginsManager.getInstance().getPlugins()) {
            GJaxbEffectiveMetaModel effMModel;
            LOG.warn("plugin class: " + plugin.getClass().getName());
            if (plugin.getPackages() != null) {
                for (URL packageUrl : plugin.getPackages()) {
                    if (packageUrl == null) continue;
                    GJaxbPackage packageModel = (GJaxbPackage)XMLJAXBContext.getInstance().unmarshallDocument(packageUrl, GJaxbPackage.class);
                    this.packages.put(new QName(packageModel.getTargetNamespace(), packageModel.getName()), packageModel);
                    effMModel = EffectiveMetaModelHelper.generateEffectiveMetaModelFromPackage(packageModel, new PackageManager[0]);
                    this.effectiveMetaModelFromPackageByQNameMap.put(new QName(packageModel.getTargetNamespace(), packageModel.getName()), effMModel);
                }
            }
            if (plugin.getMetaModels() != null) {
                for (URL modelUrl : plugin.getMetaModels()) {
                    if (modelUrl == null) continue;
                    GJaxbMetaModel model = (GJaxbMetaModel)XMLJAXBContext.getInstance().unmarshallDocument(modelUrl, GJaxbMetaModel.class);
                    this.metaModels.put(new QName(model.getTargetNamespace(), model.getName()), model);
                    effMModel = EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(model);
                    this.effectiveMetaModelFromMetaModelByQNameMap.put(new QName(model.getTargetNamespace(), model.getName()), effMModel);
                }
            }
            if (plugin.getDomains() == null) continue;
            for (URL domainUrl : plugin.getDomains()) {
                if (domainUrl == null) continue;
                GJaxbDomain domain = (GJaxbDomain)XMLJAXBContext.getInstance().unmarshallDocument(domainUrl, GJaxbDomain.class);
                discoveredDomain.add(domain);
            }
        }
        this.effectiveMetaModelFromPackageManager = new EffectiveMetaModelManager(this.effectiveMetaModelFromPackageByQNameMap.values().toArray(new GJaxbEffectiveMetaModel[this.effectiveMetaModelFromPackageByQNameMap.values().size()]));
        this.effectiveMetaModelFromMetaModelManager = new EffectiveMetaModelManager(this.effectiveMetaModelFromMetaModelByQNameMap.values().toArray(new GJaxbEffectiveMetaModel[this.effectiveMetaModelFromMetaModelByQNameMap.values().size()]));
        this.createDomainsDefinitions(discoveredDomain);
        GJaxbDomainDefinition umlDef = null;
        for (GJaxbDomainDefinition dd2 : this.domainsDefinition) {
            if (!dd2.getName().toLowerCase().equals("uml")) continue;
            umlDef = dd2;
            break;
        }
        this.domainsDefinition.removeIf(dd -> dd.getName().toLowerCase().equals("uml"));
        this.umlDomain = this.createEffectiveDomainFromDefinition(umlDef);
    }

    public GJaxbEffectiveDomain getUmlEffectiveDomain() {
        return this.umlDomain;
    }

    public List<GJaxbDomainDefinition> getDomainsDefinition() {
        return this.domainsDefinition;
    }

    public Map<QName, GJaxbPackage> getPackages() {
        return this.packages;
    }

    public Map<QName, GJaxbMetaModel> getMetaModels() {
        return this.metaModels;
    }

    public GJaxbEffectiveDomain createEffectiveDomainFromResources(GJaxbDomain domain, List<GJaxbPackage> _packages) throws Exception {
        GJaxbDomainDefinition domainDefinition = this.createDomainDefinition(domain, _packages);
        GJaxbEffectiveDomain effDomain = this.createEffectiveDomainFromDefinition(domainDefinition);
        this.effectiveDomains.put(effDomain.getName().toLowerCase(), effDomain);
        return effDomain;
    }

    public GJaxbEffectiveDomain createEffectiveDomainFromDefinition(GJaxbDomainDefinition def) throws Exception {
        GJaxbEffectiveDomain effDomain = new GJaxbEffectiveDomain();
        effDomain.setName(def.getName());
        effDomain.setPictureUrl(def.getPictureUrl());
        ArrayList<GJaxbEffectiveMetaModel> containersEffectiveMetaModels = new ArrayList<GJaxbEffectiveMetaModel>();
        boolean isCollaborativeDomain = false;
        for (GJaxbDomainDefinition.PackageDefinition cd : def.getPackageDefinition()) {
            GJaxbEffectivePackage effectivePackage = new GJaxbEffectivePackage();
            effectivePackage.setName(cd.getName());
            effectivePackage.setModeling(cd.getModeling());
            ArrayList<GJaxbPackage> packagesUsed = new ArrayList<GJaxbPackage>();
            for (QName packageQName : cd.getPackageMerged()) {
                packagesUsed.add(this.packages.get(packageQName));
                effectivePackage.getPackagesQName().add(packageQName);
            }
            effectivePackage.setTargetNamespace(effectivePackage.getPackagesQName().get(0).getNamespaceURI());
            PackageManager cvm = new PackageManager(Map.of(new QName("http://www.gind.emac.fr/modeler/metaModel", "package"), GJaxbPackage.class), packagesUsed.toArray(new GJaxbPackage[packagesUsed.size()]));
            List<GJaxbMetaModel> importedMetaModels = cvm.getChildsMetaModel();
            List<GJaxbPackage> importedPackages = cvm.getChildsPackage();
            List<GJaxbImportedNode> importedNodes = cvm.getImportedNodes();
            effectivePackage.setRules(new GJaxbEffectivePackage.Rules());
            effectivePackage.getRules().setContainmentRule(new GJaxbContainmentRule());
            for (GJaxbPackage importedPackage : importedPackages) {
                if (importedPackage.getRules() != null && importedPackage.getRules().getContainmentRule() != null) {
                    effectivePackage.getRules().getContainmentRule().getContain().addAll(importedPackage.getRules().getContainmentRule().getContain());
                }
                if (!importedPackage.getName().toLowerCase().equals("collaborative process")) continue;
                isCollaborativeDomain = true;
            }
            List<GJaxbMetaModel> excludedPackageMetaModels = this.findExcludedPackages(cd.getAdditionalPackageDetected(), cd.getAdditionalPackageSelected());
            List<GJaxbMetaModel> validImportedModels = this.findValidImportedMetaModels(importedMetaModels, excludedPackageMetaModels);
            validImportedModels.forEach(mm -> {
                if (effectivePackage.getImport().stream().filter(imp -> imp.getNamespace().equals(mm.getTargetNamespace())).count() == 0L) {
                    GJaxbImport imp2 = new GJaxbImport();
                    imp2.setNamespace(mm.getTargetNamespace());
                    effectivePackage.getImport().add(imp2);
                }
            });
            for (GJaxbImportedNode importedNode : importedNodes) {
                QName conceptQName = importedNode.getRef();
                boolean exclude = false;
                for (GJaxbMetaModel excludedPackageMetaModel : excludedPackageMetaModels) {
                    if (excludedPackageMetaModel.getConcept().stream().filter(n -> n.getType().equals(conceptQName)).count() <= 0L) continue;
                    exclude = true;
                }
                if (exclude || effectivePackage.getImportedNode().stream().filter(n -> n.getRef().equals(importedNode.getRef())).count() != 0L) continue;
                effectivePackage.getImportedNode().add(importedNode);
            }
            ArrayList<GJaxbEffectiveMetaModel> effMetaModels = new ArrayList<GJaxbEffectiveMetaModel>();
            for (GJaxbMetaModel mm2 : validImportedModels) {
                effMetaModels.add(EffectiveMetaModelHelper.generateEffectiveMetaModelFromMetaModel(mm2));
            }
            effectivePackage.setEffectiveMetaModelOfPackage(new GJaxbEffectivePackage.EffectiveMetaModelOfPackage());
            effectivePackage.getEffectiveMetaModelOfPackage().setEffectiveMetaModel(EffectiveMetaModelHelper.createMergedEffectiveMetaModelFromPackage(new QName(effectivePackage.getTargetNamespace(), effectivePackage.getName()), effectivePackage.getImportedNode(), validImportedModels));
            containersEffectiveMetaModels.add(effectivePackage.getEffectiveMetaModelOfPackage().getEffectiveMetaModel());
            effDomain.getEffectivePackage().add(effectivePackage);
            this.mergedEffectivePackage.put(new QName(effectivePackage.getTargetNamespace(), effectivePackage.getName()), effectivePackage);
        }
        effDomain.setGlobalEffectiveMetaModel(new GJaxbEffectiveDomain.GlobalEffectiveMetaModel());
        effDomain.getGlobalEffectiveMetaModel().setEffectiveMetaModel(EffectiveMetaModelHelper.mergeEffectiveMetaModel(containersEffectiveMetaModels));
        effDomain.setIsCollaborativeDomain(isCollaborativeDomain);
        this.effectiveDomains.put(effDomain.getName().toLowerCase(), effDomain);
        return effDomain;
    }

    public Map<String, GJaxbEffectiveDomain> getEffectiveDomains() {
        return this.effectiveDomains;
    }

    public Map<QName, GJaxbEffectivePackage> getMergedPackages() {
        return this.mergedEffectivePackage;
    }

    private List<GJaxbMetaModel> findValidImportedMetaModels(List<GJaxbMetaModel> importedMetaModels, List<GJaxbMetaModel> excludedPackageMetaModels) {
        ArrayList<GJaxbMetaModel> res = new ArrayList<GJaxbMetaModel>();
        for (GJaxbMetaModel mm : importedMetaModels) {
            if (excludedPackageMetaModels.stream().filter(exmm -> new QName(exmm.getTargetNamespace(), exmm.getName()).equals(new QName(mm.getTargetNamespace(), mm.getName()))).count() != 0L) continue;
            res.add(mm);
        }
        return res;
    }

    private List<GJaxbMetaModel> findExcludedPackages(List<GJaxbDomainDefinition.PackageDefinition.AdditionalPackageDetected> additionalPackageDetected, List<GJaxbDomainDefinition.PackageDefinition.AdditionalPackageSelected> additionalPackageSelected) {
        ArrayList<GJaxbMetaModel> unSelectedPackages = new ArrayList<GJaxbMetaModel>();
        for (GJaxbDomainDefinition.PackageDefinition.AdditionalPackageDetected packDetected : additionalPackageDetected) {
            GJaxbMetaModel excludeMetaModel;
            boolean find = false;
            for (GJaxbDomainDefinition.PackageDefinition.AdditionalPackageSelected packSelected : additionalPackageSelected) {
                if (!packDetected.getName().equals(packSelected.getName())) continue;
                find = true;
                break;
            }
            if (find || (excludeMetaModel = this.metaModels.get(packDetected.getName())) == null) continue;
            unSelectedPackages.add(excludeMetaModel);
        }
        return unSelectedPackages;
    }

    public GJaxbDomainDefinition findDomainDefinitionByName(String name) {
        for (GJaxbDomainDefinition domainDef : this.domainsDefinition) {
            if (!domainDef.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return domainDef;
        }
        return null;
    }

    private GJaxbDomainDefinition createDomainDefinition(GJaxbDomain domain, List<GJaxbPackage> _packages) throws Exception {
        GJaxbDomainDefinition domainDef = new GJaxbDomainDefinition();
        domainDef.setName(domain.getName());
        domainDef.setPictureUrl(domain.getPictureUrl());
        boolean isCollaborativeDomain = false;
        HashMap<String, ArrayList<GJaxbPackage>> mapPackagesBySameName = new HashMap<String, ArrayList<GJaxbPackage>>();
        if (_packages != null) {
            for (GJaxbPackage gJaxbPackage : _packages) {
                String _packageName = gJaxbPackage.getName().toLowerCase();
                ArrayList<GJaxbPackage> _packagesWithSameName = (ArrayList<GJaxbPackage>)mapPackagesBySameName.get(_packageName);
                if (_packagesWithSameName == null) {
                    _packagesWithSameName = new ArrayList<GJaxbPackage>();
                    mapPackagesBySameName.put(_packageName, _packagesWithSameName);
                }
                _packagesWithSameName.add(gJaxbPackage);
                if (!_packageName.toLowerCase().equals("collaborative process")) continue;
                isCollaborativeDomain = true;
            }
        }
        domainDef.setIsCollaborativeDomain(isCollaborativeDomain);
        for (Map.Entry entry : mapPackagesBySameName.entrySet()) {
            GJaxbDomainDefinition.PackageDefinition cd = this.createMergedPackageDefinition((List)entry.getValue());
            domainDef.getPackageDefinition().add(cd);
        }
        return domainDef;
    }

    private void createDomainsDefinitions(List<GJaxbDomain> discoveredDomain) throws Exception {
        Map<String, List<GJaxbPackage>> mapPackagesByDomain = this.getExistingPackagesByDomainMap();
        this.domainsDefinition = new ArrayList<GJaxbDomainDefinition>();
        for (GJaxbDomain domain : discoveredDomain) {
            GJaxbDomainDefinition domainDefinition = this.createDomainDefinition(domain, mapPackagesByDomain.get(domain.getName()));
            this.domainsDefinition.add(domainDefinition);
        }
    }

    public Map<String, List<GJaxbPackage>> getExistingPackagesByDomainMap() {
        HashMap<String, List<GJaxbPackage>> mapPackagesByDomain = new HashMap<String, List<GJaxbPackage>>();
        for (GJaxbPackage _package : this.packages.values()) {
            ArrayList<GJaxbPackage> _packages;
            if (_package == null || _package.getDomain() == null) continue;
            String domainName = _package.getDomain().trim();
            if (domainName == null) {
                domainName = "Default";
            }
            if ((_packages = (ArrayList<GJaxbPackage>)mapPackagesByDomain.get(domainName)) == null) {
                _packages = new ArrayList<GJaxbPackage>();
                mapPackagesByDomain.put(domainName, _packages);
            }
            _packages.add(_package);
        }
        return mapPackagesByDomain;
    }

    private GJaxbDomainDefinition.PackageDefinition createMergedPackageDefinition(List<GJaxbPackage> packagesWithSameName) throws Exception {
        GJaxbDomainDefinition.PackageDefinition packageDefinition = new GJaxbDomainDefinition.PackageDefinition();
        for (GJaxbPackage _package : packagesWithSameName) {
            packageDefinition.setName(_package.getName());
            packageDefinition.getPackageMerged().add(new QName(_package.getTargetNamespace(), _package.getName()));
            packageDefinition.setModeling(_package.getModeling());
        }
        return packageDefinition;
    }

    public GJaxbPackage createPackageFromEffectivePackage(String targetNamespaceMM, GJaxbEffectivePackage effPack) {
        GJaxbPackage _package = new GJaxbPackage();
        _package.setTargetNamespace(targetNamespaceMM);
        _package.setName(effPack.getName());
        _package.setDomain(effPack.getDomain());
        _package.setRules(new GJaxbPackage.Rules());
        _package.getRules().setContainmentRule(new GJaxbContainmentRule());
        GJaxbImport _impt = new GJaxbImport();
        _impt.setNamespace(effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().findTargetNamespace());
        _impt.setLocation("./Extended_Collaborative_MetaModel.xml");
        _package.getImport().add(_impt);
        for (GJaxbEffectiveConceptType concept : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
            GJaxbImportedNode imptNode = new GJaxbImportedNode();
            imptNode.setRef(concept.getType());
            _package.getImportedNode().add(imptNode);
            GJaxbContainmentRule.Contain contain = new GJaxbContainmentRule.Contain();
            contain.setType(concept.getType());
            _package.getRules().getContainmentRule().getContain().add(contain);
        }
        return _package;
    }

    public GJaxbMetaModel createMetaModelFromEffectivePackages(String targetNamespaceMM, List<GJaxbEffectivePackage> effPacks) {
        GJaxbMetaModel metaModel = new GJaxbMetaModel();
        metaModel.setTargetNamespace(targetNamespaceMM);
        metaModel.setRules(new GJaxbRules());
        metaModel.getRules().setConnectionRules(new GJaxbConnectionRules());
        GJaxbImport _impt = new GJaxbImport();
        _impt.setNamespace("http://fr.emac.gind/collaborative-model");
        metaModel.getImport().add(_impt);
        for (GJaxbEffectivePackage effPack : effPacks) {
            for (GJaxbEffectiveConceptType effConcept : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
                GJaxbConceptType concept = this.convertEffectiveConceptToConcept(effConcept);
                metaModel.getConcept().add(concept);
            }
            for (GJaxbConnectionRule rule : effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule()) {
                metaModel.getRules().getConnectionRules().getConnectionRule().add(rule);
            }
        }
        return metaModel;
    }

    public GJaxbConceptType convertEffectiveConceptToConcept(GJaxbEffectiveConceptType effConcept) {
        GJaxbConceptType concept = new GJaxbConceptType();
        concept.setType(effConcept.getType());
        concept.setReadonly(effConcept.isReadonly());
        concept.setAbstract(effConcept.isAbstract());
        concept.getMetaProperty().addAll(effConcept.getMetaProperty());
        concept.setNodeMetaModeling(effConcept.getNodeMetaModeling());
        concept.setNodeMetaGeolocation(effConcept.getNodeMetaGeolocation());
        concept.setDescription(effConcept.getDescription());
        return concept;
    }

    public static EffectiveMetaModelPluginManager getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new EffectiveMetaModelPluginManager();
        }
        return INSTANCE;
    }

    public Map<QName, GJaxbEffectiveMetaModel> getEffectiveMetaModelFromContainerByQNameMap() {
        return this.effectiveMetaModelFromPackageByQNameMap;
    }

    public Map<QName, GJaxbEffectiveMetaModel> getEffectiveMetaModelFromMetaModelByQNameMap() {
        return this.effectiveMetaModelFromMetaModelByQNameMap;
    }

    public EffectiveMetaModelManager getEffectiveMetaModelManagerFromContainer() {
        return this.effectiveMetaModelFromPackageManager;
    }

    public EffectiveMetaModelManager getEffectiveMetaModelManagerFromMetaModel() {
        return this.effectiveMetaModelFromMetaModelManager;
    }

    public GJaxbNode createNodeConcept(QName conceptQName) throws Exception {
        GJaxbEffectiveConceptType concept = this.effectiveMetaModelFromMetaModelManager.getConceptByType(conceptQName);
        if (concept == null) {
            throw new Exception("Concept not found: " + String.valueOf(conceptQName));
        }
        return GenericModelHelper.createNodeFromMetaModel(concept, true);
    }

    public GJaxbEdge createEdgeConcept(QName conceptQName) throws Exception {
        GJaxbRelation edge = this.effectiveMetaModelFromMetaModelManager.getRelationByType(conceptQName);
        if (edge == null) {
            throw new Exception("Concept not found: " + String.valueOf(conceptQName));
        }
        return GenericModelHelper.createEdgeFromMetaModel(edge, true);
    }

    public List<QName> getConceptsTypes() throws Exception {
        ArrayList<QName> res = new ArrayList<QName>();
        for (GJaxbEffectiveMetaModel mmodel : this.effectiveMetaModelFromPackageManager.getModels()) {
            List tmpList = mmodel.getEffectiveConcept().stream().map(n -> n.getType()).collect(Collectors.toList());
            res.addAll(tmpList);
        }
        return res;
    }

    public List<QName> getRelationsTypes() throws Exception {
        ArrayList<QName> res = new ArrayList<QName>();
        for (GJaxbEffectiveMetaModel mmodel : this.effectiveMetaModelFromPackageManager.getModels()) {
            List tmpList = mmodel.getRelation().stream().map(n -> n.getType()).collect(Collectors.toList());
            res.addAll(tmpList);
        }
        return res;
    }

    public List<GJaxbEffectiveConceptType> getInherits(QName conceptQName) throws Exception {
        ArrayList<GJaxbEffectiveConceptType> nodes = new ArrayList<GJaxbEffectiveConceptType>();
        nodes.addAll(this.effectiveMetaModelFromPackageManager.getInherits(conceptQName));
        nodes.addAll(this.effectiveMetaModelFromMetaModelManager.getInherits(conceptQName));
        nodes = ListUtil.deleteDuplicate(nodes);
        return nodes;
    }

    public List<GJaxbEffectiveConceptType> getImplements(QName conceptQName) throws Exception {
        ArrayList<GJaxbEffectiveConceptType> nodes = new ArrayList<GJaxbEffectiveConceptType>();
        nodes.addAll(this.effectiveMetaModelFromPackageManager.getImplements(conceptQName));
        nodes.addAll(this.effectiveMetaModelFromMetaModelManager.getImplements(conceptQName));
        nodes = ListUtil.deleteDuplicate(nodes);
        return nodes;
    }

    public GJaxbEffectiveConceptType getConceptByType(QName conceptQName) throws Exception {
        List nodes = new ArrayList<GJaxbEffectiveConceptType>();
        nodes.add(this.effectiveMetaModelFromPackageManager.getConceptByType(conceptQName));
        nodes.add(this.effectiveMetaModelFromMetaModelManager.getConceptByType(conceptQName));
        nodes = ListUtil.deleteDuplicate(nodes);
        GJaxbEffectiveConceptType node = null;
        if (nodes.size() >= 1) {
            node = (GJaxbEffectiveConceptType)((Object)nodes.get(0));
        }
        return node;
    }

    public GJaxbEffectiveConceptType getConceptByLocalPartName(String conceptQName) throws Exception {
        List nodes = new ArrayList<GJaxbEffectiveConceptType>();
        nodes.add(this.effectiveMetaModelFromPackageManager.getConceptByLocalPartName(conceptQName));
        nodes.add(this.effectiveMetaModelFromMetaModelManager.getConceptByLocalPartName(conceptQName));
        nodes = ListUtil.deleteDuplicate(nodes);
        GJaxbEffectiveConceptType node = null;
        if (nodes.size() >= 1) {
            node = (GJaxbEffectiveConceptType)((Object)nodes.get(0));
        }
        return node;
    }

    public GJaxbEffectiveConceptType getConceptByType(QName conceptQName, String collaborationName, String knowledgeSpaceName) throws Exception {
        if (collaborationName != null && knowledgeSpaceName != null) {
            GJaxbEffectiveDomain domain = this.getCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName);
            return EffectiveMetaModelHelper.getConceptByType(domain.getGlobalEffectiveMetaModel().getEffectiveMetaModel(), conceptQName);
        }
        return this.getConceptByType(conceptQName);
    }

    public GJaxbEffectiveConceptType getConceptFromLocalPartOfType(String localPartType, String collaborationName, String knowledgeSpaceName) throws Exception {
        if (collaborationName != null && knowledgeSpaceName != null) {
            GJaxbEffectiveDomain domain = this.getCacheEffectiveDomainByCollaborationAndKnowledge(collaborationName, knowledgeSpaceName);
            return EffectiveMetaModelHelper.getConceptByLocalPartType(domain.getGlobalEffectiveMetaModel().getEffectiveMetaModel(), localPartType);
        }
        return this.getConceptByLocalPartName(localPartType);
    }

    public GJaxbRelation getRelationByType(QName conceptQName) throws Exception {
        List edges = new ArrayList<GJaxbRelation>();
        edges.add(this.effectiveMetaModelFromPackageManager.getRelationByType(conceptQName));
        edges.add(this.effectiveMetaModelFromMetaModelManager.getRelationByType(conceptQName));
        edges = ListUtil.deleteDuplicate(edges);
        GJaxbRelation edge = null;
        if (edges.size() >= 1) {
            edge = (GJaxbRelation)((Object)edges.get(0));
        }
        return edge;
    }

    public GJaxbRelation getRelationByLocalPartName(String conceptLocalPartName) throws Exception {
        List edges = new ArrayList<GJaxbRelation>();
        edges.add(this.effectiveMetaModelFromPackageManager.getRelationByLocalPartName(conceptLocalPartName));
        edges.add(this.effectiveMetaModelFromMetaModelManager.getRelationByLocalPartName(conceptLocalPartName));
        edges = ListUtil.deleteDuplicate(edges);
        GJaxbRelation edge = null;
        if (edges.size() >= 1) {
            edge = (GJaxbRelation)((Object)edges.get(0));
        }
        return edge;
    }

    public String printDomainDefinition(GJaxbDomainDefinition domain) {
        StringBuffer buff = new StringBuffer();
        buff.append("domain definition: \n");
        buff.append("\tname: " + domain.getName() + "\n");
        buff.append("\tpictureUrl: " + domain.getPictureUrl() + "\n");
        buff.append("\tcontainer definition: \n");
        for (GJaxbDomainDefinition.PackageDefinition container : domain.getPackageDefinition()) {
            buff.append("\t\tname: " + container.getName() + "\n");
            if (container.getModeling().getIconUrl() != null) {
                buff.append("\t\t\ticon url: " + container.getModeling().getIconUrl() + "\n");
            }
            if (container.getModeling().getMatIcon() != null) {
                buff.append("\t\t\tmat-icon: " + container.getModeling().getMatIcon() + "\n");
            }
            buff.append("\t\t\tbackground-color: " + container.getModeling().getBackgroundColor() + "\n");
            buff.append("\t\t\tmerged containers: " + String.valueOf(container.getPackageMerged()) + "\n");
            if (container.getAdditionalPackageDetected().isEmpty()) continue;
            buff.append("\t\t\tdetected packages: \n");
            for (GJaxbDomainDefinition.PackageDefinition.AdditionalPackageDetected apd : container.getAdditionalPackageDetected()) {
                buff.append("\t\t\t\tname: " + String.valueOf(apd.getName()) + "\n");
                if (apd.getPackageIconUrl() != null) {
                    buff.append("\t\t\t\t\tpackage url: " + apd.getPackageIconUrl() + "\n");
                }
                if (apd.getPackageMatIcon() == null) continue;
                buff.append("\t\t\t\t\tpackage mat-icon: " + apd.getPackageMatIcon() + "\n");
            }
        }
        return buff.toString();
    }

    public String printEffectiveDomain(GJaxbEffectiveDomain domain) {
        StringBuffer buff = new StringBuffer();
        buff.append("effective domain: \n");
        buff.append("\tname: " + domain.getName() + "\n");
        buff.append("\tpictureUrl: " + domain.getPictureUrl() + "\n");
        buff.append("\tmerged container: \n");
        for (GJaxbEffectivePackage container : domain.getEffectivePackage()) {
            buff.append("\t\tname: " + container.getName() + "\n");
            if (container.getModeling().getIconUrl() != null) {
                buff.append("\t\t\ticon url: " + container.getModeling().getIconUrl() + "\n");
            }
            if (container.getModeling().getMatIcon() != null) {
                buff.append("\t\t\tmat-icon: " + container.getModeling().getMatIcon() + "\n");
            }
            buff.append("\t\t\tbackground-color: " + container.getModeling().getBackgroundColor() + "\n");
            buff.append("\t\t\tmerged containers: " + String.valueOf(container.getPackagesQName()) + "\n");
            buff.append("\t\t\tmetamodels imported: \n");
            for (GJaxbImport impt : container.getImport()) {
                buff.append("\t\t\t\t" + impt.getNamespace() + "\n");
            }
            buff.append("\t\t\timported nodes: \n");
            for (GJaxbImportedNode imptNode : container.getImportedNode()) {
                buff.append("\t\t\t\t" + String.valueOf(imptNode.getRef()) + "\n");
            }
        }
        return buff.toString();
    }

    public GJaxbDomainDefinition findDomainDefinition(String domain) {
        for (GJaxbDomainDefinition dd : this.domainsDefinition) {
            if (!dd.getName().toLowerCase().equals(domain.toLowerCase())) continue;
            return dd;
        }
        return null;
    }

    public GJaxbEffectivePackage findEffectivePackageByName(QName packageName) {
        return this.mergedEffectivePackage.get(packageName);
    }

    public Map<GJaxbConceptType, Map<GJaxbRelation, List<GJaxbConnectionRule>>> findBrokenRelations(QName packageName) throws Exception {
        MetaModelManager mms = new MetaModelManager(this.metaModels.values().toArray(new GJaxbMetaModel[this.metaModels.values().size()]));
        HashMap<GJaxbConceptType, Map<GJaxbRelation, List<GJaxbConnectionRule>>> map = new HashMap<GJaxbConceptType, Map<GJaxbRelation, List<GJaxbConnectionRule>>>();
        GJaxbEffectivePackage _package = this.findEffectivePackageByName(packageName);
        for (GJaxbEffectiveConceptType concept : _package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept()) {
            Map<GJaxbRelation, List<GJaxbConnectionRule>> brokenEdges = EffectiveMetaModelHelper.findBrokenRelations(concept, _package.getEffectiveMetaModelOfPackage().getEffectiveMetaModel(), _package.getImportedNode(), mms);
            if (brokenEdges.size() <= 0) continue;
            map.put(concept, brokenEdges);
        }
        return map;
    }

    public boolean _implements(GJaxbNode node, QName parentType) throws Exception {
        List validTypes = this.getImplements(node.getType()).stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
        validTypes.add(node.getType());
        return validTypes.contains(parentType);
    }

    public boolean _implements(QName childType, QName parentType) throws Exception {
        List validTypes = this.getImplements(childType).stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
        validTypes.add(childType);
        return validTypes.contains(parentType);
    }

    public boolean inherit(GJaxbNode node, QName parentType) throws Exception {
        List validTypes = this.getInherits(node.getType()).stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
        validTypes.add(node.getType());
        return validTypes.contains(parentType);
    }

    public boolean inherit(QName childType, QName parentType) throws Exception {
        List validTypes = this.getInherits(childType).stream().map(GJaxbConceptType::getType).collect(Collectors.toList());
        validTypes.add(childType);
        return validTypes.contains(parentType);
    }

    public GJaxbEffectiveDomain getCacheEffectiveDomainByCollaborationAndKnowledge(String collaboration, String knowledgeSpace) {
        if (this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.get(RegExpHelper.toRegexFriendlyName((String)collaboration)) == null) {
            this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.put(RegExpHelper.toRegexFriendlyName((String)collaboration), new HashMap());
        }
        return this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.get(RegExpHelper.toRegexFriendlyName((String)collaboration)).get(RegExpHelper.toRegexFriendlyName((String)knowledgeSpace));
    }

    public void setCacheEffectiveDomainByCollaborationAndKnowledge(String collaboration, String knowledgeSpace, GJaxbEffectiveDomain effDomain) {
        if (this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.get(RegExpHelper.toRegexFriendlyName((String)collaboration)) == null) {
            this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.put(RegExpHelper.toRegexFriendlyName((String)collaboration), new HashMap());
        }
        this.cacheEffectiveDomainByKnowledgeSpaceByCollaboration.get(RegExpHelper.toRegexFriendlyName((String)collaboration)).put(RegExpHelper.toRegexFriendlyName((String)knowledgeSpace), effDomain);
    }

    public void clearCaches() {
        this.effectiveMetaModelFromPackageManager.clearCaches();
        this.effectiveMetaModelFromMetaModelManager.clearCaches();
    }
}

