/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import fr.emac.gind.modeler.genericmodel.GJaxbArea;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class GeometryHelper {
    private static GeometryHelper INSTANCE = null;

    private GeometryHelper() {
    }

    public static GeometryHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GeometryHelper();
        }
        return INSTANCE;
    }

    public boolean intersects(GJaxbNode a, GJaxbNode b) throws Exception {
        if (!a.isSetGeolocation() || !b.isSetGeolocation()) {
            return false;
        }
        List<Geometry> geoAs = this.extractGeometryFromGJaxbNode(a);
        List<Geometry> geoBs = this.extractGeometryFromGJaxbNode(b);
        boolean intersect = false;
        block0: for (Geometry geoA : geoAs) {
            for (Geometry geoB : geoBs) {
                intersect = geoA.intersects(geoB);
                if (!intersect) continue;
                break block0;
            }
        }
        return intersect;
    }

    public GJaxbPointType getFirstIntersection(GJaxbNode a, GJaxbNode b) throws Exception {
        List<Geometry> geoAs = this.extractGeometryFromGJaxbNode(a);
        List<Geometry> geoBs = this.extractGeometryFromGJaxbNode(b);
        boolean intersect = false;
        Coordinate coord = null;
        block0: for (Geometry geoA : geoAs) {
            for (Geometry geoB : geoBs) {
                intersect = geoA.intersects(geoB);
                if (!intersect) continue;
                Geometry geom = geoA.intersection(geoB);
                coord = geom.getCoordinates()[0];
                break block0;
            }
        }
        GJaxbPointType p = new GJaxbPointType();
        if (!Double.isNaN(coord.y)) {
            p.setLatitude(coord.y);
        }
        if (!Double.isNaN(coord.x)) {
            p.setLongitude(coord.x);
        }
        if (!Double.isNaN(coord.z)) {
            p.setAltitude(coord.z);
        }
        return p;
    }

    public boolean contains(GJaxbNode container, GJaxbNode child) throws Exception {
        List<Geometry> geoContainers = this.extractGeometryFromGJaxbNode(container);
        List<Geometry> geoChilds = this.extractGeometryFromGJaxbNode(child);
        boolean contains = false;
        block0: for (Geometry geoContainer : geoContainers) {
            for (Geometry geoChild : geoChilds) {
                contains = geoContainer.contains(geoChild);
                if (contains) continue;
                break block0;
            }
        }
        return contains;
    }

    public List<Geometry> extractGeometryFromGJaxbNode(GJaxbNode n) throws Exception {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        if (n != null && n.getGeolocation() != null) {
            for (GJaxbNode.Geolocation.ItemView iv : n.getGeolocation().getItemView()) {
                Geometry geom = this.extractGeometryFromItemView(iv);
                if (geom == null) continue;
                geoms.add(geom);
            }
        }
        return geoms;
    }

    public Geometry extractGeometryFromItemView(GJaxbNode.Geolocation.ItemView iv) throws Exception {
        MultiLineString geom = null;
        if (iv.isSetArea()) {
            ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
            for (GJaxbPointType p : iv.getArea().getPoint()) {
                Coordinate c = new Coordinate(p.getLongitude().doubleValue(), p.getLatitude().doubleValue());
                coordinates.add(c);
            }
            if (!coordinates.isEmpty()) {
                coordinates.add(new Coordinate((Coordinate)coordinates.get(0)));
                geom = new GeometryFactory().createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
            }
        } else if (iv.isSetPolyline()) {
            ArrayList<LineString> lines = new ArrayList<LineString>();
            for (int i = 0; i < iv.getPolyline().getPoint().size() - 1; ++i) {
                GJaxbPointType p1 = iv.getPolyline().getPoint().get(i);
                GJaxbPointType p2 = iv.getPolyline().getPoint().get(i + 1);
                Coordinate c1 = new Coordinate(p1.getLongitude().doubleValue(), p1.getLatitude().doubleValue());
                Coordinate c2 = new Coordinate(p2.getLongitude().doubleValue(), p2.getLatitude().doubleValue());
                lines.add(new GeometryFactory().createLineString(new Coordinate[]{c1, c2}));
            }
            geom = new GeometryFactory().createMultiLineString(lines.toArray(new LineString[lines.size()]));
        } else if (iv.isSetPredefinedShape() && iv.getPredefinedShape().isSetCircle() && iv.getPredefinedShape().getCircle().isSetCenter()) {
            if (iv.getPredefinedShape().getCircle().getCenter().isSetLatitude() && iv.getPredefinedShape().getCircle().getCenter().isSetLongitude()) {
                GeometricShapeFactory gsf = new GeometricShapeFactory();
                gsf.setSize((double)(iv.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getCircle().getRadius() / 100000.0f * 2.0f));
                gsf.setNumPoints(100);
                gsf.setCentre(new Coordinate(iv.getPredefinedShape().getCircle().getCenter().getLongitude().doubleValue(), iv.getPredefinedShape().getCircle().getCenter().getLatitude().doubleValue()));
                geom = gsf.createCircle();
            }
        } else if (iv.isSetPredefinedShape() && iv.getPredefinedShape().isSetRect() && iv.getPredefinedShape().getRect().isSetCenter()) {
            if (iv.getPredefinedShape().getRect().getCenter().isSetLatitude() && iv.getPredefinedShape().getRect().getCenter().isSetLongitude()) {
                Double center_lat = iv.getPredefinedShape().getRect().getCenter().getLatitude();
                Double center_lng = iv.getPredefinedShape().getRect().getCenter().getLongitude();
                Float height = Float.valueOf(iv.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getRect().getHeight());
                Float width = Float.valueOf(iv.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getRect().getWidth());
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                Coordinate c_nw = new Coordinate(center_lng + (double)(height.floatValue() / 2.0f), center_lat - (double)(width.floatValue() / 2.0f));
                coordinates.add(c_nw);
                Coordinate c_ne = new Coordinate(center_lng + (double)(height.floatValue() / 2.0f), center_lat + (double)(width.floatValue() / 2.0f));
                coordinates.add(c_ne);
                Coordinate c_se = new Coordinate(center_lng - (double)(height.floatValue() / 2.0f), center_lat + (double)(width.floatValue() / 2.0f));
                coordinates.add(c_se);
                Coordinate c_sw = new Coordinate(center_lng - (double)(height.floatValue() / 2.0f), center_lat - (double)(width.floatValue() / 2.0f));
                coordinates.add(c_sw);
                geom = new GeometryFactory().createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
            }
        } else if (iv.isSetPoint()) {
            geom = new GeometryFactory().createPoint(new Coordinate(iv.getPoint().getLongitude().doubleValue(), iv.getPoint().getLatitude().doubleValue()));
        } else {
            throw new Exception("Not implemented !!!");
        }
        return geom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GJaxbNode createGeometryGJaxbNodeFromGJaxbNode(GJaxbNode n) throws Exception {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (GJaxbNode.Geolocation.ItemView iv : n.getGeolocation().getItemView()) {
            Geometry geom = null;
            if (iv.isSetArea()) {
                ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
                for (GJaxbPointType p : iv.getArea().getPoint()) {
                    Coordinate c = new Coordinate(p.getLongitude().doubleValue(), p.getLatitude().doubleValue());
                    coordinates.add(c);
                }
                coordinates.add(new Coordinate((Coordinate)coordinates.get(0)));
                geom = new GeometryFactory().createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
            } else if (iv.isSetPolyline()) {
                ArrayList<LineString> lines = new ArrayList<LineString>();
                for (int i = 0; i < iv.getPolyline().getPoint().size() - 1; ++i) {
                    GJaxbPointType p1 = iv.getPolyline().getPoint().get(i);
                    GJaxbPointType p2 = iv.getPolyline().getPoint().get(i + 1);
                    Coordinate c1 = new Coordinate(p1.getLongitude().doubleValue(), p1.getLatitude().doubleValue());
                    Coordinate c2 = new Coordinate(p2.getLongitude().doubleValue(), p2.getLatitude().doubleValue());
                    lines.add(new GeometryFactory().createLineString(new Coordinate[]{c1, c2}));
                }
                geom = new GeometryFactory().createMultiLineString(lines.toArray(new LineString[lines.size()]));
            } else {
                if (!iv.isSetPredefinedShape()) throw new Exception("Not implemented !!!");
                if (!iv.getPredefinedShape().isSetCircle()) throw new Exception("Not implemented !!!");
                GeometricShapeFactory gsf = new GeometricShapeFactory();
                gsf.setSize((double)(iv.getSpecificGeolocation().getNodeMetaGeolocation().getPredefinedShape().getCircle().getRadius() / 100000.0f * 2.0f));
                gsf.setNumPoints(100);
                gsf.setCentre(new Coordinate(iv.getPredefinedShape().getCircle().getCenter().getLongitude().doubleValue(), iv.getPredefinedShape().getCircle().getCenter().getLatitude().doubleValue()));
                geom = gsf.createCircle();
            }
            if (geom == null) continue;
            geoms.add(geom);
        }
        GJaxbNode newNode = GenericModelHelper.cloneNode(n);
        newNode.setId("jts_node_" + UUID.randomUUID().toString());
        GenericModelHelper.findProperty("name", newNode.getProperty()).setValue("NEW");
        newNode.setGeolocation(new GJaxbNode.Geolocation());
        for (Geometry geom : geoms) {
            GJaxbNode.Geolocation.ItemView iv = new GJaxbNode.Geolocation.ItemView();
            newNode.getGeolocation().getItemView().add(iv);
            iv.setArea(new GJaxbArea());
            iv.setSpecificGeolocation(new GJaxbNode.Geolocation.ItemView.SpecificGeolocation());
            iv.getSpecificGeolocation().setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor("#4B0082");
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(3.0);
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(0.8);
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor("#4B0082");
            iv.getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(0.8);
            iv.setRedesign(false);
            for (int i = 0; i < geom.getCoordinates().length; ++i) {
                Coordinate coord = geom.getCoordinates()[i];
                GJaxbPointType p = new GJaxbPointType();
                if (!Double.isNaN(coord.y)) {
                    p.setLatitude(coord.y);
                }
                if (!Double.isNaN(coord.x)) {
                    p.setLongitude(coord.x);
                }
                if (!Double.isNaN(coord.z)) {
                    p.setAltitude(coord.z);
                }
                iv.getArea().getPoint().add(p);
            }
        }
        return newNode;
    }

    public boolean hasValidGeoLocation(GJaxbNode node) {
        if (node.isSetGeolocation() && node.getGeolocation().isSetItemView()) {
            for (GJaxbNode.Geolocation.ItemView iv : node.getGeolocation().getItemView()) {
                if (iv.isSetPoint() && iv.getPoint().isSetLatitude() && iv.getPoint().isSetLongitude()) {
                    return true;
                }
                if (iv.isSetArea() && !iv.getArea().getPoint().isEmpty()) {
                    return true;
                }
                if (iv.isSetPolyline() && !iv.getPolyline().getPoint().isEmpty()) {
                    return true;
                }
                if (!iv.isSetPredefinedShape() || !iv.getPredefinedShape().getCircle().isSetCenter() || !iv.getPredefinedShape().getCircle().getCenter().isSetLatitude() || !iv.getPredefinedShape().getCircle().getCenter().isSetLongitude()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPointInsidePolygon(Point coordinate, Polygon polygon) {
        int numVertices = polygon.getCoordinates().length;
        int intersectCount = 0;
        for (int i = 0; i < numVertices; ++i) {
            double vertex1Lat = polygon.getCoordinates()[i].y;
            double vertex1Lng = polygon.getCoordinates()[i].x;
            double vertex2Lat = polygon.getCoordinates()[(i + 1) % numVertices].y;
            double vertex2Lng = polygon.getCoordinates()[(i + 1) % numVertices].x;
            if (!(coordinate.getX() > Math.min(vertex1Lng, vertex2Lng)) || !(coordinate.getX() <= Math.max(vertex1Lng, vertex2Lng)) || !(coordinate.getY() <= Math.max(vertex1Lat, vertex2Lat)) || vertex1Lng == vertex2Lng) continue;
            double xIntersection = (coordinate.getX() - vertex1Lng) * (vertex2Lat - vertex1Lat) / (vertex2Lng - vertex1Lng) + vertex1Lat;
            if (vertex1Lat != vertex2Lat && !(coordinate.getY() <= xIntersection)) continue;
            ++intersectCount;
        }
        return intersectCount % 2 != 0;
    }

    public Point getPolygonCenter(Polygon polygon) {
        return polygon.getBoundary().getCentroid();
    }

    public Point generateRandomPointInsidePolygon(Polygon polygon) {
        Point p = null;
        double minLat = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double minLng = Double.MAX_VALUE;
        double maxLng = -1.7976931348623157E308;
        for (Coordinate vertex : polygon.getCoordinates()) {
            double lat = vertex.y;
            double lng = vertex.x;
            minLat = Math.min(minLat, lat);
            maxLat = Math.max(maxLat, lat);
            minLng = Math.min(minLng, lng);
            maxLng = Math.max(maxLng, lng);
        }
        Random random = new Random();
        double randomLat = minLat + (maxLat - minLat) * random.nextDouble();
        double randomLng = minLng + (maxLng - minLng) * random.nextDouble();
        p = new GeometryFactory().createPoint(new Coordinate(randomLng, randomLat));
        boolean isInsidePolygon = GeometryHelper.getInstance().isPointInsidePolygon(p, polygon);
        boolean stop = false;
        while (!isInsidePolygon && !stop) {
            isInsidePolygon = GeometryHelper.getInstance().isPointInsidePolygon(p, polygon);
            if (isInsidePolygon) {
                System.out.println("Random coordinates inside the polygon:");
                System.out.println("Latitude: " + randomLat);
                System.out.println("Longitude: " + randomLng);
                stop = true;
                continue;
            }
            System.out.println("Generated coordinates are outside the polygon.");
            randomLat = minLat + (maxLat - minLat) * random.nextDouble();
            randomLng = minLng + (maxLng - minLng) * random.nextDouble();
            p = new GeometryFactory().createPoint(new Coordinate(randomLng, randomLat));
        }
        return p;
    }
}

