/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils.checker.anomalies;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.utils.checker.ModelAnomaly;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class SeveralSameEdgesDetected
extends ModelAnomaly {
    private Map<String, List<GJaxbEdge>> samesEdges = new HashMap<String, List<GJaxbEdge>>();

    public SeveralSameEdgesDetected(GJaxbGenericModel model) {
        super(model);
    }

    public Map<String, List<GJaxbEdge>> getSamesEdges() {
        return this.samesEdges;
    }

    public void setSamesEdges(Map<String, List<GJaxbEdge>> samesEdges) {
        this.samesEdges = samesEdges;
    }

    @Override
    public boolean check() {
        HashMap samesEdgesMap = new HashMap();
        for (GJaxbEdge edge : this.model.getEdge()) {
            String id_key = String.valueOf(edge.getType()) + "@@" + edge.getSource().getId() + "@@" + edge.getTarget().getId();
            if (samesEdgesMap.get(id_key) == null) {
                samesEdgesMap.put((CallSite)((Object)id_key), new ArrayList());
            }
            ((List)samesEdgesMap.get(id_key)).add(edge);
        }
        HashMap<String, List<GJaxbEdge>> samesEdgesDetected = new HashMap<String, List<GJaxbEdge>>();
        for (Map.Entry entry : samesEdgesMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            samesEdgesDetected.put((String)entry.getKey(), (List)entry.getValue());
        }
        if (samesEdgesDetected.isEmpty()) {
            return true;
        }
        this.setSamesEdges(samesEdgesDetected);
        return false;
    }

    @Override
    public void repair() throws Exception {
        for (Map.Entry<String, List<GJaxbEdge>> entry : this.samesEdges.entrySet()) {
            List<GJaxbEdge> duplicatedEdges = entry.getValue();
            GJaxbEdge keepEdge = duplicatedEdges.remove(0);
            for (GJaxbEdge edge : duplicatedEdges) {
                this.getModel().getEdge().remove((Object)edge);
                for (GJaxbNode node : this.getModel().getNode()) {
                    node.getBrokenEdges().getBrokenEdge().removeIf(be -> be.getEdge().getId().equals(edge.getId()));
                }
            }
        }
        String buffer = XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)this.getModel()));
        FileUtil.setContents((File)new File(this.getModel().getBaseURI()), (String)buffer);
    }

    @Override
    public String printAnomalyMessage() {
        Object msg = "\nSeveralSameEdgesDetected:\n\n";
        for (Map.Entry<String, List<GJaxbEdge>> entry : this.samesEdges.entrySet()) {
            String[] keySplit = entry.getKey().split("@@");
            msg = (String)msg + entry.getValue().size() + " sames edges '" + keySplit[0] + "' detected between '" + keySplit[1] + "' and '" + keySplit[2] + "\n";
        }
        return msg;
    }
}

