/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.interpretation.predict;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.interpretationconfigs.PredictCommand;
import fr.emac.gind.interpretationconfigs.PredictFault;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PredictCommandClient
implements PredictCommand {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private PredictCommandClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static PredictCommand createClient(String remoteAddress) throws Exception {
        PredictCommand client = (PredictCommand)LocalRegistry.getInstance().findWSImplementation(PredictCommand.class);
        if (client == null) {
            client = new PredictCommandClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public GJaxbPredictResponse predict(GJaxbPredict parameters) throws PredictFault {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/InterpretationConfigs/predict\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbPredictResponse response = (GJaxbPredictResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbPredictResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new PredictFault(e.getMessage(), null);
        }
    }
}

