/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.workflow.engine;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.process.DeployFault;
import fr.emac.gind.process.DeploymentServicePortType;
import fr.emac.gind.process.GJaxbDeploy;
import fr.emac.gind.process.GJaxbDeployResponse;
import fr.emac.gind.process.GJaxbDeployResult;
import fr.emac.gind.process.GJaxbGetProcess;
import fr.emac.gind.process.GJaxbGetProcessResponse;
import fr.emac.gind.process.GJaxbListProcesses;
import fr.emac.gind.process.GJaxbListProcessesResponse;
import fr.emac.gind.process.GJaxbPackage;
import fr.emac.gind.process.GJaxbSubscribeOnDeploymentService;
import fr.emac.gind.process.GJaxbSubscribeOnDeploymentServiceResponse;
import fr.emac.gind.process.GJaxbUndeploy;
import fr.emac.gind.process.GJaxbUndeployResponse;
import fr.emac.gind.process.SubscribeOnDeploymentServiceFault;
import fr.emac.gind.process.UndeployFault;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@WebService(name="DeploymentServicePortType", targetNamespace="http://www.gind.emac.fr/process")
@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
public class ProcessClient
implements DeploymentServicePortType {
    private static Logger LOG = LoggerFactory.getLogger((String)ProcessClient.class.getName());
    private SOAPSender sender = null;
    private String serverAddress = null;

    public ProcessClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    private ProcessClient getLocalClient() {
        return (ProcessClient)LocalRegistry.getInstance().findWSImplementation(ProcessClient.class);
    }

    private boolean hasLocalClient() {
        return LocalRegistry.getInstance().findWSImplementation(ProcessClient.class) != null;
    }

    public static ProcessClient createClient(String remoteAddress) throws Exception {
        ProcessClient client = (ProcessClient)LocalRegistry.getInstance().findWSImplementation(ProcessClient.class);
        if (client == null) {
            client = new ProcessClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public GJaxbDeployResult deploy(String workflowEngineName, File zip, String collaborationName, String knowledgeSpaceName) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (FileInputStream fileInputStream = new FileInputStream(zip);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = fileInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.deploy(workflowEngineName, byteArrayOutputStream, null, collaborationName, knowledgeSpaceName);
    }

    public GJaxbDeployResult deploy(String workflowEngineName, ByteArrayOutputStream output, String collaborationName, String knowledgeSpaceName) throws Exception {
        return this.deploy(workflowEngineName, output, null, collaborationName, knowledgeSpaceName);
    }

    public GJaxbDeployResult deploy(String workflowEngineName, ByteArrayOutputStream output, List<GJaxbProperty> parameters, String collaborationName, String knowledgeSpaceName) throws Exception {
        assert (output != null);
        LOG.debug("##### Deploy Worklow at :" + this.serverAddress);
        String name = workflowEngineName + "_" + UUID.randomUUID().toString();
        GJaxbPackage _package = new GJaxbPackage();
        ByteArrayDataSource dataSource = new ByteArrayDataSource(output.toByteArray(), "application/octet-stream");
        DataHandler bin = new DataHandler((DataSource)dataSource);
        if (bin != null) {
            _package.setZip(bin);
        }
        GJaxbDeploy request = new GJaxbDeploy();
        request.setName(name);
        request.setPackage(_package);
        request.setCollaborationName(collaborationName);
        request.setKnowledgeSpaceName(knowledgeSpaceName);
        request.setWorkflowEngineName(workflowEngineName);
        if (parameters != null) {
            request.getProperty().addAll(parameters);
        }
        if (this.hasLocalClient()) {
            return this.getLocalClient().deploy(request).getResponse();
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/deploy");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDeployResponse response = (GJaxbDeployResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDeployResponse.class);
            return response.getResponse();
        }
        catch (Exception e) {
            throw new UndeployFault(e.getMessage(), null, e);
        }
    }

    public void undeploy(GJaxbDeployResult result, String collaborationName, String knowledgeSpaceName) throws UndeployFault {
        GJaxbUndeploy request = new GJaxbUndeploy();
        request.setRequest(result);
        request.setCollaborationName(collaborationName);
        request.setKnowledgeSpaceName(knowledgeSpaceName);
        if (this.hasLocalClient()) {
            this.getLocalClient().undeploy(request);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)request);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/undeploy");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
        }
        catch (Exception e) {
            throw new UndeployFault(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbUndeployResponse undeploy(GJaxbUndeploy parameters) throws UndeployFault {
        LOG.info("Executing operation undeploy");
        if (this.hasLocalClient()) {
            return this.getLocalClient().undeploy(parameters);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/undeploy");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbUndeployResponse response = (GJaxbUndeployResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbUndeployResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new UndeployFault(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbGetProcessResponse getProcess(GJaxbGetProcess parameters) {
        if (this.hasLocalClient()) {
            return this.getLocalClient().getProcess(parameters);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/getProcess");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbGetProcessResponse response = (GJaxbGetProcessResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbGetProcessResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GJaxbListProcessesResponse listProcesses(GJaxbListProcesses parameters) {
        if (this.hasLocalClient()) {
            return this.getLocalClient().listProcesses(parameters);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/listProcesses");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbListProcessesResponse response = (GJaxbListProcessesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbListProcessesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GJaxbDeployResponse deploy(GJaxbDeploy parameters) throws DeployFault {
        LOG.info("Executing operation deploy");
        if (this.hasLocalClient()) {
            return this.getLocalClient().deploy(parameters);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/deploy");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDeployResponse response = (GJaxbDeployResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDeployResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GJaxbSubscribeOnDeploymentServiceResponse subscribeOnDeploymentService(GJaxbSubscribeOnDeploymentService parameters) throws SubscribeOnDeploymentServiceFault {
        LOG.info("Executing operation subscribeOnDeploymentService");
        if (this.hasLocalClient()) {
            return this.getLocalClient().subscribeOnDeploymentService(parameters);
        }
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/process/subscribeOnDeploymentService");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbSubscribeOnDeploymentServiceResponse response = (GJaxbSubscribeOnDeploymentServiceResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbSubscribeOnDeploymentServiceResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

