/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.process.simulation.results;

import fr.emac.gind.modeler.genericmodel.GJaxbImpact;
import fr.emac.gind.modeler.genericmodel.GJaxbIndicatorValueType;
import fr.emac.gind.modeler.genericmodel.GJaxbRange;
import fr.emac.gind.modeler.genericmodel.GJaxbTheoricValue;
import fr.emac.gind.models.process.simulation.results.GJaxbIndicator;
import java.util.List;

public class IndicatorHelper {
    public static GJaxbImpact createPreciseImpact(String indicatorName, String operator, float value) {
        GJaxbImpact impact = new GJaxbImpact();
        impact.setPropertyName(indicatorName);
        impact.setOperator(operator);
        GJaxbIndicator indicator = IndicatorHelper.createPreciseIndicator(indicatorName, value);
        impact.setIndicatorValue(indicator.getIndicatorValue());
        return impact;
    }

    public static GJaxbImpact createRangeImpact(String indicatorName, String operator, float min, float max) {
        GJaxbImpact impact = new GJaxbImpact();
        impact.setPropertyName(indicatorName);
        impact.setOperator(operator);
        GJaxbIndicator indicator = IndicatorHelper.createRangeIndicator(indicatorName, min, max);
        impact.setIndicatorValue(indicator.getIndicatorValue());
        return impact;
    }

    public static GJaxbIndicator createPreciseIndicator(String indicatorName, float value) {
        GJaxbIndicator indicator = new GJaxbIndicator();
        indicator.setName(indicatorName);
        indicator.setIndicatorValue(new GJaxbIndicatorValueType());
        indicator.getIndicatorValue().setTheoricValue(new GJaxbTheoricValue());
        indicator.getIndicatorValue().getTheoricValue().setPrecise(Float.valueOf(value));
        return indicator;
    }

    public static GJaxbIndicator createRangeIndicator(String indicatorName, float min, float max) {
        GJaxbIndicator indicator = new GJaxbIndicator();
        indicator.setName(indicatorName);
        indicator.setIndicatorValue(new GJaxbIndicatorValueType());
        indicator.getIndicatorValue().setTheoricValue(new GJaxbTheoricValue());
        GJaxbRange range = new GJaxbRange();
        range.setMin(Float.valueOf(min));
        range.setMax(Float.valueOf(max));
        indicator.getIndicatorValue().getTheoricValue().getRanges().add(range);
        return indicator;
    }

    public static GJaxbIndicator findIndicator(String name, List<GJaxbIndicator> indicators) {
        for (GJaxbIndicator indicator : indicators) {
            if (!indicator.getName().equals(name)) continue;
            return indicator;
        }
        return null;
    }
}

