/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.timeseries.mongodb.client;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.timeseries.FaultMessage;
import fr.emac.gind.timeseries.GJaxbCreateTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbCreateTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbDelete;
import fr.emac.gind.timeseries.GJaxbDeleteAll;
import fr.emac.gind.timeseries.GJaxbDeleteAllResponse;
import fr.emac.gind.timeseries.GJaxbDeleteResponse;
import fr.emac.gind.timeseries.GJaxbDumpTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbDumpTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbGetTimeseriesCollectionNames;
import fr.emac.gind.timeseries.GJaxbGetTimeseriesCollectionNamesResponse;
import fr.emac.gind.timeseries.GJaxbQuery;
import fr.emac.gind.timeseries.GJaxbQueryResponse;
import fr.emac.gind.timeseries.GJaxbRestoreTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbRestoreTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbUpdate;
import fr.emac.gind.timeseries.GJaxbUpdateResponse;
import fr.emac.gind.timeseries.GJaxbWrite;
import fr.emac.gind.timeseries.GJaxbWriteResponse;
import fr.emac.gind.timeseries.Timeseries;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TimeSeriesMongoDBClient
implements Timeseries {
    private static Logger LOG = LoggerFactory.getLogger((String)TimeSeriesMongoDBClient.class.getName());
    private SOAPSender sender = null;
    private String serverAddress = null;

    private TimeSeriesMongoDBClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static Timeseries createTimeSeriesMongoDBClient(String remoteAddress) throws Exception {
        Timeseries client = (Timeseries)LocalRegistry.getInstance().findWSImplementation(Timeseries.class);
        if (client == null) {
            client = new TimeSeriesMongoDBClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public GJaxbCreateTimeseriesCollectionResponse createTimeseriesCollection(GJaxbCreateTimeseriesCollection parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/createTimeseriesCollection");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbCreateTimeseriesCollectionResponse response = (GJaxbCreateTimeseriesCollectionResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbCreateTimeseriesCollectionResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbWriteResponse write(GJaxbWrite parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/write");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbWriteResponse response = (GJaxbWriteResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbWriteResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbUpdateResponse update(GJaxbUpdate parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/update");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbUpdateResponse response = (GJaxbUpdateResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbUpdateResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbDumpTimeseriesCollectionResponse dumpTimeseriesCollection(GJaxbDumpTimeseriesCollection parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/dumpTimeseriesCollection");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDumpTimeseriesCollectionResponse response = (GJaxbDumpTimeseriesCollectionResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDumpTimeseriesCollectionResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbRestoreTimeseriesCollectionResponse restoreTimeseriesCollection(GJaxbRestoreTimeseriesCollection parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/restoreTimeseriesCollection");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbRestoreTimeseriesCollectionResponse response = (GJaxbRestoreTimeseriesCollectionResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbRestoreTimeseriesCollectionResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbGetTimeseriesCollectionNamesResponse getTimeseriesCollectionNames(GJaxbGetTimeseriesCollectionNames parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/getTimeseriesCollectionNames");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbGetTimeseriesCollectionNamesResponse response = (GJaxbGetTimeseriesCollectionNamesResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbGetTimeseriesCollectionNamesResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/query");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbQueryResponse response = (GJaxbQueryResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbQueryResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbDeleteResponse delete(GJaxbDelete parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/delete");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDeleteResponse response = (GJaxbDeleteResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDeleteResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbDeleteAllResponse deleteAll(GJaxbDeleteAll parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/timeseries/deleteAll");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDeleteAllResponse response = (GJaxbDeleteAllResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDeleteAllResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }
}

