/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.timeseries.mongodb.client;

import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.timeseries.GJaxbField;
import fr.emac.gind.timeseries.GJaxbPointTo;
import fr.emac.gind.timeseries.GJaxbPointType;
import fr.emac.gind.timeseries.GJaxbTag;
import fr.emac.gind.timeseries.GJaxbTimeUnitType;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;

public class PointHelper {
    public static GJaxbTag createTag(String name, String value) {
        GJaxbTag tag = new GJaxbTag();
        tag.setName(name);
        tag.setValue(value);
        return tag;
    }

    public static GJaxbTag findTagByName(String name, List<GJaxbTag> tags, boolean createIfNotExist) {
        Optional<GJaxbTag> tg;
        GJaxbTag tag = null;
        if (tags != null && (tg = tags.stream().filter(t -> t.getName().equals(name)).findFirst()).isPresent()) {
            tag = tg.get();
        }
        if (tag == null && createIfNotExist) {
            GJaxbTag newTag = PointHelper.createTag(name, null);
            tags.add(newTag);
            return newTag;
        }
        return tag;
    }

    public static GJaxbField findFieldByName(String name, List<GJaxbField> fields, boolean createIfNotExist) {
        Optional<GJaxbField> f;
        GJaxbField field = null;
        if (fields != null && (f = fields.stream().filter(t -> t.getName().equals(name)).findFirst()).isPresent()) {
            field = f.get();
        }
        if (field == null && createIfNotExist) {
            GJaxbField newField = PointHelper.createField(name, null, GJaxbPointType.STRING);
            fields.add(newField);
            return newField;
        }
        return field;
    }

    public static GJaxbField createField(String name, String value, GJaxbPointType type) {
        GJaxbField field = new GJaxbField();
        field.setName(name);
        field.setValue(value);
        field.setType(type);
        return field;
    }

    public static GJaxbPointTo createTSPoint(String measurement, XMLGregorianCalendar time, GJaxbTimeUnitType timeUnit, List<GJaxbTag> tags, List<GJaxbField> fields) {
        GJaxbPointTo point = new GJaxbPointTo();
        point.setEventId(UUID.randomUUID().toString());
        point.setMeasurement(measurement);
        point.setTime(time.toXMLFormat());
        point.setPrecision(timeUnit);
        point.getTag().addAll(tags);
        point.getField().addAll(fields);
        return point;
    }

    public static GJaxbPointTo createTSPoint(String measurement, List<GJaxbTag> tags, List<GJaxbField> fields) throws Exception {
        GJaxbPointTo point = new GJaxbPointTo();
        point.setEventId(UUID.randomUUID().toString());
        point.setMeasurement(measurement);
        point.setTime(XMLGregorianCalendarHelper.getInstance().getNewCalendar().toXMLFormat());
        point.setPrecision(GJaxbTimeUnitType.SECONDS);
        point.getTag().addAll(tags);
        point.getField().addAll(fields);
        return point;
    }
}

