/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.timeseries.mongodb.server;

import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.storage.client.MongoConstant;
import fr.emac.gind.timeseries.mongodb.server.TimeSeriesMongoDBServer;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class TimeSeriesWebService
extends SPIWebServicePrimitives {
    public void onInit(Map<String, Object> context) {
        try {
            this.registerWSImplementation("timeseries", new TimeSeriesMongoDBServer(context));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static TimeSeriesWebService create(int port) throws Exception {
        return TimeSeriesWebService.create(port, MongoConstant.DEFAULT_MONGODB_PORT);
    }

    public static TimeSeriesWebService create(final int port, final int mongodb_port) throws Exception {
        TimeSeriesWebService wsStorage = new TimeSeriesWebService();
        wsStorage.start(new HashMap<String, Object>(){
            {
                this.put("host", "localhost");
                this.put("port", port);
                this.put("mongodb-database-name", "gind");
                this.put("mongodb-database-host", "localhost");
                this.put("mongodb-database-port", String.valueOf(mongodb_port));
                this.put("mongodb-database-auth_enabled", "false");
            }
        });
        return wsStorage;
    }
}

