/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.timeseries.mongodb.server;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.InsertOneResult;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.storage.mongodb.StorageImpl;
import fr.emac.gind.timeseries.FaultMessage;
import fr.emac.gind.timeseries.GJaxbCreateTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbCreateTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbDelete;
import fr.emac.gind.timeseries.GJaxbDeleteAll;
import fr.emac.gind.timeseries.GJaxbDeleteAllResponse;
import fr.emac.gind.timeseries.GJaxbDeleteResponse;
import fr.emac.gind.timeseries.GJaxbDumpTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbDumpTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbField;
import fr.emac.gind.timeseries.GJaxbGetTimeseriesCollectionNames;
import fr.emac.gind.timeseries.GJaxbGetTimeseriesCollectionNamesResponse;
import fr.emac.gind.timeseries.GJaxbPointTo;
import fr.emac.gind.timeseries.GJaxbQuery;
import fr.emac.gind.timeseries.GJaxbQueryResponse;
import fr.emac.gind.timeseries.GJaxbRestoreTimeseriesCollection;
import fr.emac.gind.timeseries.GJaxbRestoreTimeseriesCollectionResponse;
import fr.emac.gind.timeseries.GJaxbTag;
import fr.emac.gind.timeseries.GJaxbUpdate;
import fr.emac.gind.timeseries.GJaxbUpdateResponse;
import fr.emac.gind.timeseries.GJaxbWrite;
import fr.emac.gind.timeseries.GJaxbWriteResponse;
import fr.emac.gind.timeseries.Timeseries;
import jakarta.activation.DataHandler;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="timeseriesEndpointSOAP", serviceName="timeseriesService", targetNamespace="http://www.gind.emac.fr/timeseries/", wsdlLocation="wsdl/timeseries.wsdl", endpointInterface="fr.emac.gind.timeseries.Timeseries")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class TimeSeriesMongoDBServer
implements Timeseries {
    private static Logger LOG = LoggerFactory.getLogger((String)TimeSeriesMongoDBServer.class.getName());
    private MongoClient client = null;
    private MongoDatabase db = null;
    private String mongo_uri = null;
    private String database_name = null;

    public TimeSeriesMongoDBServer(Map<String, Object> context) throws UnknownHostException {
        this.database_name = (String)context.get("mongodb-database-name");
        this.mongo_uri = StorageImpl.getMongoUri(context);
        this.client = StorageImpl.createMongoClient(context);
        this.db = this.client.getDatabase(this.database_name);
        try {
            BsonDocument command = new BsonDocument("ping", (BsonValue)new BsonInt64(1L));
            Document commandResult = this.db.runCommand((Bson)command);
            System.out.println("Connected successfully to server.");
        }
        catch (MongoException me) {
            System.err.println("An error occurred while attempting to run a command: " + String.valueOf((Object)me));
        }
    }

    public synchronized GJaxbCreateTimeseriesCollectionResponse createTimeseriesCollection(GJaxbCreateTimeseriesCollection parameters) throws FaultMessage {
        TimeSeriesOptions tsOptions = new TimeSeriesOptions("time");
        tsOptions.metaField("pointTo");
        tsOptions.granularity(TimeSeriesGranularity.SECONDS);
        CreateCollectionOptions collOptions = new CreateCollectionOptions().timeSeriesOptions(tsOptions);
        if (!this.hasTimeSeriesCollection(parameters.getCollectionName())) {
            this.db.createCollection(parameters.getCollectionName(), collOptions);
        }
        return new GJaxbCreateTimeseriesCollectionResponse();
    }

    public Map<COLLECTION_TYPE, List<String>> getCollectionsNamesByType() {
        HashMap<COLLECTION_TYPE, List<String>> collsMap = new HashMap<COLLECTION_TYPE, List<String>>();
        collsMap.put(COLLECTION_TYPE.DOCUMENT, new ArrayList());
        collsMap.put(COLLECTION_TYPE.TIME_SERIES, new ArrayList());
        Document commandResult = this.db.runCommand((Bson)new Document("listCollections", (Object)new BsonInt64(1L)));
        List<String> keys = Arrays.asList("cursor");
        JSONObject colls = new JSONObject(((Document)commandResult.getEmbedded(keys, Document.class)).toJson());
        JSONArray arrays = colls.getJSONArray("firstBatch");
        for (int i = 0; i < arrays.length(); ++i) {
            JSONObject collDef = arrays.getJSONObject(i);
            String collectionName = collDef.getString("name");
            if ("timeseries".equals(collDef.getString("type"))) {
                ((List)collsMap.get((Object)COLLECTION_TYPE.TIME_SERIES)).add(collectionName);
                continue;
            }
            ((List)collsMap.get((Object)COLLECTION_TYPE.DOCUMENT)).add(collectionName);
        }
        return collsMap;
    }

    public boolean hasTimeSeriesCollection(String collectionName) {
        List<String> colls = this.getCollectionsNamesByType().get((Object)COLLECTION_TYPE.TIME_SERIES);
        for (String collName : colls) {
            if (!collectionName.equals(collName)) continue;
            return true;
        }
        return false;
    }

    public GJaxbWriteResponse write(GJaxbWrite parameters) throws FaultMessage {
        try {
            GJaxbPointTo pointTo = parameters.getPointTo();
            String json = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)pointTo)).toString();
            MongoCollection coll = this.db.getCollection(pointTo.getMeasurement());
            Document doc = Document.parse((String)json);
            doc.append("time", (Object)XMLGregorianCalendarHelper.getInstance().getNewCalendar(pointTo.getTime()).toGregorianCalendar().toInstant());
            InsertOneResult insertOneResult = coll.insertOne((Object)doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return new GJaxbWriteResponse();
    }

    public GJaxbUpdateResponse update(GJaxbUpdate parameters) throws FaultMessage {
        try {
            GJaxbPointTo newPointTo = parameters.getPointTo();
            MongoCollection coll = this.db.getCollection(newPointTo.getMeasurement());
            Document doc = (Document)coll.find(Filters.eq((String)"pointTo.eventId", (Object)newPointTo.getEventId())).first();
            GJaxbPointTo existingPointTo = (GJaxbPointTo)JSONJAXBContext.getInstance().unmarshall("{ \"pointTo\" : " + ((Document)doc.get((Object)"pointTo")).toJson() + " }", GJaxbPointTo.class);
            this.updatePoint(existingPointTo, newPointTo);
            String json = new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)existingPointTo)).getJSONObject("pointTo").toString();
            coll.updateMany((Bson)new Document("pointTo.eventId", (Object)existingPointTo.getEventId()), Updates.set((String)"pointTo", (Object)Document.parse((String)json)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return new GJaxbUpdateResponse();
    }

    private void updatePoint(GJaxbPointTo existingPointTo, GJaxbPointTo newPointTo) {
        Boolean update;
        existingPointTo.setEventId(newPointTo.getEventId());
        existingPointTo.setMeasurement(newPointTo.getMeasurement());
        if (newPointTo.getPrecision() != null) {
            existingPointTo.setPrecision(newPointTo.getPrecision());
        }
        if (newPointTo.getTime() != null) {
            existingPointTo.setTime(newPointTo.getTime());
        }
        for (GJaxbTag ntag : newPointTo.getTag()) {
            update = false;
            for (GJaxbTag etag : existingPointTo.getTag()) {
                if (!ntag.getName().equals(etag.getName())) continue;
                etag.setValue(ntag.getValue());
                update = true;
                break;
            }
            if (update.booleanValue()) continue;
            existingPointTo.getTag().add(ntag);
        }
        for (GJaxbField nField : newPointTo.getField()) {
            update = false;
            for (GJaxbField eField : existingPointTo.getField()) {
                if (!nField.getName().equals(eField.getName())) continue;
                eField.setValue(nField.getValue());
                update = true;
                break;
            }
            if (update.booleanValue()) continue;
            existingPointTo.getField().add(nField);
        }
    }

    public GJaxbDumpTimeseriesCollectionResponse dumpTimeseriesCollection(GJaxbDumpTimeseriesCollection parameters) throws FaultMessage {
        GJaxbDumpTimeseriesCollectionResponse res = new GJaxbDumpTimeseriesCollectionResponse();
        try {
            File outputDir = new File("./target/backup/timeseries/");
            outputDir.mkdirs();
            StorageImpl.dump((String)this.mongo_uri, (String)this.database_name, Arrays.asList(parameters.getCollectionName()), (File)outputDir);
            File zipMetadataCollection = new File(outputDir, parameters.getCollectionName() + ".gz");
            res.getZip().add(new DataHandler(zipMetadataCollection.toURI().toURL()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbRestoreTimeseriesCollectionResponse restoreTimeseriesCollection(GJaxbRestoreTimeseriesCollection parameters) throws FaultMessage {
        GJaxbRestoreTimeseriesCollectionResponse res = new GJaxbRestoreTimeseriesCollectionResponse();
        try {
            File inputDir = new File("./target/restore/timeseries/");
            inputDir.mkdirs();
            for (DataHandler dh : parameters.getZip()) {
                String collectionName = dh.getName().substring(dh.getName().indexOf("timeseries_"));
                collectionName = collectionName.replace(".gz", "");
                String simpleName = dh.getName().substring(dh.getName().lastIndexOf("/") + "/".length());
                File localArchive = new File(inputDir, simpleName).getCanonicalFile();
                localArchive.createNewFile();
                FileUtil.copy((InputStream)dh.getInputStream(), (OutputStream)new FileOutputStream(localArchive));
                StorageImpl.restore((String)this.mongo_uri, (String)this.database_name, Arrays.asList(collectionName), (File)inputDir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbGetTimeseriesCollectionNamesResponse getTimeseriesCollectionNames(GJaxbGetTimeseriesCollectionNames parameters) throws FaultMessage {
        GJaxbGetTimeseriesCollectionNamesResponse res = new GJaxbGetTimeseriesCollectionNamesResponse();
        List<String> colls = this.getCollectionsNamesByType().get((Object)COLLECTION_TYPE.TIME_SERIES);
        for (String collName : colls) {
            res.getTimeSeriesCollectionName().add(collName);
        }
        return res;
    }

    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        GJaxbQueryResponse response = new GJaxbQueryResponse();
        try {
            MongoCollection coll = this.db.getCollection(parameters.getTimeSeriesCollectionName());
            MongoCursor cursor = null;
            cursor = parameters.getLimit() != null ? coll.find((Bson)Document.parse((String)parameters.getQuery())).limit(parameters.getLimit().intValue()).cursor() : coll.find((Bson)Document.parse((String)parameters.getQuery())).cursor();
            while (cursor.hasNext()) {
                Document obj = (Document)cursor.next();
                Document pt = (Document)obj.get((Object)"pointTo");
                GJaxbPointTo point = (GJaxbPointTo)JSONJAXBContext.getInstance().unmarshall("{ \"pointTo\" : " + pt.toJson() + " }", GJaxbPointTo.class);
                response.getPointTo().add(point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbDeleteResponse delete(GJaxbDelete parameters) throws FaultMessage {
        GJaxbDeleteResponse response = new GJaxbDeleteResponse();
        try {
            MongoCollection coll = this.db.getCollection(parameters.getPointTo().getMeasurement());
            coll.deleteMany((Bson)new Document("pointTo.eventId", (Object)parameters.getPointTo().getEventId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbDeleteAllResponse deleteAll(GJaxbDeleteAll parameters) throws FaultMessage {
        GJaxbDeleteAllResponse response = new GJaxbDeleteAllResponse();
        try {
            MongoCollection coll = this.db.getCollection(parameters.getMeasurement());
            coll.deleteMany(Filters.empty());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public static enum COLLECTION_TYPE {
        DOCUMENT,
        TIME_SERIES;

    }
}

