/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.ws;

import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegistry {
    private static final Logger LOG = LoggerFactory.getLogger((String)LocalRegistry.class.getName());
    private static LocalRegistry INSTANCE = null;
    private List<SPIWebServicePrimitives> webservices = Collections.synchronizedList(new ArrayList());
    private Map<String, Object> dwservices = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> notifiers = Collections.synchronizedMap(new HashMap());

    private LocalRegistry() {
    }

    public static LocalRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LocalRegistry();
        }
        return INSTANCE;
    }

    public void clear() {
        this.webservices.clear();
        this.dwservices.clear();
        this.notifiers.clear();
    }

    public void addWebService(SPIWebServicePrimitives webservice) {
        if (!this.webservices.contains(webservice)) {
            this.webservices.add(webservice);
            LOG.debug(String.valueOf(webservice) + " added in registry");
        }
    }

    public <T> T findWS(Class<T> implementationClass) {
        for (SPIWebServicePrimitives ws : this.webservices) {
            if (!ws.getClass().equals(implementationClass) && !Arrays.asList(ws.getClass().getInterfaces()).contains(implementationClass)) continue;
            return (T)ws;
        }
        return null;
    }

    public <T> T findWSImplementation(Class<T> implementationClass) {
        for (SPIWebServicePrimitives ws : this.webservices) {
            for (Map.Entry<String, Object> entry : ws.getWsMap().entrySet()) {
                String wsName = entry.getKey();
                Object existingImplementation = entry.getValue();
                if (!existingImplementation.getClass().equals(implementationClass) && !Arrays.asList(existingImplementation.getClass().getInterfaces()).contains(implementationClass)) continue;
                return (T)existingImplementation;
            }
        }
        LOG.warn("Impossible to find implementation in local registry: " + String.valueOf(implementationClass));
        return null;
    }

    public void addDWService(String name, Object dw) {
        this.dwservices.put(name, dw);
    }

    public Object findDWImplementation(String name) {
        return this.dwservices.get(name);
    }

    public void addNotifier(String name, Object n) {
        this.notifiers.put(name, n);
    }

    public Object findNotifier(String name) {
        return this.notifiers.get(name);
    }
}

