/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.combinatorial;

import java.math.BigInteger;

public class CombinatorialUtil {
    private static BigInteger mult(int p, int n) {
        if (p == n) {
            return BigInteger.valueOf(p);
        }
        int a = (n + p) / 2;
        return CombinatorialUtil.mult(p, a).multiply(CombinatorialUtil.mult(a + 1, n));
    }

    public static BigInteger fact(int n) {
        if (n > 1) {
            return CombinatorialUtil.mult(2, n);
        }
        return BigInteger.ONE;
    }

    public static BigInteger binomialCoeff(int n, int k) {
        BigInteger num = CombinatorialUtil.fact(n);
        BigInteger den = CombinatorialUtil.fact(k).multiply(CombinatorialUtil.fact(n - k));
        return num.divide(den);
    }

    public static BigInteger binomialCoeffSum(int n) {
        BigInteger sum = BigInteger.valueOf(0L);
        for (int i = 0; i <= n; ++i) {
            sum = sum.add(CombinatorialUtil.binomialCoeff(n, i));
        }
        return sum;
    }
}

